// ----------------------------------------------------------------------------
//
//  Copyright (C) 2010-2015 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#include "styles.h"


unsigned long    Colors [NCOLORS];
XftColor        *XftColors [NXFTCOLORS];
XftFont         *XftFonts [NXFTFONTS];
X_button_style   Bst0, Bst1, Bst2, Bst3;
X_textln_style   Tst0, Tst1, Tst2, Tst3, Tst4;


void styles_init (X_display *disp, X_resman *xrm)
{
    unsigned long  bb, ww;

    Colors [C_BLACK]    = bb = disp->blackpixel ();
    Colors [C_WHITE]    = ww = disp->whitepixel ();
    Colors [C_BROWN]    = disp->alloc_color ("brown",   bb);
    Colors [C_RED]      = disp->alloc_color ("red",     bb);
    Colors [C_ORANGE]   = disp->alloc_color ("orange",  bb);
    Colors [C_YELLOW]   = disp->alloc_color ("yellow",  ww);
    Colors [C_GREEN]    = disp->alloc_color ("green",   ww);
    Colors [C_BLUE]     = disp->alloc_color ("blue",    bb);
    Colors [C_PURPLE]   = disp->alloc_color ("purple",  bb);
    Colors [C_GRAY]     = disp->alloc_color ("gray50",  bb);

    Colors [C_MAIN_LS]  = disp->alloc_color (xrm->get (".color.main.ls",   "gray50"),  ww);
    Colors [C_MAIN_DS]  = disp->alloc_color (xrm->get (".color.main.ds",   "black"),   bb);
    Colors [C_DISP_BG]  = disp->alloc_color (xrm->get (".color.disp.bg",   "black"),   bb);
    Colors [C_TEXT_BG]  = disp->alloc_color (xrm->get (".color.text.bg",   "white"),   ww);
    Colors [C_TEXT_HL]  = disp->alloc_color (xrm->get (".color.text.hl",   "#c0ffa0"), ww);
    Colors [C_TEXT_CA]  = disp->alloc_color (xrm->get (".color.text.ca",   "red"),     bb);
    Colors [C_TEXT_GR]  = disp->alloc_color (xrm->get (".color.text.gr",   "gray80"),  bb);
    Colors [C_TEXT_MO]  = disp->alloc_color (xrm->get (".color.text.mo",   "#e0e0c0"), ww);
    Colors [C_TEXT_ER]  = disp->alloc_color (xrm->get (".color.text.er",   "orange"),  ww);
    Colors [C_BUTT_BG0] = disp->alloc_color (xrm->get (".color.butt.bg0",  "#707060"), bb);
    Colors [C_BUTT_BG1] = disp->alloc_color (xrm->get (".color.butt.bg1",  "#fff000"), ww);
    Colors [C_BUTT_BG2] = disp->alloc_color (xrm->get (".color.butt.bg2",  "red"),     bb);
    Colors [C_BUTT_BG3] = disp->alloc_color (xrm->get (".color.butt.bg3",  "#707060"), bb);

    XftColors [C_MAIN_BG] = disp->alloc_xftcolor (0.2f, 0.2f, 0.2f, 1.0f);
    XftColors [C_MAIN_FG] = disp->alloc_xftcolor (1.0f, 1.0f, 1.0f, 1.0f);
    XftColors [C_DISP_FG1] = disp->alloc_xftcolor (xrm->get (".color.disp.fg1",  "#a0a0ff"),  0);
    XftColors [C_DISP_FG2] = disp->alloc_xftcolor (xrm->get (".color.disp.fg2",  "#ffb000"),  0);
    XftColors [C_DISP_FG3] = disp->alloc_xftcolor (xrm->get (".color.disp.fg2",  "#ff0000"),  0);
    XftColors [C_TEXT_FG]  = disp->alloc_xftcolor (xrm->get (".color.text.fg",   "black"  ),  0);
    XftColors [C_BUTT_FG0] = disp->alloc_xftcolor (xrm->get (".color.butt.fg0",  "white"  ),  0);
    XftColors [C_BUTT_FG1] = disp->alloc_xftcolor (xrm->get (".color.butt.fg1",  "black"  ),  0);
    XftColors [C_BUTT_FG2] = disp->alloc_xftcolor (xrm->get (".color.butt.fg2",  "white"  ),  0);
    XftColors [C_BUTT_FG3] = disp->alloc_xftcolor (xrm->get (".color.butt.fg3",  "white"  ),  0);

    XftFonts [F_TEXT] = disp->alloc_xftfont (xrm->get (".font.text",  "helvetica:bold:pixelsize=11"));
    XftFonts [F_JKMP] = disp->alloc_xftfont (xrm->get (".font.butt", "luxi:bold:pixelsize=10"));

    Bst0.size.x = 30;
    Bst0.size.y = 16;
    Bst0.font = XftFonts [F_JKMP];
    Bst0.type = X_button_style::PLAIN;
    Bst0.color.bg[0] = disp->alloc_color ("#000000", 0);
    Bst0.color.fg[0] = disp->alloc_xftcolor ("#8080ff", 0);
    Bst0.color.bg[1] = disp->alloc_color ("#000000", 0);
    Bst0.color.fg[1] = disp->alloc_xftcolor ("#40ff40", 0);
    Bst0.color.bg[2] = disp->alloc_color ("#000000", 0);
    Bst0.color.fg[2] = disp->alloc_xftcolor ("#ffff00", 0);
    Bst0.color.bg[3] = disp->alloc_color ("#ff2000", 0);
    Bst0.color.fg[3] = disp->alloc_xftcolor ("#ffffff", 0);

    Tst0.font = XftFonts [F_TEXT];
    Tst0.color.normal.bgnd = XftColors [C_MAIN_BG]->pixel;
    Tst0.color.normal.text = XftColors [C_MAIN_FG];
}


void styles_fini (X_display *disp)
{
}
