xjobs README
============

Contact:
--------
Author: Thomas Maier-Komor
e-mail: thomas@maier-komor.de


LICENSE:
--------
GNU GPL 2 (see file COPYING for details)


DESCRIPTION:
------------
xjobs executes commands given on its input in parallel. In contrast to
xargs, it will spawn a process for every line send to it via stdin. That
way an arbitrary sequence of commands can be parallelized. Additionally,
there are concepts to synchronize processes, by adding sequence points
that will only be passed once all processes before the sequence point
finished.

For a detailed description refer to the included manpage.


INSTALLATION:
-------------
xjobs can be build in two different ways:
1) By running './configure' and GNU make. Be aware that BSD make will
fail. So you will need to run 'gmake' instead of 'make' on Solaris and
some BSD variants.
2) With CMake by running 'cmake .' followed by executing any flavor of
make. The cmake way of building is just offered as an alternative right
now.

When building to create a package, please use configure and GNU Make. If
you use CMake, please make sure that config.h is created with the
correct settings.


Changes:
--------
See file ChangeLog.


KNOWN LIMITATIONS ON CYGWIN:
----------------------------
Cygwin seems to have a couple of issues concerning named pipes:
1) no SIGPOLL when a named pipe gets ready
2) read incorrectly returning 0, when there is still a writer on the pipe
3) need to reopen a pipe to access data written by another process
4) incorrectly delivering SIGPIPE to writer, as a consequence of 2)

In consequence, when using xjobs under Cygwin with a named pipe, single
jobs might be rejected completely by signaling SIGPIPE to the sender.
This is not a problem of xjobs, but rather an implementation issue of
Cygwin.


FEEDBACK:
---------
I would be grateful concerning getting feedback. If you like xjobs,
dislike it because of a specific reason, want to report a bug or have a
request for enhancement, feel free to contact me.

