#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import os

from winswitch.util.commands_util import JAVA_COMMAND, VASH_WRAPPER_APP
from winswitch.util.paths import SHARE_DIR
from winswitch.util.simple_logger import Logger
from winswitch.util.common import is_valid_exe, is_valid_file
from winswitch.util.process_util import twisted_exec
from winswitch.globals import OSX

logger=Logger("vash_util", log_colour=Logger.CYAN)

def generate_image(data, filename, ok_cb, err_cb=None):
	VASH_JAR = os.path.join(SHARE_DIR, "Vash", "Vash.jar")
	logger.sdebug("java=%s, vash=%s" % (JAVA_COMMAND, VASH_JAR), filename)
	if not is_valid_exe(JAVA_COMMAND) or not is_valid_file(VASH_JAR):
		return	False
	env = os.environ.copy()
	if OSX:
		#on OSX we have to use an "App" to hide it from the menu
		#and we have to use env variables as arguments. YUK
		cmd = ["open", "-n", "-W", VASH_WRAPPER_APP]
		env["VASH_JAR"] = VASH_JAR
		env["FINGERPRINT"] = data
		env["OUTPUT_FILENAME"] = filename
	else:
		cmd = [JAVA_COMMAND, "-jar", VASH_JAR, "-a", "1.1", "-F", "png", "-d", data, "-o", filename]
	twisted_exec(cmd, ok_cb, err_cb, env=env)
