##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# http://www.morningstarsecurity.com/research/whatweb
##
# Version 0.2 # 2011-02-25 #
# Updated version detection
##
Plugin.define "coWiki" do
author "Brendan Coles <bcoles@gmail.com>" # 2010-07-22
version "0.2"
description "coWiki - wiki - homepage: http://www.cowiki.org/"

# Google results as at 2010-07-22 #
# 8 for "powered by coWiki"



# Matches #
matches [

# HTML Comment
{ :version=>/<!-- Generated by coWiki ([^ ]+) \((http:\/\/www.develnet.org|http:\/\/www.cowiki.org)\) -->/ },

# Meta Generator
{ :version=>/<meta name="generator" content="coWiki ([^,]+), (http:\/\/www.develnet.org|http:\/\/www.cowiki.org)"[^>]*>/ },

]

end

