/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 1.0.4
 * December 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#if HAVE_GNOME
#include <vdk/vdkgnomededit.h>
#include <vdk/forms.h>

int
VDKGnomeDateEdit::FocusOutEvent(GtkWidget *,
			    GdkEventFocus*,
			    gpointer wid)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  VDKGnomeDateEdit* obj = reinterpret_cast<VDKGnomeDateEdit*>(wid);
  obj->SignalEmit(focus_out_signal);
  return TRUE;
}
/*
 */
int
VDKGnomeDateEdit::FocusInEvent(GtkWidget *,
			    GdkEventFocus *,
			    gpointer wid)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  VDKGnomeDateEdit* obj = reinterpret_cast<VDKGnomeDateEdit*>(wid);
  obj->SignalEmit(focus_in_signal);
  return TRUE;
}
/*
 */
void
VDKGnomeDateEdit::HandleDateChange(GtkWidget *wid, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKGnomeDateEdit* obj = reinterpret_cast<VDKGnomeDateEdit*>(gp);
  obj->SignalEmit(date_changed_signal);
}

/*
 */
void
VDKGnomeDateEdit::HandleTimeChange(GtkWidget *wid, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKGnomeDateEdit* obj = reinterpret_cast<VDKGnomeDateEdit*>(gp);
  obj->SignalEmit(time_changed_signal);
}
/*
  Constructor, makes a date edit
  initializing it with an absolute time
  (seconds elapsed since 1-1-1970)
 */
VDKGnomeDateEdit::VDKGnomeDateEdit(VDKForm* owner,
				   time_t the_time,
				   bool show_time,
				   bool format24,
 				   int mode):
    VDKObject(owner),
    mode(mode),
    AbsoluteTime("AbsoluteTime",this,the_time,
	 &VDKGnomeDateEdit::SetAbsoluteTime,
	 &VDKGnomeDateEdit::GetAbsoluteTime),
    Date("Date",this,calendardate(),
	 &VDKGnomeDateEdit::SetDate,
	 &VDKGnomeDateEdit::GetDate)
{

    time_t t;
    if(!the_time)
	{
	    time(&t);
	    AbsoluteTime(t);
	
	}
    widget = gnome_date_edit_new(the_time ? the_time : t,
				 show_time,
				 format24);
    ConnectDefaultSignals();
    ConnectSignals();
}		

/*
  Constructor, makes a date edit
  initializing it with a calendar date constructed
  with the_date string.
  the_date must be int the format mm-dd-yyyy,
  separator can be one of "./-"
 */
VDKGnomeDateEdit::VDKGnomeDateEdit(VDKForm* owner,
				   char* the_date,
				   bool show_time,
				   bool format24,
 				   int mode):
    VDKObject(owner),
    mode(mode),
    AbsoluteTime("AbsoluteTime",this,-1,
	 &VDKGnomeDateEdit::SetAbsoluteTime,
	 &VDKGnomeDateEdit::GetAbsoluteTime),
    Date("Date",this,calendardate(),
	 &VDKGnomeDateEdit::SetDate,
	 &VDKGnomeDateEdit::GetDate)
{
    time_t t;
    struct tm b;
    calendardate d;
    if(the_date)
     d = calendardate(the_date);
    if(d.Valid())
	{

	b.tm_sec = 0; b.tm_min = 0; b.tm_hour = 12;
	b.tm_isdst = 0;  b.tm_mday = d.Day(); b.tm_mon = d.Month()-1;
	b.tm_year = d.Year()-1900;
	t = mktime(&b);
	AbsoluteTime(t);
	}
    else
	{
	    time(&t);
	    AbsoluteTime(t);
	}
    widget = gnome_date_edit_new(t, show_time,format24);
    ConnectDefaultSignals();
    ConnectSignals();
}

/*
  connect
  date edit signals
*/
void
VDKGnomeDateEdit::ConnectSignals()
{
    s_activated.obj = this;
    s_activated.signal = activate_signal;

    gtk_signal_connect(GTK_OBJECT(GNOME_DATE_EDIT(widget)->date_entry),
		       "activate",
		       GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		       (gpointer) &s_activated);
    gtk_signal_connect(GTK_OBJECT(widget),
		       "date_changed",
		       GTK_SIGNAL_FUNC(VDKGnomeDateEdit::HandleDateChange),
		       (gpointer) this);
    gtk_signal_connect(GTK_OBJECT(widget),
		       "time_changed",
		       GTK_SIGNAL_FUNC(VDKGnomeDateEdit::HandleTimeChange),
		       (gpointer) this);
    gtk_signal_connect(GTK_OBJECT(GNOME_DATE_EDIT(widget)->date_entry),
		       "focus_out_event",
		       GTK_SIGNAL_FUNC(VDKGnomeDateEdit::FocusOutEvent),
		       (gpointer) this);
    gtk_signal_connect(GTK_OBJECT(GNOME_DATE_EDIT(widget)->date_entry),
		       "focus_in_event",
		       GTK_SIGNAL_FUNC(VDKGnomeDateEdit::FocusInEvent),
		       (gpointer) this);

}
/*
  destructor
*/
VDKGnomeDateEdit::~VDKGnomeDateEdit()
{
}

/*
  this routine works from 1/1/1970 until 12/31/2038
 */
void
VDKGnomeDateEdit::SetDate(calendardate d)
{
    struct tm b;
    b.tm_sec = 0;
    b.tm_min = 0;
    b.tm_hour = 12;
    b.tm_isdst = 0;
    b.tm_mday = d.Day();
    b.tm_mon = d.Month()-1;
    b.tm_year = d.Year()-1900;
    time_t t = mktime(&b);
    AbsoluteTime = t;
}
/*
  this routine works from 1/1/1970 until 12/31/2038
 */
calendardate
VDKGnomeDateEdit::GetDate()
{
    time_t t = AbsoluteTime;
    struct tm *b = localtime(&t);
    return calendardate(b->tm_mday,
			b->tm_mon+1,
			b->tm_year + 1900);
}
#endif
