/*
 * unity-webapps-binding.h
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#if ! defined (UNITY_WEBAPPS_BINDING_H)
#define UNITY_WEBAPPS_BINDING_H

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/npruntime.h"
#include "npapi-headers/headers/nptypes.h"


NPVariant
unity_webapps_binding_service_new (NPP instance
				   , NPObject * object
				   , const NPVariant *args
				   , uint32_t argCount);

NPVariant
unity_webapps_binding_service_destroy_interest_for_context (NPP instance
                                                            , NPObject * object
                                                            , const NPVariant *args
                                                            , uint32_t argCount);

NPVariant
unity_webapps_binding_context_new_sync (NPP instance
					, NPObject * object
					, const NPVariant *args
					, uint32_t argCount);

NPVariant
unity_webapps_binding_context_new_lazy (NPP instance
					, NPObject * object
					, const NPVariant *args
					, uint32_t argCount);

NPVariant
unity_webapps_binding_context_prepare (NPP instance
					, NPObject * object
					, const NPVariant *args
					, uint32_t argCount);

NPVariant
unity_webapps_binding_context_destroy (NPP instance
					, NPObject * object
				       , const NPVariant *args
				       , uint32_t argCount);

NPVariant
unity_webapps_binding_context_add_icon (NPP instance
					, NPObject * object
					, const NPVariant *args
					, uint32_t argCount);

NPVariant
unity_webapps_binding_context_set_view_is_active (NPP instance
						  , NPObject * object
						  , const NPVariant *args
						  , uint32_t argCount);

NPVariant
unity_webapps_binding_context_set_view_location (NPP instance
						 , NPObject * object
						 , const NPVariant *args
						 , uint32_t argCount);

NPVariant
unity_webapps_binding_context_get_name (NPP instance
                                        , NPObject * object
                                        , const NPVariant *args
                                        , uint32_t argCount);

NPVariant
unity_webapps_binding_context_get_domain (NPP instance
                                          , NPObject * object
                                          , const NPVariant *args
                                          , uint32_t argCount);


NPVariant
unity_webapps_binding_notification_show_notification (NPP instance
					, NPObject * object
						      , const NPVariant *args
						      , uint32_t argCount);

NPVariant
unity_webapps_binding_context_on_raise_callback (NPP instance
                                                 , NPObject * object
						 , const NPVariant *args
						 , uint32_t argCount);

NPVariant
unity_webapps_binding_context_on_close_callback (NPP instance
                                                 , NPObject * object
						 , const NPVariant *args
						 , uint32_t argCount);

NPVariant
unity_webapps_binding_context_set_preview_requested_callback (NPP instance
                                                              , NPObject * object
							      , const NPVariant *args
							      , uint32_t argCount);

NPVariant
unity_webapps_binding_context_remove_application_action (NPP instance
							 , NPObject * npobject
							 , const NPVariant *args
							 , uint32_t argCount);

NPVariant
unity_webapps_binding_context_add_application_actions (NPP instance
                                                       , NPObject * npobject
                                                       , const NPVariant *args
                                                       , uint32_t argCount);

NPVariant
unity_webapps_binding_context_remove_application_actions (NPP instance
							  , NPObject * npobject
							  , const NPVariant *args
							  , uint32_t argCount);

NPVariant
unity_webapps_binding_permissions_is_integration_allowed (NPP instance
                                                          , NPObject * npobject
                                                          , const NPVariant *args
                                                          , uint32_t argCount);

NPVariant
unity_webapps_binding_permissions_allow_domain (NPP instance
					, NPObject * object
						, const NPVariant *args
						, uint32_t argCount);

NPVariant
unity_webapps_binding_permissions_get_domain_preauthorized (NPP instance
                                                            , NPObject * npobject
                                                            , const NPVariant *args
                                                            , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_init (NPP instance
					, NPObject * object
					 , const NPVariant *args
					 , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_on_play_pause_callback (NPP instance
					, NPObject * object
							   , const NPVariant *args
							   , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_on_previous_callback (NPP instance
					, NPObject * object
							 , const NPVariant *args
							 , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_on_next_callback (NPP instance
					, NPObject * object
						     , const NPVariant *args
						     , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_set_track (NPP instance
					, NPObject * object
					      , const NPVariant *args
					      , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_set_can_pause (NPP instance
					, NPObject * object
						  , const NPVariant *args
						  , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_set_can_play (NPP instance
					, NPObject * object
						 , const NPVariant *args
						 , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_set_can_go_next (NPP instance
					, NPObject * object
						    , const NPVariant *args
						    , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_set_can_go_previous (NPP instance
					, NPObject * object
							, const NPVariant *args
							, uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_set_playback_state (NPP instance
					, NPObject * object
						       , const NPVariant *args
						       , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_get_can_pause (NPP instance
					, NPObject * object
						  , const NPVariant *args
						  , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_get_can_play (NPP instance
					, NPObject * object
						 , const NPVariant *args
						 , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_get_can_go_next (NPP instance
					, NPObject * object
						    , const NPVariant *args
						    , uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_get_can_go_previous (NPP instance
					, NPObject * object
							, const NPVariant *args
							, uint32_t argCount);

NPVariant
unity_webapps_binding_music_player_get_playback_state (NPP instance
					, NPObject * object
						       , const NPVariant *args
						       , uint32_t argCount);

NPVariant
unity_webapps_binding_notification_show_notification (NPP instance
					, NPObject * object
						      , const NPVariant *args
						      , uint32_t argCount);


NPVariant
unity_webapps_binding_permissions_get_domain_allowed (NPP instance
					, NPObject * object
						      , const NPVariant *args
						      , uint32_t argCount);


NPVariant
unity_webapps_binding_permissions_allow_domain (NPP instance
					, NPObject * object
						, const NPVariant *args
						, uint32_t argCount);


NPVariant
unity_webapps_binding_permissions_get_domain_dontask (NPP instance
					, NPObject * object
						      , const NPVariant *args
						      , uint32_t argCount);

NPVariant
unity_webapps_binding_permissions_dontask_domain (NPP instance
					, NPObject * object
						  , const NPVariant *args
						  , uint32_t argCount);

NPVariant
unity_webapps_binding_launcher_set_count (NPP instance
					, NPObject * object
					  , const NPVariant *args
					  , uint32_t argCount);

NPVariant
unity_webapps_binding_launcher_clear_count (NPP instance
					, NPObject * object
					    , const NPVariant *args
					    , uint32_t argCount);

NPVariant
unity_webapps_binding_launcher_set_progress (NPP instance
					, NPObject * object
					     , const NPVariant *args
					     , uint32_t argCount);

NPVariant
unity_webapps_binding_launcher_clear_progress (NPP instance
					, NPObject * object
					       , const NPVariant *args
					       , uint32_t argCount);

NPVariant
unity_webapps_binding_launcher_set_urgent (NPP instance
					, NPObject * object
					   , const NPVariant *args
					   , uint32_t argCount);

NPVariant
unity_webapps_binding_launcher_add_action (NPP instance
					, NPObject * object
					   , const NPVariant *args
					   , uint32_t argCount);

NPVariant
unity_webapps_binding_launcher_remove_action (NPP instance
					      , NPObject * npobject, const NPVariant *args
					      , uint32_t argCount);

NPVariant
unity_webapps_binding_launcher_remove_actions (NPP instance
					      , NPObject * npobject, const NPVariant *args
					      , uint32_t argCount);

NPVariant
unity_webapps_binding_indicator_show_indicator (NPP instance
					, NPObject * object
						, const NPVariant *args
                            			, uint32_t argCount);

NPVariant
unity_webapps_binding_indicator_clear_indicator (NPP instance
					, NPObject * object
						 , const NPVariant *args
						 , uint32_t argCount);

NPVariant
unity_webapps_binding_indicator_clear_indicators (NPP instance
					, NPObject * object
						 , const NPVariant *args
						 , uint32_t argCount);

NPVariant
unity_webapps_binding_indicator_set_callback (NPP instance
					, NPObject * object
					      , const NPVariant *args
					      , uint32_t argCount);

NPVariant
unity_webapps_binding_indicator_set_property (NPP instance
					, NPObject * object
					      , const NPVariant *args
					      , uint32_t argCount);

NPVariant
unity_webapps_binding_indicator_set_property_icon (NPP instance
					, NPObject * object
						   , const NPVariant *args
						   , uint32_t argCount);

NPVariant
unity_webapps_binding_indicator_add_action (NPP instance
					, NPObject * object
					    , const NPVariant *args
					    , uint32_t argCount);

NPVariant
unity_webapps_binding_indicator_get_presence (NPP instance
					, NPObject * object
					      , const NPVariant *args
					      , uint32_t argCount);

NPVariant
unity_webapps_binding_indicator_on_presence_changed_callback (NPP instance
					, NPObject * object
							      , const NPVariant *args
							      , uint32_t argCount);

NPVariant
unity_webapps_binding_context_set_preview_requested_callback (NPP instance
					, NPObject * object
							      , const NPVariant *args
							      , uint32_t argCount);

NPVariant
unity_webapps_binding_context_set_homepage (NPP instance
					, NPObject * object
					    , const NPVariant *args
					    , uint32_t argCount);

NPVariant
unity_webapps_binding_service_set_xid_for_browser_window_id (NPP instance
							     , NPObject * object
							     , const NPVariant *args
							     , uint32_t argCount);

NPVariant
unity_webapps_binding_context_get_interest_id (NPP instance
                                               , NPObject * object
                                               , const NPVariant *args
                                               , uint32_t argCount);

NPVariant
unity_webapps_binding_context_set_application_accept_data (NPP instance
                                                           , NPObject * npobject
                                                           , const NPVariant *args
                                                           , uint32_t argCount);

NPVariant
unity_webapps_binding_launcher_add_static_action (NPP instance
         , NPObject * npobject
         , const NPVariant *args
         , uint32_t argCount);


NPVariant
unity_webapps_binding_launcher_remove_static_actions (NPP instance
         , NPObject * npobject
         , const NPVariant *args
         , uint32_t argCount);


#endif // UNITY_WEBAPPS_BINDING_H

