/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SATADEVICE_H
#define SATADEVICE_H

#include <QObject>
#include <QVector>

#include "devicepowerinfo.h"

#define SATA_DEVICE_PATH "/sys/class/scsi_host/"

class SataDevice : public QObject
{
    Q_OBJECT
public:
    explicit SataDevice(QObject *parent = nullptr);

signals:

private:
    QVector<DevicePowerInfo *> m_devicePowerInfo;

    QString m_controlFile;

    void getDevicePowerInfo();
    bool checkUsbSupportAutosuspend(const QString &devPath);
    QString getSataDeviceName(const QString &devPath);

public:
    int getPCIDeviceNum();
    QString getDeviceName(int deviceIndex);
    QString getCurrentPowerStat(int deviceIndex);
    QString getDefaultPowerStat(int deviceIndex);

    bool setPowerStat(int deviceIndex, const QString &stat);
    bool setAllDevicePowerStat(const QString &stat);
    void printAllDeviceInfo();
};

#endif // SATADEVICE_H
