/*! \file utf8tables.cpp
 * \brief Static tables with UTF-8 state machines.
 *
 */

#include "copyright.h"
#include "autoconf.h"
#include "config.h"
#include "externs.h"

// utf/cl_Printable.txt
//
// 120077 included, 994035 excluded, 0 errors.
// 280 states, 95 columns, 9098 bytes
//
const unsigned char cl_print_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   0,

       2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,  16,  17,
      18,  19,  20,  21,  22,  23,  24,  25,   26,  27,  28,  29,  30,  31,  32,  33,
      34,  35,  36,  37,  38,  39,  40,  41,   42,  43,  44,  45,  46,  47,  48,  49,
      50,  51,  52,  53,  54,  55,  56,  57,   58,  59,  60,  61,  62,  63,  64,  65,
       0,   0,  66,  67,  67,  67,  67,  67,   67,  67,  67,  67,   0,  68,  69,  67,
      67,  67,  70,  67,  71,  72,  73,  74,   75,  76,  67,  77,  78,  79,  80,  81,
      82,  83,  84,  85,  86,  87,  87,  87,   87,  88,  89,  87,  87,  90,  91,  92,
      93,   0,   0,  94,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short cl_print_sot[280] =
{
        0,   35,   45,   51,   65,   81,   91,  101,   115,  133,  155,  169,  183,  205,  218,  224,
      230,  240,  277,  299,  309,  315,  325,  339,   372,  405,  443,  472,  506,  536,  570,  600,
      644,  670,  696,  726,  756,  789,  811,  844,   865,  889,  899,  909,  958,  979,  997, 1018,
     1040, 1054, 1113, 1126, 1136, 1153, 1177, 1199,  1216, 1230, 1240, 1250, 1260, 1270, 1276, 1294,
     1312, 1330, 1344, 1350, 1363, 1369, 1383, 1397,  1407, 1421, 1435, 1445, 1463, 1473, 1491, 1501,
     1515, 1525, 1535, 1561, 1575, 1599, 1609, 1635,  1676, 1690, 1704, 1718, 1728, 1738, 1744, 1750,
     1760, 1770, 1784, 1798, 1808, 1818, 1832, 1849,  1859, 1881, 1899, 1905, 1915, 1921, 1931, 1951,
     1961, 1967, 1977, 1987, 1997, 2007, 2013, 2023,  2029, 2037, 2043, 2082, 2092, 2102, 2108, 2122,
     2132, 2142, 2152, 2158, 2172, 2186, 2196, 2206,  2216, 2230, 2236, 2250, 2267, 2279, 2305, 2315,
     2325, 2334, 2344, 2350, 2380, 2386, 2396, 2402,  2426, 2440, 2450, 2460, 2470, 2480, 2502, 2508,
     2538, 2568, 2631, 2652, 2662, 2676, 2690, 2696,  2706, 2716, 2726, 2736, 2746, 2756, 2766, 2776,
     2801, 2811, 2821, 2835, 2849, 2859, 2886, 2900,  2906, 2916, 2926, 2940, 2954, 2960, 2966, 2976,
     2982, 3025, 3039, 3053, 3067, 3077, 3091, 3109,  3123, 3147, 3157, 3191, 3217, 3231, 3241, 3247,
     3257, 3263, 3277, 3283, 3293, 3308, 3318, 3324,  3332, 3338, 3346, 3352, 3372, 3386, 3396, 3406,
     3428, 3434, 3444, 3450, 3462, 3468, 3478, 3495,  3535, 3545, 3555, 3569, 3575, 3585, 3595, 3605,
     3637, 3647, 3673, 3690, 3700, 3710, 3724, 3739,  3749, 3782, 3843, 3865, 3871, 3909, 3923, 3933,
     3947, 3953, 3959, 3969, 3979, 3989, 3999, 4013,  4019, 4033, 4043, 4049, 4055, 4061, 4071, 4077,
     4087, 4093, 4101, 4107, 4115, 4121, 4127, 4135
};

const unsigned short cl_print_sbt[4141] =
{
     254, 280, 281,  64, 280, 227,   1,   2,    3,   4,   5,   6,   7,   8,   9,  10,
      11,  12,  13,  14,  15,  16,  17,  49,   87, 110, 118, 119, 120, 122, 144, 146,
     147, 160, 277,  34, 280,  13, 281, 255,  280,  18, 281,  29, 280,   2, 280,  64,
     281,  29, 280,  17, 280, 255, 281,  32,  280,   8, 281,   2, 280,   6, 281,  29,
     280,   6, 280,   7, 281, 253, 280, 281,  280,  20, 281, 255, 280,  29, 281,  29,
     280,   2, 280,   3, 281,   5, 280,  56,  281,  29, 280,   2, 280,  48, 281, 255,
     280,  15, 281,  29, 280,   2, 280,  23,  281,   2, 280,   7, 281, 255, 280,  31,
     281,  29, 280,   2, 280,   8, 281, 255,  280,   2, 281,   2, 280,   3, 281,  46,
     280, 255, 281,  30, 280,   2, 280, 255,  281,   2, 280, 255, 281,   2, 280, 255,
     281,   9, 280,  27, 281,   5, 280,   5,  281,  40, 280,   8, 280,  10, 281,  11,
     280, 255, 281,   2, 280,  34, 281,  29,  280,   2, 280,  11, 281,  21, 280,  16,
     281, 255, 280,  15, 281,  29, 280,   2,  280,  22, 281,   8, 280, 255, 281,   6,
     280,   2, 281,   2, 280, 255, 281,   4,  280,  18, 281,  29, 280,   2, 280,  14,
     281,   2, 280, 254, 281, 280,  30, 281,   45, 280,  15, 280,  51, 281,  29, 280,
       2, 280,  50, 281,  43, 280,   2, 280,   43, 281,   9, 280,   7, 281,  34, 280,
      34, 280, 224,  18,  19,  20, 280,  21,   22,  23,  24,  25,  26,  27,  28,  29,
      30,  31,  32,  33,  34,  35,  36,  37,   38,  39,  40,  41,  42,  43,  44,  45,
      46,  47,  48,  29, 280,   2, 280,  22,  281,   4, 280, 255, 281,   9, 280, 255,
     281,   3, 280, 255, 281,   7, 280,  15,  281,  30, 280,   2, 280,  25, 281,   5,
     280, 255, 281,  62, 280,  34, 280,  21,  281,  40, 280,   2, 280,  60, 281, 255,
     280,   3, 281,  29, 280,   2, 280,  13,  281, 255, 280,   3, 281,   4, 280,  43,
     281,  29, 280,   2, 280,   4, 281, 255,  280,   8, 281,   2, 280,   2, 281,   2,
     280,  22, 281, 255, 280,   7, 281, 254,  280, 281,   3, 280,   4, 281,   3, 280,
       3, 281,  29, 280,   2, 280,   5, 281,    2, 280,   2, 281,   2, 280,   2, 281,
     254, 280, 281,   8, 280, 255, 281,   4,  280,   2, 281, 255, 280,   5, 281,   2,
     280,  22, 281,  33, 280,   3, 280,   3,  281, 255, 280,   6, 281,   4, 280,   2,
     281,   2, 280,  22, 281, 255, 280,   7,  281, 255, 280,   2, 281, 255, 280,   2,
     281, 255, 280,   2, 281,   4, 280,   2,  281,  29, 280,   2, 280,   3, 281,   4,
     280,   2, 281,   2, 280,   2, 281,   4,  280, 255, 281,   7, 280,   4, 281, 254,
     280, 281,   7, 280,  16, 281,  39, 280,    3, 280,   3, 281, 255, 280,   9, 281,
     255, 280,   3, 281, 255, 280,  22, 281,  255, 280,   7, 281, 255, 280,   2, 281,
     255, 280,   5, 281,   3, 280,   3, 281,   29, 280,   2, 280,   6, 281, 255, 280,
       3, 281, 255, 280,   2, 281,   3, 280,  255, 281,  15, 280,   4, 281,   2, 280,
      12, 281,   7, 280, 255, 281,  35, 280,    3, 280,   3, 281, 255, 280,   8, 281,
       2, 280,   2, 281,   2, 280,  22, 281,  255, 280,   7, 281, 255, 280,   2, 281,
     255, 280,   5, 281,   3, 280,   3, 281,   29, 280,   2, 280,   5, 281,   2, 280,
       2, 281,   2, 280,   2, 281,   9, 280,    2, 281,   4, 280,   2, 281, 255, 280,
       5, 281,   2, 280,  18, 281,  37, 280,    4, 280,   2, 281, 255, 280,   6, 281,
       3, 280,   3, 281, 255, 280,   4, 281,    3, 280,   2, 281, 253, 280, 281, 280,
       2, 281,   3, 280,   2, 281,   3, 280,    3, 281,   3, 280,  12, 281,   4, 280,
       2, 281,  29, 280,   2, 280,   3, 281,    3, 280,   3, 281, 255, 280,   3, 281,
       3, 280, 255, 281,   6, 280, 255, 281,   14, 280,  21, 281,  34, 280,   2, 280,
       4, 281, 255, 280,   8, 281, 255, 280,    3, 281, 255, 280,  23, 281, 255, 280,
      16, 281,   3, 280,   3, 281,  29, 280,    2, 280,   5, 281, 255, 280,   3, 281,
     255, 280,   3, 281,  11, 280,   3, 281,    5, 280,   4, 281,   2, 280,  10, 281,
       8, 280,   8, 281,  29, 280,   3, 280,    3, 281, 255, 280,   8, 281, 255, 280,
       3, 281, 255, 280,  23, 281, 255, 280,   10, 281, 255, 280,   5, 281,   3, 280,
       3, 281,  29, 280,   2, 280,   5, 281,  255, 280,   3, 281, 255, 280,   3, 281,
       8, 280,   2, 281,   7, 280, 254, 281,  280,   4, 281,   2, 280,  10, 281, 255,
     280,   2, 281,  42, 280,   3, 280,   3,  281, 255, 280,   8, 281, 255, 280,   3,
     281, 255, 280,  41, 281,   2, 280,   3,  281,  29, 280,   2, 280,   5, 281, 255,
     280,   3, 281, 255, 280,   3, 281, 254,  280, 281,   8, 280, 255, 281,   7, 280,
       5, 281,   2, 280,  16, 281,   3, 280,    7, 281,  29, 280,   4, 280,   2, 281,
     255, 280,  18, 281,   3, 280,  24, 281,  255, 280,   9, 281, 254, 280, 281,  31,
     280,   2, 280,   7, 281,   8, 280,   6,  281, 253, 280, 281, 280,   8, 281,   6,
     280,  10, 281,   2, 280,   3, 281,  40,  280,   3, 280,  55, 281,   7, 280, 255,
     281,  29, 280,   2, 280,   8, 281,   4,  280,  16, 281,  65, 280,   3, 280,   2,
     281, 254, 280, 281,   2, 280,   2, 281,  254, 280, 281,   2, 280, 255, 281,   6,
     280,   4, 281, 255, 280,   7, 281, 255,  280,   3, 281, 252, 280, 281, 280, 281,
       2, 280,   2, 281, 255, 280,  11, 281,    3, 280,   3, 281,  31, 280,   2, 280,
       5, 281, 254, 280, 281,   5, 280,   2,  281,   2, 280,  10, 281,   2, 280,   4,
     281,  61, 280,   2, 280,  24, 281,   2,  280,  27, 281, 251, 280, 281, 280, 281,
     280,   6, 281,  29, 280,   2, 280,   8,  281, 255, 280,  36, 281,   6, 280, 254,
     281, 280,   5, 281,   4, 280,   2, 281,   29, 280,   3, 280, 255, 281,   3, 280,
     255, 281,   2, 280,  16, 281, 255, 280,   36, 281, 255, 280,   2, 281,  29, 280,
       2, 280,   6, 281, 255, 280,   6, 281,  255, 280,  13, 281,  66, 280,   2, 280,
     252,  50,   2,  51,  52,   5,   2, 249,   53,  54,  55,  56,  57,  58,  59,  10,
       2, 230,  60,  61,  62,  63,   2,  64,   65,  66,  67,  68,  69,  70,  71,  72,
      73,  74,  75, 280,  76,  77,  78,  79,   80,  81, 280,  82,   3,   2, 255, 280,
       4,   2, 252,  83,  84,  85,  86,  29,  280,   2, 280,  55, 281, 254, 280, 281,
       2, 280,   5, 281,  29, 280,   2, 280,   13, 281, 255, 280,  50, 281,  29, 280,
       2, 280,   6, 281, 254, 280, 281,   5,  280, 255, 281,   2, 280,  48, 281,  29,
     280,   2, 280,   9, 281, 255, 280,   4,  281,   2, 280,   7, 281, 253, 280, 281,
     280,   4, 281,   2, 280,  32, 281,  29,  280,   2, 280,   9, 281, 255, 280,   4,
     281,   2, 280,  33, 281, 255, 280,   4,  281,   2, 280,   7, 281,  30, 280,   2,
     280, 254, 281, 280,   4, 281,   2, 280,   15, 281, 255, 280,  40, 281,  29, 280,
       2, 280,  17, 281, 255, 280,   4, 281,    2, 280,  40, 281,  29, 280,   2, 280,
      27, 281,   5, 280,  29, 281,  32, 280,    2, 280,  26, 281,   6, 280,  32, 281,
      29, 280,   2, 280,  54, 281,   2, 280,    6, 281,  31, 280,   2, 280,  29, 281,
       3, 280,  32, 281,  29, 280,   2, 280,   57, 281,  36, 280,   2, 280,  13, 281,
     255, 280,   6, 281,  12, 280,  20, 281,  255, 280,   2, 281,  38, 280,   2, 280,
      20, 281,  12, 280,  13, 281, 255, 280,    3, 281, 255, 280,   2, 281,  41, 280,
       2, 280,  18, 281, 255, 280,  10, 281,    3, 280,  10, 281,   6, 280,  10, 281,
      35, 280,   2, 280,  14, 281,   2, 280,   10, 281,   6, 280,  32, 281,  29, 280,
       2, 280,  56, 281,  37, 280,   2, 280,   41, 281, 254, 280, 281,   5, 280,  16,
     281,  29, 280,   2, 280,  54, 281,  39,  280,   2, 280,  31, 281, 255, 280,  12,
     281,   4, 280,   9, 281,  36, 280,   2,  280, 255, 281,   3, 280,  42, 281,   2,
     280,   5, 281,  40, 280,   2, 280,  44,  281,   4, 280,  16, 281,  29, 280,   2,
     280,  10, 281,   6, 280,  11, 281,   3,  280,  34, 281,  29, 280,   2, 280,  23,
     281,   2, 280,   3, 281,   2, 280,  34,  281,  29, 280,   2, 280,  31, 281,   2,
     280,  20, 281,  40, 280,   2, 280,  10,  281,   6, 280,  10, 281,   6, 280,  14,
     281,  16, 280, 255, 281,  30, 280,   2,  280,  52, 281, 255, 280,  11, 281,  29,
     280,   2, 280,   4, 281, 255, 280,   7,  281,   4, 280,  27, 281,   9, 280,   9,
     281,  32, 280,   2, 280,  42, 281,   2,  280,  20, 281,  29, 280,   2, 280,  38,
     281, 255, 280,  11, 281,  10, 280,   4,  281,  29, 280,   2, 280,  55, 281,   4,
     280,   5, 281,  29, 280,   2, 280,  10,  281,   3, 280,  51, 281,  29, 280,   2,
     280,   8, 281,  11, 280, 255, 281,  13,  280, 255, 281,   7, 280,   4, 281, 255,
     280,   6, 281, 255, 280,   2, 281,  38,  280,   2, 280,  22, 281,   2, 280,   6,
     281,   2, 280,  32, 281,  29, 280,   2,  280,   6, 281,   2, 280,   6, 281,   2,
     280,   8, 281, 249, 280, 281, 280, 281,  280, 281, 280,  31, 281,  31, 280,   2,
     280,  53, 281, 255, 280,  10, 281,  29,  280,   2, 280,   5, 281, 255, 280,  14,
     281,   2, 280,   6, 281, 255, 280,  19,  281,   2, 280,   3, 281, 255, 280,   9,
     281,  30, 280,   2, 280, 252,  88,  89,   90,  91,   2,   2, 255,  92,   8,   2,
     253,  93,  94,  95,  27,   2, 241,  96,   97,  98,  99, 100,   2, 101, 102, 103,
     104, 105,   2, 106, 107, 108,   3,   2,  255, 109,  29, 280,   2, 280,  11, 281,
       5, 280,  26, 281,   5, 280,  17, 281,   29, 280,   2, 280,  32, 281,  16, 280,
       2, 281,   2, 280,  12, 281,  29, 280,    2, 280,  15, 281, 255, 280,  13, 281,
       3, 280,  31, 281,  30, 280,  31, 280,    4, 281, 255, 280,   3, 281,  56, 280,
       2, 280,  12, 281,   4, 280,  48, 281,   29, 280,   2, 280,  59, 281,  34, 280,
       2, 280,  39, 281,  54, 280,   2, 280,   11, 281,  21, 280,  32, 281,  29, 280,
       2, 280,  52, 281,   2, 280,  10, 281,   29, 280,   2, 280,  22, 281,   2, 280,
      34, 281,   3, 280,   3, 281,  29, 280,    2, 280,   9, 281, 255, 280,   8, 281,
      26, 280,   4, 281,  45, 280,   2, 280,   47, 281, 255, 280,  16, 281,  29, 280,
       2, 280,  31, 281, 255, 280,  32, 281,   29, 280,   2, 280,  47, 281,   3, 280,
       2, 281,   5, 280,   7, 281,  29, 280,    2, 280,  38, 281, 254, 280, 281,   5,
     280, 255, 281,   2, 280,  16, 281,  29,  280,   2, 280,  40, 281,   7, 280,   2,
     281,  44, 280,   2, 280,  23, 281,   9,  280,   7, 281, 255, 280,   7, 281, 255,
     280,   7, 281, 255, 280,   7, 281,  30,  280,   2, 280,   7, 281, 255, 280,   7,
     281, 255, 280,   7, 281, 255, 280,   7,  281,  62, 280,   2, 280,   3, 281,  90,
     280,   2, 280,  26, 281, 255, 280,  37,  281,  29, 280,   2, 280,  52, 281,  41,
     280,   2, 280,  22, 281,  26, 280,  12,  281,  33, 280,   2, 280, 247, 111, 112,
     113,   2, 114,   2, 115, 116, 100,   2,    2, 255, 117,  52,   2,  29, 280,   2,
     280,  42, 281,   6, 280,  16, 281,  29,  280,   3, 280,  63, 281,  29, 280,   2,
     280,  23, 281,   4, 280,  37, 281,  29,  280,   7, 280,  41, 281,   3, 280,  15,
     281,  29, 280,   2, 280,  15, 281, 255,  280,  43, 281,  34, 280,   2, 280,  36,
     281,  12, 280,  16, 281,  29, 280,   2,  280,  63, 281,  30, 280,   2, 280,  54,
       2, 255,  68,   9,   2,  29, 280,   2,  280,  64,   2,  29, 280,   2, 280,  63,
       2, 255, 121,  29, 280,   2, 280,  22,  281,  71, 280,   2, 280,  18,   2, 254,
     123, 124,   4,   2, 252, 125, 126, 127,  128,   2,   2, 238, 129, 130, 131,  66,
       2, 132, 133, 134, 135, 136, 137, 138,  139, 140, 141, 142,   2, 143,  16,   2,
      29, 280,   2, 280,  13, 281,   3, 280,   48, 281,  29, 280,   2, 280,   7, 281,
       9, 280,  48, 281,  29, 280,   2, 280,   44, 281,  49, 280,   2, 280,  47, 281,
     255, 280,   4, 281,  10, 280,   2, 281,   29, 280,   2, 280,  30, 281,   2, 280,
      32, 281,  29, 280,   2, 280,  48, 281,    2, 280,   6, 281,  37, 280,   2, 280,
      46, 281,   2, 280,   8, 281,  37, 280,   57, 280,   9, 281,  29, 280,   2, 280,
       6, 281, 255, 280,  37, 281,   4, 280,   10, 281,  35, 280,   2, 280,   4, 281,
      10, 280,  12, 281,  24, 280,  12, 281,   31, 280,   2, 280,  43, 281,   3, 280,
      18, 281,  29, 280,   2, 280,  19, 281,   12, 280,  30, 281,  32, 280,   2, 280,
      51, 281, 255, 280,  12, 281,  29, 280,    3, 280,  13, 281, 255, 280,  11, 281,
       4, 280,  33, 281,  30, 280,   2, 280,   55, 281,  38, 280,   2, 280,  14, 281,
       2, 280,  10, 281,   2, 280,  36, 281,   29, 280,   2, 280,  48, 281, 254, 280,
     281,   3, 280,   2, 281,   2, 280,   5,  281,  31, 280,   2, 280, 253, 281, 280,
     281,  24, 280,  27, 281,  39, 280,   3,  280,   6, 281,   2, 280,   6, 281,   2,
     280,   6, 281,   9, 280,   7, 281, 255,  280,   7, 281, 255, 280,  16, 281,  29,
     280,   2, 280,  38, 281,  10, 280,  16,  281,  29, 280,   2, 280,  45, 281,   3,
     280,  10, 281,  35, 280,   2, 280,  30,    2, 254, 116, 145,  61, 280,   2, 280,
       7, 281,   4, 280,  49, 281,  33, 280,    2, 280,   4,   2,  89, 280,  37, 280,
     255, 148,   5,   2, 249, 149,   2, 150,  151, 152,   2, 153,   5,   2, 245, 148,
     154, 155, 156, 157,   2, 158, 112,   2,  117, 159,  29, 280,  18, 280,  48, 281,
      29, 280,   2, 280,  46, 281,   2, 280,   16, 281,  29, 280,   2, 280,  26, 281,
      67, 280,   2, 280,   7, 281,  12, 280,    5, 281,   5, 280, 254, 281, 280,  24,
     281, 255, 280,   5, 281, 254, 280, 281,   30, 280,   2, 280,   2, 281, 255, 280,
       2, 281, 255, 280,  58, 281,  29, 280,    2, 280,   2, 281,  17, 280,  45, 281,
      29, 280,   2, 280,  16, 281,   2, 280,   46, 281,  29, 280,   2, 280,   8, 281,
      40, 280,  14, 281,  31, 280,   2, 280,   26, 281,  22, 280,  16, 281,  29, 280,
       2, 280,  19, 281, 255, 280,  19, 281,  255, 280,   4, 281,   4, 280,   5, 281,
     255, 280,  10, 281,  29, 280,   2, 280,   61, 281,  32, 280,   4, 280,   6, 281,
       2, 280,   6, 281,   2, 280,   6, 281,    2, 280,   3, 281,   3, 280,   7, 281,
     255, 280,   7, 281,  13, 280,   2, 281,   31, 280,  18, 280, 249, 161, 192, 212,
     215, 217, 280, 219,   4, 280, 251, 227,  280, 231, 246, 252,  10, 119, 253, 269,
     271, 273,   2, 280, 255, 275,  45, 280,    2, 280, 248, 162, 163,   2,  93, 164,
       2, 165, 166,   2, 280, 250,  60, 167,  116, 168, 169, 170,   2,   2, 252, 171,
     280, 172, 173,   2, 280,   4,   2, 254,  137, 174,   2, 280, 236, 175, 176, 177,
     178, 179, 280, 180, 154, 181, 182, 183,  184, 185, 186, 187, 280,   2, 188, 189,
     190,   5, 280, 255, 191,  35, 280,   2,  280,  12, 281, 255, 280,  26, 281, 255,
     280,  19, 281, 255, 280,   2, 281, 254,  280, 281,  29, 280,   2, 280,  14, 281,
       2, 280,  14, 281,  63, 280,   2, 280,    3, 281,   4, 280,  45, 281,   3, 280,
       9, 281,  29, 280,   2, 280,  13, 281,    3, 280,  12, 281,   4, 280, 255, 281,
      60, 280,  18, 280,  45, 281,  32, 280,    2, 280,  17, 281,  16, 280,  27, 281,
      33, 280,   2, 280,  11, 281,   5, 280,   38, 281,  39, 280,   2, 280,  30, 281,
     255, 280,  33, 281,  29, 280,   2, 280,    4, 281,   4, 280,  14, 281,  71, 280,
       2, 280,  30, 281,   2, 280,  10, 281,   51, 280,   2, 280,  40, 281,   8, 280,
      16, 281,  29, 280,   2, 280,  36, 281,   11, 280, 255, 281,  45, 280,   2, 280,
      22, 281,  10, 280,   8, 281,  53, 280,    2, 280,   6, 281,   2, 280, 254, 281,
     280,  44, 281, 255, 280,   2, 281,   3,  280, 255, 281,   2, 280, 255, 281,  29,
     280,   2, 280,  22, 281, 255, 280,  41,  281,  29, 280,   2, 280,  31, 281,   8,
     280,   9, 281,  45, 280,  34, 280,  19,  281, 255, 280,   2, 281,   5, 280,   5,
     281,  29, 280,   2, 280,  28, 281,   3,  280,  27, 281,   5, 280, 255, 281,  29,
     280,   2, 280,  56, 281,   4, 280,   4,  281,  29, 280,   2, 280,   4, 281, 255,
     280,   2, 281,   5, 280, 252, 281, 280,  281, 280,   4, 281, 255, 280,   3, 281,
     255, 280,  27, 281,  41, 280,   2, 280,    8, 281,   8, 280,   9, 281,   7, 280,
      32, 281,  29, 280,   2, 280,  32, 281,   61, 280,   2, 280,  37, 281,   6, 280,
      12, 281,  38, 280,   2, 280,  54, 281,    3, 280,   7, 281,  29, 280,   2, 280,
      22, 281,   2, 280,  27, 281,   5, 280,    8, 281,  29, 280,   2, 280,  18, 281,
       7, 280,   4, 281,  12, 280,   7, 281,   45, 280,   2, 280,   9, 281,  84, 280,
       2, 280,  51, 281,  42, 280,   2, 280,   51, 281,   7, 280,   6, 281,  29, 280,
      34, 280,  31, 281,  30, 280,   2, 280,  242,   2, 193, 194, 195, 196, 197,   2,
     198, 199, 280, 200, 201, 202, 203,   4,  280, 254,   2, 204,   2, 280, 249, 205,
     206, 117, 207,  68, 208, 209,   5, 280,  254, 210, 211,   7, 280, 255,  61,  49,
     280,   2, 280,   6, 281, 255, 280,   7,  281,   4, 280,  30, 281,  45, 280,   2,
     280,  57, 281,   2, 280,   2, 281, 255,  280,   2, 281,  29, 280,   2, 280,   2,
     281,  14, 280,  25, 281,   7, 280,  10,  281,  35, 280,   5, 280,  48, 281,   3,
     280,  10, 281,  29, 280,   2, 280,   4,  281,  12, 280,  35, 281, 255, 280,   3,
     281,  38, 280,   3, 280,   9, 281, 255,  280,   3, 281,   2, 280,  16, 281, 255,
     280,  20, 281,  40, 280,   2, 280,  18,  281, 255, 280,  34, 281,   2, 280,   7,
     281,  31, 280,   2, 280,   7, 281, 253,  280, 281, 280,   4, 281, 255, 280,  15,
     281, 255, 280,  11, 281,   6, 280,  16,  281,  29, 280,   2, 280,  41, 281,   7,
     280,  10, 281,  35, 280,   2, 280,   4,  281, 255, 280,   8, 281,   2, 280,   2,
     281,   2, 280,  22, 281, 255, 280,   7,  281, 255, 280,   2, 281, 255, 280,   5,
     281,   3, 280,   3, 281,  29, 280,   2,  280,   5, 281,   2, 280,   2, 281,   2,
     280,   2, 281,   3, 280, 255, 281,   6,  280, 255, 281,   5, 280,   7, 281,  57,
     280,   2, 280,   2, 281,   2, 280,   4,  281,   8, 280,  10, 281,  67, 280,   2,
     280,  54, 281,   2, 280,   7, 281,  30,  280,   3, 280,  29, 281,  63, 280,   2,
     280,   5, 281,  11, 280,  10, 281,  67,  280,   2, 280,  10, 281,  83, 280,   2,
     280,  26, 281,   3, 280,  14, 281,   5,  280,  16, 281,  29, 280,  34, 280,  32,
     281,  29, 280,   2, 280,  51, 281,  12,  280, 255, 281,  29, 280,   2, 280,  14,
       2, 252, 150, 280,   2, 213,   3,   2,  255, 214,  71, 280,   2, 280,  47, 281,
     255, 280,   5, 281,  40, 280,   2, 280,    4, 281,  89, 280,   2, 280,  16,   2,
     255, 216,  76, 280,   2, 280,  47, 281,   46, 280,  18, 280,   9,   2, 255, 218,
      67, 280,   2, 280,   7, 281,  86, 280,   34, 280,   8,   2, 249,  61, 220, 280,
     221, 222, 223, 224,  13, 280, 253,   2,  225, 226,  30, 280,   2, 280,  31, 281,
     255, 280,  10, 281,   4, 280,   2, 281,   45, 280,  18, 280,  30, 281,   7, 280,
     255, 281,  39, 280,   2, 280,  48, 281,    7, 280,   9, 281,  29, 280,   2, 280,
       6, 281,  10, 280,  10, 281, 255, 280,    7, 281, 255, 280,  21, 281,   5, 280,
       3, 281,  29, 280,   2, 280,  16, 281,   77, 280,   2, 280,   5, 281,  11, 280,
      47, 281,  30, 280,  17, 280,  17, 281,   61, 280,   2, 280, 255, 228,  47, 280,
     253,   2, 229, 230,  42, 280,   2, 280,    2, 281,  91, 280,   2, 280,  43, 281,
       5, 280,  13, 281,  32, 280,   2, 280,    9, 281,   7, 280,  10, 281,   2, 280,
       2, 281, 254, 280, 281,  61, 280,   2,  280,   3,   2, 249,  68, 232, 233, 234,
     235,   2, 236,   2, 280, 254,   2, 237,    2, 280, 250,   2, 238, 239, 240, 241,
     242,   4,   2, 255, 243,   4,   2, 255,  244,  10,   2, 255, 245,  50, 280,   2,
     280,  39, 281,   2, 280,  23, 281,  29,  280,   2, 280,  37, 281,   5, 280,   3,
     281,  48, 280,   5, 280,   2, 281,   7,  280,  30, 281,   4, 280,  18, 281,  29,
     280,   2, 280,  41, 281,  52, 280,   2,  280,   2, 281,   3, 280, 255, 281,  87,
     280,   2, 280,  23, 281,   9, 280,  18,  281,  43, 280,   2, 280,  21, 281, 255,
     280,  42, 281,  29, 280,   2, 280,  29,  281, 255, 280,   2, 281,   2, 280, 255,
     281,   2, 280,   2, 281,   2, 280,   4,  281, 255, 280,  12, 281, 253, 280, 281,
     280,   3, 281,  29, 280,   2, 280,   4,  281, 255, 280,  59, 281,  29, 280,   2,
     280,   6, 281, 255, 280,   4, 281,   2,  280,   8, 281, 255, 280,   7, 281, 255,
     280,  28, 281, 255, 280,   4, 281,  30,  280,   2, 280,   5, 281, 254, 280, 281,
       3, 280,   7, 281, 255, 280,  46, 281,   29, 280,   2, 280,  38, 281,   2, 280,
      24, 281,  29, 280,   2, 280,  12, 281,    2, 280,  50, 281,  29, 280,   2, 280,
      12, 281,  15, 280,   5, 281, 255, 280,   15, 281,  45, 280,  34, 280,   3,   2,
     255, 247,  20, 280, 252, 248, 249, 250,  251,  33, 280,   2, 280,   5, 281,   2,
     280,   9, 281,  77, 280,   2, 280,   4,  281, 255, 280,  27, 281, 255, 280,   2,
     281, 254, 280, 281,   2, 280, 254, 281,  280,  10, 281, 255, 280,   4, 281, 252,
     280, 281, 280, 281,  33, 280,   4, 280,  255, 281,   4, 280, 250, 281, 280, 281,
     280, 281, 280,   3, 281, 255, 280,   2,  281, 254, 280, 281,   2, 280, 246, 281,
     280, 281, 280, 281, 280, 281, 280, 281,  280,   2, 281, 254, 280, 281,   2, 280,
       4, 281, 255, 280,   7, 281, 255, 280,    4, 281, 255, 280,   4, 281, 254, 280,
     281,  30, 280,   2, 280,  10, 281, 255,  280,  17, 281,   5, 280,   3, 281, 255,
     280,   5, 281, 255, 280,  17, 281,  33,  280,  50, 280,   2, 281,  43, 280,   2,
     280, 246,  71,   2, 253, 254, 255,  71,  256, 257, 258, 259,   2, 280,   9,   2,
     254, 260, 261,   4,   2, 243, 262,   2,  108,   2, 263,  92, 264, 265, 280, 266,
     280, 267, 268,  53, 280,   2, 280,  20,  281,  12, 280,  15, 281,   2, 280,  15,
     281,  29, 280,   3, 280,  15, 281, 255,  280,  37, 281,  39, 280,   2, 280,  13,
     281,   3, 280,  31, 281, 255, 280,  16,  281,  29, 280,   2, 280,  27, 281,  66,
     280,  40, 280,  26, 281,  29, 280,   2,  280,   3, 281,  13, 280,  43, 281,  34,
     280,   2, 280,   9, 281,   7, 280,   2,  281,  75, 280,   2, 280,  58, 281, 255,
     280,   5, 281,  29, 280,   2, 280,  36,  281, 255, 280,  27, 281,  29, 280,   2,
     280,  17, 281,  15, 280,  13, 281,   3,  280,   4, 281,  41, 280,   2, 280,  21,
     281,  72, 280,   2, 280,   8, 281,   8,  280,  10, 281,   6, 280,  32, 281,  29,
     280,   2, 280,   8, 281,   8, 280,  30,  281,  47, 280,  18, 280,   9, 281,  68,
     280,   2, 280,   5, 281,  88, 280,   2,  280, 255, 281,  92, 280,   2, 280,  27,
       2, 255, 270,  36,   2,  29, 280,   2,  280,  23, 281,  70, 280,   2, 280,  28,
       2, 255, 272,  35,   2,  29, 280,   2,  280,  53, 281,  40, 280,   2, 280,  58,
       2, 255, 274,  34, 280,   2, 280,  34,  281,  59, 280,  34, 280,   8,   2, 255,
     276,  52, 280,   2, 280,  30, 281,  63,  280,  34, 280, 255, 278,  60, 280,   6,
     280,   3,   2, 255, 279,  85, 280,   2,  280,  48, 281,  45, 280
};

// utf/cl_AttrNameInitial.txt
//
// 177 included, 1113935 excluded, 0 errors.
// 6 states, 14 columns, 312 bytes
//
const unsigned char cl_attrnameinitial_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   1,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   1,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   1,   0,

       2,   3,   4,   4,   4,   5,   5,   4,    3,   2,   2,   2,   5,   5,   5,   5,
       4,   4,   6,   3,   3,   3,   2,   0,    4,   4,   4,   4,   2,   2,   3,   3,
       3,   3,   3,   3,   3,   3,   2,   2,    2,   2,   7,   2,   2,   2,   3,   3,
       3,   3,   2,   2,   2,   7,   2,   0,    3,   4,   8,   3,   3,   4,   4,   2,
       0,   0,   9,  10,  11,  12,  13,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_attrnameinitial_sot[6] =
{
        0,   11,   17,   23,   33,   44
};

const unsigned char cl_attrnameinitial_sbt[50] =
{
     254,   6,   7,   7,   6, 251,   1,   2,    3,   4,   5,   7,   6,   2,   7,   5,
       6,   2,   6,   7,   7,   5,   6,   4,    6,   2,   7,   2,   6, 255,   7,   5,
       6,   3,   6,   2,   7, 252,   6,   7,    6,   7,   5,   6,   6,   6, 255,   7,
       7,   6
};

// utf/cl_AttrName.txt
//
// 203 included, 1113909 excluded, 0 errors.
// 6 states, 14 columns, 312 bytes
//
const unsigned char cl_attrname_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   0,   1,   1,   0,   1,   1,    1,   1,   0,   1,   0,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   0,   0,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   1,   0,

       2,   3,   4,   4,   4,   5,   5,   4,    3,   2,   2,   2,   5,   5,   5,   5,
       4,   4,   6,   3,   3,   3,   2,   0,    4,   4,   4,   4,   2,   2,   3,   3,
       3,   3,   3,   3,   3,   3,   2,   2,    2,   2,   7,   2,   2,   2,   3,   3,
       3,   3,   2,   2,   2,   7,   2,   0,    3,   4,   8,   3,   3,   4,   4,   2,
       0,   0,   9,  10,  11,  12,  13,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_attrname_sot[6] =
{
        0,   11,   17,   23,   33,   44
};

const unsigned char cl_attrname_sbt[50] =
{
     254,   6,   7,   7,   6, 251,   1,   2,    3,   4,   5,   7,   6,   2,   7,   5,
       6,   2,   6,   7,   7,   5,   6,   4,    6,   2,   7,   2,   6, 255,   7,   5,
       6,   3,   6,   2,   7, 252,   6,   7,    6,   7,   5,   6,   6,   6, 255,   7,
       7,   6
};

// utf/cl_ObjectName.txt
//
// 87250 included, 1026862 excluded, 0 errors.
// 32 states, 63 columns, 643 bytes
//
const unsigned char cl_objectname_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       1,   1,   1,   1,   1,   1,   0,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   0,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   0,   1,   1,   0,

       2,   3,   4,   5,   6,   7,   7,   8,    9,  10,  10,  10,  11,  11,  11,  11,
      12,  12,  13,  14,  15,  16,  17,  18,   19,  19,  20,  21,  22,  23,  24,  25,
      26,  27,  27,  28,  29,  29,  30,  31,   32,  33,  34,  35,  36,  36,  37,  38,
      39,  40,  41,  41,  41,  42,  43,  44,   45,  46,  47,  45,  45,  47,  47,  48,
       0,   0,  49,  50,  51,  52,  53,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,  54,  55,  56,  57,  57,  57,   57,  58,  59,  57,  57,  60,   0,  61,
      62,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short cl_objectname_sot[32] =
{
        0,   20,   26,   32,   50,   80,   86,   92,   122,  138,  144,  154,  160,  171,  177,  183,
      191,  197,  203,  211,  217,  228,  238,  244,   259,  265,  275,  285,  291,  303,  309,  315

};

const unsigned char cl_objectname_sbt[323] =
{
     254,  32,  33,  47,  32, 242,   1,   2,    3,   4,   5,   6,   8,  12,  14,  15,
      17,  18,  20,  23,  27,  32,  22,  33,   14,  32,   2,  32,  47,  33,  14,  32,
       4,  32,   5,  33,   2,  32,   2,  33,    6,  32,   3,  33,  24,  32,   2,  33,
      15,  32,   3,  32,   4,  33, 255,  32,    2,  33,   2,  32,   5,  33,   2,  32,
       3,  33,   2,  32,   6,  33,   7,  32,    4,  33,   4,  32,   3,  33,  15,  32,
      13,  32, 255,  33,  49,  32,   2,  32,  255,   7,  60,  32,  14,  32,   2,  33,
       3,  32,   2,  33, 255,  32,   3,  33,  255,  32,   2,  33,   2,  32, 255,  33,
       8,  32, 255,  33,   6,  32, 255,  33,   16,  32,   3,  32, 253,   9,  10,   2,
       2,  32, 255,  11,   3,  32,  37,   2,   14,  32,   3,  32,  46,  33,  14,  32,
       2,  32,  16,  33,   3,  32,  28,  33,   14,  32,  39,  32,  10,  33,  14,  32,
       2,  32,  41,   2, 254,  13,  32,   4,    2,  14,  32,   2,  32,  41,  33,  20,
      32,   2,  32,  47,   2,  14,  32,   2,   32,  46,   2, 255,  16,  14,  32,   2,
      32,   9,  33,  52,  32,  39,  32,  10,    2,  14,  32,   2,  32,  22,   2, 255,
      19,  38,  32,   2,  32,  27,  33,  34,   32,  29,  32,   3,   2,   2,  21, 254,
       2,  22,  27,  32,   2,  32,  35,  33,    2,  32,  10,  33,  14,  32,   2,  32,
      18,  33,  43,  32,  25,  32, 255,  24,    8,  14, 254,  26,  28,   2,  32, 255,
      31,  24,  32,   9,  32, 255,  25,  53,   32,   2,  32, 255,  33,  11,  32, 255,
      33,  48,  32,   2,  32,  19,   2, 255,   27,  27,   2,  14,  32,   2,  32,  16,
      33,  45,  32,   2,  32,  20,   2, 255,   29,   3,   2, 255,  30,  36,  32,   2,
      32,  40,  33,  21,  32,   2,  32,  22,   33,  39,  32,  26,  32,   6,   2, 255,
      30,  30,  32
};

// utf/cl_PlayerName.txt
//
// 87183 included, 1026929 excluded, 0 errors.
// 31 states, 58 columns, 626 bytes
//
const unsigned char cl_playername_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   1,   0,   0,   1,    0,   0,   0,   0,   1,   1,   1,   0,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   0,

       2,   3,   4,   5,   6,   7,   7,   8,    9,  10,  10,  10,  11,  11,  11,  11,
      12,  12,  13,  14,  15,  15,  16,  17,   18,  18,  19,  20,  21,  22,  23,  24,
      25,  26,  26,  26,  27,  27,  28,  28,   29,  30,  31,  32,  33,  33,  34,  35,
      36,  36,  37,  37,  37,  38,  39,  40,   41,  42,  43,  41,  41,  42,  42,  44,
       0,   0,  45,  46,  47,  48,  49,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,  50,  51,  52,  52,  52,   52,  53,  54,  52,  52,  55,   0,  56,
      57,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short cl_playername_sot[31] =
{
        0,   19,   33,   47,   65,   95,  101,  117,   123,  133,  139,  145,  156,  162,  168,  176,
      182,  188,  196,  202,  213,  223,  229,  244,   250,  260,  270,  276,  288,  294,  300
};

const unsigned char cl_playername_sbt[308] =
{
     254,  31,  32,  43,  31, 243,   1,   2,    3,   4,   5,   6,  11,  13,  14,  16,
      17,  19,  22,  31,  31, 255,  32,   6,   31, 255,  32,   4,  31, 255,  32,  14,
      31,   2,  31,  15,  32, 255,  31,  22,   32, 255,  31,   4,  32,  13,  31,   4,
      31,   5,  32,   2,  31,   2,  32,   5,   31,   3,  32,  21,  31,   2,  32,  14,
      31,   3,  31,   4,  32, 255,  31,   2,   32,   2,  31,   4,  32,   2,  31,   3,
      32,   2,  31,   5,  32,   6,  31,   3,   32,   4,  31,   3,  32,  14,  31,  13,
      31, 255,  32,  44,  31,   3,  31, 253,    7,   8,   9,   2,  31, 255,  10,   3,
      31,  33,   9,  13,  31,   3,  31,  42,   32,  13,  31,   2,  31,  15,  32,   3,
      31,  25,  32,  13,  31,   2,  31,  43,   32,  13,  31,  36,  31,   9,  32,  13,
      31,   2,  31,  37,   9, 254,  12,  31,    4,   9,  13,  31,   2,  31,  37,  32,
      19,  31,   2,  31,  43,   9,  13,  31,    2,  31,  42,   9, 255,  15,  13,  31,
       2,  31,   9,  32,  47,  31,  36,  31,    9,   9,  13,  31,   2,  31,  21,   9,
     255,  18,  34,  31,   2,  31,  25,  32,   31,  31,  27,  31,   2,   9,   2,  20,
     254,   9,  21,  25,  31,   2,  31,  32,   32,   2,  31,   9,  32,  13,  31,   2,
      31,  17,  32,  39,  31,  24,  31, 255,   23,   6,  13, 254,  25,  27,   2,  31,
     255,  30,  22,  31,   9,  31, 255,  24,   48,  31,   2,  31, 255,  32,  11,  31,
     255,  32,  43,  31,   2,  31,  18,   9,  255,  26,  24,   9,  13,  31,   2,  31,
      15,  32,  41,  31,   2,  31,  19,   9,  255,  28,   3,   9, 255,  29,  32,  31,
       2,  31,  36,  32,  20,  31,   2,  31,   21,  32,  35,  31,  25,  31,   4,   9,
     255,  29,  28,  31
};

// utf/cl_8859_1.txt
//
// 191 included, 1113921 excluded, 0 errors.
// 3 states, 6 columns, 279 bytes
//
const unsigned char cl_8859_1_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   0,

       2,   2,   2,   2,   2,   2,   2,   2,    2,   2,   2,   2,   2,   2,   2,   2,
       2,   2,   2,   2,   2,   2,   2,   2,    2,   2,   2,   2,   2,   2,   2,   2,
       3,   3,   3,   3,   3,   3,   3,   3,    3,   3,   3,   3,   3,   3,   3,   3,
       3,   3,   3,   3,   3,   3,   3,   3,    3,   3,   3,   3,   3,   3,   3,   3,
       0,   0,   4,   5,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_8859_1_sot[3] =
{
        0,    8,   14
};

const unsigned char cl_8859_1_sbt[20] =
{
     254,   3,   4,   2,   3, 254,   1,   2,    3,   3, 255,   4,   2,   3,   2,   3,
       2,   4,   2,   3
};

// utf/cl_8859_2.txt
//
// 191 included, 1113921 excluded, 0 errors.
// 6 states, 21 columns, 335 bytes
//
const unsigned char cl_8859_2_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   0,

       0,   2,   3,   4,   3,   5,   5,   6,    7,   8,   0,   8,   5,   9,   9,   5,
       4,   4,   0,   8,   2,   7,   8,   8,   10,  10,   3,  10,   8,  11,   7,   2,
      12,   2,   2,   7,  13,   7,   0,  14,   15,   8,   0,   8,   0,  14,   2,   7,
      12,   7,   0,   8,  14,   0,   8,   8,   15,   4,   3,   7,   2,   3,   4,   0,
       0,   0,  16,  17,  18,  19,   0,   0,    0,   0,   0,  20,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_8859_2_sot[6] =
{
        0,   11,   17,   36,   46,   63
};

const unsigned char cl_8859_2_sbt[73] =
{
     254,   6,   7,  14,   6, 251,   1,   2,    3,   4,   5,  12,   6,   4,   7,   5,
       6,   2,   6,   2,   7,   2,   6, 254,    7,   6,   2,   7, 253,   6,   7,   6,
       2,   7,   6,   6,   3,   6,   4,   7,    2,   6,   2,   7,  10,   6,   2,   6,
       3,   7, 255,   6,   2,   7,   2,   6,  254,   7,   6,   2,   7,   7,   6,   6,
       6, 255,   7,   3,   6,   2,   7,   9,    6
};

// utf/cl_hangul.txt
//
// 11172 included, 1102940 excluded, 0 errors.
// 6 states, 9 columns, 298 bytes
//
const unsigned char cl_hangul_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   2,   3,
       3,   3,   3,   3,   4,   4,   4,   4,    4,   4,   4,   4,   4,   4,   4,   4,
       5,   5,   5,   5,   5,   5,   5,   5,    5,   5,   5,   5,   5,   5,   5,   5,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   6,   7,   7,   8,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_hangul_sot[6] =
{
        0,    6,   12,   18,   24,   30
};

const unsigned char cl_hangul_sbt[36] =
{
       6,   6, 253,   1,   3,   4,   5,   6,  255,   2,   3,   6, 255,   6,   5,   7,
       3,   6, 255,   6,   5,   2,   3,   6,  253,   6,   2,   5,   6,   6, 255,   6,
       3,   7,   5,   6
};

// utf/cl_hiragana.txt
//
// 94 included, 1114018 excluded, 0 errors.
// 8 states, 12 columns, 315 bytes
//
const unsigned char cl_hiragana_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       1,   2,   3,   4,   5,   5,   5,   5,    6,   5,   5,   5,   5,   5,   5,   5,
       5,   5,   5,   5,   5,   5,   5,   7,    7,   7,   7,   5,   5,   5,   5,   8,
       5,   7,   7,   7,   7,   7,   7,   7,    7,   7,   7,   7,   7,   7,   7,   7,
       7,   7,   7,   7,   7,   7,   7,   7,    7,   7,   7,   7,   9,   7,   7,   7,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,  10,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
      11,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_hiragana_sot[8] =
{
        0,    5,   13,   19,   28,   34,   40,   46
};

const unsigned char cl_hiragana_sbt[51] =
{
      10,   8, 254,   1,   5,   2,   8, 253,    2,   3,   4,   7,   8,   2,   8,   8,
       9,   2,   8, 255,   8,   6,   9, 254,    8,   9,   3,   8,   9,   8, 255,   9,
       2,   8,   8,   8, 255,   6,   3,   8,    6,   8, 255,   7,   5,   8, 254,   8,
       9,  10,   8
};

// utf/cl_kanji.txt
//
// 75616 included, 1038496 excluded, 0 errors.
// 18 states, 30 columns, 417 bytes
//
const unsigned char cl_kanji_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   2,   2,   2,   2,
       3,   3,   3,   3,   3,   3,   3,   4,    4,   4,   5,   6,   7,   5,   8,   8,
       9,  10,  10,  10,  11,  11,  11,  11,   12,  13,  14,  15,  16,  16,  17,  18,
      16,  16,  16,  16,  16,  19,  20,  21,   22,  22,  22,  22,  22,  22,  22,  23,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,  24,  25,  26,  26,  26,   26,  27,   0,   0,   0,   0,   0,  28,
      29,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_kanji_sot[18] =
{
        0,    9,   15,   21,   32,   38,   44,   52,    57,   68,   78,   84,   97,  107,  113,  123,
      129,  135
};

const unsigned char cl_kanji_sbt[143] =
{
      24,  18, 250,   1,   3,   5,   6,   8,   11,   3,  18,  21,   2,   6,  18, 255,
      18,  23,  19,   6,  18, 255,  18,  19,    2, 254,   4,  18,   2,   2,   6,  18,
     255,  18,  19,  19,  10,  18, 255,  18,   23,   2,   6,  18, 255,  18,  22,   2,
     255,   7,   6,  18, 254,  18,  19,  28,   18,  11,  18, 255,   2,   2,   9, 254,
       2,  10,  14,  18, 255,  18,  16,  19,    2,  18,   5,  19,   6,  18, 255,  18,
       4,  19,  25,  18,   9,  18,   5,   5,  254,  12,  14,   2,  18, 255,  17,  11,
      18, 255,  18,   5,   2, 255,  13,  17,    2,   6,  18, 255,  18,   3,  19,  26,
      18, 255,  18,   6,   2, 253,  15,   2,   16,  20,  18, 255,  18,  18,  19,  11,
      18, 255,  18,   7,  19,  22,  18,   9,   18,   3,   2, 255,  16,  17,  18
};

// utf/cl_katakana.txt
//
// 115 included, 1113997 excluded, 0 errors.
// 8 states, 12 columns, 315 bytes
//
const unsigned char cl_katakana_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       1,   1,   2,   3,   1,   1,   1,   4,    5,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   6,   1,   1,   1,   1,    1,   1,   1,   7,   7,   1,   1,   8,
       7,   7,   7,   7,   7,   7,   7,   7,    7,   7,   7,   7,   7,   7,   7,   7,
       9,   9,   9,   9,   9,   9,   9,   9,    9,   9,   9,   9,   9,   9,   9,   9,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,  10,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
      11,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_katakana_sot[8] =
{
        0,    5,   13,   21,   27,   33,   39,   45
};

const unsigned char cl_katakana_sbt[51] =
{
      10,   8, 254,   1,   5,   2,   8, 253,    2,   3,   4,   7,   8,   7,   8, 253,
       9,   8,   9,   2,   8, 255,   8,   9,    9,   2,   8,   9,   8, 255,   9,   2,
       8,   8,   8, 255,   6,   3,   8,   5,    8, 255,   7,   6,   8,   6,   8, 255,
       9,   5,   8
};

// utf/tr_utf8_ascii.txt
//
// 2538 code points.
// 99 states, 193 columns, 3885 bytes
//
const unsigned char tr_ascii_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   1,    2,   3,   4,   0,   0,   5,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   6,   0,   0,   0,   0,
       7,   8,   9,  10,  11,  12,  13,  14,   15,  16,  17,  18,  19,  20,  21,  22,
      23,  24,  25,  26,  27,  28,  29,  30,   31,  32,  33,  34,  35,  36,  37,   0,
      38,  39,  40,  41,  42,  43,  44,  45,   46,  47,  48,  49,  50,  51,  52,  53,
      54,  55,  56,  57,  58,  59,  60,  61,   62,  63,  64,  65,  66,  67,  68,  69,
      70,  71,  72,  73,  74,  75,  76,  77,   78,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,  90,  91,  92,  93,   94,  95,  96,  97,  98,  99, 100,   0,

     101, 102, 103, 104, 105, 106, 107, 108,  109, 110, 111, 112, 113, 114, 115, 116,
     117, 118, 119, 120, 121, 122, 123, 124,  125, 126, 127, 128, 129, 130, 131, 132,
     133, 134, 135, 136, 137, 138, 139, 140,  141, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
       0,   0, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174,   0, 175, 176,   0,
     177, 178, 179, 180,   0, 181, 182,   0,    0, 183,   0, 184,   0,   0,   0, 185,
     186, 187, 188, 189,   0,   0,   0,   0,    0,   0, 190,   0,   0,   0,   0, 191,
     192,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_ascii_sot[99] =
{
        0,  133,  166,  216,  285,  356,  418,  482,   553,  607,  644,  659,  671,  677,  721,  741,
      755,  784,  792,  798,  815,  832,  851,  882,   899,  914,  965,  980,  996, 1015, 1032, 1048,
     1076, 1140, 1203, 1271, 1340, 1409, 1477, 1540,  1550, 1574, 1617, 1655, 1693, 1727, 1780, 1826,
     1836, 1849, 1865, 1893, 1946, 2008, 2014, 2034,  2058, 2076, 2082, 2092, 2121, 2130, 2146, 2154,
     2162, 2176, 2191, 2210, 2231, 2255, 2263, 2271,  2292, 2351, 2419, 2455, 2463, 2476, 2492, 2502,
     2511, 2527, 2533, 2560, 2580, 2649, 2718, 2790,  2859, 2928, 2997, 3066, 3135, 3204, 3273, 3314,
     3369, 3376, 3416
};

const unsigned char tr_ascii_sbt[3431] =
{
     155, 162, 106, 107, 108, 109, 112, 126,  131, 132, 133, 134, 135, 136, 137, 138,
     139, 140, 141, 142, 143, 144, 145, 146,  147, 148, 149, 150, 151, 152, 153, 154,
     155, 156, 157, 158, 159, 160, 161, 163,  164, 165, 166, 167, 168, 169, 170, 171,
     172, 173, 174, 175, 176, 177, 178, 179,  180, 181, 182, 183, 184, 185, 186, 187,
     188, 189, 190, 191, 192, 193, 194, 195,  196, 197, 198, 199, 200, 201, 202, 203,
     204, 205, 206, 207, 208, 209, 210, 211,  212, 213, 214, 215, 216, 217, 218, 219,
     220, 221, 222, 223, 224, 225,  64, 162,  228,   1,   2,   3,   4,   5,   6,   7,
       8,   9,  10,  11,  12,  13,  14,  15,   16,  17,  18,  19,  20,  21,  22,  25,
      41,  61,  67,  68,  76, 127, 162,   6,  162, 254, 131, 132,   6, 162, 253, 131,
     162, 196,   2, 162, 253, 144, 162, 131,    2, 162, 253, 149, 150, 131,   3, 162,
     253, 131, 148, 210,  33, 162, 101, 162,    6, 164, 254, 162, 166,   4, 168,   4,
     172, 254, 167, 177,   5, 178, 254, 141,  178,   4, 184, 255, 188,   2, 162,   6,
     196, 254, 162, 198,   4, 200,   4, 204,  254, 199, 209,   5, 210, 254, 146, 210,
       4, 216, 253, 220, 162, 220,  28, 162,  101, 162, 207, 164, 196, 164, 196, 164,
     196, 166, 198, 166, 198, 166, 198, 166,  198, 167, 199, 167, 199, 168, 200, 168,
     200, 168, 200, 168, 200, 168, 200, 170,  202, 170, 202, 170, 202, 170, 202, 171,
     203, 171, 203, 172, 204, 172, 204, 172,  204, 172, 204, 172,   3, 162, 244, 173,
     205, 174, 206, 162, 175, 207, 175, 207,  175, 207, 175,  28, 162, 101, 162, 248,
     207, 175, 207, 177, 209, 177, 209, 177,    2, 209,   2, 162, 250, 178, 210, 178,
     210, 178, 210,   2, 162, 212, 181, 213,  181, 213, 181, 213, 182, 214, 182, 214,
     182, 214, 182, 214, 183, 215, 183, 215,  183, 215, 184, 216, 184, 216, 184, 216,
     184, 216, 184, 216, 184, 216, 186, 218,  188, 220, 188, 189, 221, 189, 221, 189,
     221, 214,  28, 162, 101, 162, 255, 197,    2, 165, 255, 197,   3, 162, 253, 166,
     198, 162,   2, 167, 255, 199,   4, 162,  253, 169, 201, 170,   3, 162, 252, 172,
     174, 206, 207,   2, 162, 254, 177, 209,    2, 178, 255, 210,   2, 162, 254, 179,
     211,   5, 162, 244, 215, 183, 215, 183,  184, 216, 162, 185, 188, 220, 189, 221,
      37, 162, 104, 162, 255, 132,   9, 162,  235, 164, 196, 172, 204, 178, 210, 184,
     216, 184, 216, 184, 216, 184, 216, 184,  216, 162, 164, 196, 164, 196,   2, 162,
     246, 170, 202, 170, 202, 174, 206, 178,  210, 178, 210,   2, 162, 255, 205,   3,
     162, 254, 170, 202,   2, 162, 252, 177,  209, 164, 196,   2, 162, 254, 178, 210,
      28, 162, 101, 162, 228, 164, 196, 164,  196, 168, 200, 168, 200, 172, 204, 172,
     204, 178, 210, 178, 210, 181, 213, 181,  213, 184, 216, 184, 216, 182, 214, 183,
     215,   2, 162, 252, 171, 203, 177, 199,    2, 162, 237, 189, 221, 164, 196, 168,
     200, 178, 210, 178, 210, 178, 210, 178,  210, 188, 220, 207, 209, 215,   3, 162,
     250, 164, 166, 198, 175, 183, 214,  28,  162, 101, 162, 255, 221,   2, 162, 243,
     165, 184, 162, 168, 200, 173, 205, 162,  212, 181, 213, 188, 220,   3, 162, 253,
     197, 162, 198,   2, 199,   8, 162, 255,  202,   5, 162, 253, 203, 162, 204,   2,
     162,   4, 207,   2, 162, 255, 208,   2,  209,   8, 162,   3, 213,  29, 162, 103,
     162, 255, 214,   5, 162, 252, 215, 216,  162, 217,   4, 162,   2, 221,  11, 162,
     255, 205,   2, 162, 255, 212,  15, 162,  252, 203, 162, 205, 213,   3, 162, 254,
     218, 220,  35, 162, 125, 162,   4, 131,  254, 225, 131,   3, 162, 253, 207, 214,
     219,  56, 162, 127, 162,  32, 162, 255,  131,   3, 162, 255, 158,  29, 162, 105,
     162,   2, 131,  86, 162, 105, 162, 253,  168, 162, 172,   6, 162, 255, 172,   2,
     162, 255, 164,   7, 162, 255, 172,   5,  162, 255, 178,   4, 162, 255, 184,   9,
     162, 255, 168,   2, 162, 255, 196,   7,  162, 255, 204,   5, 162, 255, 210,  29,
     162, 104, 162, 255, 216,   9, 162, 255,  200,   6, 162, 253, 200, 162, 204,   6,
     162, 255, 204,  62, 162, 127, 162,  14,  162, 254, 178, 210,  16, 162, 254, 171,
     203,  32, 162, 117, 162, 252, 164, 196,  164, 196,  14, 162, 250, 172, 204, 172,
     204, 178, 210,   4, 162, 248, 168, 200,  184, 216, 184, 216, 184, 216,  40, 162,
     127, 162,   2, 162, 255, 132,  63, 162,  111, 162, 255, 144,  81, 162, 127, 162,
       6, 162, 246, 147, 148, 149, 150, 151,  152, 153, 154, 155, 156,  50, 162, 127,
     162,  22, 162, 246, 147, 148, 149, 150,  151, 152, 153, 154, 155, 156,  34, 162,
     101, 162, 246, 147, 148, 149, 150, 151,  152, 153, 154, 155, 156,  47, 162, 255,
     132,  34, 162, 127, 162,  11, 162, 239,   23, 162,  23, 162,  23, 162,  23, 162,
      23, 162,  23, 162,  23, 162,  23, 162,   23,   3, 162, 252,  24, 162,  24,  19,
      31, 162, 127, 162,  12, 162, 246, 147,  148, 149, 150, 151, 152, 153, 154, 155,
     156,  44, 162, 117, 162, 246, 147, 148,  149, 150, 151, 152, 153, 154, 155, 156,
      66, 162, 102, 162, 254,  26,  24,  10,  162, 255,  27,  17, 162, 254,  19,  28,
       4, 162, 253,  29, 162,  30,   2, 162,  255,  31,   2, 162, 254,  24,  20,   2,
     162, 255,  31,   2, 162, 248,  32,  33,   34, 162,  35,  36,  37,  38,   2, 162,
     254,  39,  40,  28, 162, 101, 162, 246,  147, 148, 149, 150, 151, 152, 153, 154,
     155, 156,  82, 162, 127, 162,  15, 162,  247, 148, 149, 150, 151, 152, 153, 154,
     155, 156,  42, 162, 107, 162, 255, 144,    9, 162, 246, 147, 148, 149, 150, 151,
     152, 153, 154, 155, 156,  66, 162, 105,  162, 244, 132, 162, 147, 148, 149, 150,
     151, 152, 153, 154, 155, 156,  76, 162,  117, 162, 245, 147, 148, 149, 150, 151,
     152, 153, 154, 155, 156, 148,  65, 162,  101, 162, 246, 147, 148, 149, 150, 151,
     152, 153, 154, 155, 156,   6, 162, 246,  147, 148, 149, 150, 151, 152, 153, 154,
     155, 156,  66, 162, 101, 162, 255, 164,    2, 162, 252, 165, 166, 167, 199,   2,
     168, 250, 172, 173, 174, 175, 176, 177,    5, 178,   2, 162,   2, 178, 255, 179,
       2, 181, 255, 183,   3, 184, 252, 176,  185, 186, 189,   9, 162, 236, 164, 162,
     165, 162, 167, 168, 162, 170, 171, 172,  173, 174, 175, 176, 177, 162, 178, 162,
     179, 181,  28, 162, 101, 162, 252, 183,  184, 186, 196,   3, 162, 253, 197, 199,
     200,   3, 162, 250, 202, 162, 206, 208,  162, 210,   3, 162, 253, 211, 215, 216,
       2, 162, 255, 217,   6, 162, 252, 204,  213, 216, 217,   6, 162, 250, 197, 199,
     201, 208, 209, 211,   2, 213, 253, 214,  215, 221,   4, 162, 252, 172, 162, 211,
     184,  29, 162, 101, 162, 237, 197, 199,  201, 202, 206, 207, 208, 209, 211, 213,
     214, 162, 217, 219, 221, 196, 162, 199,  200,   3, 162, 255, 204,   2, 162, 255,
     216,   2, 162,   2, 198, 248, 199, 200,  201, 205, 202, 203, 204, 162,   2, 204,
     255, 205,   3, 207,   2, 208,   3, 209,  248, 210, 162, 214, 162, 215, 216, 162,
     216,   2, 217,   3, 221,  30, 162, 101,  162, 192, 164, 196, 165, 197, 165, 197,
     165, 197, 166, 198, 167, 199, 167, 199,  167, 199, 167, 199, 167, 199, 168, 200,
     168, 200, 168, 200, 168, 200, 168, 200,  169, 201, 170, 202, 171, 203, 171, 203,
     171, 203, 171, 203, 171, 203, 172, 204,  172, 204, 174, 206, 174, 206, 174, 206,
     175, 207, 175, 207, 175, 207, 175, 207,  176, 208,  28, 162, 101, 162, 192, 176,
     208, 176, 208, 177, 209, 177, 209, 177,  209, 177, 209, 178, 210, 178, 210, 178,
     210, 178, 210, 179, 211, 179, 211, 181,  213, 181, 213, 181, 213, 181, 213, 182,
     214, 182, 214, 182, 214, 182, 214, 182,  214, 183, 215, 183, 215, 183, 215, 183,
     215, 184, 216, 184, 216, 184, 216, 184,  216, 184, 216, 185, 217, 185, 217,  28,
     162, 101, 162, 228, 186, 218, 186, 218,  186, 218, 186, 218, 186, 218, 187, 219,
     187, 219, 188, 220, 189, 221, 189, 221,  189, 221, 203, 215, 218, 220, 196, 214,
       4, 162, 224, 164, 196, 164, 196, 164,  196, 164, 196, 164, 196, 164, 196, 164,
     196, 164, 196, 164, 196, 164, 196, 164,  196, 164, 196, 168, 200, 168, 200, 168,
     200, 168, 200,  28, 162, 101, 162, 198,  168, 200, 168, 200, 168, 200, 168, 200,
     172, 204, 172, 204, 178, 210, 178, 210,  178, 210, 178, 210, 178, 210, 178, 210,
     178, 210, 178, 210, 178, 210, 178, 210,  178, 210, 178, 210, 184, 216, 184, 216,
     184, 216, 184, 216, 184, 216, 184, 216,  184, 216, 188, 220, 188, 220, 188, 220,
     188, 220,  34, 162, 127, 162,  35, 162,  253, 131, 162, 131,  28, 162, 101, 162,
       2, 131,  11, 162,   3, 131,  13, 162,    3, 131,  13, 162,   2, 131, 255, 195,
      13, 162,   2, 131,  29, 162, 101, 162,  250,  42,  43,  44, 162,  45,  46,   2,
     162, 253,  47,  48,  49,   6, 162, 253,   50,  51,  52,   8, 162, 253,  53,  54,
      55,   9, 162, 255,  56,   2, 162, 255,   57,   4, 162, 253,  58,  59,  60,  41,
     162, 101, 162,  11, 131,   5, 162,   2,  144, 255, 162,   2, 144,   2, 162, 255,
     131,   4, 138,   4, 133,   2, 162, 253,  141, 162, 145,  10, 162, 255, 131,  12,
     162, 253, 132, 162, 131,  29, 162, 104,  162, 255, 144,   4, 162, 255, 132,   9,
     162, 255, 144,  12, 162, 255, 131,  16,  162, 254, 147, 204,   2, 162, 244, 151,
     152, 153, 154, 155, 156, 142, 144, 160,  139, 140, 209,  28, 162, 101, 162, 227,
     147, 148, 149, 150, 151, 152, 153, 154,  155, 156, 142, 144, 160, 139, 140, 162,
     196, 200, 210, 219, 162, 203, 206, 207,  208, 209, 211, 214, 215,  63, 162, 103,
     162, 255, 166,   7, 162, 255, 202,   3,  171, 254, 203, 162,   2, 172, 252, 175,
     207, 162, 177,   3, 162, 254, 179, 180,    3, 181,   6, 162, 255, 189,   3, 162,
     243, 189, 162, 174, 164, 165, 166, 162,  200, 168, 169, 162, 176, 210,   4, 162,
     255, 204,  34, 162, 106, 162, 251, 167,  199, 200, 204, 205,  21, 162, 254, 148,
     172,   3, 162, 255, 185,   4, 162, 255,  187,   2, 162, 251, 175, 166, 167, 176,
     204,   3, 162, 255, 217,   4, 162, 255,  219,   2, 162, 252, 207, 198, 199, 208,
      28, 162, 119, 162, 255, 144,   2, 162,  255, 146,  70, 162, 127, 162,   6, 162,
     255, 160,  13, 162, 254, 159, 161,  44,  162, 114, 162, 255, 141,   8, 162, 253,
     144, 162, 146,   6, 162, 255, 144,  60,  162, 127, 162,   6, 162, 247, 148, 149,
     150, 151, 152, 153, 154, 155, 156,  11,  162, 247, 148, 149, 150, 151, 152, 153,
     154, 155, 156,  31, 162, 109, 162, 247,  148, 149, 150, 151, 152, 153, 154, 155,
     156,  11, 162, 220, 196, 197, 198, 199,  200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 217, 218, 219, 220, 221, 164, 165,
     166, 167, 168, 169, 170, 171, 172, 173,   28, 162, 101, 162, 213, 174, 175, 176,
     177, 178, 179, 180, 181, 182, 183, 184,  185, 186, 187, 188, 189, 196, 197, 198,
     199, 200, 201, 202, 203, 204, 205, 206,  207, 208, 209, 210, 211, 212, 213, 214,
     215, 216, 217, 218, 219, 220, 221, 147,   10, 162, 245, 148, 149, 150, 151, 152,
     153, 154, 155, 156, 162, 147,  28, 162,  122, 162,   2, 141,  69, 162, 127, 162,
       8, 162,   2, 132,  18, 162, 247, 148,  149, 150, 151, 152, 153, 154, 155, 156,
      29, 162, 101, 162, 237, 148, 149, 150,  151, 152, 153, 154, 155, 156, 162, 148,
     149, 150, 151, 152, 153, 154, 155, 156,   73, 162, 127, 162,  22, 162,   2, 141,
       2, 162,   4, 141, 255, 146,   2, 162,  255, 141,  32, 162, 102, 162,   2, 141,
      89, 162, 112, 162, 255, 172,  47, 162,  255, 204,  32, 162, 127, 162,   6, 162,
     243, 175, 207, 175, 179, 181, 196, 215,  171, 203, 174, 206, 189, 221,   7, 162,
     255, 217,   7, 162, 254, 205, 185,  30,  162, 127, 162,   4, 162, 254, 178, 210,
      60, 162, 101, 162, 253,  62, 162,  63,    8, 162, 251,  64, 162,  65, 162,  66,
      76, 162, 101, 162, 253, 131, 143, 145,   89, 162, 127, 162, 255, 162,   2, 131,
      63, 162, 101, 162, 247, 148, 149, 150,  151, 152, 153, 154, 155, 156,  83, 162,
     125, 162, 246, 147, 148, 149, 150, 151,  152, 153, 154, 155, 156,  58, 162, 101,
     162, 254, 206, 176,  30, 162, 247, 148,  149, 150, 151, 152, 153, 154, 155, 156,
      51, 162, 125, 162, 255,  19,  10, 162,  254,  24,  26,   2, 162, 253,  24, 162,
      24,   5, 162, 255,  20,  44, 162, 127,  162,  18, 162, 255,  69,   4, 162, 255,
      70,   6, 162, 254,  71,  72,   2, 162,  252,  73,  74, 162,  75,  28, 162, 127,
     162,  15, 162, 255, 142,  50, 162, 127,  162,   4, 162,   6, 131,  56, 162, 117,
     162, 255, 143,   2, 162, 253, 157, 158,  132,  29, 162,   2, 194, 252, 139, 140,
     222, 224,  35, 162, 108, 162, 254, 190,  192,   4, 131,   3, 194, 243, 143, 162,
     145, 162, 158, 157, 162, 132, 162, 139,  140, 222, 224,   2, 162, 243, 134, 137,
     141, 142, 144, 159, 161, 160, 162, 191,  135, 136, 163,   4, 162, 241, 131, 162,
     131, 162, 131, 162, 131, 162, 131, 162,  131, 162, 131, 162, 131,  29, 162, 102,
     162, 193, 132, 133, 134, 135, 136, 137,  138, 139, 140, 141, 142, 143, 144, 145,
     146, 147, 148, 149, 150, 151, 152, 153,  154, 155, 156, 157, 158, 159, 160, 161,
     162, 163, 164, 165, 166, 167, 168, 169,  170, 171, 172, 173, 174, 175, 176, 177,
     178, 179, 180, 181, 182, 183, 184, 185,  186, 187, 188, 189, 190, 191, 192, 193,
     194,  28, 162, 101, 162, 225, 195, 196,  197, 198, 199, 200, 201, 202, 203, 204,
     205, 206, 207, 208, 209, 210, 211, 212,  213, 214, 215, 216, 217, 218, 219, 220,
     221, 222, 223, 224, 225,  61, 162, 127,  162,   9, 162, 255, 131,  56, 162, 117,
     162, 254,  77,  81,  11, 162, 253,  83,  162,  96,  60, 162, 117, 162, 253,  78,
     162,  19,  22, 162, 255,  79,  15, 162,  255,  80,  34, 162, 117, 162, 255, 171,
      39, 162, 255, 203,  35, 162, 101, 162,  252, 148, 149, 150, 151,  88, 162, 127,
     162,   6, 162, 247, 148, 149, 150, 151,  152, 153, 154, 155, 156,  51, 162, 102,
     162, 255,  82,  90, 162, 119, 162, 247,  148, 149, 150, 151, 152, 153, 154, 155,
     156,  11, 162, 246, 147, 148, 149, 150,  151, 152, 153, 154, 155, 156,  44, 162,
     117, 162, 245,  84,  85,  86,  87,  88,   89,  90,  91,  92,  93,  94,   4, 162,
     255,  95,  60, 162, 101, 162, 192, 164,  165, 166, 167, 168, 169, 170, 171, 172,
     173, 174, 175, 176, 177, 178, 179, 180,  181, 182, 183, 184, 185, 186, 187, 188,
     189, 196, 197, 198, 199, 200, 201, 202,  203, 204, 205, 206, 207, 208, 209, 210,
     211, 212, 213, 214, 215, 216, 217, 218,  219, 220, 221, 164, 165, 166, 167, 168,
     169, 170, 171, 172, 173, 174, 175,  28,  162, 101, 162, 192, 176, 177, 178, 179,
     180, 181, 182, 183, 184, 185, 186, 187,  188, 189, 196, 197, 198, 199, 200, 201,
     202, 162, 204, 205, 206, 207, 208, 209,  210, 211, 212, 213, 214, 215, 216, 217,
     218, 219, 220, 221, 164, 165, 166, 167,  168, 169, 170, 171, 172, 173, 174, 175,
     176, 177, 178, 179, 180, 181, 182, 183,  184, 185, 186, 187,  28, 162, 101, 162,
     224, 188, 189, 196, 197, 198, 199, 200,  201, 202, 203, 204, 205, 206, 207, 208,
     209, 210, 211, 212, 213, 214, 215, 216,  217, 218, 219, 220, 221, 164, 162, 166,
     167,   2, 162, 255, 170,   2, 162, 254,  173, 174,   2, 162, 233, 177, 178, 179,
     180, 162, 182, 183, 184, 185, 186, 187,  188, 189, 196, 197, 198, 199, 162, 201,
     162, 203, 204, 205,  28, 162, 101, 162,  192, 206, 207, 208, 209, 162, 211, 212,
     213, 214, 215, 216, 217, 218, 219, 220,  221, 164, 165, 166, 167, 168, 169, 170,
     171, 172, 173, 174, 175, 176, 177, 178,  179, 180, 181, 182, 183, 184, 185, 186,
     187, 188, 189, 196, 197, 198, 199, 200,  201, 202, 203, 204, 205, 206, 207, 208,
     209, 210, 211, 212, 213, 214, 215, 216,  217,  28, 162, 101, 162, 245, 218, 219,
     220, 221, 164, 165, 162, 167, 168, 169,  170,   2, 162, 206, 173, 174, 175, 176,
     177, 178, 179, 180, 162, 182, 183, 184,  185, 186, 187, 188, 162, 196, 197, 198,
     199, 200, 201, 202, 203, 204, 205, 206,  207, 208, 209, 210, 211, 212, 213, 214,
     215, 216, 217, 218, 219, 220, 221, 164,  165, 162, 167, 168, 169, 170,  29, 162,
     101, 162, 249, 172, 173, 174, 175, 176,  162, 178,   3, 162, 202, 182, 183, 184,
     185, 186, 187, 188, 162, 196, 197, 198,  199, 200, 201, 202, 203, 204, 205, 206,
     207, 208, 209, 210, 211, 212, 213, 214,  215, 216, 217, 218, 219, 220, 221, 164,
     165, 166, 167, 168, 169, 170, 171, 172,  173, 174, 175, 176, 177, 178, 179, 180,
     181, 182, 183,  28, 162, 101, 162, 192,  184, 185, 186, 187, 188, 189, 196, 197,
     198, 199, 200, 201, 202, 203, 204, 205,  206, 207, 208, 209, 210, 211, 212, 213,
     214, 215, 216, 217, 218, 219, 220, 221,  164, 165, 166, 167, 168, 169, 170, 171,
     172, 173, 174, 175, 176, 177, 178, 179,  180, 181, 182, 183, 184, 185, 186, 187,
     188, 189, 196, 197, 198, 199, 200, 201,   28, 162, 101, 162, 192, 202, 203, 204,
     205, 206, 207, 208, 209, 210, 211, 212,  213, 214, 215, 216, 217, 218, 219, 220,
     221, 164, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174, 175, 176, 177, 178,
     179, 180, 181, 182, 183, 184, 185, 186,  187, 188, 189, 196, 197, 198, 199, 200,
     201, 202, 203, 204, 205, 206, 207, 208,  209, 210, 211, 212, 213,  28, 162, 101,
     162, 192, 214, 215, 216, 217, 218, 219,  220, 221, 164, 165, 166, 167, 168, 169,
     170, 171, 172, 173, 174, 175, 176, 177,  178, 179, 180, 181, 182, 183, 184, 185,
     186, 187, 188, 189, 196, 197, 198, 199,  200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 217, 218, 219, 220, 221, 164, 165,
     166, 167,  28, 162, 101, 162, 192, 168,  169, 170, 171, 172, 173, 174, 175, 176,
     177, 178, 179, 180, 181, 182, 183, 184,  185, 186, 187, 188, 189, 196, 197, 198,
     199, 200, 201, 202, 203, 204, 205, 206,  207, 208, 209, 210, 211, 212, 213, 214,
     215, 216, 217, 218, 219, 220, 221, 164,  165, 166, 167, 168, 169, 170, 171, 172,
     173, 174, 175, 176, 177, 178, 179,  28,  162, 101, 162, 220, 180, 181, 182, 183,
     184, 185, 186, 187, 188, 189, 196, 197,  198, 199, 200, 201, 202, 203, 204, 205,
     206, 207, 208, 209, 210, 211, 212, 213,  214, 215, 216, 217, 218, 219, 220, 221,
      56, 162, 115, 162, 206, 147, 148, 149,  150, 151, 152, 153, 154, 155, 156, 147,
     148, 149, 150, 151, 152, 153, 154, 155,  156, 147, 148, 149, 150, 151, 152, 153,
     154, 155, 156, 147, 148, 149, 150, 151,  152, 153, 154, 155, 156, 147, 148, 149,
     150, 151, 152, 153, 154, 155, 156,  28,  162, 105, 162, 254,  97,  98,  86, 162,
     101, 162,   2, 147, 247, 148, 149, 150,  151, 152, 153, 154, 155, 156,  32, 162,
     254, 166, 181,   3, 162, 240, 164, 165,  166, 167, 168, 169, 170, 171, 172, 173,
     174, 175, 176, 177, 178, 179,  28, 162,  101, 162, 246, 180, 181, 182, 183, 184,
     185, 186, 187, 188, 189,  82, 162
};

// utf/tr_utf8_cp437.txt
//
// 2813 code points.
// 114 states, 194 columns, 8614 bytes
//
const unsigned char tr_cp437_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   1,    2,   3,   4,   0,   0,   5,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   6,   0,   0,   0,   0,
       7,   8,   9,  10,  11,  12,  13,  14,   15,  16,  17,  18,  19,  20,  21,  22,
      23,  24,  25,  26,  27,  28,  29,  30,   31,  32,  33,  34,  35,  36,  37,   0,
      38,  39,  40,  41,  42,  43,  44,  45,   46,  47,  48,  49,  50,  51,  52,  53,
      54,  55,  56,  57,  58,  59,  60,  61,   62,  63,  64,  65,  66,  67,  68,  69,
      70,  71,  72,  73,  74,  75,  76,  77,   78,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,  90,  91,  92,  93,   94,  95,  96,  97,  98,  99, 100,   0,

     101, 102, 103, 104, 105, 106, 107, 108,  109, 110, 111, 112, 113, 114, 115, 116,
     117, 118, 119, 120, 121, 122, 123, 124,  125, 126, 127, 128, 129, 130, 131, 132,
     133, 134, 135, 136, 137, 138, 139, 140,  141, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
       0,   0, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174,   0, 175, 176, 177,
     178, 179, 180, 181,   0, 182, 183,   0,    0, 184,   0, 185,   0,   0,   0, 186,
     187, 188, 189, 190,   0,   0,   0,   0,    0,   0, 191,   0,   0,   0,   0, 192,
     193,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_cp437_sot[114] =
{
        0,  134,  173,  238,  307,  378,  440,  502,   573,  627,  664,  679,  691,  738,  765,  809,
      829,  843,  872,  880,  886,  903,  920,  939,   970,  987, 1002, 1052, 1067, 1083, 1102, 1119,
     1135, 1163, 1227, 1297, 1365, 1434, 1503, 1571,  1634, 1644, 1656, 1678, 1704, 1754, 1796, 1834,
     1872, 1931, 1977, 1991, 2015, 2038, 2054, 2065,  2093, 2146, 2208, 2252, 2286, 2329, 2339, 2349,
     2372, 2378, 2398, 2422, 2440, 2446, 2456, 2485,  2494, 2510, 2518, 2526, 2540, 2555, 2574, 2595,
     2619, 2627, 2635, 2656, 2715, 2783, 2819, 2840,  2853, 2869, 2879, 2888, 2904, 2910, 2937, 2958,
     3027, 3096, 3168, 3237, 3306, 3375, 3444, 3513,  3582, 3651, 3709, 3770, 3825, 3880, 3938, 4003,
     4010, 4050
};

const unsigned short tr_cp437_sbt[4065] =
{
     155, 177, 121, 122, 123, 124, 127, 141,  146, 147, 148, 149, 150, 151, 152, 153,
     154, 155, 156, 157, 158, 159, 160, 161,  162, 163, 164, 165, 166, 167, 168, 169,
     170, 171, 172, 173, 174, 175, 176, 178,  179, 180, 181, 182, 183, 184, 185, 186,
     187, 188, 189, 190, 191, 192, 193, 194,  195, 196, 197, 198, 199, 200, 201, 202,
     203, 204, 205, 206, 207, 208, 209, 210,  211, 212, 213, 214, 215, 216, 217, 218,
     219, 220, 221, 222, 223, 224, 225, 226,  227, 228, 229, 230, 231, 232, 233, 234,
     235, 236, 237, 238, 239, 240,  64, 177,  227,   1,   2,   3,   4,   5,   6,   7,
       8,   9,  10,  11,  12,  13,  14,  15,   16,  17,  18,  19,  20,  21,  22,  23,
      26,  44,  72,  78,  79,  87, 127, 177,    6, 177, 224, 369, 287, 269, 270, 177,
     271, 177, 135, 146, 177, 280, 288, 284,  159, 177, 146, 362, 355, 367, 165, 146,
     344, 134, 364, 146, 163, 281, 289, 286,  285, 177, 282,  29, 177, 101, 177,   4,
     179, 250, 256, 257, 260, 242, 183, 258,    2, 183,   4, 187, 254, 182, 279,   4,
     193, 253, 267, 156, 193,   3, 199, 220,  268, 203, 177, 339, 247, 274, 245, 211,
     246, 248, 259, 249, 252, 244, 250, 251,  255, 275, 254, 253, 214, 278, 263, 276,
     261, 225, 262, 360, 225, 265, 277, 264,  243, 235, 177, 266,  29, 177, 101, 177,
     207, 179, 211, 179, 211, 179, 211, 181,  213, 181, 213, 181, 213, 181, 213, 182,
     214, 182, 214, 183, 215, 183, 215, 183,  215, 183, 215, 183, 215, 185, 217, 185,
     217, 185, 217, 185, 217, 186, 218, 186,  218, 187, 219, 187, 219, 187, 219, 187,
     219, 187,   3, 177, 244, 188, 220, 189,  221, 177, 190, 222, 190, 222, 190, 222,
     190,  29, 177, 101, 177, 248, 222, 190,  222, 192, 224, 192, 224, 192,   2, 224,
       2, 177, 250, 193, 225, 193, 225, 193,  225,   2, 177, 212, 196, 228, 196, 228,
     196, 228, 197, 229, 197, 229, 197, 229,  197, 229, 198, 230, 198, 230, 198, 230,
     199, 231, 199, 231, 199, 231, 199, 231,  199, 231, 199, 231, 201, 233, 203, 235,
     203, 204, 236, 204, 236, 204, 236, 229,   29, 177, 101, 177, 255, 212,   2, 180,
     255, 212,   3, 177, 253, 181, 213, 177,    2, 182, 255, 214,   4, 177, 253, 184,
     273, 185,   3, 177, 252, 187, 189, 221,  222,   2, 177, 254, 192, 224,   2, 193,
     255, 225,   2, 177, 254, 194, 226,   5,  177, 244, 230, 198, 230, 198, 199, 231,
     177, 200, 203, 235, 204, 236,  38, 177,  104, 177, 255, 147,   9, 177, 223, 179,
     211, 187, 219, 193, 225, 199, 231, 199,  231, 199, 231, 199, 231, 199, 231, 177,
     179, 211, 179, 211, 260, 259, 185, 217,  185, 217, 189, 221, 193, 225, 193, 225,
       2, 177, 255, 220,   3, 177, 254, 185,  217,   2, 177, 248, 192, 224, 179, 211,
     260, 259, 193, 225,  29, 177, 101, 177,  228, 179, 211, 179, 211, 183, 215, 183,
     215, 187, 219, 187, 219, 193, 225, 193,  225, 196, 228, 196, 228, 199, 231, 199,
     231, 197, 229, 198, 230,   2, 177, 252,  186, 218, 192, 214,   2, 177, 237, 204,
     236, 179, 211, 183, 215, 193, 225, 193,  225, 193, 225, 193, 225, 203, 235, 222,
     224, 230,   3, 177, 250, 179, 181, 213,  190, 198, 229,  29, 177, 101, 177, 255,
     236,   2, 177, 243, 180, 199, 177, 183,  215, 188, 220, 177, 227, 196, 228, 203,
     235,   3, 177, 253, 212, 177, 213,   2,  214,   8, 177, 255, 217,   5, 177, 253,
     218, 177, 219,   2, 177,   4, 222,   2,  177, 255, 223,   2, 224,   8, 177,   3,
     228,  30, 177, 103, 177, 255, 229,   5,  177, 252, 230, 231, 177, 232,   4, 177,
       2, 236,  11, 177, 255, 220,   2, 177,  255, 227,  15, 177, 252, 218, 177, 220,
     228,   3, 177, 254, 233, 235,  36, 177,  125, 177,   4, 146, 254, 240, 146,   3,
     177, 253, 222, 229, 234,  57, 177, 127,  177,  32, 177, 255, 146,   3, 177, 255,
     173,  30, 177, 105, 177,   2, 146, 254,  177, 364,   7, 177, 255, 348,   3, 177,
     255, 340,   4, 177, 255, 347,  10, 177,  255, 342,   2, 177, 255, 346,   2, 177,
     255, 348,   2, 177, 254, 338, 352,   3,  177, 255, 338,   2, 177, 254, 349, 352,
      39, 177, 101, 177, 255, 341,   2, 177,  252, 343, 345, 177, 351,  14, 177, 254,
     351, 341,  29, 177, 254, 347, 352,   3,  177, 255, 342,  35, 177, 105, 177, 253,
     183, 177, 187,   6, 177, 255, 187,   2,  177, 255, 179,   7, 177, 255, 187,   5,
     177, 255, 193,   4, 177, 255, 199,   9,  177, 255, 183,   2, 177, 255, 211,   7,
     177, 255, 219,   5, 177, 255, 225,  30,  177, 104, 177, 255, 231,   9, 177, 255,
     215,   6, 177, 253, 215, 177, 219,   6,  177, 255, 219,  63, 177, 127, 177,  14,
     177, 254, 193, 225,  16, 177, 254, 186,  218,  33, 177, 117, 177, 252, 179, 211,
     179, 211,  14, 177, 250, 187, 219, 187,  219, 193, 225,   4, 177, 248, 183, 215,
     199, 231, 199, 231, 199, 231,  41, 177,  127, 177,   2, 177, 255, 147,  64, 177,
     111, 177, 255, 159,  82, 177, 127, 177,    6, 177, 246, 162, 163, 164, 165, 166,
     167, 168, 169, 170, 171,  51, 177, 127,  177,  22, 177, 246, 162, 163, 164, 165,
     166, 167, 168, 169, 170, 171,  35, 177,  101, 177, 246, 162, 163, 164, 165, 166,
     167, 168, 169, 170, 171,  47, 177, 255,  147,  35, 177, 127, 177,  11, 177, 239,
      24, 177,  24, 177,  24, 177,  24, 177,   24, 177,  24, 177,  24, 177,  24, 177,
      24,   3, 177, 252,  25, 177,  25,  20,   32, 177, 127, 177,  12, 177, 246, 162,
     163, 164, 165, 166, 167, 168, 169, 170,  171,  45, 177, 117, 177, 246, 162, 163,
     164, 165, 166, 167, 168, 169, 170, 171,   67, 177, 102, 177, 254,  27,  25,  10,
     177, 255,  28,  17, 177, 254,  20,  29,    4, 177, 253,  30, 177,  31,   2, 177,
     255,  32,   2, 177, 254,  25,  21,   2,  177, 255,  32,   2, 177, 244,  33,  34,
      35, 177,  36,  37,  38,  39,  40,  41,   42,  43,  29, 177, 101, 177, 246, 162,
     163, 164, 165, 166, 167, 168, 169, 170,  171,  83, 177, 127, 177,  15, 177, 247,
     163, 164, 165, 166, 167, 168, 169, 170,  171,  43, 177, 107, 177, 255, 159,   9,
     177, 246, 162, 163, 164, 165, 166, 167,  168, 169, 170, 171,  67, 177, 105, 177,
     244, 147, 177, 162, 163, 164, 165, 166,  167, 168, 169, 170, 171,  77, 177, 117,
     177, 245, 162, 163, 164, 165, 166, 167,  168, 169, 170, 171, 163,  66, 177, 101,
     177, 246, 162, 163, 164, 165, 166, 167,  168, 169, 170, 171,   6, 177, 246, 162,
     163, 164, 165, 166, 167, 168, 169, 170,  171,  67, 177, 101, 177, 255, 179,   2,
     177, 252, 180, 181, 182, 214,   2, 183,  250, 187, 188, 189, 190, 191, 192,   5,
     193,   2, 177,   2, 193, 255, 194,   2,  196, 255, 198,   3, 199, 252, 191, 200,
     201, 204,   9, 177, 236, 179, 260, 180,  177, 182, 183, 177, 185, 186, 187, 188,
     189, 190, 191, 192, 177, 193, 177, 194,  196,  29, 177, 101, 177, 252, 198, 199,
     201, 211,   3, 177, 253, 212, 214, 215,    3, 177, 250, 217, 177, 221, 223, 177,
     225,   3, 177, 253, 226, 230, 231,   2,  177, 255, 232,   3, 177, 249, 349, 351,
     177, 219, 228, 231, 232,   3, 177, 255,  351,   2, 177, 250, 212, 214, 216, 223,
     224, 226,   2, 228, 253, 229, 230, 236,    4, 177, 252, 187, 177, 226, 199,  30,
     177, 101, 177, 237, 212, 214, 216, 217,  221, 222, 223, 224, 226, 228, 229, 177,
     232, 234, 236, 211, 177, 214, 215,   3,  177, 255, 219,   2, 177, 255, 231,   2,
     177,   2, 213, 248, 214, 215, 216, 220,  217, 218, 219, 177,   2, 219, 255, 220,
       3, 222,   2, 223,   3, 224, 248, 225,  177, 229, 177, 230, 231, 177, 231,   2,
     232,   3, 236,  31, 177, 101, 177, 192,  179, 211, 180, 212, 180, 212, 180, 212,
     181, 213, 182, 214, 182, 214, 182, 214,  182, 214, 182, 214, 183, 215, 183, 215,
     183, 215, 183, 215, 183, 215, 184, 216,  185, 217, 186, 218, 186, 218, 186, 218,
     186, 218, 186, 218, 187, 219, 187, 219,  189, 221, 189, 221, 189, 221, 190, 222,
     190, 222, 190, 222, 190, 222, 191, 223,   29, 177, 101, 177, 192, 191, 223, 191,
     223, 192, 224, 192, 224, 192, 224, 192,  224, 193, 225, 193, 225, 193, 225, 193,
     225, 194, 226, 194, 226, 196, 228, 196,  228, 196, 228, 196, 228, 197, 229, 197,
     229, 197, 229, 197, 229, 197, 229, 198,  230, 198, 230, 198, 230, 198, 230, 199,
     231, 199, 231, 199, 231, 199, 231, 199,  231, 200, 232, 200, 232,  29, 177, 101,
     177, 228, 201, 233, 201, 233, 201, 233,  201, 233, 201, 233, 202, 234, 202, 234,
     203, 235, 204, 236, 204, 236, 204, 236,  218, 230, 233, 235, 211, 229,   4, 177,
     224, 179, 211, 179, 211, 179, 211, 179,  211, 179, 211, 179, 211, 179, 211, 179,
     211, 179, 211, 179, 211, 179, 211, 179,  211, 183, 215, 183, 215, 183, 215, 183,
     215,  29, 177, 101, 177, 198, 183, 215,  183, 215, 183, 215, 183, 215, 187, 219,
     187, 219, 193, 225, 193, 225, 193, 225,  193, 225, 193, 225, 193, 225, 193, 225,
     193, 225, 193, 225, 193, 225, 193, 225,  193, 225, 199, 231, 199, 231, 199, 231,
     199, 231, 199, 231, 199, 231, 199, 231,  203, 235, 203, 235, 203, 235, 203, 235,
      35, 177, 101, 177,   8, 338,   8, 177,    6, 352,  71, 177, 127, 177,  14, 177,
       8, 348,   2, 338,   2, 352,  41, 177,  101, 177,   8, 338,  32, 177,   8, 348,
       5, 338, 255, 177,   2, 338,   5, 177,  253, 146, 177, 146,  29, 177, 101, 177,
       2, 146,  11, 177,   3, 146,  13, 177,    3, 146,  13, 177,   2, 146, 255, 210,
      10, 177,   3, 348,   2, 146,  30, 177,  101, 177, 243,  45,  46,  47, 177,  48,
      49,  50, 177,  51,  52,  53, 177,  54,    4, 177, 247,  55,  56,  57,  58,  59,
      60,  61,  62,  63,   2, 177, 253,  64,   65,  66,   9, 177, 255,  67,   2, 177,
     255,  68,   4, 177, 253,  69,  70,  71,   42, 177, 101, 177,   7, 146, 255, 114,
       3, 146,   5, 177,   2, 159, 255, 177,    2, 159,   2, 177, 255, 146,   4, 153,
       4, 148,   2, 177, 253, 121, 177, 160,   10, 177, 255, 146,  12, 177, 253, 133,
     177, 146,  30, 177, 104, 177, 255, 159,    4, 177, 255, 147,   9, 177, 255, 159,
      12, 177, 255, 146,  16, 177, 254, 162,  219,   2, 177, 244, 166, 167, 168, 169,
     170, 171, 157, 159, 175, 154, 155, 366,   29, 177, 101, 177, 227, 162, 163, 164,
     165, 166, 167, 168, 169, 170, 171, 157,  159, 175, 154, 155, 177, 211, 215, 225,
     234, 177, 218, 221, 222, 223, 224, 226,  229, 230,  10, 177, 255, 272,  53, 177,
     103, 177, 255, 181,   7, 177, 255, 217,    3, 186, 254, 218, 177,   2, 187, 252,
     190, 222, 177, 192,   3, 177, 254, 194,  195,   3, 196,   6, 177, 239, 204, 177,
     348, 177, 204, 177, 189, 179, 180, 181,  177, 215, 183, 184, 177, 191, 225,   4,
     177, 255, 219,   2, 177, 253, 341, 177,  340,  30, 177, 106, 177, 251, 182, 214,
     215, 219, 220,  21, 177, 254, 163, 187,    3, 177, 255, 200,   4, 177, 255, 202,
       2, 177, 251, 190, 181, 182, 191, 219,    3, 177, 255, 232,   4, 177, 255, 234,
       2, 177, 252, 222, 213, 214, 223,  29,  177, 118, 177, 251, 138, 140, 139, 143,
     132,  18, 177, 255, 137,  52, 177, 119,  177, 255, 159,   2, 177, 255, 161,   3,
     177, 254, 363, 365,   3, 177, 254, 350,  142,   9, 177, 255, 353,  51, 177, 109,
     177,   2, 361,  22, 177, 255, 175,   2,  354, 253, 177, 357, 356,   8, 177, 252,
     174, 176, 357, 356,  43, 177, 114, 177,  255, 156,   8, 177, 253, 159, 177, 161,
       6, 177, 255, 159,  61, 177, 117, 177,  255, 283,  15, 177, 254, 358, 359,  59,
     177, 127, 177,   6, 177, 247, 163, 164,  165, 166, 167, 168, 169, 170, 171,  11,
     177, 247, 163, 164, 165, 166, 167, 168,  169, 170, 171,  32, 177, 109, 177, 247,
     163, 164, 165, 166, 167, 168, 169, 170,  171,  11, 177, 220, 211, 212, 213, 214,
     215, 216, 217, 218, 219, 220, 221, 222,  223, 224, 225, 226, 227, 228, 229, 230,
     231, 232, 233, 234, 235, 236, 179, 180,  181, 182, 183, 184, 185, 186, 187, 188,
      29, 177, 101, 177, 213, 189, 190, 191,  192, 193, 194, 195, 196, 197, 198, 199,
     200, 201, 202, 203, 204, 211, 212, 213,  214, 215, 216, 217, 218, 219, 220, 221,
     222, 223, 224, 225, 226, 227, 228, 229,  230, 231, 232, 233, 234, 235, 236, 162,
      10, 177, 245, 163, 164, 165, 166, 167,  168, 169, 170, 171, 177, 162,  29, 177,
     101, 177, 253, 310, 177, 293,   9, 177,  255, 332,   3, 177, 255, 305,   3, 177,
     255, 306,   3, 177, 255, 331,   3, 177,  255, 309,   7, 177, 255, 294,   7, 177,
     255, 308,   7, 177, 255, 307,   7, 177,  255, 311,  32, 177, 117, 177, 227, 319,
     300, 327, 328, 315, 298, 297, 301, 326,  325, 314, 304, 303, 302, 312, 313, 318,
     295, 296, 299, 323, 324, 317, 321, 322,  316, 330, 329, 320,  48, 177, 101, 177,
     255, 337,   3, 177, 255, 334,   3, 177,  255, 333,   3, 177, 255, 335,   3, 177,
     252, 336, 290, 291, 292,  12, 177, 255,  368,  11, 177, 255, 136,   5, 177, 255,
     144,   7, 177, 253, 130, 177, 145,  32,  177, 105, 177, 255, 131,   6, 177, 255,
     123,  81, 177, 127, 177,  32, 177, 253,  115, 116, 129,  32, 177, 101, 177, 253,
     126, 177, 125,  29, 177, 255, 120,   2,  177, 252, 119, 177, 117, 118,   4, 177,
     255, 128,  49, 177, 122, 177,   2, 156,   70, 177, 127, 177,   8, 177,   2, 147,
      18, 177, 247, 163, 164, 165, 166, 167,  168, 169, 170, 171,  30, 177, 101, 177,
     237, 163, 164, 165, 166, 167, 168, 169,  170, 171, 177, 163, 164, 165, 166, 167,
     168, 169, 170, 171,  74, 177, 127, 177,   22, 177,   2, 156,   2, 177,   4, 156,
     255, 161,   2, 177, 255, 156,  33, 177,  102, 177,   2, 156,  90, 177, 112, 177,
     255, 187,  47, 177, 255, 219,  33, 177,  127, 177,   6, 177, 243, 190, 222, 190,
     194, 196, 211, 230, 186, 218, 189, 221,  204, 236,   7, 177, 255, 232,   7, 177,
     254, 220, 200,  31, 177, 127, 177,   4,  177, 254, 193, 225,  61, 177, 101, 177,
     253,  73, 177,  74,   8, 177, 251,  75,  177,  76, 177,  77,  77, 177, 101, 177,
     253, 146, 158, 160,  90, 177, 127, 177,  255, 177,   2, 146,  64, 177, 101, 177,
     247, 163, 164, 165, 166, 167, 168, 169,  170, 171,  84, 177, 125, 177, 246, 162,
     163, 164, 165, 166, 167, 168, 169, 170,  171,  59, 177, 101, 177, 254, 221, 191,
      30, 177, 247, 163, 164, 165, 166, 167,  168, 169, 170, 171,  52, 177, 125, 177,
     255,  20,  10, 177, 254,  25,  27,   2,  177, 253,  25, 177,  25,   5, 177, 255,
      21,  45, 177, 127, 177,  18, 177, 255,   80,   4, 177, 255,  81,   6, 177, 254,
      82,  83,   2, 177, 252,  84,  85, 177,   86,  29, 177, 127, 177,  15, 177, 255,
     157,  51, 177, 127, 177,   4, 177,   6,  146,  57, 177, 117, 177, 255, 158,   2,
     177, 253, 172, 173, 147,  29, 177,   2,  209, 252, 154, 155, 237, 239,  36, 177,
     108, 177, 254, 205, 207,   4, 146,   3,  209, 243, 158, 177, 160, 177, 173, 172,
     177, 147, 177, 154, 155, 237, 239,   2,  177, 243, 149, 152, 156, 157, 159, 174,
     176, 175, 177, 206, 150, 151, 178,   4,  177, 241, 146, 177, 146, 177, 146, 177,
     146, 177, 146, 177, 146, 177, 146, 177,  146,  30, 177, 102, 177, 193, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
     165, 166, 167, 168, 169, 170, 171, 172,  173, 174, 175, 176, 177, 178, 179, 180,
     181, 182, 183, 184, 185, 186, 187, 188,  189, 190, 191, 192, 193, 194, 195, 196,
     197, 198, 199, 200, 201, 202, 203, 204,  205, 206, 207, 208, 209,  29, 177, 101,
     177, 225, 210, 211, 212, 213, 214, 215,  216, 217, 218, 219, 220, 221, 222, 223,
     224, 225, 226, 227, 228, 229, 230, 231,  232, 233, 234, 235, 236, 237, 238, 239,
     240,  62, 177, 127, 177,   6, 177, 250,  269, 270, 284, 146, 177, 271,   2, 177,
     255, 293,   4, 177, 255, 368,  47, 177,  117, 177, 254,  88,  92,  11, 177, 253,
      94, 177, 111,  61, 177, 117, 177, 253,   89, 177,  20,  22, 177, 255,  90,  15,
     177, 255,  91,  35, 177, 117, 177, 255,  186,  39, 177, 255, 218,  36, 177, 101,
     177, 252, 163, 164, 165, 166,  89, 177,  127, 177,   6, 177, 247, 163, 164, 165,
     166, 167, 168, 169, 170, 171,  52, 177,  102, 177, 255,  93,  91, 177, 119, 177,
     247, 163, 164, 165, 166, 167, 168, 169,  170, 171,  11, 177, 246, 162, 163, 164,
     165, 166, 167, 168, 169, 170, 171,  45,  177, 117, 177, 240,  95,  96,  97,  98,
      99, 100, 101, 102, 103, 104, 105, 106,  107, 108, 109, 110,  61, 177, 101, 177,
     192, 179, 180, 181, 182, 183, 184, 185,  186, 187, 188, 189, 190, 191, 192, 193,
     194, 195, 196, 197, 198, 199, 200, 201,  202, 203, 204, 211, 212, 213, 214, 215,
     216, 217, 218, 219, 220, 221, 222, 223,  224, 225, 226, 227, 228, 229, 230, 231,
     232, 233, 234, 235, 236, 179, 180, 181,  182, 183, 184, 185, 186, 187, 188, 189,
     190,  29, 177, 101, 177, 192, 191, 192,  193, 194, 195, 196, 197, 198, 199, 200,
     201, 202, 203, 204, 211, 212, 213, 214,  215, 216, 217, 177, 219, 220, 221, 222,
     223, 224, 225, 226, 227, 228, 229, 230,  231, 232, 233, 234, 235, 236, 179, 180,
     181, 182, 183, 184, 185, 186, 187, 188,  189, 190, 191, 192, 193, 194, 195, 196,
     197, 198, 199, 200, 201, 202,  29, 177,  101, 177, 224, 203, 204, 211, 212, 213,
     214, 215, 216, 217, 218, 219, 220, 221,  222, 223, 224, 225, 226, 227, 228, 229,
     230, 231, 232, 233, 234, 235, 236, 179,  177, 181, 182,   2, 177, 255, 185,   2,
     177, 254, 188, 189,   2, 177, 233, 192,  193, 194, 195, 177, 197, 198, 199, 200,
     201, 202, 203, 204, 211, 212, 213, 214,  177, 216, 177, 218, 219, 220,  29, 177,
     101, 177, 192, 221, 222, 223, 224, 177,  226, 227, 228, 229, 230, 231, 232, 233,
     234, 235, 236, 179, 180, 181, 182, 183,  184, 185, 186, 187, 188, 189, 190, 191,
     192, 193, 194, 195, 196, 197, 198, 199,  200, 201, 202, 203, 204, 211, 212, 213,
     214, 215, 216, 217, 218, 219, 220, 221,  222, 223, 224, 225, 226, 227, 228, 229,
     230, 231, 232,  29, 177, 101, 177, 245,  233, 234, 235, 236, 179, 180, 177, 182,
     183, 184, 185,   2, 177, 206, 188, 189,  190, 191, 192, 193, 194, 195, 177, 197,
     198, 199, 200, 201, 202, 203, 177, 211,  212, 213, 214, 215, 216, 217, 218, 219,
     220, 221, 222, 223, 224, 225, 226, 227,  228, 229, 230, 231, 232, 233, 234, 235,
     236, 179, 180, 177, 182, 183, 184, 185,   30, 177, 101, 177, 249, 187, 188, 189,
     190, 191, 177, 193,   3, 177, 202, 197,  198, 199, 200, 201, 202, 203, 177, 211,
     212, 213, 214, 215, 216, 217, 218, 219,  220, 221, 222, 223, 224, 225, 226, 227,
     228, 229, 230, 231, 232, 233, 234, 235,  236, 179, 180, 181, 182, 183, 184, 185,
     186, 187, 188, 189, 190, 191, 192, 193,  194, 195, 196, 197, 198,  29, 177, 101,
     177, 192, 199, 200, 201, 202, 203, 204,  211, 212, 213, 214, 215, 216, 217, 218,
     219, 220, 221, 222, 223, 224, 225, 226,  227, 228, 229, 230, 231, 232, 233, 234,
     235, 236, 179, 180, 181, 182, 183, 184,  185, 186, 187, 188, 189, 190, 191, 192,
     193, 194, 195, 196, 197, 198, 199, 200,  201, 202, 203, 204, 211, 212, 213, 214,
     215, 216,  29, 177, 101, 177, 192, 217,  218, 219, 220, 221, 222, 223, 224, 225,
     226, 227, 228, 229, 230, 231, 232, 233,  234, 235, 236, 179, 180, 181, 182, 183,
     184, 185, 186, 187, 188, 189, 190, 191,  192, 193, 194, 195, 196, 197, 198, 199,
     200, 201, 202, 203, 204, 211, 212, 213,  214, 215, 216, 217, 218, 219, 220, 221,
     222, 223, 224, 225, 226, 227, 228,  29,  177, 101, 177, 192, 229, 230, 231, 232,
     233, 234, 235, 236, 179, 180, 181, 182,  183, 184, 185, 186, 187, 188, 189, 190,
     191, 192, 193, 194, 195, 196, 197, 198,  199, 200, 201, 202, 203, 204, 211, 212,
     213, 214, 215, 216, 217, 218, 219, 220,  221, 222, 223, 224, 225, 226, 227, 228,
     229, 230, 231, 232, 233, 234, 235, 236,  179, 180, 181, 182,  29, 177, 101, 177,
     192, 183, 184, 185, 186, 187, 188, 189,  190, 191, 192, 193, 194, 195, 196, 197,
     198, 199, 200, 201, 202, 203, 204, 211,  212, 213, 214, 215, 216, 217, 218, 219,
     220, 221, 222, 223, 224, 225, 226, 227,  228, 229, 230, 231, 232, 233, 234, 235,
     236, 179, 180, 181, 182, 183, 184, 185,  186, 187, 188, 189, 190, 191, 192, 193,
     194,  29, 177, 101, 177, 220, 195, 196,  197, 198, 199, 200, 201, 202, 203, 204,
     211, 212, 213, 214, 215, 216, 217, 218,  219, 220, 221, 222, 223, 224, 225, 226,
     227, 228, 229, 230, 231, 232, 233, 234,  235, 236,   6, 177, 255, 340,   4, 177,
     255, 347,   9, 177, 254, 347, 342,   2,  177, 255, 346,  31, 177, 101, 177, 253,
     348, 177, 338,   2, 177, 254, 349, 352,   10, 177, 255, 341,   2, 177, 252, 343,
     345, 177, 351,   4, 177, 255, 352,   2,  177, 253, 351, 177, 341,   2, 177, 255,
     340,   4, 177, 255, 347,   9, 177, 254,  347, 342,   2, 177, 255, 346,   2, 177,
     253, 348, 177, 338,   2, 177, 255, 349,   29, 177, 101, 177, 255, 352,  10, 177,
     255, 341,   2, 177, 252, 343, 345, 177,  351,   4, 177, 255, 352,   2, 177, 253,
     351, 177, 341,   2, 177, 255, 340,   4,  177, 255, 347,   9, 177, 254, 347, 342,
       2, 177, 255, 346,   2, 177, 253, 348,  177, 338,   2, 177, 254, 349, 352,  34,
     177, 106, 177, 255, 341,   2, 177, 252,  343, 345, 177, 351,   4, 177, 255, 352,
       2, 177, 253, 351, 177, 341,   2, 177,  255, 340,   4, 177, 255, 347,   9, 177,
     254, 347, 342,   2, 177, 255, 346,   2,  177, 253, 348, 177, 338,   2, 177, 254,
     349, 352,  10, 177, 255, 341,  29, 177,  103, 177, 252, 343, 345, 177, 351,   4,
     177, 255, 352,   2, 177, 253, 351, 177,  341,   2, 177, 255, 340,   4, 177, 255,
     347,   9, 177, 254, 347, 342,   2, 177,  255, 346,   2, 177, 253, 348, 177, 338,
       2, 177, 254, 349, 352,  10, 177, 255,  341,   2, 177, 252, 343, 345, 177, 351,
      29, 177, 105, 177, 255, 352,   2, 177,  253, 351, 177, 341,   4, 177, 206, 162,
     163, 164, 165, 166, 167, 168, 169, 170,  171, 162, 163, 164, 165, 166, 167, 168,
     169, 170, 171, 162, 163, 164, 165, 166,  167, 168, 169, 170, 171, 162, 163, 164,
     165, 166, 167, 168, 169, 170, 171, 162,  163, 164, 165, 166, 167, 168, 169, 170,
     171,  29, 177, 105, 177, 254, 112, 113,   87, 177, 101, 177,   2, 162, 247, 163,
     164, 165, 166, 167, 168, 169, 170, 171,   32, 177, 254, 181, 196,   3, 177, 240,
     179, 180, 181, 182, 183, 184, 185, 186,  187, 188, 189, 190, 191, 192, 193, 194,
      29, 177, 101, 177, 246, 195, 196, 197,  198, 199, 200, 201, 202, 203, 204,  83,
     177
};

// utf/tr_utf8_latin1.txt
//
// 2579 code points.
// 101 states, 193 columns, 7434 bytes
//
const unsigned char tr_latin1_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   1,    2,   3,   4,   0,   0,   5,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   6,   0,   0,   0,   0,
       7,   8,   9,  10,  11,  12,  13,  14,   15,  16,  17,  18,  19,  20,  21,  22,
      23,  24,  25,  26,  27,  28,  29,  30,   31,  32,  33,  34,  35,  36,  37,   0,
      38,  39,  40,  41,  42,  43,  44,  45,   46,  47,  48,  49,  50,  51,  52,  53,
      54,  55,  56,  57,  58,  59,  60,  61,   62,  63,  64,  65,  66,  67,  68,  69,
      70,  71,  72,  73,  74,  75,  76,  77,   78,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,  90,  91,  92,  93,   94,  95,  96,  97,  98,  99, 100,   0,

     101, 102, 103, 104, 105, 106, 107, 108,  109, 110, 111, 112, 113, 114, 115, 116,
     117, 118, 119, 120, 121, 122, 123, 124,  125, 126, 127, 128, 129, 130, 131, 132,
     133, 134, 135, 136, 137, 138, 139, 140,  141, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
       0,   0, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174,   0, 175, 176,   0,
     177, 178, 179, 180,   0, 181, 182,   0,    0, 183,   0, 184,   0,   0,   0, 185,
     186, 187, 188, 189,   0,   0,   0,   0,    0,   0, 190,   0,   0,   0,   0, 191,
     192,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_latin1_sot[101] =
{
        0,  133,  172,  241,  310,  381,  443,  505,   576,  630,  667,  682,  694,  703,  747,  767,
      781,  810,  818,  824,  841,  858,  877,  908,   925,  940,  991, 1006, 1022, 1041, 1058, 1074,
     1102, 1166, 1229, 1297, 1366, 1435, 1503, 1566,  1576, 1600, 1645, 1683, 1721, 1755, 1808, 1854,
     1864, 1877, 1893, 1903, 1931, 1984, 2046, 2052,  2072, 2096, 2114, 2124, 2134, 2163, 2172, 2188,
     2196, 2204, 2218, 2233, 2252, 2273, 2297, 2305,  2313, 2334, 2393, 2461, 2497, 2510, 2523, 2539,
     2553, 2559, 2568, 2584, 2590, 2617, 2637, 2706,  2775, 2847, 2916, 2985, 3054, 3123, 3192, 3261,
     3330, 3371, 3426, 3433, 3473
};

const unsigned short tr_latin1_sbt[3488] =
{
     155, 164, 108, 109, 110, 111, 114, 128,  133, 134, 135, 136, 137, 138, 139, 140,
     141, 142, 143, 144, 145, 146, 147, 148,  149, 150, 151, 152, 153, 154, 155, 156,
     157, 158, 159, 160, 161, 162, 163, 165,  166, 167, 168, 169, 170, 171, 172, 173,
     174, 175, 176, 177, 178, 179, 180, 181,  182, 183, 184, 185, 186, 187, 188, 189,
     190, 191, 192, 193, 194, 195, 196, 197,  198, 199, 200, 201, 202, 203, 204, 205,
     206, 207, 208, 209, 210, 211, 212, 213,  214, 215, 216, 217, 218, 219, 220, 221,
     222, 223, 224, 225, 226, 227,  64, 164,  228,   1,   2,   3,   4,   5,   6,   7,
       8,   9,  10,  11,  12,  13,  14,  15,   16,  17,  18,  19,  20,  21,  22,  25,
      41,  62,  68,  69,  77, 127, 164,   6,  164, 224, 261, 262, 263, 264, 265, 266,
     267, 268, 269, 270, 271, 272, 273, 274,  275, 276, 277, 278, 279, 280, 281, 282,
     283, 284, 285, 286, 287, 288, 289, 290,  291, 292,  28, 164, 101, 164, 192, 293,
     294, 295, 296, 297, 298, 299, 300, 301,  302, 303, 304, 305, 306, 307, 308, 309,
     310, 311, 312, 313, 314, 315, 316, 317,  318, 319, 320, 321, 322, 323, 324, 325,
     326, 327, 328, 329, 330, 331, 332, 333,  334, 335, 336, 337, 338, 339, 340, 341,
     342, 343, 344, 345, 346, 347, 348, 349,  350, 351, 352, 353, 354, 355, 356,  28,
     164, 101, 164, 207, 166, 198, 166, 198,  166, 198, 168, 200, 168, 200, 168, 200,
     168, 200, 169, 201, 169, 201, 170, 202,  170, 202, 170, 202, 170, 202, 170, 202,
     172, 204, 172, 204, 172, 204, 172, 204,  173, 205, 173, 205, 174, 206, 174, 206,
     174, 206, 174, 206, 174,   3, 164, 244,  175, 207, 176, 208, 164, 177, 209, 177,
     209, 177, 209, 177,  28, 164, 101, 164,  248, 209, 177, 209, 179, 211, 179, 211,
     179,   2, 211,   2, 164, 250, 180, 212,  180, 212, 180, 212,   2, 164, 212, 183,
     215, 183, 215, 183, 215, 184, 216, 184,  216, 184, 216, 184, 216, 185, 217, 185,
     217, 185, 217, 186, 218, 186, 218, 186,  218, 186, 218, 186, 218, 186, 218, 188,
     220, 190, 222, 356, 191, 223, 191, 223,  191, 223, 216,  28, 164, 101, 164, 255,
     199,   2, 167, 255, 199,   3, 164, 253,  168, 200, 164,   2, 169, 255, 201,   4,
     164, 253, 171, 203, 172,   3, 164, 252,  174, 176, 208, 209,   2, 164, 254, 179,
     211,   2, 180, 255, 212,   2, 164, 254,  181, 213,   5, 164, 244, 217, 185, 217,
     185, 186, 218, 164, 187, 190, 222, 191,  223,  37, 164, 104, 164, 255, 134,   9,
     164, 223, 166, 198, 174, 206, 180, 212,  186, 218, 186, 218, 186, 218, 186, 218,
     186, 218, 164, 166, 198, 166, 198, 299,  331, 172, 204, 172, 204, 176, 208, 180,
     212, 180, 212,   2, 164, 255, 207,   3,  164, 254, 172, 204,   2, 164, 248, 179,
     211, 166, 198, 299, 331, 317, 349,  28,  164, 101, 164, 228, 166, 198, 166, 198,
     170, 202, 170, 202, 174, 206, 174, 206,  180, 212, 180, 212, 183, 215, 183, 215,
     186, 218, 186, 218, 184, 216, 185, 217,    2, 164, 252, 173, 205, 179, 201,   2,
     164, 237, 191, 223, 166, 198, 170, 202,  180, 212, 180, 212, 180, 212, 180, 212,
     190, 222, 209, 211, 217,   3, 164, 250,  166, 168, 200, 177, 185, 216,  28, 164,
     101, 164, 255, 223,   2, 164, 243, 167,  186, 164, 170, 202, 175, 207, 164, 214,
     183, 215, 190, 222,   3, 164, 253, 199,  164, 200,   2, 201,   8, 164, 255, 204,
       5, 164, 253, 205, 164, 206,   2, 164,    4, 209,   2, 164, 255, 210,   2, 211,
       8, 164,   3, 215,  29, 164, 103, 164,  255, 216,   5, 164, 252, 217, 218, 164,
     219,   4, 164,   2, 223,  11, 164, 255,  207,   2, 164, 255, 214,  15, 164, 252,
     205, 164, 207, 215,   3, 164, 254, 220,  222,  35, 164, 125, 164,   4, 133, 254,
     227, 133,   3, 164, 253, 209, 216, 221,   56, 164, 127, 164,  32, 164, 255, 133,
       3, 164, 255, 160,  29, 164, 105, 164,    2, 133, 254, 164, 284,  84, 164, 105,
     164, 253, 170, 164, 174,   6, 164, 255,  174,   2, 164, 255, 166,   7, 164, 255,
     174,   5, 164, 255, 180,   4, 164, 255,  186,   9, 164, 255, 170,   2, 164, 255,
     198,   7, 164, 255, 206,   5, 164, 255,  212,  29, 164, 104, 164, 255, 218,   9,
     164, 255, 202,   6, 164, 253, 202, 164,  206,   6, 164, 255, 206,  62, 164, 127,
     164,  14, 164, 254, 180, 212,  16, 164,  254, 173, 205,  32, 164, 117, 164, 252,
     166, 198, 166, 198,  14, 164, 250, 174,  206, 174, 206, 180, 212,   4, 164, 248,
     170, 202, 186, 218, 186, 218, 186, 218,   40, 164, 127, 164,   2, 164, 255, 134,
      63, 164, 111, 164, 255, 146,  81, 164,  127, 164,   6, 164, 246, 149, 150, 151,
     152, 153, 154, 155, 156, 157, 158,  50,  164, 127, 164,  22, 164, 246, 149, 150,
     151, 152, 153, 154, 155, 156, 157, 158,   34, 164, 101, 164, 246, 149, 150, 151,
     152, 153, 154, 155, 156, 157, 158,  47,  164, 255, 134,  34, 164, 127, 164,  11,
     164, 239,  23, 164,  23, 164,  23, 164,   23, 164,  23, 164,  23, 164,  23, 164,
      23, 164,  23,   3, 164, 252,  24, 164,   24,  19,  31, 164, 127, 164,  12, 164,
     246, 149, 150, 151, 152, 153, 154, 155,  156, 157, 158,  44, 164, 117, 164, 246,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158,  66, 164, 102, 164, 254,  26,
      24,  10, 164, 255,  27,  17, 164, 254,   19,  28,   4, 164, 253,  29, 164,  30,
       2, 164, 255,  31,   2, 164, 254,  24,   20,   2, 164, 255,  31,   2, 164, 248,
      32,  33,  34, 164,  35,  36,  37,  38,    2, 164, 254,  39,  40,  28, 164, 101,
     164, 246, 149, 150, 151, 152, 153, 154,  155, 156, 157, 158,  82, 164, 127, 164,
      15, 164, 247, 150, 151, 152, 153, 154,  155, 156, 157, 158,  42, 164, 107, 164,
     255, 274,   9, 164, 246, 149, 150, 151,  152, 153, 154, 155, 156, 157, 158,  66,
     164, 105, 164, 244, 134, 164, 149, 150,  151, 152, 153, 154, 155, 156, 157, 158,
      76, 164, 117, 164, 245, 149, 150, 151,  152, 153, 154, 155, 156, 157, 158, 150,
      65, 164, 101, 164, 246, 149, 150, 151,  152, 153, 154, 155, 156, 157, 158,   6,
     164, 246, 149, 150, 151, 152, 153, 154,  155, 156, 157, 158,  66, 164, 101, 164,
     255, 166,   2, 164, 252, 167, 168, 169,  201,   2, 170, 250, 174, 175, 176, 177,
     178, 179,   5, 180,   2, 164,   2, 180,  255, 181,   2, 183, 255, 185,   3, 186,
     252, 178, 187, 188, 191,   9, 164, 236,  166, 299, 167, 164, 169, 170, 164, 172,
     173, 174, 175, 176, 177, 178, 179, 164,  180, 164, 181, 183,  28, 164, 101, 164,
     252, 185, 186, 188, 198,   3, 164, 253,  199, 201, 202,   3, 164, 250, 204, 164,
     208, 210, 164, 212,   3, 164, 253, 213,  217, 218,   2, 164, 255, 219,   6, 164,
     252, 206, 215, 218, 219,   6, 164, 250,  199, 201, 203, 210, 211, 213,   2, 215,
     253, 216, 217, 223,   4, 164, 252, 174,  164, 213, 186,  29, 164, 101, 164, 237,
     199, 201, 203, 204, 208, 209, 210, 211,  213, 215, 216, 164, 219, 221, 223, 198,
     164, 201, 202,   3, 164, 255, 206,   2,  164, 255, 218,   2, 164,   2, 200, 248,
     341, 202, 203, 207, 204, 205, 206, 164,    2, 206, 255, 207,   3, 209,   2, 210,
       3, 211, 248, 212, 164, 216, 164, 217,  218, 164, 218,   2, 219,   3, 223,  30,
     164, 101, 164, 192, 166, 198, 167, 199,  167, 199, 167, 199, 168, 200, 169, 201,
     169, 201, 169, 201, 169, 201, 169, 201,  170, 202, 170, 202, 170, 202, 170, 202,
     170, 202, 171, 203, 172, 204, 173, 205,  173, 205, 173, 205, 173, 205, 173, 205,
     174, 206, 174, 206, 176, 208, 176, 208,  176, 208, 177, 209, 177, 209, 177, 209,
     177, 209, 178, 210,  28, 164, 101, 164,  192, 178, 210, 178, 210, 179, 211, 179,
     211, 179, 211, 179, 211, 180, 212, 180,  212, 180, 212, 180, 212, 181, 213, 181,
     213, 183, 215, 183, 215, 183, 215, 183,  215, 184, 216, 184, 216, 184, 216, 184,
     216, 184, 216, 185, 217, 185, 217, 185,  217, 185, 217, 186, 218, 186, 218, 186,
     218, 186, 218, 186, 218, 187, 219, 187,  219,  28, 164, 101, 164, 228, 188, 220,
     188, 220, 188, 220, 188, 220, 188, 220,  189, 221, 189, 221, 190, 222, 191, 223,
     191, 223, 191, 223, 205, 217, 220, 222,  198, 216,   4, 164, 224, 166, 198, 166,
     198, 166, 198, 166, 198, 166, 198, 166,  198, 166, 198, 166, 198, 166, 198, 166,
     198, 166, 198, 166, 198, 170, 202, 170,  202, 170, 202, 170, 202,  28, 164, 101,
     164, 198, 170, 202, 170, 202, 170, 202,  170, 202, 174, 206, 174, 206, 180, 212,
     180, 212, 180, 212, 180, 212, 180, 212,  180, 212, 180, 212, 180, 212, 180, 212,
     180, 212, 180, 212, 180, 212, 186, 218,  186, 218, 186, 218, 186, 218, 186, 218,
     186, 218, 186, 218, 190, 222, 190, 222,  190, 222, 190, 222,  34, 164, 127, 164,
      35, 164, 253, 133, 164, 133,  28, 164,  101, 164,   2, 133,  11, 164,   3, 133,
      13, 164,   3, 133,  13, 164,   2, 133,  255, 197,  13, 164,   2, 133,  29, 164,
     101, 164, 250,  42,  43,  44, 164,  45,   46,   2, 164, 251,  47,  48,  49, 164,
      50,   4, 164, 253,  51,  52,  53,   8,  164, 253,  54,  55,  56,   9, 164, 255,
      57,   2, 164, 255,  58,   4, 164, 253,   59,  60,  61,  41, 164, 101, 164,  11,
     133,   5, 164,   2, 146, 255, 164,   2,  146,   2, 164, 255, 133,   4, 140,   4,
     135,   2, 164, 253, 143, 164, 147,  10,  164, 255, 133,  12, 164, 253, 134, 164,
     133,  29, 164, 104, 164, 255, 146,   4,  164, 255, 134,   9, 164, 255, 146,  12,
     164, 255, 133,  16, 164, 254, 149, 206,    2, 164, 244, 153, 154, 155, 156, 157,
     158, 144, 274, 162, 141, 142, 211,  28,  164, 101, 164, 227, 149, 150, 151, 152,
     153, 154, 155, 156, 157, 158, 144, 274,  162, 141, 142, 164, 198, 202, 212, 221,
     164, 205, 208, 209, 210, 211, 213, 216,  217,  63, 164, 103, 164, 255, 168,   7,
     164, 255, 204,   3, 173, 254, 205, 164,    2, 174, 252, 177, 209, 164, 179,   3,
     164, 254, 181, 182,   3, 183,   6, 164,  255, 191,   3, 164, 243, 191, 164, 176,
     166, 167, 168, 164, 202, 170, 171, 164,  178, 212,   4, 164, 255, 206,  34, 164,
     106, 164, 251, 169, 201, 202, 206, 207,   21, 164, 254, 150, 174,   3, 164, 255,
     187,   4, 164, 255, 189,   2, 164, 251,  177, 168, 169, 178, 206,   3, 164, 255,
     219,   4, 164, 255, 221,   2, 164, 252,  209, 200, 201, 210,  28, 164, 119, 164,
     255, 146,   2, 164, 255, 148,  70, 164,  127, 164,   6, 164, 255, 162,  13, 164,
     254, 161, 163,  44, 164, 114, 164, 255,  143,   8, 164, 253, 146, 164, 148,   6,
     164, 255, 146,  60, 164, 117, 164, 255,  273,   8, 164, 255, 273,  66, 164, 127,
     164,   6, 164, 247, 150, 151, 152, 153,  154, 155, 156, 157, 158,  11, 164, 247,
     150, 151, 152, 153, 154, 155, 156, 157,  158,  31, 164, 109, 164, 247, 150, 151,
     152, 153, 154, 155, 156, 157, 158,  11,  164, 220, 198, 199, 200, 201, 202, 203,
     204, 205, 206, 207, 208, 209, 210, 211,  212, 213, 214, 215, 216, 217, 218, 219,
     220, 221, 222, 223, 166, 167, 168, 169,  170, 171, 172, 173, 174, 175,  28, 164,
     101, 164, 213, 176, 177, 178, 179, 180,  181, 182, 183, 184, 185, 186, 187, 188,
     189, 190, 191, 198, 199, 200, 201, 202,  203, 204, 205, 206, 207, 208, 209, 210,
     211, 212, 213, 214, 215, 216, 217, 218,  219, 220, 221, 222, 223, 149,  10, 164,
     245, 150, 151, 152, 153, 154, 155, 156,  157, 158, 164, 149,  28, 164, 122, 164,
       2, 143,  69, 164, 127, 164,   8, 164,    2, 134,  18, 164, 247, 150, 151, 152,
     153, 154, 155, 156, 157, 158,  29, 164,  101, 164, 237, 150, 151, 152, 153, 154,
     155, 156, 157, 158, 164, 150, 151, 152,  153, 154, 155, 156, 157, 158,  73, 164,
     127, 164,  22, 164,   2, 143,   2, 164,    4, 143, 255, 148,   2, 164, 255, 143,
      32, 164, 102, 164,   2, 143,  41, 164,    2, 273,  46, 164, 112, 164, 255, 174,
      47, 164, 255, 206,  32, 164, 127, 164,    6, 164, 243, 177, 209, 177, 181, 183,
     198, 217, 173, 205, 176, 208, 191, 223,    7, 164, 255, 219,   7, 164, 254, 207,
     187,  30, 164, 127, 164,   4, 164, 254,  180, 212,  60, 164, 101, 164, 253,  63,
     164,  64,   8, 164, 251,  65, 164,  66,  164,  67,  76, 164, 101, 164, 253, 133,
     145, 147,  89, 164, 127, 164, 255, 164,    2, 133,  63, 164, 101, 164, 247, 150,
     151, 152, 153, 154, 155, 156, 157, 158,   83, 164, 125, 164, 246, 149, 150, 151,
     152, 153, 154, 155, 156, 157, 158,  58,  164, 101, 164, 254, 208, 178,  30, 164,
     247, 150, 151, 152, 153, 154, 155, 156,  157, 158,  51, 164, 125, 164, 255,  19,
      10, 164, 254,  24,  26,   2, 164, 253,   24, 164,  24,   5, 164, 255,  20,  44,
     164, 127, 164,  18, 164, 255,  70,   4,  164, 255,  71,   6, 164, 254,  72,  73,
       2, 164, 252,  74,  75, 164,  76,  28,  164, 127, 164,  15, 164, 255, 144,  50,
     164, 127, 164,   4, 164,   6, 133,  56,  164, 117, 164, 255, 145,   2, 164, 253,
     159, 160, 134,  29, 164,   2, 196, 252,  141, 142, 224, 226,  35, 164, 108, 164,
     254, 192, 194,   4, 133,   3, 196, 243,  145, 164, 147, 164, 160, 159, 164, 134,
     164, 141, 142, 224, 226,   2, 164, 243,  136, 139, 143, 144, 146, 161, 163, 162,
     164, 193, 137, 138, 165,   4, 164, 241,  133, 164, 133, 164, 133, 164, 133, 164,
     133, 164, 133, 164, 133, 164, 133,  29,  164, 102, 164, 193, 134, 135, 136, 137,
     138, 139, 140, 141, 142, 143, 144, 145,  146, 147, 148, 149, 150, 151, 152, 153,
     154, 155, 156, 157, 158, 159, 160, 161,  162, 163, 164, 165, 166, 167, 168, 169,
     170, 171, 172, 173, 174, 175, 176, 177,  178, 179, 180, 181, 182, 183, 184, 185,
     186, 187, 188, 189, 190, 191, 192, 193,  194, 195, 196,  28, 164, 101, 164, 225,
     197, 198, 199, 200, 201, 202, 203, 204,  205, 206, 207, 208, 209, 210, 211, 212,
     213, 214, 215, 216, 217, 218, 219, 220,  221, 222, 223, 224, 225, 226, 227,  61,
     164, 127, 164,   6, 164, 250, 263, 264,  273, 133, 267, 266,  54, 164, 117, 164,
     254,  78,  83,  11, 164, 253,  85, 164,   98,  60, 164, 117, 164, 253,  79,  80,
      19,  22, 164, 255,  81,  15, 164, 255,   82,  34, 164, 117, 164, 255, 173,  10,
     164, 255, 309,  28, 164, 255, 205,  35,  164, 104, 164, 255, 341,  88, 164, 101,
     164, 252, 150, 151, 152, 153,  88, 164,  127, 164,   6, 164, 247, 150, 151, 152,
     153, 154, 155, 156, 157, 158,  51, 164,  102, 164, 255,  84,  90, 164, 119, 164,
     247, 150, 151, 152, 153, 154, 155, 156,  157, 158,  11, 164, 246, 149, 150, 151,
     152, 153, 154, 155, 156, 157, 158,  44,  164, 117, 164, 245,  86,  87,  88,  89,
      90,  91,  92,  93,  94,  95,  96,   4,  164, 255,  97,  60, 164, 101, 164, 192,
     166, 167, 168, 169, 170, 171, 172, 173,  174, 175, 176, 177, 178, 179, 180, 181,
     182, 183, 184, 185, 186, 187, 188, 189,  190, 191, 198, 199, 200, 201, 202, 203,
     204, 205, 206, 207, 208, 209, 210, 211,  212, 213, 214, 215, 216, 217, 218, 219,
     220, 221, 222, 223, 166, 167, 168, 169,  170, 171, 172, 173, 174, 175, 176, 177,
      28, 164, 101, 164, 192, 178, 179, 180,  181, 182, 183, 184, 185, 186, 187, 188,
     189, 190, 191, 198, 199, 200, 201, 202,  203, 204, 164, 206, 207, 208, 209, 210,
     211, 212, 213, 214, 215, 216, 217, 218,  219, 220, 221, 222, 223, 166, 167, 168,
     169, 170, 171, 172, 173, 174, 175, 176,  177, 178, 179, 180, 181, 182, 183, 184,
     185, 186, 187, 188, 189,  28, 164, 101,  164, 224, 190, 191, 198, 199, 200, 201,
     202, 203, 204, 205, 206, 207, 208, 209,  210, 211, 212, 213, 214, 215, 216, 217,
     218, 219, 220, 221, 222, 223, 166, 164,  168, 169,   2, 164, 255, 172,   2, 164,
     254, 175, 176,   2, 164, 233, 179, 180,  181, 182, 164, 184, 185, 186, 187, 188,
     189, 190, 191, 198, 199, 200, 201, 164,  203, 164, 205, 206, 207,  28, 164, 101,
     164, 192, 208, 209, 210, 211, 164, 213,  214, 215, 216, 217, 218, 219, 220, 221,
     222, 223, 166, 167, 168, 169, 170, 171,  172, 173, 174, 175, 176, 177, 178, 179,
     180, 181, 182, 183, 184, 185, 186, 187,  188, 189, 190, 191, 198, 199, 200, 201,
     202, 203, 204, 205, 206, 207, 208, 209,  210, 211, 212, 213, 214, 215, 216, 217,
     218, 219,  28, 164, 101, 164, 245, 220,  221, 222, 223, 166, 167, 164, 169, 170,
     171, 172,   2, 164, 206, 175, 176, 177,  178, 179, 180, 181, 182, 164, 184, 185,
     186, 187, 188, 189, 190, 164, 198, 199,  200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 217, 218, 219, 220, 221, 222, 223,
     166, 167, 164, 169, 170, 171, 172,  29,  164, 101, 164, 249, 174, 175, 176, 177,
     178, 164, 180,   3, 164, 202, 184, 185,  186, 187, 188, 189, 190, 164, 198, 199,
     200, 201, 202, 203, 204, 205, 206, 207,  208, 209, 210, 211, 212, 213, 214, 215,
     216, 217, 218, 219, 220, 221, 222, 223,  166, 167, 168, 169, 170, 171, 172, 173,
     174, 175, 176, 177, 178, 179, 180, 181,  182, 183, 184, 185,  28, 164, 101, 164,
     192, 186, 187, 188, 189, 190, 191, 198,  199, 200, 201, 202, 203, 204, 205, 206,
     207, 208, 209, 210, 211, 212, 213, 214,  215, 216, 217, 218, 219, 220, 221, 222,
     223, 166, 167, 168, 169, 170, 171, 172,  173, 174, 175, 176, 177, 178, 179, 180,
     181, 182, 183, 184, 185, 186, 187, 188,  189, 190, 191, 198, 199, 200, 201, 202,
     203,  28, 164, 101, 164, 192, 204, 205,  206, 207, 208, 209, 210, 211, 212, 213,
     214, 215, 216, 217, 218, 219, 220, 221,  222, 223, 166, 167, 168, 169, 170, 171,
     172, 173, 174, 175, 176, 177, 178, 179,  180, 181, 182, 183, 184, 185, 186, 187,
     188, 189, 190, 191, 198, 199, 200, 201,  202, 203, 204, 205, 206, 207, 208, 209,
     210, 211, 212, 213, 214, 215,  28, 164,  101, 164, 192, 216, 217, 218, 219, 220,
     221, 222, 223, 166, 167, 168, 169, 170,  171, 172, 173, 174, 175, 176, 177, 178,
     179, 180, 181, 182, 183, 184, 185, 186,  187, 188, 189, 190, 191, 198, 199, 200,
     201, 202, 203, 204, 205, 206, 207, 208,  209, 210, 211, 212, 213, 214, 215, 216,
     217, 218, 219, 220, 221, 222, 223, 166,  167, 168, 169,  28, 164, 101, 164, 192,
     170, 171, 172, 173, 174, 175, 176, 177,  178, 179, 180, 181, 182, 183, 184, 185,
     186, 187, 188, 189, 190, 191, 198, 199,  200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 217, 218, 219, 220, 221, 222, 223,
     166, 167, 168, 169, 170, 171, 172, 173,  174, 175, 176, 177, 178, 179, 180, 181,
      28, 164, 101, 164, 220, 182, 183, 184,  185, 186, 187, 188, 189, 190, 191, 198,
     199, 200, 201, 202, 203, 204, 205, 206,  207, 208, 209, 210, 211, 212, 213, 214,
     215, 216, 217, 218, 219, 220, 221, 222,  223,  56, 164, 115, 164, 206, 149, 150,
     151, 152, 153, 154, 155, 156, 157, 158,  149, 150, 151, 152, 153, 154, 155, 156,
     157, 158, 149, 150, 151, 152, 153, 154,  155, 156, 157, 158, 149, 150, 151, 152,
     153, 154, 155, 156, 157, 158, 149, 150,  151, 152, 153, 154, 155, 156, 157, 158,
      28, 164, 105, 164, 254,  99, 100,  86,  164, 101, 164,   2, 149, 247, 150, 151,
     152, 153, 154, 155, 156, 157, 158,  32,  164, 254, 168, 183,   3, 164, 240, 166,
     167, 168, 169, 170, 171, 172, 173, 174,  175, 176, 177, 178, 179, 180, 181,  28,
     164, 101, 164, 246, 182, 183, 184, 185,  186, 187, 188, 189, 190, 191,  82, 164

};

// utf/tr_utf8_latin2.txt
//
// 2543 code points.
// 99 states, 193 columns, 7374 bytes
//
const unsigned char tr_latin2_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   1,    2,   3,   4,   0,   0,   5,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   6,   0,   0,   0,   0,
       7,   8,   9,  10,  11,  12,  13,  14,   15,  16,  17,  18,  19,  20,  21,  22,
      23,  24,  25,  26,  27,  28,  29,  30,   31,  32,  33,  34,  35,  36,  37,   0,
      38,  39,  40,  41,  42,  43,  44,  45,   46,  47,  48,  49,  50,  51,  52,  53,
      54,  55,  56,  57,  58,  59,  60,  61,   62,  63,  64,  65,  66,  67,  68,  69,
      70,  71,  72,  73,  74,  75,  76,  77,   78,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,  90,  91,  92,  93,   94,  95,  96,  97,  98,  99, 100,   0,

     101, 102, 103, 104, 105, 106, 107, 108,  109, 110, 111, 112, 113, 114, 115, 116,
     117, 118, 119, 120, 121, 122, 123, 124,  125, 126, 127, 128, 129, 130, 131, 132,
     133, 134, 135, 136, 137, 138, 139, 140,  141, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
       0,   0, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174,   0, 175, 176,   0,
     177, 178, 179, 180,   0, 181, 182,   0,    0, 183,   0, 184,   0,   0,   0, 185,
     186, 187, 188, 189,   0,   0,   0,   0,    0,   0, 190,   0,   0,   0,   0, 191,
     192,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_latin2_sot[99] =
{
        0,  133,  170,  239,  308,  379,  441,  505,   576,  630,  667,  688,  700,  706,  750,  770,
      784,  813,  821,  827,  844,  861,  880,  911,   928,  943,  994, 1009, 1025, 1044, 1061, 1077,
     1105, 1169, 1232, 1300, 1369, 1438, 1506, 1569,  1579, 1603, 1646, 1684, 1722, 1756, 1809, 1855,
     1865, 1878, 1894, 1922, 1975, 2037, 2043, 2063,  2087, 2105, 2111, 2121, 2150, 2159, 2175, 2183,
     2191, 2205, 2220, 2239, 2260, 2284, 2292, 2300,  2321, 2380, 2448, 2484, 2492, 2505, 2521, 2531,
     2540, 2556, 2562, 2589, 2609, 2678, 2747, 2819,  2888, 2957, 3026, 3095, 3164, 3233, 3302, 3343,
     3398, 3405, 3445
};

const unsigned short tr_latin2_sbt[3460] =
{
     155, 162, 106, 107, 108, 109, 112, 126,  131, 132, 133, 134, 135, 136, 137, 138,
     139, 140, 141, 142, 143, 144, 145, 146,  147, 148, 149, 150, 151, 152, 153, 154,
     155, 156, 157, 158, 159, 160, 161, 163,  164, 165, 166, 167, 168, 169, 170, 171,
     172, 173, 174, 175, 176, 177, 178, 179,  180, 181, 182, 183, 184, 185, 186, 187,
     188, 189, 190, 191, 192, 193, 194, 195,  196, 197, 198, 199, 200, 201, 202, 203,
     204, 205, 206, 207, 208, 209, 210, 211,  212, 213, 214, 215, 216, 217, 218, 219,
     220, 221, 222, 223, 224, 225,  64, 162,  228,   1,   2,   3,   4,   5,   6,   7,
       8,   9,  10,  11,  12,  13,  14,  15,   16,  17,  18,  19,  20,  21,  22,  25,
      41,  61,  67,  68,  76, 127, 162,   6,  162, 254, 259, 132,   2, 162, 255, 263,
       2, 162, 252, 266, 267, 162, 196,   2,  162, 248, 272, 162, 131, 275, 162, 149,
     150, 279,   3, 162, 253, 283, 148, 210,   33, 162, 101, 162, 192, 164, 292, 293,
     164, 295, 164, 162, 298, 168, 300, 168,  302, 172, 304, 305, 172, 167, 177, 178,
     310, 311, 178, 313, 314, 178, 184, 317,  184, 319, 320, 162, 322, 196, 324, 325,
     196, 327, 196, 162, 330, 200, 332, 200,  334, 204, 336, 337, 204, 199, 209, 210,
     342, 343, 210, 345, 346, 210, 216, 349,  216, 351, 352, 162, 220,  28, 162, 101,
     162, 207, 164, 196, 294, 326, 260, 276,  297, 329, 166, 198, 166, 198, 299, 331,
     306, 338, 307, 339, 168, 200, 168, 200,  168, 200, 301, 333, 303, 335, 170, 202,
     170, 202, 170, 202, 170, 202, 171, 203,  171, 203, 172, 204, 172, 204, 172, 204,
     172, 204, 172,   3, 162, 244, 173, 205,  174, 206, 162, 296, 328, 175, 207, 264,
     280, 175,  28, 162, 101, 162, 246, 207,  262, 278, 308, 340, 177, 209, 309, 341,
     209,   2, 162, 250, 178, 210, 178, 210,  312, 344,   2, 162, 212, 291, 323, 181,
     213, 315, 347, 265, 281, 182, 214, 269,  285, 268, 284, 321, 353, 270, 286, 183,
     215, 184, 216, 184, 216, 184, 216, 316,  348, 318, 350, 184, 216, 186, 218, 188,
     220, 188, 271, 287, 274, 290, 273, 289,  214,  28, 162, 101, 162, 255, 197,   2,
     165, 255, 197,   3, 162, 253, 166, 198,  162,   2, 167, 255, 199,   4, 162, 253,
     169, 201, 170,   3, 162, 252, 172, 174,  206, 207,   2, 162, 254, 177, 209,   2,
     178, 255, 210,   2, 162, 254, 179, 211,    5, 162, 244, 215, 183, 215, 183, 184,
     216, 162, 185, 188, 220, 189, 221,  37,  162, 104, 162, 255, 132,   9, 162, 235,
     164, 196, 172, 204, 178, 210, 184, 216,  184, 216, 184, 216, 184, 216, 184, 216,
     162, 164, 196, 164, 196,   2, 162, 246,  170, 202, 170, 202, 174, 206, 178, 210,
     178, 210,   2, 162, 255, 205,   3, 162,  254, 170, 202,   2, 162, 252, 177, 209,
     164, 196,   2, 162, 254, 178, 210,  28,  162, 101, 162, 228, 164, 196, 164, 196,
     168, 200, 168, 200, 172, 204, 172, 204,  178, 210, 178, 210, 181, 213, 181, 213,
     184, 216, 184, 216, 182, 214, 183, 215,    2, 162, 252, 171, 203, 177, 199,   2,
     162, 237, 189, 221, 164, 196, 168, 200,  178, 210, 178, 210, 178, 210, 178, 210,
     188, 220, 207, 209, 215,   3, 162, 250,  164, 166, 198, 175, 183, 214,  28, 162,
     101, 162, 255, 221,   2, 162, 243, 165,  184, 162, 168, 200, 173, 205, 162, 212,
     181, 213, 188, 220,   3, 162, 253, 197,  162, 198,   2, 199,   8, 162, 255, 202,
       5, 162, 253, 203, 162, 204,   2, 162,    4, 207,   2, 162, 255, 208,   2, 209,
       8, 162,   3, 213,  29, 162, 103, 162,  255, 214,   5, 162, 252, 215, 216, 162,
     217,   4, 162,   2, 221,  11, 162, 255,  205,   2, 162, 255, 212,  15, 162, 252,
     203, 162, 205, 213,   3, 162, 254, 218,  220,  35, 162, 108, 162, 255, 282,  16,
     162, 250, 261, 354, 131, 277, 225, 288,    3, 162, 253, 207, 214, 219,  56, 162,
     127, 162,  32, 162, 255, 131,   3, 162,  255, 158,  29, 162, 105, 162,   2, 131,
      86, 162, 105, 162, 253, 168, 162, 172,    6, 162, 255, 172,   2, 162, 255, 164,
       7, 162, 255, 172,   5, 162, 255, 178,    4, 162, 255, 184,   9, 162, 255, 168,
       2, 162, 255, 196,   7, 162, 255, 204,    5, 162, 255, 210,  29, 162, 104, 162,
     255, 216,   9, 162, 255, 200,   6, 162,  253, 200, 162, 204,   6, 162, 255, 204,
      62, 162, 127, 162,  14, 162, 254, 178,  210,  16, 162, 254, 171, 203,  32, 162,
     117, 162, 252, 164, 196, 164, 196,  14,  162, 250, 172, 204, 172, 204, 178, 210,
       4, 162, 248, 168, 200, 184, 216, 184,  216, 184, 216,  40, 162, 127, 162,   2,
     162, 255, 132,  63, 162, 111, 162, 255,  144,  81, 162, 127, 162,   6, 162, 246,
     147, 148, 149, 150, 151, 152, 153, 154,  155, 156,  50, 162, 127, 162,  22, 162,
     246, 147, 148, 149, 150, 151, 152, 153,  154, 155, 156,  34, 162, 101, 162, 246,
     147, 148, 149, 150, 151, 152, 153, 154,  155, 156,  47, 162, 255, 132,  34, 162,
     127, 162,  11, 162, 239,  23, 162,  23,  162,  23, 162,  23, 162,  23, 162,  23,
     162,  23, 162,  23, 162,  23,   3, 162,  252,  24, 162,  24,  19,  31, 162, 127,
     162,  12, 162, 246, 147, 148, 149, 150,  151, 152, 153, 154, 155, 156,  44, 162,
     117, 162, 246, 147, 148, 149, 150, 151,  152, 153, 154, 155, 156,  66, 162, 102,
     162, 254,  26,  24,  10, 162, 255,  27,   17, 162, 254,  19,  28,   4, 162, 253,
      29, 162,  30,   2, 162, 255,  31,   2,  162, 254,  24,  20,   2, 162, 255,  31,
       2, 162, 248,  32,  33,  34, 162,  35,   36,  37,  38,   2, 162, 254,  39,  40,
      28, 162, 101, 162, 246, 147, 148, 149,  150, 151, 152, 153, 154, 155, 156,  82,
     162, 127, 162,  15, 162, 247, 148, 149,  150, 151, 152, 153, 154, 155, 156,  42,
     162, 107, 162, 255, 144,   9, 162, 246,  147, 148, 149, 150, 151, 152, 153, 154,
     155, 156,  66, 162, 105, 162, 244, 132,  162, 147, 148, 149, 150, 151, 152, 153,
     154, 155, 156,  76, 162, 117, 162, 245,  147, 148, 149, 150, 151, 152, 153, 154,
     155, 156, 148,  65, 162, 101, 162, 246,  147, 148, 149, 150, 151, 152, 153, 154,
     155, 156,   6, 162, 246, 147, 148, 149,  150, 151, 152, 153, 154, 155, 156,  66,
     162, 101, 162, 255, 164,   2, 162, 252,  165, 166, 167, 199,   2, 168, 250, 172,
     173, 174, 175, 176, 177,   5, 178,   2,  162,   2, 178, 255, 179,   2, 181, 255,
     183,   3, 184, 252, 176, 185, 186, 189,    9, 162, 236, 164, 162, 165, 162, 167,
     168, 162, 170, 171, 172, 173, 174, 175,  176, 177, 162, 178, 162, 179, 181,  28,
     162, 101, 162, 252, 183, 184, 186, 196,    3, 162, 253, 197, 199, 200,   3, 162,
     250, 202, 162, 206, 208, 162, 210,   3,  162, 253, 211, 215, 216,   2, 162, 255,
     217,   6, 162, 252, 204, 213, 216, 217,    6, 162, 250, 197, 199, 201, 208, 209,
     211,   2, 213, 253, 214, 215, 221,   4,  162, 252, 172, 162, 211, 184,  29, 162,
     101, 162, 237, 197, 199, 201, 202, 206,  207, 208, 209, 211, 213, 214, 162, 217,
     219, 221, 196, 162, 199, 200,   3, 162,  255, 204,   2, 162, 255, 216,   2, 162,
       2, 198, 248, 199, 200, 201, 205, 202,  203, 204, 162,   2, 204, 255, 205,   3,
     207,   2, 208,   3, 209, 248, 210, 162,  214, 162, 215, 216, 162, 216,   2, 217,
       3, 221,  30, 162, 101, 162, 192, 164,  196, 165, 197, 165, 197, 165, 197, 166,
     198, 167, 199, 167, 199, 167, 199, 167,  199, 167, 199, 168, 200, 168, 200, 168,
     200, 168, 200, 168, 200, 169, 201, 170,  202, 171, 203, 171, 203, 171, 203, 171,
     203, 171, 203, 172, 204, 172, 204, 174,  206, 174, 206, 174, 206, 175, 207, 175,
     207, 175, 207, 175, 207, 176, 208,  28,  162, 101, 162, 192, 176, 208, 176, 208,
     177, 209, 177, 209, 177, 209, 177, 209,  178, 210, 178, 210, 178, 210, 178, 210,
     179, 211, 179, 211, 181, 213, 181, 213,  181, 213, 181, 213, 182, 214, 182, 214,
     182, 214, 182, 214, 182, 214, 183, 215,  183, 215, 183, 215, 183, 215, 184, 216,
     184, 216, 184, 216, 184, 216, 184, 216,  185, 217, 185, 217,  28, 162, 101, 162,
     228, 186, 218, 186, 218, 186, 218, 186,  218, 186, 218, 187, 219, 187, 219, 188,
     220, 189, 221, 189, 221, 189, 221, 203,  215, 218, 220, 196, 214,   4, 162, 224,
     164, 196, 164, 196, 164, 196, 164, 196,  164, 196, 164, 196, 164, 196, 164, 196,
     164, 196, 164, 196, 164, 196, 164, 196,  168, 200, 168, 200, 168, 200, 168, 200,
      28, 162, 101, 162, 198, 168, 200, 168,  200, 168, 200, 168, 200, 172, 204, 172,
     204, 178, 210, 178, 210, 178, 210, 178,  210, 178, 210, 178, 210, 178, 210, 178,
     210, 178, 210, 178, 210, 178, 210, 178,  210, 184, 216, 184, 216, 184, 216, 184,
     216, 184, 216, 184, 216, 184, 216, 188,  220, 188, 220, 188, 220, 188, 220,  34,
     162, 127, 162,  35, 162, 253, 131, 162,  131,  28, 162, 101, 162,   2, 131,  11,
     162,   3, 131,  13, 162,   3, 131,  13,  162,   2, 131, 255, 195,  13, 162,   2,
     131,  29, 162, 101, 162, 250,  42,  43,   44, 162,  45,  46,   2, 162, 253,  47,
      48,  49,   6, 162, 253,  50,  51,  52,    8, 162, 253,  53,  54,  55,   9, 162,
     255,  56,   2, 162, 255,  57,   4, 162,  253,  58,  59,  60,  41, 162, 101, 162,
      11, 131,   5, 162,   2, 144, 255, 162,    2, 144,   2, 162, 255, 131,   4, 138,
       4, 133,   2, 162, 253, 141, 162, 145,   10, 162, 255, 131,  12, 162, 253, 132,
     162, 131,  29, 162, 104, 162, 255, 144,    4, 162, 255, 132,   9, 162, 255, 144,
      12, 162, 255, 131,  16, 162, 254, 147,  204,   2, 162, 244, 151, 152, 153, 154,
     155, 156, 142, 144, 160, 139, 140, 209,   28, 162, 101, 162, 227, 147, 148, 149,
     150, 151, 152, 153, 154, 155, 156, 142,  144, 160, 139, 140, 162, 196, 200, 210,
     219, 162, 203, 206, 207, 208, 209, 211,  214, 215,  63, 162, 103, 162, 255, 166,
       7, 162, 255, 202,   3, 171, 254, 203,  162,   2, 172, 252, 175, 207, 162, 177,
       3, 162, 254, 179, 180,   3, 181,   6,  162, 255, 189,   3, 162, 243, 189, 162,
     174, 164, 165, 166, 162, 200, 168, 169,  162, 176, 210,   4, 162, 255, 204,  34,
     162, 106, 162, 251, 167, 199, 200, 204,  205,  21, 162, 254, 148, 172,   3, 162,
     255, 185,   4, 162, 255, 187,   2, 162,  251, 175, 166, 167, 176, 204,   3, 162,
     255, 217,   4, 162, 255, 219,   2, 162,  252, 207, 198, 199, 208,  28, 162, 119,
     162, 255, 144,   2, 162, 255, 146,  70,  162, 127, 162,   6, 162, 255, 160,  13,
     162, 254, 159, 161,  44, 162, 114, 162,  255, 141,   8, 162, 253, 144, 162, 146,
       6, 162, 255, 144,  60, 162, 127, 162,    6, 162, 247, 148, 149, 150, 151, 152,
     153, 154, 155, 156,  11, 162, 247, 148,  149, 150, 151, 152, 153, 154, 155, 156,
      31, 162, 109, 162, 247, 148, 149, 150,  151, 152, 153, 154, 155, 156,  11, 162,
     220, 196, 197, 198, 199, 200, 201, 202,  203, 204, 205, 206, 207, 208, 209, 210,
     211, 212, 213, 214, 215, 216, 217, 218,  219, 220, 221, 164, 165, 166, 167, 168,
     169, 170, 171, 172, 173,  28, 162, 101,  162, 213, 174, 175, 176, 177, 178, 179,
     180, 181, 182, 183, 184, 185, 186, 187,  188, 189, 196, 197, 198, 199, 200, 201,
     202, 203, 204, 205, 206, 207, 208, 209,  210, 211, 212, 213, 214, 215, 216, 217,
     218, 219, 220, 221, 147,  10, 162, 245,  148, 149, 150, 151, 152, 153, 154, 155,
     156, 162, 147,  28, 162, 122, 162,   2,  141,  69, 162, 127, 162,   8, 162,   2,
     132,  18, 162, 247, 148, 149, 150, 151,  152, 153, 154, 155, 156,  29, 162, 101,
     162, 237, 148, 149, 150, 151, 152, 153,  154, 155, 156, 162, 148, 149, 150, 151,
     152, 153, 154, 155, 156,  73, 162, 127,  162,  22, 162,   2, 141,   2, 162,   4,
     141, 255, 146,   2, 162, 255, 141,  32,  162, 102, 162,   2, 141,  89, 162, 112,
     162, 255, 172,  47, 162, 255, 204,  32,  162, 127, 162,   6, 162, 243, 175, 207,
     175, 179, 181, 196, 215, 171, 203, 174,  206, 189, 221,   7, 162, 255, 217,   7,
     162, 254, 205, 185,  30, 162, 127, 162,    4, 162, 254, 178, 210,  60, 162, 101,
     162, 253,  62, 162,  63,   8, 162, 251,   64, 162,  65, 162,  66,  76, 162, 101,
     162, 253, 131, 143, 145,  89, 162, 127,  162, 255, 162,   2, 131,  63, 162, 101,
     162, 247, 148, 149, 150, 151, 152, 153,  154, 155, 156,  83, 162, 125, 162, 246,
     147, 148, 149, 150, 151, 152, 153, 154,  155, 156,  58, 162, 101, 162, 254, 206,
     176,  30, 162, 247, 148, 149, 150, 151,  152, 153, 154, 155, 156,  51, 162, 125,
     162, 255,  19,  10, 162, 254,  24,  26,    2, 162, 253,  24, 162,  24,   5, 162,
     255,  20,  44, 162, 127, 162,  18, 162,  255,  69,   4, 162, 255,  70,   6, 162,
     254,  71,  72,   2, 162, 252,  73,  74,  162,  75,  28, 162, 127, 162,  15, 162,
     255, 142,  50, 162, 127, 162,   4, 162,    6, 131,  56, 162, 117, 162, 255, 143,
       2, 162, 253, 157, 158, 132,  29, 162,    2, 194, 252, 139, 140, 222, 224,  35,
     162, 108, 162, 254, 190, 192,   4, 131,    3, 194, 243, 143, 162, 145, 162, 158,
     157, 162, 132, 162, 139, 140, 222, 224,    2, 162, 243, 134, 137, 141, 142, 144,
     159, 161, 160, 162, 191, 135, 136, 163,    4, 162, 241, 131, 162, 131, 162, 131,
     162, 131, 162, 131, 162, 131, 162, 131,  162, 131,  29, 162, 102, 162, 193, 132,
     133, 134, 135, 136, 137, 138, 139, 140,  141, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
     165, 166, 167, 168, 169, 170, 171, 172,  173, 174, 175, 176, 177, 178, 179, 180,
     181, 182, 183, 184, 185, 186, 187, 188,  189, 190, 191, 192, 193, 194,  28, 162,
     101, 162, 225, 195, 196, 197, 198, 199,  200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 217, 218, 219, 220, 221, 222, 223,
     224, 225,  61, 162, 127, 162,   9, 162,  255, 131,  56, 162, 117, 162, 254,  77,
      81,  11, 162, 253,  83, 162,  96,  60,  162, 117, 162, 253,  78, 162,  19,  22,
     162, 255,  79,  15, 162, 255,  80,  34,  162, 117, 162, 255, 171,  39, 162, 255,
     203,  35, 162, 101, 162, 252, 148, 149,  150, 151,  88, 162, 127, 162,   6, 162,
     247, 148, 149, 150, 151, 152, 153, 154,  155, 156,  51, 162, 102, 162, 255,  82,
      90, 162, 119, 162, 247, 148, 149, 150,  151, 152, 153, 154, 155, 156,  11, 162,
     246, 147, 148, 149, 150, 151, 152, 153,  154, 155, 156,  44, 162, 117, 162, 245,
      84,  85,  86,  87,  88,  89,  90,  91,   92,  93,  94,   4, 162, 255,  95,  60,
     162, 101, 162, 192, 164, 165, 166, 167,  168, 169, 170, 171, 172, 173, 174, 175,
     176, 177, 178, 179, 180, 181, 182, 183,  184, 185, 186, 187, 188, 189, 196, 197,
     198, 199, 200, 201, 202, 203, 204, 205,  206, 207, 208, 209, 210, 211, 212, 213,
     214, 215, 216, 217, 218, 219, 220, 221,  164, 165, 166, 167, 168, 169, 170, 171,
     172, 173, 174, 175,  28, 162, 101, 162,  192, 176, 177, 178, 179, 180, 181, 182,
     183, 184, 185, 186, 187, 188, 189, 196,  197, 198, 199, 200, 201, 202, 162, 204,
     205, 206, 207, 208, 209, 210, 211, 212,  213, 214, 215, 216, 217, 218, 219, 220,
     221, 164, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174, 175, 176, 177, 178,
     179, 180, 181, 182, 183, 184, 185, 186,  187,  28, 162, 101, 162, 224, 188, 189,
     196, 197, 198, 199, 200, 201, 202, 203,  204, 205, 206, 207, 208, 209, 210, 211,
     212, 213, 214, 215, 216, 217, 218, 219,  220, 221, 164, 162, 166, 167,   2, 162,
     255, 170,   2, 162, 254, 173, 174,   2,  162, 233, 177, 178, 179, 180, 162, 182,
     183, 184, 185, 186, 187, 188, 189, 196,  197, 198, 199, 162, 201, 162, 203, 204,
     205,  28, 162, 101, 162, 192, 206, 207,  208, 209, 162, 211, 212, 213, 214, 215,
     216, 217, 218, 219, 220, 221, 164, 165,  166, 167, 168, 169, 170, 171, 172, 173,
     174, 175, 176, 177, 178, 179, 180, 181,  182, 183, 184, 185, 186, 187, 188, 189,
     196, 197, 198, 199, 200, 201, 202, 203,  204, 205, 206, 207, 208, 209, 210, 211,
     212, 213, 214, 215, 216, 217,  28, 162,  101, 162, 245, 218, 219, 220, 221, 164,
     165, 162, 167, 168, 169, 170,   2, 162,  206, 173, 174, 175, 176, 177, 178, 179,
     180, 162, 182, 183, 184, 185, 186, 187,  188, 162, 196, 197, 198, 199, 200, 201,
     202, 203, 204, 205, 206, 207, 208, 209,  210, 211, 212, 213, 214, 215, 216, 217,
     218, 219, 220, 221, 164, 165, 162, 167,  168, 169, 170,  29, 162, 101, 162, 249,
     172, 173, 174, 175, 176, 162, 178,   3,  162, 202, 182, 183, 184, 185, 186, 187,
     188, 162, 196, 197, 198, 199, 200, 201,  202, 203, 204, 205, 206, 207, 208, 209,
     210, 211, 212, 213, 214, 215, 216, 217,  218, 219, 220, 221, 164, 165, 166, 167,
     168, 169, 170, 171, 172, 173, 174, 175,  176, 177, 178, 179, 180, 181, 182, 183,
      28, 162, 101, 162, 192, 184, 185, 186,  187, 188, 189, 196, 197, 198, 199, 200,
     201, 202, 203, 204, 205, 206, 207, 208,  209, 210, 211, 212, 213, 214, 215, 216,
     217, 218, 219, 220, 221, 164, 165, 166,  167, 168, 169, 170, 171, 172, 173, 174,
     175, 176, 177, 178, 179, 180, 181, 182,  183, 184, 185, 186, 187, 188, 189, 196,
     197, 198, 199, 200, 201,  28, 162, 101,  162, 192, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 217, 218, 219, 220, 221, 164, 165,
     166, 167, 168, 169, 170, 171, 172, 173,  174, 175, 176, 177, 178, 179, 180, 181,
     182, 183, 184, 185, 186, 187, 188, 189,  196, 197, 198, 199, 200, 201, 202, 203,
     204, 205, 206, 207, 208, 209, 210, 211,  212, 213,  28, 162, 101, 162, 192, 214,
     215, 216, 217, 218, 219, 220, 221, 164,  165, 166, 167, 168, 169, 170, 171, 172,
     173, 174, 175, 176, 177, 178, 179, 180,  181, 182, 183, 184, 185, 186, 187, 188,
     189, 196, 197, 198, 199, 200, 201, 202,  203, 204, 205, 206, 207, 208, 209, 210,
     211, 212, 213, 214, 215, 216, 217, 218,  219, 220, 221, 164, 165, 166, 167,  28,
     162, 101, 162, 192, 168, 169, 170, 171,  172, 173, 174, 175, 176, 177, 178, 179,
     180, 181, 182, 183, 184, 185, 186, 187,  188, 189, 196, 197, 198, 199, 200, 201,
     202, 203, 204, 205, 206, 207, 208, 209,  210, 211, 212, 213, 214, 215, 216, 217,
     218, 219, 220, 221, 164, 165, 166, 167,  168, 169, 170, 171, 172, 173, 174, 175,
     176, 177, 178, 179,  28, 162, 101, 162,  220, 180, 181, 182, 183, 184, 185, 186,
     187, 188, 189, 196, 197, 198, 199, 200,  201, 202, 203, 204, 205, 206, 207, 208,
     209, 210, 211, 212, 213, 214, 215, 216,  217, 218, 219, 220, 221,  56, 162, 115,
     162, 206, 147, 148, 149, 150, 151, 152,  153, 154, 155, 156, 147, 148, 149, 150,
     151, 152, 153, 154, 155, 156, 147, 148,  149, 150, 151, 152, 153, 154, 155, 156,
     147, 148, 149, 150, 151, 152, 153, 154,  155, 156, 147, 148, 149, 150, 151, 152,
     153, 154, 155, 156,  28, 162, 105, 162,  254,  97,  98,  86, 162, 101, 162,   2,
     147, 247, 148, 149, 150, 151, 152, 153,  154, 155, 156,  32, 162, 254, 166, 181,
       3, 162, 240, 164, 165, 166, 167, 168,  169, 170, 171, 172, 173, 174, 175, 176,
     177, 178, 179,  28, 162, 101, 162, 246,  180, 181, 182, 183, 184, 185, 186, 187,
     188, 189,  82, 162
};

// utf/tr_widths.txt
//
// 333242 code points.
// 231 states, 91 columns, 4054 bytes
//
const unsigned char tr_widths_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       1,   2,   3,   4,   5,   6,   7,   8,    9,  10,  11,  12,  13,  14,  15,  16,
      17,  18,  19,  20,  21,  22,  23,  24,   25,  26,  27,  28,  29,  30,  31,  32,
      33,  34,  35,  36,  37,  38,  39,  40,   41,  42,  43,  44,  45,  46,  47,  48,
      49,  50,  51,  52,  53,  54,  55,  56,   57,  58,  59,  60,  61,  62,  63,  64,
      65,  65,  66,  66,  66,  66,  66,  66,   66,  66,  66,  66,  66,  67,  68,  66,
      66,  66,  66,  66,  69,  70,  71,  72,   73,  66,  66,  66,  74,  75,  76,  77,
      78,  79,  80,  81,  82,  83,  83,  83,   83,  83,  84,  83,  83,  85,  86,  87,
      88,  65,  65,  89,  90,  65,  65,  65,   65,  65,  65,  65,  65,  65,  65,  65

};

const unsigned short tr_widths_sot[231] =
{
        0,   30,   36,   46,   62,   72,   86,  103,   117,  131,  141,  151,  157,  163,  200,  210,
      220,  229,  235,  245,  278,  308,  349,  378,   412,  438,  472,  502,  546,  572,  602,  636,
      666,  699,  721,  751,  772,  796,  806,  812,   861,  881,  895,  909,  919,  979,  996, 1002,
     1010, 1020, 1028, 1052, 1074, 1090, 1104, 1114,  1124, 1130, 1140, 1146, 1160, 1178, 1192, 1206,
     1212, 1222, 1228, 1242, 1255, 1265, 1279, 1289,  1303, 1317, 1327, 1337, 1347, 1357, 1367, 1377,
     1391, 1415, 1425, 1451, 1500, 1514, 1528, 1534,  1544, 1554, 1560, 1566, 1576, 1582, 1592, 1602,
     1612, 1622, 1639, 1653, 1675, 1697, 1703, 1713,  1719, 1729, 1747, 1755, 1761, 1771, 1781, 1791,
     1801, 1811, 1821, 1827, 1837, 1843, 1883, 1893,  1903, 1909, 1919, 1933, 1939, 1949, 1963, 1975,
     1989, 1995, 2009, 2019, 2041, 2051, 2062, 2072,  2078, 2105, 2126, 2140, 2150, 2156, 2166, 2176,
     2192, 2214, 2224, 2232, 2238, 2268, 2297, 2350,  2371, 2381, 2395, 2405, 2411, 2417, 2431, 2437,
     2447, 2457, 2467, 2492, 2502, 2516, 2526, 2556,  2570, 2580, 2594, 2600, 2606, 2623, 2633, 2647,
     2653, 2663, 2669, 2682, 2688, 2698, 2706, 2720,  2726, 2736, 2742, 2747, 2753, 2790, 2800, 2806,
     2812, 2822, 2832, 2864, 2874, 2900, 2917, 2927,  2937, 2946, 2979, 3040, 3062, 3068, 3103, 3117,
     3127, 3141, 3147, 3153, 3163, 3173, 3187, 3193,  3203, 3217, 3225, 3235, 3241, 3251, 3257, 3266,
     3274, 3280, 3292, 3304, 3314, 3320, 3328
};

const unsigned char tr_widths_sbt[3336] =
{
     255, 232,  65, 231, 231,   1,   2,   3,    4,   5,   6,   7,   8,   9,  10,  11,
      12,  13,  44,  83, 105, 115, 116, 117,  133, 135, 136, 149, 225, 230, 255, 231,
      64, 232,  26, 231, 255, 231,  56, 232,    2, 231,   5, 232,  27, 231,   5, 231,
       7, 232, 253, 231, 232, 231,  20, 232,  255, 231,  29, 232,  26, 231, 255, 231,
      40, 232,   9, 231,  15, 232,  26, 231,  255, 231,  23, 232,   2, 231,   7, 232,
     255, 231,  31, 232,  26, 231, 255, 231,    8, 232, 255, 231,   2, 232,   4, 231,
     254, 232, 231,  47, 232,  26, 231, 255,  231,   8, 232,   8, 231,  27, 232,   5,
     231,   5, 232,  37, 231, 255, 231,   5,  232, 255, 231,  22, 232,   2, 231,  34,
     232,  26, 231, 255, 231,  14, 232, 255,  231,  49, 232,  26, 231, 255, 231,  11,
     232,   2, 231,  51, 232,  26, 231, 255,  231,  50, 232,  40, 231, 255, 231,  59,
     232,  31, 231,  33, 231, 224,  14,  15,   16,  17,   1,  18,  19,  20,  21,  22,
      23,  24,  25,  26,  27,  28,  29,  30,   31,  32,  33,  34,  35,  36,  37,  38,
      39,  40,   1,  41,  42,  43,  26, 231,  255, 231,  46, 232,   2, 231,  15, 232,
      27, 231, 255, 231,  28, 232,   2, 231,  255, 232,  59, 231,  33, 231, 254, 232,
     231,  11, 232,  45, 231,  37, 231,  27,  232,  27, 231, 255, 231,  56, 232, 255,
     231,   7, 232,  26, 231,   2, 231,   3,  232, 255, 231,   8, 232,   2, 231,   2,
     232,   2, 231,  22, 232, 255, 231,   7,  232, 254, 231, 232,   3, 231,   4, 232,
       2, 231,   4, 232,  26, 231, 255, 231,    5, 232,   2, 231,   2, 232,   2, 231,
       4, 232,   8, 231, 255, 232,   4, 231,    2, 232, 255, 231,   5, 232,   2, 231,
      22, 232,  30, 231,   2, 231,   3, 232,  255, 231,   6, 232,   4, 231,   2, 232,
       2, 231,  22, 232, 255, 231,   7, 232,  255, 231,   2, 232, 255, 231,   2, 232,
     255, 231,   2, 232,   2, 231, 254, 232,  231,   2, 232,  26, 231, 255, 231,   3,
     232,   4, 231,   2, 232,   2, 231,   3,  232,   3, 231, 255, 232,   7, 231,   4,
     232, 254, 231, 232,   7, 231,  16, 232,   36, 231,   2, 231,   3, 232, 255, 231,
       9, 232, 255, 231,   3, 232, 255, 231,   22, 232, 255, 231,   7, 232, 255, 231,
       2, 232, 255, 231,   5, 232,   2, 231,    4, 232,  26, 231, 255, 231,   6, 232,
     255, 231,   3, 232, 255, 231,   3, 232,    2, 231, 255, 232,  15, 231,   4, 232,
       2, 231,  12, 232,  40, 231,   2, 231,    3, 232, 255, 231,   8, 232,   2, 231,
       2, 232,   2, 231,  22, 232, 255, 231,    7, 232, 255, 231,   2, 232, 255, 231,
       5, 232,   2, 231,   4, 232,  26, 231,  255, 231,   5, 232,   2, 231,   2, 232,
       2, 231,   3, 232,   8, 231,   2, 232,    4, 231,   2, 232, 255, 231,   5, 232,
       2, 231,  18, 232,  34, 231,   3, 231,    2, 232, 255, 231,   6, 232,   3, 231,
       3, 232, 255, 231,   4, 232,   3, 231,    2, 232, 253, 231, 232, 231,   2, 232,
       3, 231,   2, 232,   3, 231,   3, 232,    3, 231,  12, 232,   4, 231,   2, 232,
      26, 231, 255, 231,   3, 232,   3, 231,    3, 232, 255, 231,   4, 232,   2, 231,
     255, 232,   6, 231, 255, 232,  14, 231,   21, 232,  31, 231,   2, 231,   3, 232,
     255, 231,   8, 232, 255, 231,   3, 232,  255, 231,  23, 232, 255, 231,  10, 232,
     255, 231,   5, 232,   3, 231,   3, 232,   26, 231, 255, 231,   5, 232, 255, 231,
       3, 232, 255, 231,   4, 232,   7, 231,    2, 232, 255, 231,   2, 232,   6, 231,
       4, 232,   2, 231,  10, 232,   8, 231,    8, 232,  26, 231,   3, 231,   2, 232,
     255, 231,   8, 232, 255, 231,   3, 232,  255, 231,  23, 232, 255, 231,  10, 232,
     255, 231,   5, 232,   2, 231,   4, 232,   26, 231, 255, 231,   5, 232, 255, 231,
       3, 232, 255, 231,   4, 232,   7, 231,    2, 232,   7, 231, 254, 232, 231,   4,
     232,   2, 231,  10, 232, 255, 231,   2,  232,  39, 231,   3, 231,   2, 232, 255,
     231,   8, 232, 255, 231,   3, 232, 255,  231,  41, 232,   2, 231,   3, 232,  26,
     231, 255, 231,   5, 232, 255, 231,   3,  232, 255, 231,   5, 232,   8, 231, 255,
     232,   8, 231,   4, 232,   2, 231,  16,  232,   3, 231,   7, 232,  26, 231,   3,
     231,   2, 232, 255, 231,  18, 232,   3,  231,  24, 232, 255, 231,   9, 232, 254,
     231, 232,  28, 231, 255, 231,   7, 232,    3, 231, 255, 232,   4, 231,   6, 232,
     253, 231, 232, 231,   8, 232,  18, 231,    3, 232,  37, 231,   2, 231,  58, 232,
       4, 231, 255, 232,  26, 231, 255, 231,   28, 232,  62, 231,   2, 231,   2, 232,
     254, 231, 232,   2, 231,   2, 232, 254,  231, 232,   2, 231, 255, 232,   6, 231,
       4, 232, 255, 231,   7, 232, 255, 231,    3, 232, 252, 231, 232, 231, 232,   2,
     231,   2, 232, 255, 231,  13, 232, 255,  231,   3, 232,  28, 231, 255, 231,   5,
     232, 253, 231, 232, 231,   6, 232,   2,  231,  10, 232,   2, 231,   4, 232,  58,
     231, 255, 231,   8, 232, 255, 231,  36,  232,   4, 231,  15, 232,  26, 231, 255,
     231,  24, 232, 255, 231,  36, 232, 255,  231,   2, 232,  26, 231, 255, 231,  13,
     232, 255, 231,  13, 232,  63, 231, 255,  231,   3,   1, 243,  45,  46,  47,  48,
      49,   1,  50,  51,  52,  53,  54,  55,   56,  10,   1, 230,  57,  58,  59,  60,
       1,  61,  62,  63,  64,  65,  66,  67,   68,  69,  70,  71,  72, 231,   1,  73,
       1,  74,  75,  76, 231,  77,   3,   1,  255,  78,   4,   1, 252,  79,  80,  81,
      82,  26, 231, 255, 231,   6, 232, 254,  231, 232,   5, 231, 255, 232,   2, 231,
      48, 232,  26, 231, 255, 231,  64, 233,   26, 231, 255, 231,  32, 233,  32, 232,
      26, 231, 255, 231,  35, 232,   5, 233,   24, 232,  26, 231, 255, 231,  58, 232,
       6, 233,  26, 231, 255, 231,   9, 232,  255, 231,   4, 232,   2, 231,   7, 232,
     253, 231, 232, 231,   4, 232,   2, 231,   32, 232,  26, 231, 255, 231,   9, 232,
     255, 231,   4, 232,   2, 231,  33, 232,  255, 231,   4, 232,   2, 231,   7, 232,
      27, 231, 253, 231, 232, 231,   4, 232,    2, 231,  15, 232, 255, 231,  40, 232,
      26, 231, 255, 231,  17, 232, 255, 231,    4, 232,   2, 231,  40, 232,  26, 231,
     255, 231,  27, 232,   2, 231,  32, 232,   29, 231, 255, 231,  26, 232,   6, 231,
      32, 232,  26, 231, 255, 231,  53, 232,   37, 231, 255, 231,  29, 232,   3, 231,
      32, 232,  26, 231, 255, 231,  49, 232,   41, 231, 255, 231,  13, 232, 255, 231,
       7, 232,  11, 231,  23, 232,  35, 231,  255, 231,  20, 232,  12, 231,  13, 232,
     255, 231,   3, 232, 255, 231,   2, 232,   38, 231, 255, 231,  30, 232,   2, 231,
      10, 232,   6, 231,  10, 232,  32, 231,  255, 231,  15, 232, 255, 231,  10, 232,
       6, 231,  32, 232,  26, 231, 255, 231,   56, 232,  34, 231, 255, 231,  43, 232,
       5, 231,  16, 232,  26, 231, 255, 231,   54, 232,  36, 231, 255, 231,  29, 232,
       3, 231,  12, 232,   4, 231,  12, 232,   30, 231, 254, 231, 232,   3, 231,  42,
     232,   2, 231,   5, 232,  37, 231, 255,  231,  44, 232,   4, 231,  16, 232,  26,
     231, 255, 231,  10, 232,   6, 231,  11,  232,   3, 231,  34, 232,  26, 231, 255,
     231,  28, 232,   2, 231,  34, 232,  26,  231, 255, 231,  31, 232, 255, 231,  29,
     232,   2, 231, 255, 232,  26, 231, 255,  231,  10, 232,   6, 231,  10, 232,   6,
     231,  14, 232,  44, 231, 255, 231,  12,  232,   4, 231,  45, 232,  29, 231, 255,
     231,  52, 232,   8, 231,   4, 232,  26,  231, 255, 231,  56, 232,   3, 231,   5,
     232,  26, 231, 255, 231,  10, 232,   3,  231,  51, 232,  26, 231, 255, 231,   8,
     232,   8, 231,  39, 232,  35, 231, 255,  231,  39, 232,  21, 231,   4, 232,  26,
     231, 255, 231,  22, 232,   2, 231,   6,  232,   2, 231,  32, 232,  26, 231, 255,
     231,   6, 232,   2, 231,   6, 232,   2,  231,   8, 232, 249, 231, 232, 231, 232,
     231, 232, 231,  31, 232,  28, 231, 255,  231,  53, 232, 255, 231,  10, 232,  26,
     231, 255, 231,   5, 232, 255, 231,  14,  232,   2, 231,   6, 232, 255, 231,  19,
     232,   2, 231,   3, 232, 255, 231,   9,  232,  27, 231, 251, 231,   1,  84,  85,
      86,   2,   1, 255,  87,   5,   1, 255,   88,   2,   1, 253,  89,  90,  91,  10,
       1, 255,  92,  16,   1, 255,  93,   2,  231, 244,  94,  95,   1,  96,  97,  98,
      99, 100, 101, 231, 102, 103,   3,  46,  255, 104,  26, 231, 255, 231,  37, 232,
       5, 231,   8, 232,   2, 231,  12, 232,   26, 231, 255, 231,  15, 232, 255, 231,
      13, 232,   3, 231,  26, 232,  32, 231,   17, 231,  33, 232,  41, 231, 255, 231,
      10, 232,   6, 231,  48, 232,  26, 231,  255, 231,  41, 232,   2, 233,  21, 232,
      26, 231, 255, 231,  52, 232,  38, 231,  255, 231,  39, 232,  51, 231, 255, 231,
      11, 232,  21, 231,  32, 232,  26, 231,    2, 231,  63, 232,  26, 231, 255, 231,
      13, 232,   3, 231,  10, 232,  64, 231,  255, 231,  47, 232, 255, 231,  16, 232,
      26, 231, 255, 231,  31, 232, 255, 231,   32, 232,  26, 231, 255, 231,  52, 232,
       5, 231,   7, 232,  26, 231, 255, 231,   38, 232, 254, 231, 232,   5, 231, 255,
     232,   2, 231,  16, 232,  26, 231, 255,  231,  40, 232,   7, 231,   2, 232,  14,
     231, 255, 232,  26, 231, 255, 231,  23,  232,   9, 231,   7, 232, 255, 231,   7,
     232, 255, 231,   7, 232, 255, 231,   7,  232,  27, 231, 255, 231,   7, 232, 255,
     231,   7, 232, 255, 231,   7, 232, 255,  231,   7, 232, 255, 231,  32, 232,  26,
     231, 255, 231,  60, 232,  30, 231, 255,  231,  26, 233, 255, 231,  37, 233,  26,
     231, 255, 231,  52, 233,  38, 231, 255,  231,  22, 233,  26, 231,  12, 233,  30,
     231, 243, 231, 106, 107, 108,  46, 109,   46, 110, 111, 112, 113,  46, 114,  52,
      46,  26, 231, 255, 231,  63, 233, 255,  232,  26, 231,   2, 231,  63, 233,  26,
     231, 255, 231,  23, 233,   2, 231,  39,  233,  26, 231,   6, 231,  41, 233,   3,
     231,  15, 233,  26, 231, 255, 231,  15,  233, 255, 231,  43, 233,  31, 231, 255,
     231,  36, 233,  12, 231,  16, 233,  26,  231, 255, 231,  31, 233, 255, 231,  32,
     233,  26, 231, 255, 231,   8, 233,   8,  232,  48, 233,  26, 231, 255, 231,  63,
     233,  27, 231, 255, 231,  55,  46, 255,    1,   8,  46,  26, 231, 255, 231,  64,
      46,  26, 231, 255, 231,  18,  46, 254,  118, 119,   4,   1, 252, 120,   1, 121,
      63,   2,   1, 241, 122, 123, 124,  63,    1, 125,   1, 126,   1, 127, 128, 129,
       1, 130, 131,   2, 231, 255, 132,  16,   46,  26, 231, 255, 231,  13, 233,   3,
     231,  48, 233,  26, 231, 255, 231,   7,  233,   9, 231,  48, 232,  26, 231, 255,
     231,  44, 232,  46, 231, 255, 231,  24,  232,   7, 231,  33, 232,  26, 231, 255,
     231,  15, 232, 255, 231,   4, 232,  12,  231,  11, 232,  47, 231,  57, 231,   8,
     232,  26, 231, 255, 231,  44, 232,   4,  231,  10, 232,  32, 231, 255, 231,   5,
     232,   9, 231,  12, 232,   6, 231,  28,  232,  30, 231, 255, 231,  20, 232,  11,
     231, 255, 232,  29, 233,  29, 231, 255,  231,  14, 232, 255, 231,  11, 232,   4,
     231,   2, 232,  58, 231, 255, 231,  55,  232,  35, 231, 255, 231,  14, 232,   2,
     231,  10, 232,   2, 231,  32, 232,  30,  231, 255, 231,   3, 232,  24, 231,  28,
     232,  35, 231,   2, 231,   6, 232,   2,  231,   6, 232,   2, 231,   6, 232,   9,
     231,   7, 232, 255, 231,   7, 232,  43,  231, 255, 231,  46, 232,   2, 231,  10,
     232,  32, 231, 255, 231,  30,  46, 254,  111, 134,  32,   1,  26, 231, 255, 231,
       7, 233,   4, 231,  49, 233,  30, 231,  255, 231,  64,   1,  26, 231, 255, 231,
      36,   1,   8,  46, 252, 137, 138,   1,  139,   5,   1, 245, 140, 141, 142, 143,
     144,   1, 145, 107, 146, 147, 148,  26,  231, 255, 231,   7, 232,  12, 231,   5,
     232,   5, 231,  26, 232, 255, 231,   5,  232, 254, 231, 232,  27, 231, 255, 231,
       2, 232, 255, 231,   2, 232, 255, 231,   58, 232,  26, 231, 255, 231,   2, 232,
      17, 231,  45, 232,  26, 231,  17, 231,   48, 232,  26, 231, 255, 231,  16, 232,
       2, 231,  46, 232,  26, 231, 255, 231,    8, 232,  40, 231,  14, 232,  28, 231,
     255, 231,  16, 232,  10, 233,   6, 231,    7, 232,   9, 231,  16, 233,  26, 231,
     255, 231,  19, 233, 255, 231,  19, 233,  255, 231,   4, 233,   4, 231,   5, 232,
     255, 231,  10, 232,  26, 231, 255, 231,   61, 232,   2, 231, 255, 232,  26, 231,
     255, 231,  33, 233,  31, 232,  26, 231,  255, 231,  63, 232,  27, 231,   3, 231,
       6, 232,   2, 231,   6, 232,   2, 231,    6, 232,   2, 231,   3, 232,   3, 231,
       7, 233, 255, 231,   7, 232,  10, 231,    5, 232,  28, 231,  17, 231, 252, 150,
     172, 178, 181,   2, 231, 255, 182,   4,  231, 251, 186, 231, 188, 200, 205,  15,
     116, 255, 223,  15, 116, 255, 223,  26,  231, 247, 231, 151, 152,   1,  12, 153,
       1, 154, 155,   2, 231, 250,  57, 156,  157, 158, 159, 160,   2,   1, 255, 161,
      13, 231, 254, 162, 163,   2, 231, 250,  164, 231, 165, 231, 166, 167,   2, 231,
     254, 168, 169,   2, 231, 254,   1, 170,    7, 231, 255, 171,  32, 231, 255, 231,
      12, 232, 255, 231,  26, 232, 255, 231,   19, 232, 255, 231,   2, 232, 254, 231,
     232,  26, 231, 255, 231,  14, 232,   2,  231,  14, 232,  60, 231, 255, 231,   3,
     232,   4, 231,  45, 232,   3, 231,   9,  232,  26, 231, 255, 231,  11, 232,   5,
     231,  12, 232,  62, 231,  17, 231,  46,  232,  28, 231, 255, 231,  17, 232,  73,
     231, 255, 231,  31, 232, 255, 231,   4,  232,  12, 231,  16, 232,  26, 231, 255,
     231,  11, 232,  79, 231, 255, 231,  30,  232, 255, 231,  33, 232,  26, 231, 255,
     231,   4, 232,   4, 231,  14, 232,  68,  231, 255, 231,  30, 232,   2, 231,  10,
     232,  48, 231, 255, 231,   6, 232,   2,  231, 254, 232, 231,  44, 232, 255, 231,
       2, 232,   3, 231, 255, 232,   2, 231,  255, 232,  26, 231, 255, 231,  22, 232,
     255, 231,   9, 232,  58, 231, 255, 231,   28, 232,   3, 231,  27, 232,   5, 231,
     255, 232,  26, 231, 255, 231,  56, 232,    6, 231,   2, 232,  26, 231, 255, 231,
       4, 232, 255, 231,   2, 232,   5, 231,    8, 232, 255, 231,   3, 232, 255, 231,
      27, 232,   4, 231,   3, 232,   4, 231,  255, 232,  26, 231, 255, 231,   8, 232,
       8, 231,   9, 232,   7, 231,  32, 232,   26, 231, 255, 231,  54, 232,   3, 231,
       7, 232,  26, 231, 255, 231,  22, 232,    2, 231,  27, 232,   5, 231,   8, 232,
      26, 231, 255, 231,   9, 232,  81, 231,   33, 231,  31, 232,  27, 231, 247, 231,
       1, 173,   1, 174,  81, 175,   1, 176,   18, 231, 254,  63, 177,  62, 231, 255,
     231,  14, 232,   4, 231,  30, 232,  42,  231, 255, 231,   2, 232,  14, 231,  25,
     232,   7, 231,  10, 232,  32, 231, 255,  231,   4, 232,  86, 231, 255, 231,   9,
     232,   7, 231,  10, 232,  64, 231, 255,  231,  10, 232,  80, 231, 255, 231,  13,
       1, 255, 179,   2, 231, 254,   1, 180,   72, 231, 255, 231,  47, 232,  43, 231,
     255, 231,  35, 232,  13, 231,   4, 232,   38, 231, 255, 231,  16,   1, 255, 179,
      73, 231,  33, 231,   8,   1, 255, 183,   19, 231, 253,   1, 184, 185,  27, 231,
     255, 231,  57, 232,  33, 231, 255, 231,    5, 232,  11, 231,  47, 232,  27, 231,
      16, 231,  17, 232,  58, 231, 254, 231,  187,  89, 231, 255, 231,   2, 233,  88,
     231, 255, 231,   3,   1, 254,  65, 189,    2,   1, 253, 190,   1, 191,   2, 231,
     254,   1, 192,   2, 231, 250,   1, 193,  194, 195, 196, 197,   4,   1, 255, 198,
       4,   1, 255, 199,  58, 231, 255, 231,   39, 232,   2, 231,  23, 232,  26, 231,
     255, 231,  30, 232,  60, 231, 255, 231,    6, 232,  84, 231, 255, 231,  23, 232,
       9, 231,  18, 232,  40, 231, 255, 231,   21, 232, 255, 231,  42, 232,  26, 231,
     255, 231,  29, 232, 255, 231,   2, 232,    2, 231, 255, 232,   2, 231,   2, 232,
       2, 231,   4, 232, 255, 231,  12, 232,  253, 231, 232, 231,   3, 232,  26, 231,
     255, 231,   4, 232, 255, 231,  59, 232,   26, 231, 255, 231,   6, 232, 255, 231,
       4, 232,   2, 231,   8, 232, 255, 231,    7, 232, 255, 231,  28, 232, 255, 231,
       4, 232,  27, 231, 255, 231,   5, 232,  254, 231, 232,   3, 231,   7, 232, 255,
     231,  46, 232,  26, 231, 255, 231,  38,  232,   2, 231,  24, 232,  26, 231, 255,
     231,  12, 232,   2, 231,  50, 232,  26,  231,  57, 231, 252, 201, 202, 203, 204,
      30, 231, 255, 231,   4, 232, 255, 231,   27, 232, 255, 231,   2, 232, 254, 231,
     232,   2, 231, 254, 232, 231,  10, 232,  255, 231,   4, 232, 252, 231, 232, 231,
     232,  30, 231,   3, 231, 255, 232,   4,  231, 250, 232, 231, 232, 231, 232, 231,
       3, 232, 255, 231,   2, 232, 254, 231,  232,   2, 231, 246, 232, 231, 232, 231,
     232, 231, 232, 231, 232, 231,   2, 232,  254, 231, 232,   2, 231,   4, 232, 255,
     231,   7, 232, 255, 231,   4, 232, 255,  231,   4, 232, 254, 231, 232,  27, 231,
     255, 231,  10, 232, 255, 231,  17, 232,    5, 231,   3, 232, 255, 231,   5, 232,
     255, 231,  17, 232,  30, 231,  49, 231,    2, 232,  40, 231, 245, 231,  68,   1,
     206, 207, 208,  68, 209, 210, 211, 212,    2, 231, 238, 213, 214, 215, 216, 147,
     217,   1, 218, 219, 220, 231, 221,   1,  222,   1, 191,   1,  89,  60, 231, 255,
     231,  20, 232,  12, 231,  15, 232,   2,  231,  14, 232,  27, 231,   2, 231,  15,
     232, 255, 231,  15, 232,  58, 231, 255,  231,  11, 232,   5, 231,  31, 232, 255,
     231,  16, 232,  26, 231, 255, 231,  27,  232,  63, 231,  39, 231,  26, 232,  26,
     231, 255, 231,   3, 233,  13, 231,  43,  233,  31, 231, 255, 231,   9, 233,   7,
     231,   2, 233,  72, 231, 255, 231,  33,  232,  15, 231,   6, 232, 255, 231,   9,
     232,  26, 231, 255, 231,  61, 232,  29,  231, 255, 231,  20, 232,  12, 231,  32,
     232,  26, 231, 255, 231,   5, 232, 255,  231,   5, 232,  21, 231,  17, 232,  41,
     231, 253, 231, 232, 231,  62, 232,  26,  231, 255, 231,  56, 232, 255, 231,   4,
     232,  29, 231, 255, 231,  62, 232,  28,  231, 255, 231,   4, 232,  12, 231,  24,
     232,  50, 231,  60, 231,   5, 232,  26,  231, 254, 231, 232,   4, 231,  11, 232,
      74, 231, 255, 231,  63,  46, 255, 224,   26, 231, 255, 231,  62, 233,  28, 231,
      33, 231, 255, 226,  15, 231,  15, 135,  255, 229,  26, 231, 253, 231, 227,   1,
       2, 231,   3,   1, 255, 228,  82, 231,    2, 231, 255, 232,  30, 231,  32, 232,
      26, 231, 255, 231,  48, 232,  42, 231,  255, 231,  63,   1, 255, 219,  26, 231,
     255, 231,  15, 135, 255, 229,  74, 231
};

// utf/tr_tolower.txt
//
// 1233 code points.
// 51 states, 86 columns, 1845 bytes
//
const unsigned char tr_tolower_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,  16,  17,
      18,  19,  20,  21,  22,  23,  24,  25,   26,  27,  28,  29,  30,  31,  32,  33,
      34,  35,  36,  37,  38,  35,  39,  40,   41,  42,  43,  44,  45,  46,  47,  48,
      49,  50,  51,  52,  53,  54,  55,  56,   57,  58,  59,  60,  61,  62,  63,  64,
       0,   0,   0,  65,  66,  67,  68,  69,   70,  71,   0,   0,   0,  72,  73,  74,
      75,  76,  77,  78,  79,  80,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,  81,  82,   0,   0,   0,   0,   0,    0,   0,  83,   0,   0,   0,   0,  84,
      85,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_tolower_sot[51] =
{
        0,   27,   37,  107,  174,  241,  307,  371,   390,  406,  430,  479,  489,  525,  587,  656,
      712,  720,  743,  749,  762,  770,  782,  850,   912,  930,  950,  972, 1004, 1024, 1039, 1045,
     1051, 1065, 1085, 1095, 1127, 1177, 1188, 1238,  1270, 1304, 1365, 1426, 1432, 1438, 1445, 1455,
     1469, 1475, 1481
};

const unsigned char tr_tolower_sbt[1487] =
{
     254,  51,  75,  63,  51, 235,   1,   2,    3,   4,   5,   6,   7,   8,   9,  10,
      11,  12,  13,  14,  15,  16,  17,  28,   37,  43,  45,   2,  51,  23,  76, 255,
      51,   7,  76,  53,  51,   2,  51, 220,   77,  51,  77,  51,  77,  51,  77,  51,
      77,  51,  77,  51,  77,  51,  77,  51,   77,  51,  77,  51,  77,  51,  77,  51,
      77,  51,  77,  51,  77,  51,  77,  51,   77,  51,  77,  51,   2,  77, 240,  51,
      77,  51,  77,  51,  77,  51,  77,  51,   52,  51,  77,  51,  77,  51,  77,   2,
      51, 249,  78,  51,  79,  51,  78,  51,   80,  21,  51,   3,  51, 249,  78,  51,
      79,  51,  78,  51,  81,   2,  51, 230,   77,  51,  77,  51,  77,  51,  77,  51,
      77,  51,  77,  51,  77,  51,  77,  51,   77,  51,  77,  51,  77,  51,  77,  51,
      77,  51,   2,  77, 233,  51,  77,  51,   77,  51,  77,  51,  77,  51,  77,  51,
      77,  51,  77,  51,  77,  51,  82,  78,   51,  79,  51,  78,  23,  51,   3,  51,
     245,  83,  77,  51,  77,  51,  83,  81,   51,  84,  85,  79,   2,  51, 248,  86,
      87,  88,  78,  51,  89,  90,  51,   2,   91, 255,  77,   3,  51, 243,  89,  92,
      51,  93,  77,  51,  77,  51,  77,  94,   81,  51,  95,   2,  51, 243,  77,  51,
      94,  96,  51,  97,  98,  79,  51,  78,   51,  99,  77,   3,  51, 255,  77,  24,
      51,   6,  51, 232, 100,  78,  51, 101,   77,  51, 102,  79,  51,  78,  51,  96,
      51,  78,  51,  79,  51,  78,  51,  81,   51,  78,  51,  79,   2,  51, 250,  77,
      51,  77,  51,  77,  51,   2,  77, 248,   51,  77,  51,  77,  51,  77,  51,  77,
       2,  51, 242, 100,  77,  51,  77,  51,  103, 104,  77,  51,  77,  51,  77,  51,
      77,  22,  51,   2,  51, 220,  77,  51,   77,  51,  77,  51,  77,  51,  77,  51,
      77,  51,  77,  51,  77,  51,  77,  51,   77,  51,  77,  51,  77,  51,  77,  51,
      77,  51,  77,  51,  77,  51, 105,  51,   77,  51,   2,  77, 244,  51,  77,  51,
      77,  51,  77,  51,  77,  51,  77,  51,   77,   7,  51, 251,  53,  79,  51, 106,
      54,  22,  51,   3,  51, 242,  78,  51,  107, 108, 109,  77,  51,  77,  51,  77,
      51,  77,  51,  77,  69,  51,  49,  51,  253,  77,  51,  77,   3,  51, 255,  77,
       8,  51, 255, 110,  21,  51,   8,  51,  245, 111,  51, 112, 113, 112,  51, 114,
      51, 115, 116,  51,  15,  76,   2, 117,  255,  51,   8, 117,  41,  51,  17,  51,
     255, 118,   8,  51, 244,  77,  51,  77,   51,  77,  51,  77,  51,  77,  51,  77,
      51,   2,  77, 248,  51,  77,  51,  77,   51,  77,  51,  77,   5,  51, 255, 119,
       2,  51, 252,  81,  51, 120,  77,   2,   51, 255, 121,   2, 122,  21,  51,   2,
      51,  16, 123,  16,  76,  15, 117,  37,   51,  34,  51, 252,  77,  51,  77,  51,
       2,  77, 232,  51,  77,  51,  77,  51,   77,  51,  77,  51,  77,  51,  77,  51,
      77,  51,  77,  51,  77,  51,  77,  51,   77,  51,  77,  22,  51,   2,  51, 255,
      77,   9,  51, 230,  77,  51,  77,  51,   77,  51,  77,  51,  77,  51,  77,  51,
      77,  51,  77,  51,  77,  51,  77,  51,   77,  51,  77,  51,  77,  51,   2,  77,
     232,  51,  77,  51,  77,  51,  77,  51,   77,  51,  77,  51,  77,  51,  77,  51,
      77,  51,  77,  51,  77,  51,  77,  51,   77,  22,  51,   2,  51, 242,  81,  78,
      51,  79,  51,  78,  51,  81,  51,  78,   51,  79,  51,  78,   2,  51, 236,  77,
      51,  77,  51,  77,  51,  77,  51,  77,   51,  77,  51,  77,  51,  77,  51,  77,
      51,  77,  51,   2,  77, 232,  51,  77,   51,  77,  51,  77,  51,  77,  51,  77,
      51,  77,  51,  77,  51,  77,  51,  77,   51,  77,  51,  77,  51,  77,  22,  51,
       2,  51, 220,  77,  51,  77,  51,  77,   51,  77,  51,  77,  51,  77,  51,  77,
      51,  77,  51,  77,  51,  77,  51,  77,   51,  77,  51,  77,  51,  77,  51,  77,
      51,  77,  51,  77,  51,  77,  51,   2,   77, 248,  51,  77,  51,  77,  51,  77,
      51,  77,   2,  51,  15, 123,  21,  51,    2,  51,  16, 124,   7, 125,  61,  51,
       4,  51, 254,  18,  19,  10,  51, 254,   20,  21,  39,  51,   2,  22, 250,  23,
      22,  24,  25,  26,  27,  21,  51,  34,   51,  31, 126,  21,  51,   2,  51,   6,
     127, 254,  51, 127,   5,  51, 255, 127,   70,  51,  34,  51,  15, 128,  16, 129,
      21,  51,   2,  51,  16, 130,  16, 131,   15, 130,   6, 132,  31,  51,   2,  51,
     220, 133,  51, 133,  51, 133,  51, 133,   51, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51, 133,  51, 133,   51, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51,   2, 133, 232,   51, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51, 133,  51, 133,   51, 133,  51, 133,  51, 133,  51, 133,
      22,  51,   2,  51, 235, 133,  51, 133,   51, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51, 133,  51, 133,   51, 133,   9,  51, 250,  55,  51, 133,
      51, 133,  51,   2, 133, 232,  51, 133,   51, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51, 133,  51, 133,   51, 133,  51, 133,  51, 133,  22,  51,
      10,  51,   8, 132,   8,  51,   6, 132,    9,  51,   8, 132,   8,  51,   8, 132,
      21,  51,  10,  51,   6, 132,  11,  51,  249, 132,  51, 132,  51, 132,  51, 132,
       7,  51,   8, 132,  37,  51,  10,  51,    8, 132,   8,  51,   8, 132,   7,  51,
       8, 132,   8,  51,   2, 132,   2, 134,  255, 135,  24,  51,  10,  51,   2, 136,
       2, 137, 255, 135,  11,  51,   2, 132,    2, 138,  11,  51,   2, 132,   2, 139,
     255, 140,  11,  51,   2, 141,   2, 142,  255, 135,  24,  51,   6,  51, 253,  29,
      30,  31,  11,  51, 254,  32,  33,  27,   51, 252,  34,  35,  22,  36,  33,  51,
      39,  51, 255,  56,   3,  51, 254,  57,   58,   6,  51, 255, 143,  34,  51,  34,
      51,  15, 144,  37,  51,   5,  51, 255,  145,  80,  51,  55,  51,   2, 146,   2,
     147,   2, 148,   2, 147,   2, 146,  21,   51,   2,  51,   2, 149,   2, 150,   2,
     149,   2, 151,   2, 152,   2, 153,   2,  152,   2, 151,  68,  51,   2,  51,  16,
     154,  16, 155,  14, 156,  38,  51,  34,   51, 238, 133,  51,  59, 157,  60,  51,
     135,  51, 158,  51, 145,  51,  61,  62,   63,  64,  51, 133,   2,  51, 255, 158,
       8,  51, 254,  65,  66,  21,  51,   2,   51, 221, 133,  51, 133,  51, 133,  51,
     133,  51, 133,  51, 133,  51, 133,  51,  133,  51, 133,  51, 133,  51, 133,  51,
     133,  51, 133,  51, 133,  51, 133,  51,  133,  51, 133,  51, 133,   7,  51, 253,
     145,  51, 158,   4,  51, 255, 133,  34,   51,  27,  51, 250,  38,  39,  51,  40,
      41,  42,  53,  51,   2,  51, 220, 133,   51, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51, 133,  51, 133,   51, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51, 133,  51, 133,   51, 133,  51,   2, 133, 250,  51, 133,
      51, 133,  51, 133,  40,  51,   2,  51,  229, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51, 133,  51, 133,   51, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  57,  51,  36,  51,  254, 133,  51,   2, 133, 248,  51, 133,
      51, 133,  51, 133,  51, 133,   3,  51,  243, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51, 133,  22,  51,    2,  51, 220, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51, 133,  51, 133,   51, 133,  51, 133,  51, 133,  51, 133,
      51, 133,  51, 133,  51, 133,  51, 133,   51, 133,  51, 133,  51, 133,  51,   2,
     133, 248,  51, 133,  51, 133,  51, 133,   51, 133,  10,  51, 250, 158,  51, 145,
      51, 159, 133,  22,  51,   2,  51, 249,  133,  51, 133,  51, 133,  51, 133,   4,
      51, 253, 145,  51,  67,   2,  51, 253,  133,  51, 133,   3,  51, 242, 133,  51,
     133,  51, 133,  51, 133,  51, 133,  51,  133,  51, 133,  51,   2, 133, 249,  51,
     133,  51,  68,  69,  70,  71,   2,  51,  249,  72,  73,  74, 160, 133,  51, 133,
      30,  51,  61,  51, 255,  44,  24,  51,   35,  51,  25, 161,  26,  51,  18,  51,
     254,  46,  49,  66,  51,  18,  51, 255,   47,  32,  51, 255,  48,  34,  51,   2,
      51,   8, 162,   8, 163,   8, 162,   8,  164,   7, 165,  45,  51,   2,  51,  50,
     166,  34,  51,  36,  51, 255,  50,  49,   51,  34,  51,  31, 167,  21,  51
};

const string_desc tr_tolower_ott[116] =
{
    {  1,  1, T("\x69") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA5") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA6") }, // 1 references
    {  2,  1, T("\xC3\x9F") }, // 1 references
    {  2,  1, T("\xCF\x89") }, // 1 references
    {  1,  1, T("\x6B") }, // 1 references
    {  2,  1, T("\xC3\xA5") }, // 1 references
    {  2,  1, T("\xC9\xAB") }, // 1 references
    {  2,  1, T("\xC9\xBD") }, // 1 references
    {  2,  1, T("\xC9\x91") }, // 1 references
    {  2,  1, T("\xC9\xB1") }, // 1 references
    {  2,  1, T("\xC9\x90") }, // 1 references
    {  2,  1, T("\xC9\x92") }, // 1 references
    {  2,  1, T("\xC8\xBF") }, // 1 references
    {  2,  1, T("\xC9\x80") }, // 1 references
    {  2,  1, T("\xC9\xA5") }, // 1 references
    {  2,  1, T("\xC9\xA6") }, // 1 references
    {  2,  1, T("\xC9\x9C") }, // 1 references
    {  2,  1, T("\xC9\xA1") }, // 1 references
    {  2,  1, T("\xC9\xAC") }, // 1 references
    {  2,  1, T("\xCA\x9E") }, // 1 references
    {  2,  1, T("\xCA\x87") }, // 1 references
    {  2,  1, T("\xCA\x9D") }, // 1 references
    {  1,  1, T("\x20") }, // 26 references
    {  2,  1, T("\x00\x20") }, // 61 references
    {  2,  1, T("\x00\x01") }, // 213 references
    {  2,  1, T("\x00\x03") }, // 18 references
    {  2,  1, T("\x00\x07") }, // 11 references
    {  2,  1, T("\x01\x3F") }, // 1 references
    {  2,  1, T("\x00\x0F") }, // 7 references
    {  2,  1, T("\x06\x07") }, // 1 references
    {  2,  1, T("\x0F\x12") }, // 2 references
    {  2,  1, T("\x0F\x1F") }, // 1 references
    {  2,  1, T("\x0F\x1D") }, // 1 references
    {  2,  1, T("\x01\x13") }, // 1 references
    {  2,  1, T("\x0F\x16") }, // 1 references
    {  2,  1, T("\x0F\x0B") }, // 1 references
    {  2,  1, T("\x0F\x33") }, // 2 references
    {  2,  1, T("\x0F\x37") }, // 1 references
    {  2,  1, T("\x0F\x3F") }, // 2 references
    {  2,  1, T("\x0F\x2F") }, // 1 references
    {  2,  1, T("\x0F\x2A") }, // 1 references
    {  2,  1, T("\x0C\x26") }, // 2 references
    {  2,  1, T("\x0C\x2A") }, // 1 references
    {  2,  1, T("\x00\x1F") }, // 2 references
    {  2,  1, T("\x0C\x3B") }, // 1 references
    {  2,  1, T("\x0C\x39") }, // 1 references
    {  2,  1, T("\x0C\x25") }, // 1 references
    {  2,  1, T("\x00\x02") }, // 2 references
    {  2,  1, T("\x00\x0E") }, // 1 references
    {  2,  1, T("\x00\x06") }, // 1 references
    {  2,  1, T("\x01\x23") }, // 1 references
    {  2,  1, T("\x01\x08") }, // 1 references
    {  2,  1, T("\x0E\x3E") }, // 1 references
    {  2,  1, T("\x0E\x27") }, // 1 references
    {  2,  1, T("\x0F\x03") }, // 1 references
    {  2,  1, T("\x03\x0D") }, // 1 references
    {  2,  1, T("\x03\x09") }, // 1 references
    {  2,  1, T("\x02\x0C") }, // 1 references
    {  2,  1, T("\x00\x2A") }, // 1 references
    {  2,  1, T("\x00\x25") }, // 2 references
    {  2,  1, T("\x00\x27") }, // 1 references
    {  2,  1, T("\x01\x00") }, // 1 references
    {  2,  1, T("\x01\x03") }, // 1 references
    {  2,  1, T("\x01\x01") }, // 1 references
    {  2,  1, T("\x01\x20") }, // 27 references
    {  2,  1, T("\x00\x18") }, // 1 references
    {  2,  1, T("\x01\x0C") }, // 1 references
    {  2,  1, T("\x00\x0B") }, // 1 references
    {  2,  1, T("\x02\x06") }, // 1 references
    {  2,  1, T("\x02\x02") }, // 2 references
    {  2,  1, T("\x01\x10") }, // 31 references
    {  2,  1, T("\x00\x30") }, // 16 references
    {  2,  1, T("\x03\x10") }, // 7 references
    {  3,  1, T("\x03\x36\x20") }, // 32 references
    {  3,  1, T("\x03\x37\x20") }, // 8 references
    {  3,  1, T("\x0B\x23\x10") }, // 16 references
    {  3,  1, T("\x0B\x20\x30") }, // 16 references
    {  3,  1, T("\x0B\x21\x10") }, // 32 references
    {  3,  1, T("\x0B\x21\x30") }, // 16 references
    {  3,  1, T("\x00\x00\x08") }, // 84 references
    {  3,  1, T("\x00\x00\x01") }, // 270 references
    {  3,  1, T("\x00\x03\x0A") }, // 2 references
    {  3,  1, T("\x00\x00\x0F") }, // 4 references
    {  3,  1, T("\x00\x02\x3A") }, // 2 references
    {  3,  1, T("\x00\x02\x3E") }, // 2 references
    {  3,  1, T("\x00\x02\x2C") }, // 2 references
    {  3,  1, T("\x00\x02\x10") }, // 2 references
    {  3,  1, T("\x00\x00\x09") }, // 1 references
    {  3,  1, T("\x00\x02\x00") }, // 2 references
    {  3,  1, T("\x00\x02\x06") }, // 2 references
    {  3,  1, T("\x00\x01\x3C") }, // 1 references
    {  3,  1, T("\x00\x00\x10") }, // 16 references
    {  3,  1, T("\x00\x00\x07") }, // 5 references
    {  3,  1, T("\x00\x01\x26") }, // 4 references
    {  3,  1, T("\x00\x01\x2A") }, // 4 references
    {  3,  1, T("\x00\x01\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x1A") }, // 4 references
    {  3,  1, T("\x00\x00\x1E") }, // 2 references
    {  3,  1, T("\x00\x00\x26") }, // 4 references
    {  3,  1, T("\x00\x00\x2A") }, // 4 references
    {  3,  1, T("\x00\x00\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x30") }, // 16 references
    {  3,  1, T("\x00\x01\x10") }, // 16 references
    {  3,  1, T("\x00\x01\x30") }, // 15 references
    {  3,  1, T("\x03\x04\x1E") }, // 1 references
    {  3,  1, T("\x00\x00\x03") }, // 4 references
    {  3,  1, T("\x0B\x28\x04") }, // 1 references
    {  3,  1, T("\x00\x33\x20") }, // 1 references
    {  3,  1, T("\x00\x01\x20") }, // 26 references
    {  4,  1, T("\x00\x00\x00\x28") }, // 16 references
    {  4,  1, T("\x00\x00\x00\x38") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x18") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x28") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x00") }, // 51 references
    {  4,  1, T("\x00\x00\x01\x20") } // 32 references
};

// utf/tr_toupper.txt
//
// 1240 code points.
// 54 states, 90 columns, 1949 bytes
//
const unsigned char tr_toupper_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   0,

       2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,  16,  17,
      18,  19,  20,  21,  22,  23,  24,  25,   26,  27,  28,  29,  30,  31,  32,  33,
      34,  35,  36,  37,  38,  39,  40,  41,   42,  43,  44,  45,  46,  47,  48,  49,
      50,  51,  52,  53,  54,  55,  56,  57,   58,  59,  60,  61,  62,  63,  64,  65,
       0,   0,  66,  67,  68,  69,  70,  71,   72,  73,  74,   0,   0,  75,  76,  77,
      78,  79,  80,  81,  82,  83,  84,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,  85,  86,   0,   0,   0,   0,   0,    0,   0,  87,   0,   0,   0,   0,  88,
      89,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_toupper_sot[54] =
{
        0,   30,   36,   48,  116,  187,  260,  325,   389,  455,  483,  501,  513,  574,  580,  621,
      683,  750,  802,  810,  816,  837,  843,  853,   921,  985, 1003, 1039, 1064, 1086, 1105, 1115,
     1121, 1151, 1157, 1188, 1238, 1253, 1269, 1319,  1351, 1385, 1447, 1497, 1507, 1519, 1525, 1531,
     1538, 1549, 1559, 1567, 1573, 1579
};

const unsigned char tr_toupper_sbt[1585] =
{
     254,  54,  76,  64,  54, 232,   1,   2,    3,   4,   5,   6,   7,   8,   9,  10,
      11,  12,  13,  14,  15,  16,  17,  18,   19,  20,  29,  37,  45,  47,  55,  54,
     255,  77,  34,  54,  34,  54,  23,  78,  255,  54,   7,  78, 255,  79,  24,  54,
       3,  54, 201,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  55,  54,  80,  54,  80,   54,  80,   2,  54, 251,  81,  54,  82,
      54,  81,  25,  54,   2,  54, 247,  83,   54,  81,  54,  82,  54,  81,  54,  84,
       2,  54, 211,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
       2,  54, 250,  81,  54,  82,  54,  81,   56,  24,  54,   2,  54, 255,  85,   2,
      54, 253,  80,  54,  80,   2,  54, 255,   84,   3,  54, 255,  82,   5,  54, 255,
      81,   2,  54, 255,  86,   3,  54, 254,   80,  87,   3,  54, 255,  88,   2,  54,
     251,  80,  54,  80,  54,  80,   2,  54,  255,  84,   4,  54, 255,  80,   2,  54,
     255,  89,   3,  54, 253,  82,  54,  81,    2,  54, 255,  80,   3,  54, 253,  80,
      54,  90,  24,  54,   7,  54, 213,  80,   91,  54,  84,  92,  54,  80,  93,  54,
      81,  54,  89,  54,  81,  54,  82,  54,   81,  54,  84,  54,  81,  54,  82,  94,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,   2,  54, 252,  81,  91,  54,   80,   3,  54, 249,  80,  54,  80,  54,
      80,  54,  80,  24,  54,   3,  54, 225,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,   3,   54, 239,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,   8,  54, 255,  82,   2,
      54, 255,  57,  24,  54,   2,  54, 253,   58,  54,  81,   4,  54, 244,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  59,   60,  61,   2,  95, 248,  54,  96,  97,
      54,  98,  54,  99,  62,   3,  54, 248,  100,  63,  54, 101,  54,  64,  65,  54,
       2, 102, 253,  54,  66,  67,   2,  54,  252, 100,  54,  68, 103,   2,  54, 255,
     104,   7,  54, 255,  69,  26,  54,   2,   54, 255, 105,   2,  54, 255, 106,   3,
      54, 250,  70, 105, 107, 108, 109, 110,    5,  54, 255, 111,  10,  54, 254,  71,
      72,  57,  54,  51,  54, 253,  80,  54,   80,   3,  54, 255,  80,   3,  54, 255,
     112,   2, 113,  26,  54,  46,  54, 251,  114, 115, 116, 115,  54,  15,  78,  24,
      54,   2,  54,   2, 117, 255, 118,   9,  117, 250, 119, 120, 121,  54, 122, 123,
       3,  54, 223, 124, 125, 126,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80, 127, 128,
     129, 130,  54, 117,   2,  54, 255,  84,    2,  54, 255,  80,  28,  54,  50,  54,
      16,  78,  24,  54,   2,  54,  16, 117,   16, 128, 224,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  24,  54,   3,  54, 255,
      80,   9,  54, 203,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  24,  54,   4,  54, 194,  81,  54,
      82,  54,  81,  54,  84,  54,  81,  54,   82,  54,  81,  84,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  24,  54,   3,  54,
     209,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      40,  54,  35,  54,  15, 128,  16, 131,   24,  54,   2,  54,   7, 132,  81,  54,
      17,  54, 255,  21,  37,  54, 255,  22,    2,  54,   2,  23, 250,  24,  23,  25,
      26,  27,  28,  24,  54,  58,  54,   6,  133,  26,  54,  59,  54, 255, 134,   3,
      54, 255, 135,  26,  54,   3,  54, 193,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  24,   54,   3,  54, 235, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,   5,  54, 255, 137,   5,  54, 225,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  24,   54,   2,  54,   8, 133,   8,  54,   6,
     133,  10,  54,   8, 133,   8,  54,   8,  133,  32,  54,   2,  54,   6, 133,  11,
      54, 249, 133,  54, 133,  54, 133,  54,  133,   8,  54,   8, 133,   8,  54,   2,
     138,   2, 139,   2, 140,   2, 141,   2,  142,   2, 143,   2, 144,  26,  54,   2,
      54,   8, 133,   8,  54,   8, 133,   8,   54,   8, 133,   8,  54,   2, 133, 254,
      54, 145,  10,  54, 255,  73,  25,  54,    5,  54, 255, 145,  12,  54,   2, 133,
      14,  54,   2, 133,   3,  54, 255, 146,   13,  54, 255, 145,  36,  54,   7,  54,
     254,  30,  31,  12,  54, 255,  32,  28,   54, 251,  33,  34,  23,  35,  36,  35,
      54,  16,  54, 255, 147,  33,  54,  16,  148,  24,  54,   6,  54, 255, 149,  83,
      54,  18,  54,   2, 150,   2, 151,   2,  152,   2, 151,   2, 150,   2, 153,   2,
     154,   2, 153,   2, 155,   2, 156,   2,  157,   2, 156,   2, 155,  46,  54,  50,
      54,  16, 158,  24,  54,   2,  54,  16,  159,  15, 160,   2,  54, 255, 136,   3,
      54, 248,  74,  75,  54, 145,  54, 161,   54, 149,   6,  54, 255, 136,   2,  54,
     255, 161,  33,  54,   3,  54, 221, 136,   54, 136,  54, 136,  54, 136,  54, 136,
      54, 136,  54, 136,  54, 136,  54, 136,   54, 136,  54, 136,  54, 136,  54, 136,
      54, 136,  54, 136,  54, 136,  54, 136,   54, 136,   8,  54, 253, 149,  54, 161,
       4,  54, 255, 136,  36,  54,   2,  54,   32, 162,   6, 163, 254,  54, 163,   5,
      54, 255, 163,  42,  54,  27,  54, 250,   38,  39,  54,  40,  41,  42,  14,  54,
     254,  43,  44,  41,  54,   3,  54, 211,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  42,  54,   3,   54, 229, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  60,  54,  37,   54, 243, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,   3,   54, 243, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  24,   54,   3,  54, 209, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  10,  54, 253, 161,  54,
     149,   2,  54, 255, 136,  24,  54,   3,   54, 249, 136,  54, 136,  54, 136,  54,
     136,   4,  54, 255, 149,   4,  54, 253,  136,  54, 136,   3,  54, 237, 136,  54,
     136,  54, 136,  54, 136,  54, 136,  54,  136,  54, 136,  54, 136,  54, 136,  54,
     136,  11,  54, 253, 136,  54, 136,  32,   54,  21,  54, 255, 164,  28,  54,  16,
     165,  24,  54,   2,  54,  16, 166,  16,  167,  16, 168,  16, 167,  24,  54,  63,
      54, 255,  46,  26,  54,   3,  54,  26,  169,  61,  54,  18,  54, 254,  48,  52,
      70,  54,  18,  54, 254,  49,  50,  33,   54, 255,  51,  36,  54,  42,  54,   8,
     170,   8, 171,   8, 170,  24,  54,   2,   54,   8, 172,   8, 173,  72,  54,   2,
      54,  51, 174,  37,  54,  37,  54, 255,   53,  52,  54,   2,  54,  32, 175,  56,
      54
};

const string_desc tr_toupper_ott[121] =
{
    {  1,  1, T("\x49") }, // 1 references
    {  1,  1, T("\x53") }, // 1 references
    {  3,  1, T("\xE2\xB1\xBE") }, // 1 references
    {  3,  1, T("\xE2\xB1\xBF") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAF") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAD") }, // 1 references
    {  3,  1, T("\xE2\xB1\xB0") }, // 1 references
    {  3,  1, T("\xEA\x9E\xAB") }, // 1 references
    {  3,  1, T("\xEA\x9E\xAC") }, // 1 references
    {  3,  1, T("\xEA\x9E\x8D") }, // 1 references
    {  3,  1, T("\xEA\x9E\xAA") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA2") }, // 1 references
    {  3,  1, T("\xEA\x9E\xAD") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAE") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA4") }, // 1 references
    {  3,  1, T("\xEA\x9E\xB1") }, // 1 references
    {  3,  1, T("\xEA\x9E\xB2") }, // 1 references
    {  3,  1, T("\xEA\x9E\xB0") }, // 1 references
    {  2,  1, T("\xCE\x99") }, // 1 references
    {  2,  1, T("\xC8\xBA") }, // 1 references
    {  2,  1, T("\xC8\xBE") }, // 1 references
    {  1,  1, T("\x20") }, // 26 references
    {  2,  1, T("\x0C\x29") }, // 1 references
    {  2,  1, T("\x00\x20") }, // 61 references
    {  2,  1, T("\x06\x07") }, // 1 references
    {  2,  1, T("\x00\x01") }, // 213 references
    {  2,  1, T("\x00\x03") }, // 18 references
    {  2,  1, T("\x00\x07") }, // 10 references
    {  2,  1, T("\x01\x3F") }, // 1 references
    {  2,  1, T("\x00\x0F") }, // 8 references
    {  2,  1, T("\x0F\x03") }, // 1 references
    {  2,  1, T("\x01\x23") }, // 1 references
    {  2,  1, T("\x0E\x27") }, // 1 references
    {  2,  1, T("\x0E\x3E") }, // 1 references
    {  2,  1, T("\x00\x1F") }, // 2 references
    {  2,  1, T("\x01\x08") }, // 1 references
    {  2,  1, T("\x00\x02") }, // 2 references
    {  2,  1, T("\x00\x0E") }, // 1 references
    {  2,  1, T("\x00\x06") }, // 1 references
    {  2,  1, T("\x01\x13") }, // 1 references
    {  2,  1, T("\x0F\x12") }, // 2 references
    {  2,  1, T("\x0F\x1F") }, // 1 references
    {  2,  1, T("\x0F\x1D") }, // 1 references
    {  2,  1, T("\x0F\x16") }, // 1 references
    {  2,  1, T("\x0F\x0B") }, // 1 references
    {  2,  1, T("\x0F\x33") }, // 2 references
    {  2,  1, T("\x0F\x37") }, // 1 references
    {  2,  1, T("\x0F\x3F") }, // 2 references
    {  2,  1, T("\x0F\x2F") }, // 1 references
    {  2,  1, T("\x0F\x2A") }, // 1 references
    {  2,  1, T("\x0C\x26") }, // 2 references
    {  2,  1, T("\x0C\x2A") }, // 1 references
    {  2,  1, T("\x03\x0D") }, // 1 references
    {  2,  1, T("\x0C\x3B") }, // 1 references
    {  2,  1, T("\x0C\x39") }, // 1 references
    {  2,  1, T("\x03\x09") }, // 1 references
    {  2,  1, T("\x0C\x25") }, // 1 references
    {  2,  1, T("\x02\x06") }, // 1 references
    {  2,  1, T("\x02\x02") }, // 2 references
    {  2,  1, T("\x00\x2A") }, // 1 references
    {  2,  1, T("\x00\x25") }, // 2 references
    {  2,  1, T("\x00\x27") }, // 1 references
    {  2,  1, T("\x01\x20") }, // 28 references
    {  2,  1, T("\x01\x21") }, // 1 references
    {  2,  1, T("\x01\x00") }, // 1 references
    {  2,  1, T("\x01\x03") }, // 1 references
    {  2,  1, T("\x01\x01") }, // 1 references
    {  2,  1, T("\x01\x02") }, // 1 references
    {  2,  1, T("\x01\x09") }, // 1 references
    {  2,  1, T("\x01\x33") }, // 1 references
    {  2,  1, T("\x01\x36") }, // 1 references
    {  2,  1, T("\x00\x18") }, // 1 references
    {  2,  1, T("\x01\x2A") }, // 1 references
    {  2,  1, T("\x01\x10") }, // 32 references
    {  2,  1, T("\x00\x0B") }, // 1 references
    {  2,  1, T("\x02\x0C") }, // 1 references
    {  2,  1, T("\x00\x30") }, // 16 references
    {  2,  1, T("\x03\x10") }, // 7 references
    {  3,  1, T("\x00\x00\x08") }, // 84 references
    {  3,  1, T("\x0B\x28\x04") }, // 1 references
    {  3,  1, T("\x03\x04\x1E") }, // 1 references
    {  3,  1, T("\x00\x00\x01") }, // 270 references
    {  3,  1, T("\x00\x03\x3B") }, // 1 references
    {  3,  1, T("\x00\x03\x0A") }, // 2 references
    {  3,  1, T("\x00\x02\x3A") }, // 2 references
    {  3,  1, T("\x00\x02\x3E") }, // 2 references
    {  3,  1, T("\x00\x02\x2C") }, // 2 references
    {  3,  1, T("\x00\x02\x00") }, // 2 references
    {  3,  1, T("\x00\x02\x10") }, // 2 references
    {  3,  1, T("\x00\x02\x06") }, // 2 references
    {  3,  1, T("\x00\x00\x0F") }, // 4 references
    {  3,  1, T("\x00\x00\x09") }, // 1 references
    {  3,  1, T("\x00\x01\x3C") }, // 1 references
    {  3,  1, T("\x00\x00\x10") }, // 16 references
    {  3,  1, T("\x00\x00\x07") }, // 5 references
    {  3,  1, T("\x00\x01\x26") }, // 4 references
    {  3,  1, T("\x00\x01\x2A") }, // 4 references
    {  3,  1, T("\x00\x01\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x1A") }, // 4 references
    {  3,  1, T("\x00\x00\x1E") }, // 2 references
    {  3,  1, T("\x00\x00\x26") }, // 4 references
    {  3,  1, T("\x00\x00\x2A") }, // 4 references
    {  3,  1, T("\x00\x00\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x30") }, // 16 references
    {  3,  1, T("\x00\x01\x10") }, // 16 references
    {  3,  1, T("\x00\x01\x30") }, // 15 references
    {  3,  1, T("\x00\x00\x03") }, // 4 references
    {  3,  1, T("\x03\x36\x20") }, // 32 references
    {  3,  1, T("\x03\x37\x20") }, // 8 references
    {  3,  1, T("\x00\x33\x20") }, // 1 references
    {  3,  1, T("\x0B\x23\x10") }, // 16 references
    {  3,  1, T("\x0B\x20\x30") }, // 16 references
    {  3,  1, T("\x0B\x21\x10") }, // 32 references
    {  3,  1, T("\x0B\x21\x30") }, // 16 references
    {  3,  1, T("\x00\x01\x20") }, // 26 references
    {  4,  1, T("\x00\x00\x00\x28") }, // 16 references
    {  4,  1, T("\x00\x00\x00\x38") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x18") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x28") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x00") }, // 51 references
    {  4,  1, T("\x00\x00\x01\x20") } // 32 references
};

// utf/tr_totitle.txt
//
// 1244 code points.
// 54 states, 90 columns, 1950 bytes
//
const unsigned char tr_totitle_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   0,

       2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,  16,  17,
      18,  19,  20,  21,  22,  23,  24,  25,   26,  27,  28,  29,  30,  31,  32,  33,
      34,  35,  36,  37,  38,  39,  40,  41,   42,  43,  44,  45,  46,  47,  48,  49,
      50,  51,  52,  53,  54,  55,  56,  57,   58,  59,  60,  61,  62,  63,  64,  65,
       0,   0,  66,  67,  68,  69,  70,  71,   72,  73,  74,   0,   0,  75,  76,  77,
      78,  79,  80,  81,  82,  83,  84,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,  85,  86,   0,   0,   0,   0,   0,    0,   0,  87,   0,   0,   0,   0,  88,
      89,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_totitle_sot[54] =
{
        0,   30,   36,   48,  116,  187,  260,  326,   390,  456,  484,  502,  514,  575,  581,  622,
      684,  751,  803,  811,  817,  838,  844,  854,   922,  986, 1004, 1040, 1065, 1087, 1106, 1116,
     1122, 1152, 1158, 1189, 1239, 1254, 1270, 1320,  1352, 1386, 1448, 1498, 1508, 1520, 1526, 1532,
     1539, 1550, 1560, 1568, 1574, 1580
};

const unsigned char tr_totitle_sbt[1586] =
{
     254,  54,  76,  64,  54, 232,   1,   2,    3,   4,   5,   6,   7,   8,   9,  10,
      11,  12,  13,  14,  15,  16,  17,  18,   19,  20,  29,  37,  45,  47,  55,  54,
     255,  77,  34,  54,  34,  54,  23,  78,  255,  54,   7,  78, 255,  79,  24,  54,
       3,  54, 201,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  55,  54,  80,  54,  80,   54,  80,   2,  54, 251,  81,  54,  82,
      54,  81,  25,  54,   2,  54, 247,  83,   54,  81,  54,  82,  54,  81,  54,  84,
       2,  54, 211,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
       2,  54, 250,  81,  54,  82,  54,  81,   56,  24,  54,   2,  54, 255,  85,   2,
      54, 253,  80,  54,  80,   2,  54, 255,   84,   3,  54, 255,  82,   5,  54, 255,
      81,   2,  54, 255,  86,   3,  54, 254,   80,  87,   3,  54, 255,  88,   2,  54,
     251,  80,  54,  80,  54,  80,   2,  54,  255,  84,   4,  54, 255,  80,   2,  54,
     255,  89,   3,  54, 253,  82,  54,  81,    2,  54, 255,  80,   3,  54, 253,  80,
      54,  90,  24,  54,   6,  54, 251,  80,   91,  81,  84,  91,   2,  80, 213,  91,
      82,  54,  81,  54,  89,  54,  81,  54,   82,  54,  81,  54,  84,  54,  81,  54,
      82,  92,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  81,  91,  80,   54,  80,   3,  54, 249,  80,  54,  80,
      54,  80,  54,  80,  24,  54,   3,  54,  225,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,    3,  54, 239,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,   8,  54, 255,  82,
       2,  54, 255,  57,  24,  54,   2,  54,  253,  58,  54,  81,   4,  54, 244,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   59,  60,  61,   2,  93, 248,  54,  94,
      95,  54,  96,  54,  97,  62,   3,  54,  248,  98,  63,  54,  99,  54,  64,  65,
      54,   2, 100, 253,  54,  66,  67,   2,   54, 252,  98,  54,  68, 101,   2,  54,
     255, 102,   7,  54, 255,  69,  26,  54,    2,  54, 255, 103,   2,  54, 255, 104,
       3,  54, 250,  70, 103, 105, 106, 107,  108,   5,  54, 255, 109,  10,  54, 254,
      71,  72,  57,  54,  51,  54, 253,  80,   54,  80,   3,  54, 255,  80,   3,  54,
     255, 110,   2, 111,  26,  54,  46,  54,  251, 112, 113, 114, 113,  54,  15,  78,
      24,  54,   2,  54,   2, 115, 255, 116,    9, 115, 250, 117, 118, 119,  54, 120,
     121,   3,  54, 223, 122, 123, 124,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80, 125,
     126, 127, 128,  54, 115,   2,  54, 255,   84,   2,  54, 255,  80,  28,  54,  50,
      54,  16,  78,  24,  54,   2,  54,  16,  115,  16, 126, 224,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  24,  54,   3,  54,
     255,  80,   9,  54, 203,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  54,  80,  54,  80,  54,  80,
      54,  80,  54,  80,  54,  80,  54,  80,   54,  80,  24,  54,   4,  54, 194,  81,
      54,  82,  54,  81,  54,  84,  54,  81,   54,  82,  54,  81,  84,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  24,  54,   3,
      54, 209,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  54,  80,  54,  80,  54,  80,  54,   80,  54,  80,  54,  80,  54,  80,  54,
      80,  40,  54,  35,  54,  15, 126,  16,  129,  24,  54,   2,  54,   7, 130,  81,
      54,  17,  54, 255,  21,  37,  54, 255,   22,   2,  54,   2,  23, 250,  24,  23,
      25,  26,  27,  28,  24,  54,  58,  54,    6, 131,  26,  54,  59,  54, 255, 132,
       3,  54, 255, 133,  26,  54,   3,  54,  193, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   24,  54,   3,  54, 235, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,   5,  54, 255, 135,   5,  54,  225, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   24,  54,   2,  54,   8, 131,   8,  54,
       6, 131,  10,  54,   8, 131,   8,  54,    8, 131,  32,  54,   2,  54,   6, 131,
      11,  54, 249, 131,  54, 131,  54, 131,   54, 131,   8,  54,   8, 131,   8,  54,
       2, 136,   2, 137,   2, 138,   2, 139,    2, 140,   2, 141,   2, 142,  26,  54,
       2,  54,   8, 131,   8,  54,   8, 131,    8,  54,   8, 131,   8,  54,   2, 131,
     254,  54, 143,  10,  54, 255,  73,  25,   54,   5,  54, 255, 143,  12,  54,   2,
     131,  14,  54,   2, 131,   3,  54, 255,  144,  13,  54, 255, 143,  36,  54,   7,
      54, 254,  30,  31,  12,  54, 255,  32,   28,  54, 251,  33,  34,  23,  35,  36,
      35,  54,  16,  54, 255, 145,  33,  54,   16, 146,  24,  54,   6,  54, 255, 147,
      83,  54,  18,  54,   2, 148,   2, 149,    2, 150,   2, 149,   2, 148,   2, 151,
       2, 152,   2, 151,   2, 153,   2, 154,    2, 155,   2, 154,   2, 153,  46,  54,
      50,  54,  16, 156,  24,  54,   2,  54,   16, 157,  15, 158,   2,  54, 255, 134,
       3,  54, 248,  74,  75,  54, 143,  54,  159,  54, 147,   6,  54, 255, 134,   2,
      54, 255, 159,  33,  54,   3,  54, 221,  134,  54, 134,  54, 134,  54, 134,  54,
     134,  54, 134,  54, 134,  54, 134,  54,  134,  54, 134,  54, 134,  54, 134,  54,
     134,  54, 134,  54, 134,  54, 134,  54,  134,  54, 134,   8,  54, 253, 147,  54,
     159,   4,  54, 255, 134,  36,  54,   2,   54,  32, 160,   6, 161, 254,  54, 161,
       5,  54, 255, 161,  42,  54,  27,  54,  250,  38,  39,  54,  40,  41,  42,  14,
      54, 254,  43,  44,  41,  54,   3,  54,  211, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  42,  54,    3,  54, 229, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  60,  54,   37,  54, 243, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,    3,  54, 243, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   24,  54,   3,  54, 209, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  10,  54, 253, 159,
      54, 147,   2,  54, 255, 134,  24,  54,    3,  54, 249, 134,  54, 134,  54, 134,
      54, 134,   4,  54, 255, 147,   4,  54,  253, 134,  54, 134,   3,  54, 237, 134,
      54, 134,  54, 134,  54, 134,  54, 134,   54, 134,  54, 134,  54, 134,  54, 134,
      54, 134,  11,  54, 253, 134,  54, 134,   32,  54,  21,  54, 255, 162,  28,  54,
      16, 163,  24,  54,   2,  54,  16, 164,   16, 165,  16, 166,  16, 165,  24,  54,
      63,  54, 255,  46,  26,  54,   3,  54,   26, 167,  61,  54,  18,  54, 254,  48,
      52,  70,  54,  18,  54, 254,  49,  50,   33,  54, 255,  51,  36,  54,  42,  54,
       8, 168,   8, 169,   8, 168,  24,  54,    2,  54,   8, 170,   8, 171,  72,  54,
       2,  54,  51, 172,  37,  54,  37,  54,  255,  53,  52,  54,   2,  54,  32, 173,
      56,  54
};

const string_desc tr_totitle_ott[119] =
{
    {  1,  1, T("\x49") }, // 1 references
    {  1,  1, T("\x53") }, // 1 references
    {  3,  1, T("\xE2\xB1\xBE") }, // 1 references
    {  3,  1, T("\xE2\xB1\xBF") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAF") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAD") }, // 1 references
    {  3,  1, T("\xE2\xB1\xB0") }, // 1 references
    {  3,  1, T("\xEA\x9E\xAB") }, // 1 references
    {  3,  1, T("\xEA\x9E\xAC") }, // 1 references
    {  3,  1, T("\xEA\x9E\x8D") }, // 1 references
    {  3,  1, T("\xEA\x9E\xAA") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA2") }, // 1 references
    {  3,  1, T("\xEA\x9E\xAD") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAE") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA4") }, // 1 references
    {  3,  1, T("\xEA\x9E\xB1") }, // 1 references
    {  3,  1, T("\xEA\x9E\xB2") }, // 1 references
    {  3,  1, T("\xEA\x9E\xB0") }, // 1 references
    {  2,  1, T("\xCE\x99") }, // 1 references
    {  2,  1, T("\xC8\xBA") }, // 1 references
    {  2,  1, T("\xC8\xBE") }, // 1 references
    {  1,  1, T("\x20") }, // 26 references
    {  2,  1, T("\x0C\x29") }, // 1 references
    {  2,  1, T("\x00\x20") }, // 61 references
    {  2,  1, T("\x06\x07") }, // 1 references
    {  2,  1, T("\x00\x01") }, // 215 references
    {  2,  1, T("\x00\x03") }, // 19 references
    {  2,  1, T("\x00\x07") }, // 11 references
    {  2,  1, T("\x01\x3F") }, // 1 references
    {  2,  1, T("\x00\x0F") }, // 8 references
    {  2,  1, T("\x0F\x03") }, // 1 references
    {  2,  1, T("\x01\x23") }, // 1 references
    {  2,  1, T("\x0E\x27") }, // 1 references
    {  2,  1, T("\x0E\x3E") }, // 1 references
    {  2,  1, T("\x00\x1F") }, // 2 references
    {  2,  1, T("\x01\x08") }, // 1 references
    {  2,  1, T("\x00\x00") }, // 4 references
    {  2,  1, T("\x01\x13") }, // 1 references
    {  2,  1, T("\x0F\x12") }, // 2 references
    {  2,  1, T("\x0F\x1F") }, // 1 references
    {  2,  1, T("\x0F\x1D") }, // 1 references
    {  2,  1, T("\x0F\x16") }, // 1 references
    {  2,  1, T("\x0F\x0B") }, // 1 references
    {  2,  1, T("\x0F\x33") }, // 2 references
    {  2,  1, T("\x0F\x37") }, // 1 references
    {  2,  1, T("\x0F\x3F") }, // 2 references
    {  2,  1, T("\x0F\x2F") }, // 1 references
    {  2,  1, T("\x0F\x2A") }, // 1 references
    {  2,  1, T("\x0C\x26") }, // 2 references
    {  2,  1, T("\x0C\x2A") }, // 1 references
    {  2,  1, T("\x03\x0D") }, // 1 references
    {  2,  1, T("\x0C\x3B") }, // 1 references
    {  2,  1, T("\x0C\x39") }, // 1 references
    {  2,  1, T("\x03\x09") }, // 1 references
    {  2,  1, T("\x0C\x25") }, // 1 references
    {  2,  1, T("\x02\x06") }, // 1 references
    {  2,  1, T("\x02\x02") }, // 2 references
    {  2,  1, T("\x00\x2A") }, // 1 references
    {  2,  1, T("\x00\x25") }, // 2 references
    {  2,  1, T("\x00\x27") }, // 1 references
    {  2,  1, T("\x01\x20") }, // 28 references
    {  2,  1, T("\x01\x21") }, // 1 references
    {  2,  1, T("\x01\x00") }, // 1 references
    {  2,  1, T("\x01\x03") }, // 1 references
    {  2,  1, T("\x01\x01") }, // 1 references
    {  2,  1, T("\x01\x02") }, // 1 references
    {  2,  1, T("\x01\x09") }, // 1 references
    {  2,  1, T("\x01\x33") }, // 1 references
    {  2,  1, T("\x01\x36") }, // 1 references
    {  2,  1, T("\x00\x18") }, // 1 references
    {  2,  1, T("\x01\x2A") }, // 1 references
    {  2,  1, T("\x01\x10") }, // 32 references
    {  2,  1, T("\x00\x0B") }, // 1 references
    {  2,  1, T("\x02\x0C") }, // 1 references
    {  2,  1, T("\x00\x30") }, // 16 references
    {  2,  1, T("\x03\x10") }, // 7 references
    {  3,  1, T("\x00\x00\x08") }, // 84 references
    {  3,  1, T("\x0B\x28\x04") }, // 1 references
    {  3,  1, T("\x03\x04\x1E") }, // 1 references
    {  3,  1, T("\x00\x00\x01") }, // 270 references
    {  3,  1, T("\x00\x03\x3B") }, // 1 references
    {  3,  1, T("\x00\x03\x0A") }, // 2 references
    {  3,  1, T("\x00\x02\x3A") }, // 2 references
    {  3,  1, T("\x00\x02\x3E") }, // 2 references
    {  3,  1, T("\x00\x02\x2C") }, // 2 references
    {  3,  1, T("\x00\x02\x00") }, // 2 references
    {  3,  1, T("\x00\x02\x10") }, // 2 references
    {  3,  1, T("\x00\x02\x06") }, // 2 references
    {  3,  1, T("\x00\x00\x0F") }, // 4 references
    {  3,  1, T("\x00\x00\x09") }, // 1 references
    {  3,  1, T("\x00\x01\x3C") }, // 1 references
    {  3,  1, T("\x00\x00\x10") }, // 16 references
    {  3,  1, T("\x00\x00\x07") }, // 5 references
    {  3,  1, T("\x00\x01\x26") }, // 4 references
    {  3,  1, T("\x00\x01\x2A") }, // 4 references
    {  3,  1, T("\x00\x01\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x1A") }, // 4 references
    {  3,  1, T("\x00\x00\x1E") }, // 2 references
    {  3,  1, T("\x00\x00\x26") }, // 4 references
    {  3,  1, T("\x00\x00\x2A") }, // 4 references
    {  3,  1, T("\x00\x00\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x30") }, // 16 references
    {  3,  1, T("\x00\x01\x10") }, // 16 references
    {  3,  1, T("\x00\x01\x30") }, // 15 references
    {  3,  1, T("\x00\x00\x03") }, // 4 references
    {  3,  1, T("\x03\x36\x20") }, // 32 references
    {  3,  1, T("\x03\x37\x20") }, // 8 references
    {  3,  1, T("\x00\x33\x20") }, // 1 references
    {  3,  1, T("\x0B\x23\x10") }, // 16 references
    {  3,  1, T("\x0B\x20\x30") }, // 16 references
    {  3,  1, T("\x0B\x21\x10") }, // 32 references
    {  3,  1, T("\x0B\x21\x30") }, // 16 references
    {  3,  1, T("\x00\x01\x20") }, // 26 references
    {  4,  1, T("\x00\x00\x00\x28") }, // 16 references
    {  4,  1, T("\x00\x00\x00\x38") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x18") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x28") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x00") }, // 51 references
    {  4,  1, T("\x00\x00\x01\x20") } // 32 references
};

// utf/tr_foldmatch.txt
//
// 14 code points.
// 7 states, 11 columns, 310 bytes
//
const unsigned char tr_foldmatch_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   1,   0,   0,   0,   0,   1,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       2,   0,   3,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    4,   4,   4,   4,   5,   6,   6,   6,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   7,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   8,   9,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,  10,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char tr_foldmatch_sot[7] =
{
        0,    9,   15,   23,   29,   35,   41
};

const unsigned char tr_foldmatch_sbt[47] =
{
     254,   7,  10,   6,   7, 253,   1,   3,    5,   2,   7, 255,   2,   8,   7,   4,
       7, 255,   8,   2,   9,   4,   7,   2,    7, 255,   4,   8,   7,   6,   7, 255,
       9,   4,   7,   7,   7, 255,   6,   3,    7,   3,   7, 255,   9,   7,   7
};

const string_desc tr_foldmatch_ott[3] =
{
    {  1,  1, T("\x27") }, // 4 references
    {  1,  1, T("\x22") }, // 8 references
    {  1,  1, T("\x00") } // 2 references
};

// utf/tr_Color.txt
//
// 2053 code points.
// 37 states, 67 columns, 4820 bytes
//
const unsigned char tr_color_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       1,   2,   3,   4,   5,   6,   7,   8,    9,  10,  11,  12,  13,  14,  15,  16,
      17,  18,  19,  20,  21,  22,  23,  24,   25,  26,  27,  28,  29,  30,  31,  32,
      33,  34,  35,  36,  37,  38,  39,  40,   41,  42,  43,  44,  45,  46,  47,  48,
      49,  50,  51,  52,  53,  54,  55,  56,   57,  58,  59,  60,  61,  62,  63,  64,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,  65,
       0,   0,   0,  66,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_color_sot[37] =
{
        0,    5,   22,   35,  103,  171,  239,  307,   375,  443,  511,  579,  585,  613,  681,  749,
      817,  885,  953, 1021, 1089, 1157, 1225, 1293,  1361, 1429, 1497, 1565, 1633, 1701, 1769, 1837,
     1905, 1973, 2041, 2109, 2177
};

const unsigned short tr_color_sbt[2245] =
{
      65,  37, 254,   1,  11,  21,  37, 255,    2,   3,  37, 248,   3,   4,   5,   6,
       7,   8,   9,  10,  34,  37, 253,  37,   38,  39,   2,  37, 252,  40,  41,  37,
      42,  58,  37, 191,  37,  43,  44,  45,   46,  47,  48,  49,  50,  51,  52,  53,
      54,  55,  56,  57,  58,  59,  60,  61,   62,  63,  64,  65,  66,  67,  68,  69,
      70,  71,  72,  73,  74,  75,  76,  77,   78,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,  90,  91,  92,  93,   94,  95,  96,  97,  98,  99, 100, 101,
     102, 103, 104, 105, 106,   2,  37, 191,   37, 107, 108, 109, 110, 111, 112, 113,
     114, 115, 116, 117, 118, 119, 120, 121,  122, 123, 124, 125, 126, 127, 128, 129,
     130, 131, 132, 133, 134, 135, 136, 137,  138, 139, 140, 141, 142, 143, 144, 145,
     146, 147, 148, 149, 150, 151, 152, 153,  154, 155, 156, 157, 158, 159, 160, 161,
     162, 163, 164, 165, 166, 167, 168, 169,  170,   2,  37, 191,  37, 171, 172, 173,
     174, 175, 176, 177, 178, 179, 180, 181,  182, 183, 184, 185, 186, 187, 188, 189,
     190, 191, 192, 193, 194, 195, 196, 197,  198, 199, 200, 201, 202, 203, 204, 205,
     206, 207, 208, 209, 210, 211, 212, 213,  214, 215, 216, 217, 218, 219, 220, 221,
     222, 223, 224, 225, 226, 227, 228, 229,  230, 231, 232, 233, 234,   2,  37, 191,
      37, 235, 236, 237, 238, 239, 240, 241,  242, 243, 244, 245, 246, 247, 248, 249,
     250, 251, 252, 253, 254, 255, 256, 257,  258, 259, 260, 261, 262, 263, 264, 265,
     266, 267, 268, 269, 270, 271, 272, 273,  274, 275, 276, 277, 278, 279, 280, 281,
     282, 283, 284, 285, 286, 287, 288, 289,  290, 291, 292, 293, 294, 295, 296, 297,
     298,   2,  37, 191,  37, 299, 300, 301,  302, 303, 304, 305, 306, 307, 308, 309,
     310, 311, 312, 313, 314, 315, 316, 317,  318, 319, 320, 321, 322, 323, 324, 325,
     326, 327, 328, 329, 330, 331, 332, 333,  334, 335, 336, 337, 338, 339, 340, 341,
     342, 343, 344, 345, 346, 347, 348, 349,  350, 351, 352, 353, 354, 355, 356, 357,
     358, 359, 360, 361, 362,   2,  37, 191,   37, 363, 364, 365, 366, 367, 368, 369,
     370, 371, 372, 373, 374, 375, 376, 377,  378, 379, 380, 381, 382, 383, 384, 385,
     386, 387, 388, 389, 390, 391, 392, 393,  394, 395, 396, 397, 398, 399, 400, 401,
     402, 403, 404, 405, 406, 407, 408, 409,  410, 411, 412, 413, 414, 415, 416, 417,
     418, 419, 420, 421, 422, 423, 424, 425,  426,   2,  37, 191,  37, 427, 428, 429,
     430, 431, 432, 433, 434, 435, 436, 437,  438, 439, 440, 441, 442, 443, 444, 445,
     446, 447, 448, 449, 450, 451, 452, 453,  454, 455, 456, 457, 458, 459, 460, 461,
     462, 463, 464, 465, 466, 467, 468, 469,  470, 471, 472, 473, 474, 475, 476, 477,
     478, 479, 480, 481, 482, 483, 484, 485,  486, 487, 488, 489, 490,   2,  37, 191,
      37, 491, 492, 493, 494, 495, 496, 497,  498, 499, 500, 501, 502, 503, 504, 505,
     506, 507, 508, 509, 510, 511, 512, 513,  514, 515, 516, 517, 518, 519, 520, 521,
     522, 523, 524, 525, 526, 527, 528, 529,  530, 531, 532, 533, 534, 535, 536, 537,
     538, 539, 540, 541, 542, 543, 544, 545,  546, 547, 548, 549, 550, 551, 552, 553,
     554,   2,  37,  49,  37, 255,  12,  17,   37, 231,  37,  13,  14,  15,  16,  17,
      18,  19,  20,  21,  22,  23,  24,  25,   26,  27,  28,  29,  30,  31,  32,  33,
      34,  35,  36,  42,  37, 191,  37, 555,  556, 557, 558, 559, 560, 561, 562, 563,
     564, 565, 566, 567, 568, 569, 570, 571,  572, 573, 574, 575, 576, 577, 578, 579,
     580, 581, 582, 583, 584, 585, 586, 587,  588, 589, 590, 591, 592, 593, 594, 595,
     596, 597, 598, 599, 600, 601, 602, 603,  604, 605, 606, 607, 608, 609, 610, 611,
     612, 613, 614, 615, 616, 617, 618,   2,   37, 191,  37, 619, 620, 621, 622, 623,
     624, 625, 626, 627, 628, 629, 630, 631,  632, 633, 634, 635, 636, 637, 638, 639,
     640, 641, 642, 643, 644, 645, 646, 647,  648, 649, 650, 651, 652, 653, 654, 655,
     656, 657, 658, 659, 660, 661, 662, 663,  664, 665, 666, 667, 668, 669, 670, 671,
     672, 673, 674, 675, 676, 677, 678, 679,  680, 681, 682,   2,  37, 191,  37, 683,
     684, 685, 686, 687, 688, 689, 690, 691,  692, 693, 694, 695, 696, 697, 698, 699,
     700, 701, 702, 703, 704, 705, 706, 707,  708, 709, 710, 711, 712, 713, 714, 715,
     716, 717, 718, 719, 720, 721, 722, 723,  724, 725, 726, 727, 728, 729, 730, 731,
     732, 733, 734, 735, 736, 737, 738, 739,  740, 741, 742, 743, 744, 745, 746,   2,
      37, 191,  37, 747, 748, 749, 750, 751,  752, 753, 754, 755, 756, 757, 758, 759,
     760, 761, 762, 763, 764, 765, 766, 767,  768, 769, 770, 771, 772, 773, 774, 775,
     776, 777, 778, 779, 780, 781, 782, 783,  784, 785, 786, 787, 788, 789, 790, 791,
     792, 793, 794, 795, 796, 797, 798, 799,  800, 801, 802, 803, 804, 805, 806, 807,
     808, 809, 810,   2,  37, 191,  37, 811,  812, 813, 814, 815, 816, 817, 818, 819,
     820, 821, 822, 823, 824, 825, 826, 827,  828, 829, 830, 831, 832, 833, 834, 835,
     836, 837, 838, 839, 840, 841, 842, 843,  844, 845, 846, 847, 848, 849, 850, 851,
     852, 853, 854, 855, 856, 857, 858, 859,  860, 861, 862, 863, 864, 865, 866, 867,
     868, 869, 870, 871, 872, 873, 874,   2,   37, 191,  37, 875, 876, 877, 878, 879,
     880, 881, 882, 883, 884, 885, 886, 887,  888, 889, 890, 891, 892, 893, 894, 895,
     896, 897, 898, 899, 900, 901, 902, 903,  904, 905, 906, 907, 908, 909, 910, 911,
     912, 913, 914, 915, 916, 917, 918, 919,  920, 921, 922, 923, 924, 925, 926, 927,
     928, 929, 930, 931, 932, 933, 934, 935,  936, 937, 938,   2,  37, 191,  37, 939,
     940, 941, 942, 943, 944, 945, 946, 947,  948, 949, 950, 951, 952, 953, 954, 955,
     956, 957, 958, 959, 960, 961, 962, 963,  964, 965, 966, 967, 968, 969, 970, 971,
     972, 973, 974, 975, 976, 977, 978, 979,  980, 981, 982, 983, 984, 985, 986, 987,
     988, 989, 990, 991, 992, 993, 994, 995,  996, 997, 998, 999, 1000, 1001, 1002,   2,
      37, 191,  37, 1003, 1004, 1005, 1006, 1007,  1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015,
     1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023,  1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031,
     1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039,  1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047,
     1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,  1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063,
     1064, 1065, 1066,   2,  37, 191,  37, 1067,  1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075,
     1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083,  1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091,
     1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099,  1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107,
     1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115,  1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123,
     1124, 1125, 1126, 1127, 1128, 1129, 1130,   2,   37, 191,  37, 1131, 1132, 1133, 1134, 1135,
     1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143,  1144, 1145, 1146, 1147, 1148, 1149, 1150, 1151,
     1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159,  1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167,
     1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175,  1176, 1177, 1178, 1179, 1180, 1181, 1182, 1183,
     1184, 1185, 1186, 1187, 1188, 1189, 1190, 1191,  1192, 1193, 1194,   2,  37, 191,  37, 1195,
     1196, 1197, 1198, 1199, 1200, 1201, 1202, 1203,  1204, 1205, 1206, 1207, 1208, 1209, 1210, 1211,
     1212, 1213, 1214, 1215, 1216, 1217, 1218, 1219,  1220, 1221, 1222, 1223, 1224, 1225, 1226, 1227,
     1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235,  1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243,
     1244, 1245, 1246, 1247, 1248, 1249, 1250, 1251,  1252, 1253, 1254, 1255, 1256, 1257, 1258,   2,
      37, 191,  37, 1259, 1260, 1261, 1262, 1263,  1264, 1265, 1266, 1267, 1268, 1269, 1270, 1271,
     1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279,  1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287,
     1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295,  1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303,
     1304, 1305, 1306, 1307, 1308, 1309, 1310, 1311,  1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319,
     1320, 1321, 1322,   2,  37, 191,  37, 1323,  1324, 1325, 1326, 1327, 1328, 1329, 1330, 1331,
     1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339,  1340, 1341, 1342, 1343, 1344, 1345, 1346, 1347,
     1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355,  1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363,
     1364, 1365, 1366, 1367, 1368, 1369, 1370, 1371,  1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379,
     1380, 1381, 1382, 1383, 1384, 1385, 1386,   2,   37, 191,  37, 1387, 1388, 1389, 1390, 1391,
     1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399,  1400, 1401, 1402, 1403, 1404, 1405, 1406, 1407,
     1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415,  1416, 1417, 1418, 1419, 1420, 1421, 1422, 1423,
     1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431,  1432, 1433, 1434, 1435, 1436, 1437, 1438, 1439,
     1440, 1441, 1442, 1443, 1444, 1445, 1446, 1447,  1448, 1449, 1450,   2,  37, 191,  37, 1451,
     1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459,  1460, 1461, 1462, 1463, 1464, 1465, 1466, 1467,
     1468, 1469, 1470, 1471, 1472, 1473, 1474, 1475,  1476, 1477, 1478, 1479, 1480, 1481, 1482, 1483,
     1484, 1485, 1486, 1487, 1488, 1489, 1490, 1491,  1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499,
     1500, 1501, 1502, 1503, 1504, 1505, 1506, 1507,  1508, 1509, 1510, 1511, 1512, 1513, 1514,   2,
      37, 191,  37, 1515, 1516, 1517, 1518, 1519,  1520, 1521, 1522, 1523, 1524, 1525, 1526, 1527,
     1528, 1529, 1530, 1531, 1532, 1533, 1534, 1535,  1536, 1537, 1538, 1539, 1540, 1541, 1542, 1543,
     1544, 1545, 1546, 1547, 1548, 1549, 1550, 1551,  1552, 1553, 1554, 1555, 1556, 1557, 1558, 1559,
     1560, 1561, 1562, 1563, 1564, 1565, 1566, 1567,  1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575,
     1576, 1577, 1578,   2,  37, 191,  37, 1579,  1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587,
     1588, 1589, 1590, 1591, 1592, 1593, 1594, 1595,  1596, 1597, 1598, 1599, 1600, 1601, 1602, 1603,
     1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611,  1612, 1613, 1614, 1615, 1616, 1617, 1618, 1619,
     1620, 1621, 1622, 1623, 1624, 1625, 1626, 1627,  1628, 1629, 1630, 1631, 1632, 1633, 1634, 1635,
     1636, 1637, 1638, 1639, 1640, 1641, 1642,   2,   37, 191,  37, 1643, 1644, 1645, 1646, 1647,
     1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655,  1656, 1657, 1658, 1659, 1660, 1661, 1662, 1663,
     1664, 1665, 1666, 1667, 1668, 1669, 1670, 1671,  1672, 1673, 1674, 1675, 1676, 1677, 1678, 1679,
     1680, 1681, 1682, 1683, 1684, 1685, 1686, 1687,  1688, 1689, 1690, 1691, 1692, 1693, 1694, 1695,
     1696, 1697, 1698, 1699, 1700, 1701, 1702, 1703,  1704, 1705, 1706,   2,  37, 191,  37, 1707,
     1708, 1709, 1710, 1711, 1712, 1713, 1714, 1715,  1716, 1717, 1718, 1719, 1720, 1721, 1722, 1723,
     1724, 1725, 1726, 1727, 1728, 1729, 1730, 1731,  1732, 1733, 1734, 1735, 1736, 1737, 1738, 1739,
     1740, 1741, 1742, 1743, 1744, 1745, 1746, 1747,  1748, 1749, 1750, 1751, 1752, 1753, 1754, 1755,
     1756, 1757, 1758, 1759, 1760, 1761, 1762, 1763,  1764, 1765, 1766, 1767, 1768, 1769, 1770,   2,
      37, 191,  37, 1771, 1772, 1773, 1774, 1775,  1776, 1777, 1778, 1779, 1780, 1781, 1782, 1783,
     1784, 1785, 1786, 1787, 1788, 1789, 1790, 1791,  1792, 1793, 1794, 1795, 1796, 1797, 1798, 1799,
     1800, 1801, 1802, 1803, 1804, 1805, 1806, 1807,  1808, 1809, 1810, 1811, 1812, 1813, 1814, 1815,
     1816, 1817, 1818, 1819, 1820, 1821, 1822, 1823,  1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831,
     1832, 1833, 1834,   2,  37, 191,  37, 1835,  1836, 1837, 1838, 1839, 1840, 1841, 1842, 1843,
     1844, 1845, 1846, 1847, 1848, 1849, 1850, 1851,  1852, 1853, 1854, 1855, 1856, 1857, 1858, 1859,
     1860, 1861, 1862, 1863, 1864, 1865, 1866, 1867,  1868, 1869, 1870, 1871, 1872, 1873, 1874, 1875,
     1876, 1877, 1878, 1879, 1880, 1881, 1882, 1883,  1884, 1885, 1886, 1887, 1888, 1889, 1890, 1891,
     1892, 1893, 1894, 1895, 1896, 1897, 1898,   2,   37, 191,  37, 1899, 1900, 1901, 1902, 1903,
     1904, 1905, 1906, 1907, 1908, 1909, 1910, 1911,  1912, 1913, 1914, 1915, 1916, 1917, 1918, 1919,
     1920, 1921, 1922, 1923, 1924, 1925, 1926, 1927,  1928, 1929, 1930, 1931, 1932, 1933, 1934, 1935,
     1936, 1937, 1938, 1939, 1940, 1941, 1942, 1943,  1944, 1945, 1946, 1947, 1948, 1949, 1950, 1951,
     1952, 1953, 1954, 1955, 1956, 1957, 1958, 1959,  1960, 1961, 1962,   2,  37, 191,  37, 1963,
     1964, 1965, 1966, 1967, 1968, 1969, 1970, 1971,  1972, 1973, 1974, 1975, 1976, 1977, 1978, 1979,
     1980, 1981, 1982, 1983, 1984, 1985, 1986, 1987,  1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995,
     1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003,  2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011,
     2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019,  2020, 2021, 2022, 2023, 2024, 2025, 2026,   2,
      37, 191,  37, 2027, 2028, 2029, 2030, 2031,  2032, 2033, 2034, 2035, 2036, 2037, 2038, 2039,
     2040, 2041, 2042, 2043, 2044, 2045, 2046, 2047,  2048, 2049, 2050, 2051, 2052, 2053, 2054, 2055,
     2056, 2057, 2058, 2059, 2060, 2061, 2062, 2063,  2064, 2065, 2066, 2067, 2068, 2069, 2070, 2071,
     2072, 2073, 2074, 2075, 2076, 2077, 2078, 2079,  2080, 2081, 2082, 2083, 2084, 2085, 2086, 2087,
     2088, 2089, 2090,   2,  37
};
