#!/usr/bin/env texlua

-- JIS->Unicode->CID ではうまくいかない部分
local nonuni_cid = {
   -- 鼻濁音
   [0x2477] = 16209,
   [0x2478] = 16210,
   [0x2479] = 16211,
   [0x247A] = 16212,
   [0x247B] = 16213,
   [0x2577] = 16214,
   [0x2578] = 16215,
   [0x2579] = 16216,
   [0x257A] = 16217,
   [0x257B] = 16218,
   [0x257C] = 16219,
   [0x257D] = 16220,
   [0x257E] = 16221,
   [0x2678] = 16246,
   -- from http://examples.oreilly.de/english_examples/nutshell/cjkv/adobe/jisx0213-all.txt
   [0x2B44] = 9422,
   [0x2B48] = 9425,
   [0x2B49] = 9424,
   [0x2B4A] = 9440,
   [0x2B4B] = 9439,
   [0x2B4C] = 9428,
   [0x2B4D] = 9427,
   [0x2B4E] = 9431,
   [0x2B4F] = 9430,
   [0x2B65] = 15856,
   [0x2B66] = 15857,
}

-- 小塚明朝 Pr6 R の fwid feature による変換テーブル
local prop_to_full =  {
	[1]=633, 	[2]=642, 	[3]=8007, 	[4]=716, 
	[5]=712, 	[6]=715, 	[7]=717, 	[8]=8006, 
	[9]=674, 	[10]=675, 	[11]=718, 	[12]=692, 
	[13]=636, 	[14]=662, 	[15]=637, 	[16]=663, 
	[17]=780, 	[18]=781, 	[19]=782, 	[20]=783, 
	[21]=784, 	[22]=785, 	[23]=786, 	[24]=787, 
	[25]=788, 	[26]=789, 	[27]=639, 	[28]=640, 
	[29]=699, 	[30]=697, 	[31]=700, 	[32]=641, 
	[33]=719, 	[34]=790, 	[35]=791, 	[36]=792, 
	[37]=793, 	[38]=794, 	[39]=795, 	[40]=796, 
	[41]=797, 	[42]=798, 	[43]=799, 	[44]=800, 
	[45]=801, 	[46]=802, 	[47]=803, 	[48]=804, 
	[49]=805, 	[50]=806, 	[51]=807, 	[52]=808, 
	[53]=809, 	[54]=810, 	[55]=811, 	[56]=812, 
	[57]=813, 	[58]=814, 	[59]=815, 	[60]=678, 
	[61]=711, 	[62]=679, 	[63]=648, 	[64]=650, 
	[65]=646, 	[66]=816, 	[67]=817, 	[68]=818, 
	[69]=819, 	[70]=820, 	[71]=821, 	[72]=822, 
	[73]=823, 	[74]=824, 	[75]=825, 	[76]=826, 
	[77]=827, 	[78]=828, 	[79]=829, 	[80]=830, 
	[81]=831, 	[82]=832, 	[83]=833, 	[84]=834, 
	[85]=835, 	[86]=836, 	[87]=837, 	[88]=838, 
	[89]=839, 	[90]=840, 	[91]=841, 	[92]=680, 
	[93]=8005, 	[94]=681, 	[95]=665, 	[96]=671, 
	[97]=664, 	[98]=670, 	[99]=667, 	[100]=665, 
	[102]=713, 	[103]=714, 	[106]=720, 	[107]=16280, 
	[108]=672, 	[109]=684, 	[110]=682, 	[111]=683, 
	[114]=16206, 	[115]=776, 	[116]=777, 	[117]=638, 
	[118]=778, 	[119]=12256, 	[120]=636, 	[121]=8280, 
	[122]=673, 	[123]=685, 	[124]=668, 	[125]=772, 
	[127]=645, 	[128]=648, 	[129]=649, 	[132]=647, 
	[138]=661, 	[151]=693, 	[152]=8059, 	[153]=8008, 
	[154]=8060, 	[155]=707, 	[156]=694, 	[159]=12093, 
	[161]=8185, 	[162]=8184, 	[163]=9783, 	[186]=695, 
	[215]=696, 	[226]=649, 	[228]=11853, 	[230]=8228, 
	[231]=633, 	[232]=642, 	[233]=673, 	[234]=716, 
	[235]=712, 	[236]=715, 	[237]=717, 	[238]=671, 
	[239]=674, 	[240]=675, 	[241]=718, 	[242]=692, 
	[243]=636, 	[244]=662, 	[245]=637, 	[246]=663, 
	[247]=780, 	[248]=781, 	[249]=782, 	[250]=783, 
	[251]=784, 	[252]=785, 	[253]=786, 	[254]=787, 
	[255]=788, 	[256]=789, 	[257]=639, 	[258]=640, 
	[259]=699, 	[260]=697, 	[261]=700, 	[262]=641, 
	[263]=719, 	[264]=790, 	[265]=791, 	[266]=792, 
	[267]=793, 	[268]=794, 	[269]=795, 	[270]=796, 
	[271]=797, 	[272]=798, 	[273]=799, 	[274]=800, 
	[275]=801, 	[276]=802, 	[277]=803, 	[278]=804, 
	[279]=805, 	[280]=806, 	[281]=807, 	[282]=808, 
	[283]=809, 	[284]=810, 	[285]=811, 	[286]=812, 
	[287]=813, 	[288]=814, 	[289]=815, 	[290]=678, 
	[291]=711, 	[292]=679, 	[293]=648, 	[294]=650, 
	[295]=670, 	[296]=816, 	[297]=817, 	[298]=818, 
	[299]=819, 	[300]=820, 	[301]=821, 	[302]=822, 
	[303]=823, 	[304]=824, 	[305]=825, 	[306]=826, 
	[307]=827, 	[308]=828, 	[309]=829, 	[310]=830, 
	[311]=831, 	[312]=832, 	[313]=833, 	[314]=834, 
	[315]=835, 	[316]=836, 	[317]=837, 	[318]=838, 
	[319]=839, 	[320]=840, 	[321]=841, 	[322]=680, 
	[323]=8005, 	[324]=681, 	[325]=649, 	[327]=635, 
	[328]=686, 	[329]=687, 	[330]=634, 	[331]=638, 
	[332]=1006, 	[333]=925, 	[334]=927, 	[335]=929, 
	[336]=931, 	[337]=933, 	[338]=991, 	[339]=993, 
	[340]=995, 	[341]=959, 	[342]=660, 	[343]=926, 
	[344]=928, 	[345]=930, 	[346]=932, 	[347]=934, 
	[348]=935, 	[349]=937, 	[350]=939, 	[351]=941, 
	[352]=943, 	[353]=945, 	[354]=947, 	[355]=949, 
	[356]=951, 	[357]=953, 	[358]=955, 	[359]=957, 
	[360]=960, 	[361]=962, 	[362]=964, 	[363]=966, 
	[364]=967, 	[365]=968, 	[366]=969, 	[367]=970, 
	[368]=971, 	[369]=974, 	[370]=977, 	[371]=980, 
	[372]=983, 	[373]=986, 	[374]=987, 	[375]=988, 
	[376]=989, 	[377]=990, 	[378]=992, 	[379]=994, 
	[380]=996, 	[381]=997, 	[382]=998, 	[383]=999, 
	[384]=1000, 	[385]=1001, 	[386]=1003, 	[387]=1007, 
	[388]=643, 	[389]=644, 	[390]=646, 	[391]=1004, 
	[392]=1005, 	[393]=1002, 	[394]=1009, 	[395]=1010, 
	[396]=1008, 	[397]=936, 	[398]=938, 	[399]=940, 
	[400]=942, 	[401]=944, 	[402]=946, 	[403]=948, 
	[404]=950, 	[405]=952, 	[406]=954, 	[407]=956, 
	[408]=958, 	[409]=961, 	[410]=963, 	[411]=965, 
	[412]=972, 	[413]=973, 	[414]=975, 	[415]=976, 
	[416]=978, 	[417]=979, 	[418]=981, 	[419]=982, 
	[420]=984, 	[421]=985, 	[423]=7608, 	[424]=7609, 
	[425]=7479, 	[426]=7480, 	[427]=7481, 	[428]=7482, 
	[429]=7483, 	[430]=7484, 	[431]=7485, 	[432]=7486, 
	[433]=7487, 	[434]=7488, 	[435]=7489, 	[436]=7490, 
	[437]=7491, 	[438]=7492, 	[439]=7493, 	[440]=7494, 
	[441]=7495, 	[442]=7496, 	[443]=7497, 	[444]=7498, 
	[445]=7499, 	[446]=7500, 	[447]=7501, 	[448]=7502, 
	[449]=7503, 	[450]=7504, 	[451]=7505, 	[452]=7506, 
	[453]=7507, 	[454]=7508, 	[455]=7509, 	[456]=7510, 
	[457]=7511, 	[458]=7512, 	[459]=7513, 	[460]=7514, 
	[461]=7515, 	[462]=7516, 	[463]=7517, 	[464]=7518, 
	[465]=7519, 	[466]=7520, 	[467]=7521, 	[468]=7522, 
	[469]=7523, 	[470]=7524, 	[471]=7525, 	[472]=7526, 
	[473]=7527, 	[474]=7528, 	[475]=7529, 	[476]=7530, 
	[477]=7531, 	[478]=7532, 	[479]=7533, 	[480]=7534, 
	[481]=7535, 	[482]=7536, 	[483]=7537, 	[484]=7538, 
	[485]=7539, 	[486]=7540, 	[487]=7541, 	[488]=7542, 
	[489]=7543, 	[490]=7544, 	[491]=7545, 	[492]=7546, 
	[493]=7547, 	[494]=7548, 	[495]=7549, 	[496]=7550, 
	[497]=7551, 	[498]=7552, 	[499]=7553, 	[500]=7554, 
	[501]=645, 	[502]=647, 	[503]=672, 	[504]=676, 
	[505]=677, 	[506]=682, 	[507]=683, 	[508]=684, 
	[509]=685, 	[510]=688, 	[511]=689, 	[512]=690, 
	[513]=691, 	[514]=693, 	[516]=923, 	[517]=842, 
	[518]=844, 	[519]=846, 	[520]=848, 	[521]=850, 
	[522]=908, 	[523]=910, 	[524]=912, 	[525]=876, 
	[526]=843, 	[527]=845, 	[528]=847, 	[529]=849, 
	[530]=851, 	[531]=852, 	[532]=854, 	[533]=856, 
	[534]=858, 	[535]=860, 	[536]=862, 	[537]=864, 
	[538]=866, 	[539]=868, 	[540]=870, 	[541]=872, 
	[542]=874, 	[543]=877, 	[544]=879, 	[545]=881, 
	[546]=883, 	[547]=884, 	[548]=885, 	[549]=886, 
	[550]=887, 	[551]=888, 	[552]=891, 	[553]=894, 
	[554]=897, 	[555]=900, 	[556]=903, 	[557]=904, 
	[558]=905, 	[559]=906, 	[560]=907, 	[561]=909, 
	[562]=911, 	[563]=913, 	[564]=914, 	[565]=915, 
	[566]=916, 	[567]=917, 	[568]=918, 	[569]=920, 
	[570]=924, 	[571]=921, 	[572]=922, 	[573]=919, 
	[574]=853, 	[575]=855, 	[576]=857, 	[577]=859, 
	[578]=861, 	[579]=863, 	[580]=865, 	[581]=867, 
	[582]=869, 	[583]=871, 	[584]=873, 	[585]=875, 
	[586]=878, 	[587]=880, 	[588]=882, 	[589]=889, 
	[590]=890, 	[591]=892, 	[592]=893, 	[593]=895, 
	[594]=896, 	[595]=898, 	[596]=899, 	[597]=901, 
	[598]=902, 	[608]=713, 	[609]=714, 	[614]=9826, 
	[629]=731, 	[631]=665, 	[632]=8228, 	[8718]=8008, 
	[8719]=664, 	[9354]=9779, 	[9355]=1034, 	[9356]=708, 
	[9357]=709, 	[9371]=9796, 	[9372]=9797, 	[9373]=9798, 
	[9374]=9799, 	[9375]=9781, 	[9376]=9782, 	[9442]=769, 
	[12063]=661, 	[12064]=697, 	[12065]=710, 	[12066]=706, 
	[12067]=705, 	[12068]=740, 	[12069]=735, 	[12070]=12123, 
	[12071]=12124, 	[12072]=12125, 	[12073]=12126, 	[12074]=12127, 
	[12075]=12128, 	[12076]=12129, 	[12077]=12130, 	[12078]=12131, 
	[12079]=12132, 	[12080]=12169, 	[12081]=12170, 	[12086]=8006, 
	[12087]=8007, 	[15449]=651, 	[15450]=652, 	[15451]=653, 
	[15452]=654, 	[15453]=655, 	[15454]=658, 	[15455]=660, 
	[15456]=698, 	[15457]=701, 	[15458]=702, 	[15459]=703, 
	[15460]=704, 	[15461]=710, 	[15462]=16195, 	[15463]=12181, 
	[15464]=741, 	[15465]=742, 	[15466]=743, 	[15467]=744, 
	[15468]=745, 	[15469]=746, 	[15470]=747, 	[15471]=748, 
	[15472]=16306, 	[15473]=16307, 	[15474]=16308, 	[15475]=16309, 
	[15476]=16299, 	[15477]=12184, 	[15480]=749, 	[15481]=750, 
	[15482]=752, 	[15483]=753, 	[15484]=754, 	[15485]=755, 
	[15486]=12188, 	[15487]=12186, 	[15488]=12189, 	[15489]=16196, 
	[15490]=16300, 	[15491]=756, 	[15492]=757, 	[15493]=759, 
	[15494]=760, 	[15495]=761, 	[15496]=762, 	[15497]=763, 
	[15498]=764, 	[15499]=765, 	[15500]=766, 	[15501]=767, 
	[15502]=768, 	[15503]=769, 	[15504]=770, 	[15505]=16303, 
	[15506]=12120, 	[15507]=16301, 	[15508]=16302, 	[15509]=16304, 
	[15510]=16305, 	[15511]=12201, 	[15512]=12118, 	[15513]=12089, 
	[15514]=12092, 	[15515]=16204, 	[15516]=16205, 	[15517]=842, 
	[15518]=843, 	[15519]=844, 	[15520]=845, 	[15521]=846, 
	[15522]=847, 	[15523]=848, 	[15524]=849, 	[15525]=850, 
	[15526]=851, 	[15527]=852, 	[15528]=853, 	[15529]=854, 
	[15530]=855, 	[15531]=856, 	[15532]=857, 	[15533]=858, 
	[15534]=859, 	[15535]=860, 	[15536]=861, 	[15537]=862, 
	[15538]=863, 	[15539]=864, 	[15540]=865, 	[15541]=866, 
	[15542]=867, 	[15543]=868, 	[15544]=869, 	[15545]=870, 
	[15546]=871, 	[15547]=872, 	[15548]=873, 	[15549]=874, 
	[15550]=875, 	[15551]=876, 	[15552]=877, 	[15553]=878, 
	[15554]=879, 	[15555]=880, 	[15556]=881, 	[15557]=882, 
	[15558]=883, 	[15559]=884, 	[15560]=885, 	[15561]=886, 
	[15562]=887, 	[15563]=888, 	[15564]=889, 	[15565]=890, 
	[15566]=891, 	[15567]=892, 	[15568]=893, 	[15569]=894, 
	[15570]=895, 	[15571]=896, 	[15572]=897, 	[15573]=898, 
	[15574]=899, 	[15575]=900, 	[15576]=901, 	[15577]=902, 
	[15578]=903, 	[15579]=904, 	[15580]=905, 	[15581]=906, 
	[15582]=907, 	[15583]=908, 	[15584]=909, 	[15585]=910, 
	[15586]=911, 	[15587]=912, 	[15588]=913, 	[15589]=914, 
	[15590]=915, 	[15591]=916, 	[15592]=917, 	[15593]=918, 
	[15594]=919, 	[15595]=920, 	[15596]=921, 	[15597]=922, 
	[15598]=923, 	[15599]=924, 	[15600]=7958, 	[15601]=7959, 
	[15602]=7960, 	[15603]=16209, 	[15604]=16210, 	[15605]=16211, 
	[15606]=16212, 	[15607]=16213, 	[15608]=925, 	[15609]=926, 
	[15610]=927, 	[15611]=928, 	[15612]=929, 	[15613]=930, 
	[15614]=931, 	[15615]=932, 	[15616]=933, 	[15617]=934, 
	[15618]=935, 	[15619]=936, 	[15620]=937, 	[15621]=938, 
	[15622]=939, 	[15623]=940, 	[15624]=941, 	[15625]=942, 
	[15626]=943, 	[15627]=944, 	[15628]=945, 	[15629]=946, 
	[15630]=947, 	[15631]=948, 	[15632]=949, 	[15633]=950, 
	[15634]=951, 	[15635]=952, 	[15636]=953, 	[15637]=954, 
	[15638]=955, 	[15639]=956, 	[15640]=957, 	[15641]=958, 
	[15642]=959, 	[15643]=960, 	[15644]=961, 	[15645]=962, 
	[15646]=963, 	[15647]=964, 	[15648]=965, 	[15649]=966, 
	[15650]=967, 	[15651]=968, 	[15652]=969, 	[15653]=970, 
	[15654]=971, 	[15655]=972, 	[15656]=973, 	[15657]=974, 
	[15658]=975, 	[15659]=976, 	[15660]=977, 	[15661]=978, 
	[15662]=979, 	[15663]=980, 	[15664]=981, 	[15665]=982, 
	[15666]=983, 	[15667]=984, 	[15668]=985, 	[15669]=986, 
	[15670]=987, 	[15671]=988, 	[15672]=989, 	[15673]=990, 
	[15674]=991, 	[15675]=992, 	[15676]=993, 	[15677]=994, 
	[15678]=995, 	[15679]=996, 	[15680]=997, 	[15681]=998, 
	[15682]=999, 	[15683]=1000, 	[15684]=1001, 	[15685]=1002, 
	[15686]=1003, 	[15687]=1004, 	[15688]=1005, 	[15689]=1006, 
	[15690]=1007, 	[15691]=1008, 	[15692]=1009, 	[15693]=1010, 
	[15694]=16214, 	[15695]=16215, 	[15696]=16216, 	[15697]=16217, 
	[15698]=16218, 	[15699]=16219, 	[15700]=16220, 	[15701]=16221, 
	[15702]=16236, 	[15703]=16237, 	[15704]=16238, 	[15705]=16239, 
	[15706]=16240, 	[15707]=16241, 	[15708]=16242, 	[15709]=16243, 
	[15710]=16244, 	[15711]=16245, 	[15712]=16246, 	[15713]=16247, 
	[15714]=16248, 	[15715]=16249, 	[15716]=16250, 	[15717]=16251, 
	[15718]=16252, 	[15719]=8313, 	[15720]=8314, 	[15721]=8315, 
	[15722]=8316, 	[15723]=12269, 	[15724]=12271, 	[15725]=16310, 
	[15726]=16311, 	[15727]=9784, 	[15728]=16271, 	[15880]=7624, 
	[15881]=7629, 	[15882]=7630, 	[15900]=12091, 	[15901]=7625, 
	[15902]=8195, 	[15903]=12121, 	[15904]=12122, 	[15905]=12187, 
	[15906]=12190, 	[15907]=12185, 
}

-- JIS->Unicode, Unicode->CID のテーブルから JIS->CID のテーブルを作る
local function mk_jis_cid_table(jis_uni, uni_cid)
   local res = {}
   for jis, uni in pairs(jis_uni) do
      local c = uni_cid[uni]
      if c then
	 if ((jis>=0x2900) and (jis<=0x2B7E)) then
	    res[#res+1] = { jis, nonuni_cid[jis] or c}
	 else
	    -- それ以外の場合は全角化する
	    res[#res+1] = { jis, nonuni_cid[jis] or (prop_to_full[c] or c)}
	 end
      end
   end
   table.sort(res, function (a,b) return a[1]<b[1] end)
   return res
end

-- 
local function change_repr(t)
   local res = {}   
   for i,v in pairs(t) do
      res[#res+1] = {i,v}
   end
   table.sort(res, function (a,b) return a[1]<b[1] end)
   return res
end


-- 出力処理
do
   local buf, bufline, fh
   
   local function flush()
      fh:write(tonumber(bufline) .. " begincidrange\n" .. buf .. "endcidrange\n")
      buf, bufline = "", 0
   end

   local function out(s)
      buf = buf .. s .. "\n"; bufline = bufline + 1;
      if bufline==100 then flush() end
   end

   local function out_header(fname, hname, crange, wmode)
      fh:write([[
%!PS-Adobe-3.0 Resource-CMap
%%DocumentNeededResources: ProcSet (CIDInit)
]])
      if wmode == 1 then
         local s = string.gsub('%%DocumentNeededResources: CMap ($NAME)\n', '$NAME', hname)
	 fh:write(s)
      end

      fh:write([[
%%IncludeResource: ProcSet (CIDInit)
]])
      if wmode == 1 then
         local s = string.gsub('%%IncludeResource: CMap ($NAME)\n', '$NAME', hname)
	 fh:write(s)
      end

      local s = string.gsub([[
%%BeginResource: CMap ($NAME)
%%Title: ($NAME Adobe Japan1 6)
%%Version: 0.001
%%Copyright: ------------------------------------------------------------
%%Copyright: Copyright (c) 2013 Hironori KITAGAWA.
%%Copyright: 
%%Copyright: This software is free software.
%%Copyright: Unlimited permission is granted to use, copy, and distribute
%%Copyright: it, with or without modification, either commercially and
%%Copyright: noncommercially.
%%Copyright: THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT ANY WARRANTY.
%%Copyright: ------------------------------------------------------------
%%EndComments

/CIDInit /ProcSet findresource begin

12 dict begin

begincmap
]], '$NAME', fname)
      fh:write(s)
      if wmode == 1 then
         s=string.gsub(
		  string.gsub('\n/$NAME usecmap\n\n', '$NAME', fname),
	          '-V', '-H')
	 fh:write(s)
      end
      s = string.gsub([[
/CIDSystemInfo 3 dict dup begin
  /Registry (Adobe) def
  /Ordering (Japan1) def
  /Supplement 6 def
end def

/CMapName /$NAME def
/CMapVersion 0.001 def
/CMapType 1 def
]], '$NAME', fname)
      fh:write(s)

      fh:write('\n/WMode ' .. wmode .. ' def\n\n')
      if wmode ==0 then
	    fh:write(crange .. '\n')
      end
   end

   local function out_footer()
      fh:write([[
endcmap
CMapName currentdict /CMap defineresource pop
end
end

%%EndResource
%%EOF
]])
   end

   function out_cmap(fname, hname, jis_cid, col_num, crange, wmode)
      fh = io.open(fname, 'w+')
      out_header(fname, hname, crange, wmode)
      buf, bufline = "", 0
      local fstr = "<%x> <%x> %" .. col_num .. "d"
      local i, outbi, outbc = 1, jis_cid[1][1], jis_cid[1][2]
      while i < #jis_cid do
	 if jis_cid[i+1][2] == jis_cid[i][2] + 1 
	    and jis_cid[i+1][1] == jis_cid[i][1] + 1 then
	    oute = jis_cid[i+1][1]
	 else 
	    out(string.format(fstr, outbi, oute, outbc))
	    outbi, oute, outbc = jis_cid[i+1][1], jis_cid[i+1][1], jis_cid[i+1][2]
	 end
	 i = i + 1
      end
      out(string.format(fstr, outbi, jis_cid[#jis_cid][1], outbc))
      flush(); 
      out_footer(); 
      fh:close()
   end
end

-- 
local function cleanup(new, old)
   table.sort(new, function (a,b) return a[1]<b[1] end)
   -- We can assume new and old are sorted.
   local oi, ol = 1, #old
   local res = {}
   for _,v in ipairs(new) do
      for i = oi, ol do
         local w = old[i]
	 if v[1] == w[1] and v[2] ~= w[2] then
	    res [#res+1] = v; 
            oi = i + 1; break
         elseif v[1]<w[1] then
            -- We don't need further search.
            oi = i; break
         end
      end
   end
   return res
end

local function write_text(fname, tb)
   print('writing ' .. fname )
   fh = io.open(fname, 'w+')
   for _,v in pairs(tb) do
      fh:write(string.format('%4X\t%d\n', v[1], v[2]))
   end
   fh:close()
end

local function replace(ar, jis, cid)
   local i = 1
   for j=1,#ar do
      if ar[j][1] == jis then ar[j][2] = cid; break end
   end
end

----------------------------------------------------------------
----------------------------------------------------------------
----------------------------------------------------------------
----------------------------------------------------------------


local f
local cmap_dec = require('cmapdec')

kpse.set_program_name('luatex')
dofile(kpse.find_file('lualibs-table.lua'))

do
----------------------------------------------------------------
-- jisx0213-2004-8bit-std.txt 読み込み
local jis04_uni = {}
f = io.open("jisx0213-2004-8bit-std.txt", "r")
for lx in f:lines() do
   l = string.match(lx,"^([^#]*)#.*$")
   if l ~= "" then
      local jis = tonumber(string.match(l, "^(0x%x*)%s*U%+%x*"))
      local uni = string.match(l, "^0x%x*%s*U%+(%x*)")
      -- 全角幅優先
      uni = string.match(lx, 'Fullwidth: U%+(%x*)') or uni
      if jis and uni then
	 uni = tonumber(uni,16)
	 jis04_uni[jis] = uni
      end
   end
end
f:close()

local code_range_04 = [[
2 begincodespacerange
  <2121> <7E7E>
  <A1A1> <FEFE>
endcodespacerange
]]

----------------------------------------------------------------
-- JIS X 0213:2004 => Adobe-Japan1-6 横組
local uni_cid_h04 = cmap_dec.open_cmap_file('UniJIS2004-UTF32-H')
local jis_cid_h04 = mk_jis_cid_table(jis04_uni, uni_cid_h04)

replace(jis_cid_h04, 0x224C,   751) -- NOT SIGN

-- 全角字形があるものは全角化しておく
replace(jis_cid_h04, 0x2921,  9779) -- EURO SIGN
replace(jis_cid_h04, 0x2924, 16280) -- CURRENCY SIGN
replace(jis_cid_h04, 0x2925,  8005) -- BROKEN BAR
replace(jis_cid_h04, 0x2926,  8059) -- COPYRIGHT SIGN
replace(jis_cid_h04, 0x292A,  8060) -- REGISTERED SIGN
replace(jis_cid_h04, 0x2933,  8185) -- VULGAR FRACTION ONE QUARTER
replace(jis_cid_h04, 0x2934,  8184) -- VULGAR FRACTION ONE HALF
replace(jis_cid_h04, 0x2935,  9783) -- VULGAR FRACTION THREE QUARTERS 

out_cmap('2004-H', '', jis_cid_h04, '', code_range_04, 0)


----------------------------------------------------------------
-- JIS X 0213:2004 => Adobe-Japan1-6 縦組
local uni_cid_v04 = table.fastcopy(uni_cid_h04)
uni_cid_v04 =cmap_dec.open_cmap_file('UniJIS2004-UTF32-V', uni_cid_v04)
local jis_cid_v04 = mk_jis_cid_table(jis04_uni, uni_cid_v04)

replace(jis_cid_v04, 0x2127, 12101) -- COLON
replace(jis_cid_v04, 0x2131,  7889) -- OVERLINE
replace(jis_cid_v04, 0x213D,  7892) -- EM DASH
replace(jis_cid_v04, 0x2146, 12173) -- 
replace(jis_cid_v04, 0x2147, 12174) -- 
replace(jis_cid_v04, 0x2148,  7956) -- 
replace(jis_cid_v04, 0x2149,  7957) -- 
replace(jis_cid_v04, 0x224C,   751) -- NOT SIGN

replace(jis_cid_v04, 0x2236, 12107) -- HIRAGANA VOICED ITERATION MARK
replace(jis_cid_v04, 0x237C, 16332) -- EN DASH
replace(jis_cid_v04, 0x2678, 16343) -- KATAKANA LETTER SMALL PU
replace(jis_cid_v04, 0x2D5F, 12044) -- SQUARE ERA NAME HEISEI
replace(jis_cid_v04, 0x2D6D, 12041) -- SQUARE ERA NAME MEIZI
replace(jis_cid_v04, 0x2D6E, 12042) -- SQUARE ERA NAME TAISYOU
replace(jis_cid_v04, 0x2D6F, 12043) -- SQUARE ERA NAME SYOUWA

replace(jis_cid_v04, 0x2921,  9779) -- EURO SIGN
replace(jis_cid_v04, 0x2924, 16280) -- CURRENCY SIGN
replace(jis_cid_v04, 0x2925,  8005) -- BROKEN BAR
replace(jis_cid_v04, 0x2926,  8059) -- COPYRIGHT SIGN
replace(jis_cid_v04, 0x292A,  8060) -- REGISTERED SIGN
replace(jis_cid_v04, 0x2933,  8185) -- VULGAR FRACTION ONE QUARTER
replace(jis_cid_v04, 0x2934,  8184) -- VULGAR FRACTION ONE HALF
replace(jis_cid_v04, 0x2935,  9783) -- VULGAR FRACTION THREE QUARTERS 


out_cmap('2004-V', '2004-H', cleanup(jis_cid_v04, jis_cid_h04), '', code_range_04, 1)

end

-- do
-- ----------------------------------------------------------------
-- -- JIS0208.txt 読み込み
-- local jis90_uni = {}
-- f = io.open("JIS0208.TXT", "r")
-- for lx in f:lines() do
--    l = string.match(lx,"^([^#]*)#.*$")
--    if l ~= "" then
--       local jis = tonumber(string.match(l, "^0x%x*%s*(0x%x*)%s*0x%x*"))
--       local uni = string.match(l, "^0x%x*%s*0x%x*%s*0x(%x*)")
--       -- 全角幅優先
--       if jis and uni then
-- 	 uni = tonumber(uni,16)
-- 	 jis90_uni[jis] = uni
--       end
--    end
-- end
-- f:close()

-- local code_range_90 = [[
-- 1 begincodespacerange
--   <2121> <7E7E>
-- endcodespacerange
-- ]]

-- ----------------------------------------------------------------
-- -- JIS X 0208:1990 => Adobe-Japan1-6 縦組

-- -- とりあえず 横組を load
-- local uni_cid_h90 = cmap_dec.open_cmap_file('UniJIS-UTF32-H')
-- local jis_cid_h90 = mk_jis_cid_table(jis90_uni, uni_cid_h90)

-- replace(jis_cid_h90, 0x224C,   751) -- NOT SIGN

-- local uni_cid_v90 = table.fastcopy(uni_cid_h90)
-- uni_cid_v90 =cmap_dec.open_cmap_file('UniJIS-UTF32-V', uni_cid_v90)
-- local jis_cid_v90 = mk_jis_cid_table(jis90_uni, uni_cid_v90)

-- replace(jis_cid_v90, 0x2127, 12101) -- COLON
-- replace(jis_cid_v90, 0x2131, 7889)  -- OVERLINE
-- replace(jis_cid_v90, 0x213D, 7892)  -- EM DASH
-- replace(jis_cid_v90, 0x2146, 12173) -- 
-- replace(jis_cid_v90, 0x2147, 12174) -- 
-- replace(jis_cid_v90, 0x2148, 7956)  -- 
-- replace(jis_cid_v90, 0x2149, 7957)  -- 
-- replace(jis_cid_v90, 0x224C,   751) -- NOT SIGN

-- out_cmap('1990N-V', 'H', cleanup(jis_cid_v90, jis_cid_h90), '', code_range_90, 1)

-- end
