/* Public domain. */

#include "bytestr.h"

#ifdef USE_BASE_LIBC

#include <string.h>

int str_diff (register char const *s, register char const *t)
{
  return strcmp(s, t) ;
}

#else

int str_diff (register char const *s, register char const *t)
{
  register char x ;

  for (;;)
  {
    x = *s; if (x != *t) break; if (!x) break; ++s; ++t;
    x = *s; if (x != *t) break; if (!x) break; ++s; ++t;
    x = *s; if (x != *t) break; if (!x) break; ++s; ++t;
    x = *s; if (x != *t) break; if (!x) break; ++s; ++t;
  }
  return ((int)(unsigned int)(unsigned char) x)
       - ((int)(unsigned int)(unsigned char) *t) ;
}

#endif
