/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : MemoryLeak.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/12/27
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifndef __MEMORYLEAK_H__
#define __MEMORYLEAK_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

#if defined(MAXPATHLEN)
#else
#define MAXPATHLEN	1024
#endif


/* xmalloc, xfree を malloc, free と同じように使うための #define */
#if defined(DEBUG)
#define xmalloc(x)	_xmalloc((x), __LINE__, __FILE__)
#define xfree(x)	_xfree((x), __LINE__, __FILE__)
#define xdump()		_xdump()

#else
#define xmalloc(x)	malloc(x)
#define xfree(x)	free(x)
#define xdump()		

#endif


/* メモリ管理情報を記憶するための構造体の定義 */
typedef struct alloc_element {
	void *alloc_ptr;			// 確保したメモリブロックを指すポインタ
	int alloc_line;				// xmalloc を呼び出した位置
	char *alloc_file;			// そのコードが記述されているファイル名
	struct alloc_element *next;	// 次の ALLOC_ELEMENT へのポインタ
} ALLOC_ELEMENT;




/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _MEMORYLEAK_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)

	ALLOC_ELEMENT *_top = NULL;

#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */

	extern ALLOC_ELEMENT *_top;

#endif




#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _MEMORYLEAK_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
void* _xmalloc(size_t size, int line, char *file);
void _xfree(void *p, int line, char *file);
void _xdump(void);
int MemoryDebugLogPath(char *output_path);
int DeleteMemoryDebugLog(void);
char *GetFileName(char *lpszPath);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __MEMORYLEAK_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : MemoryLeak.h
 * ====================================================================
 */
