/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveAstIds;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAstAlt;
import org.sablecc.sablecc.node.AAstProd;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.APlusUnOp;
import org.sablecc.sablecc.node.AProductions;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.AStarUnOp;

public class GenAlts
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveAstIds ast_ids;
    private File pkgDir;
    private String pkgName;
    private List elemList;
    private String currentProd;
    ElemInfo info;

    public GenAlts(ResolveAstIds resolveAstIds) {
        this.ast_ids = resolveAstIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("alternatives.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open alternatives.txt.");
        }
        this.pkgDir = new File(resolveAstIds.astIds.pkgDir, "node");
        String string = this.pkgName = resolveAstIds.astIds.pkgName.equals("") ? "node" : resolveAstIds.astIds.pkgName + ".node";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    public void inAAstProd(AAstProd aAstProd) {
        this.currentProd = (String)this.ast_ids.ast_names.get(aAstProd);
    }

    public void inAAstAlt(AAstAlt aAstAlt) {
        this.elemList = new TypedLinkedList(ElemInfoCast.instance);
    }

    public void caseAProductions(AProductions aProductions) {
    }

    public void inAElem(AElem aElem) {
        this.info = new ElemInfo();
        this.info.name = (String)this.ast_ids.ast_names.get(aElem);
        this.info.type = (String)this.ast_ids.ast_elemTypes.get(aElem);
        this.info.operator = 0;
        if (aElem.getUnOp() != null) {
            aElem.getUnOp().apply(new DepthFirstAdapter(){

                public void caseAStarUnOp(AStarUnOp aStarUnOp) {
                    GenAlts.this.info.operator = 1;
                }

                public void caseAQMarkUnOp(AQMarkUnOp aQMarkUnOp) {
                    GenAlts.this.info.operator = 2;
                }

                public void caseAPlusUnOp(APlusUnOp aPlusUnOp) {
                    GenAlts.this.info.operator = 3;
                }
            });
        }
        this.elemList.add(this.info);
        this.info = null;
    }

    public void outAAstAlt(AAstAlt aAstAlt) {
        BufferedWriter bufferedWriter;
        String string = (String)this.ast_ids.ast_names.get(aAstAlt);
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, string + ".java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, string + ".java").getAbsolutePath());
        }
        try {
            Iterator iterator;
            ElemInfo elemInfo2;
            boolean bl = false;
            boolean bl2 = false;
            for (ElemInfo elemInfo2 : this.elemList) {
                if (elemInfo2 == null) continue;
                switch (elemInfo2.operator) {
                    case 1: 
                    case 3: {
                        bl2 = true;
                    }
                }
            }
            this.macros.apply(bufferedWriter, "AlternativeHeader1", new String[]{this.pkgName});
            if (bl2) {
                this.macros.apply(bufferedWriter, "AlternativeHeaderList", new String[0]);
            }
            this.macros.apply(bufferedWriter, "AlternativeHeader2", new String[]{this.ast_ids.astIds.pkgName.equals("") ? "analysis" : this.ast_ids.astIds.pkgName + ".analysis", string, this.currentProd});
            for (ElemInfo elemInfo2 : this.elemList) {
                if (elemInfo2 == null) continue;
                switch (elemInfo2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "NodeElement", new String[]{elemInfo2.type, GenAlts.nodeName(elemInfo2.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        bl = true;
                        this.macros.apply(bufferedWriter, "ListElement", new String[]{elemInfo2.type, GenAlts.nodeName(elemInfo2.name)});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "ConstructorHeader", new String[]{string});
            this.macros.apply(bufferedWriter, "ConstructorBodyHeader", null);
            this.macros.apply(bufferedWriter, "ConstructorBodyTail", null);
            if (this.elemList.size() > 0) {
                this.macros.apply(bufferedWriter, "ConstructorHeader", new String[]{string});
                iterator = this.elemList.iterator();
                while (iterator.hasNext()) {
                    elemInfo2 = (ElemInfo)iterator.next();
                    if (elemInfo2 == null) continue;
                    switch (elemInfo2.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "ConstructorHeaderDeclNode", new String[]{elemInfo2.type, GenAlts.nodeName(elemInfo2.name), iterator.hasNext() ? "," : ""});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "ConstructorHeaderDeclList", new String[]{elemInfo2.type, GenAlts.nodeName(elemInfo2.name), iterator.hasNext() ? "," : ""});
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "ConstructorBodyHeader", null);
                for (ElemInfo elemInfo2 : this.elemList) {
                    if (elemInfo2 == null) continue;
                    switch (elemInfo2.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "ConstructorBodyNode", new String[]{elemInfo2.name, GenAlts.nodeName(elemInfo2.name)});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "ConstructorBodyList", new String[]{elemInfo2.name, GenAlts.nodeName(elemInfo2.name)});
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "ConstructorBodyTail", null);
            }
            this.macros.apply(bufferedWriter, "CloneHeader", new String[]{string});
            iterator = this.elemList.iterator();
            while (iterator.hasNext()) {
                elemInfo2 = (ElemInfo)iterator.next();
                if (elemInfo2 == null) continue;
                switch (elemInfo2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "CloneBodyNode", new String[]{elemInfo2.type, GenAlts.nodeName(elemInfo2.name), iterator.hasNext() ? "," : ""});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "CloneBodyList", new String[]{GenAlts.nodeName(elemInfo2.name), iterator.hasNext() ? "," : ""});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "CloneTail", null);
            this.macros.apply(bufferedWriter, "Apply", new String[]{string});
            for (ElemInfo elemInfo2 : this.elemList) {
                if (elemInfo2 == null) continue;
                switch (elemInfo2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "GetSetNode", new String[]{elemInfo2.type, elemInfo2.name, GenAlts.nodeName(elemInfo2.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "GetSetList", new String[]{elemInfo2.name, GenAlts.nodeName(elemInfo2.name), elemInfo2.type});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "ToStringHeader", null);
            for (ElemInfo elemInfo2 : this.elemList) {
                if (elemInfo2 == null) continue;
                switch (elemInfo2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "ToStringBodyNode", new String[]{GenAlts.nodeName(elemInfo2.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "ToStringBodyList", new String[]{GenAlts.nodeName(elemInfo2.name)});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "ToStringTail", null);
            this.macros.apply(bufferedWriter, "RemoveChildHeader", null);
            for (ElemInfo elemInfo2 : this.elemList) {
                if (elemInfo2 == null) continue;
                switch (elemInfo2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "RemoveChildNode", new String[]{GenAlts.nodeName(elemInfo2.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "RemoveChildList", new String[]{GenAlts.nodeName(elemInfo2.name)});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "RemoveChildTail", null);
            this.macros.apply(bufferedWriter, "ReplaceChildHeader", null);
            for (ElemInfo elemInfo2 : this.elemList) {
                if (elemInfo2 == null) continue;
                switch (elemInfo2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "ReplaceChildNode", new String[]{GenAlts.nodeName(elemInfo2.name), elemInfo2.name, elemInfo2.type});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "ReplaceChildList", new String[]{GenAlts.nodeName(elemInfo2.name), elemInfo2.type});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "ReplaceChildTail", null);
            this.macros.apply(bufferedWriter, "AlternativeTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, string + ".java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.elemList = null;
    }

    public static String nodeName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() > 0) {
            stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
        }
        return stringBuffer.toString();
    }

    private static class ElemInfoCast
    implements Cast {
        public static final ElemInfoCast instance = new ElemInfoCast();

        private ElemInfoCast() {
        }

        public Object cast(Object object) {
            return (ElemInfo)object;
        }
    }

    private static class ElemInfo {
        static final int NONE = 0;
        static final int STAR = 1;
        static final int QMARK = 2;
        static final int PLUS = 3;
        String name;
        String type;
        int operator;

        private ElemInfo() {
        }
    }
}

