use pipeline::Pipeline;

pub fn make_pipeline() -> Pipeline {
    Pipeline {
        queue: vec![
            ("trimmer-pt".into(), trimmer),
            ("stopWordFilter-pt".into(), stop_word_filter),
            ("stemmer-pt".into(), stemmer),
        ],
    }
}

make_trimmer!(
    "A-Za-z\\xAA\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02B8\\u02E0-\\u02E4\\u1D00-\\u1D25\
     \\u1D2C-\\u1D5C\\u1D62-\\u1D65\\u1D6B-\\u1D77\\u1D79-\\u1DBE\\u1E00-\\u1EFF\\u2071\\u207F\
     \\u2090-\\u209C\\u212A\\u212B\\u2132\\u214E\\u2160-\\u2188\\u2C60-\\u2C7F\\uA722-\\uA787\
     \\uA78B-\\uA7AD\\uA7B0-\\uA7B7\\uA7F7-\\uA7FF\\uAB30-\\uAB5A\\uAB5C-\\uAB64\\uFB00-\\uFB06\
     \\uFF21-\\uFF3A\\uFF41-\\uFF5A"
);

make_stop_word_filter!([
    "",
    "a",
    "ao",
    "aos",
    "aquela",
    "aquelas",
    "aquele",
    "aqueles",
    "aquilo",
    "as",
    "até",
    "com",
    "como",
    "da",
    "das",
    "de",
    "dela",
    "delas",
    "dele",
    "deles",
    "depois",
    "do",
    "dos",
    "e",
    "ela",
    "elas",
    "ele",
    "eles",
    "em",
    "entre",
    "era",
    "eram",
    "essa",
    "essas",
    "esse",
    "esses",
    "esta",
    "estamos",
    "estas",
    "estava",
    "estavam",
    "este",
    "esteja",
    "estejam",
    "estejamos",
    "estes",
    "esteve",
    "estive",
    "estivemos",
    "estiver",
    "estivera",
    "estiveram",
    "estiverem",
    "estivermos",
    "estivesse",
    "estivessem",
    "estivéramos",
    "estivéssemos",
    "estou",
    "está",
    "estávamos",
    "estão",
    "eu",
    "foi",
    "fomos",
    "for",
    "fora",
    "foram",
    "forem",
    "formos",
    "fosse",
    "fossem",
    "fui",
    "fôramos",
    "fôssemos",
    "haja",
    "hajam",
    "hajamos",
    "havemos",
    "hei",
    "houve",
    "houvemos",
    "houver",
    "houvera",
    "houveram",
    "houverei",
    "houverem",
    "houveremos",
    "houveria",
    "houveriam",
    "houvermos",
    "houverá",
    "houverão",
    "houveríamos",
    "houvesse",
    "houvessem",
    "houvéramos",
    "houvéssemos",
    "há",
    "hão",
    "isso",
    "isto",
    "já",
    "lhe",
    "lhes",
    "mais",
    "mas",
    "me",
    "mesmo",
    "meu",
    "meus",
    "minha",
    "minhas",
    "muito",
    "na",
    "nas",
    "nem",
    "no",
    "nos",
    "nossa",
    "nossas",
    "nosso",
    "nossos",
    "num",
    "numa",
    "não",
    "nós",
    "o",
    "os",
    "ou",
    "para",
    "pela",
    "pelas",
    "pelo",
    "pelos",
    "por",
    "qual",
    "quando",
    "que",
    "quem",
    "se",
    "seja",
    "sejam",
    "sejamos",
    "sem",
    "serei",
    "seremos",
    "seria",
    "seriam",
    "será",
    "serão",
    "seríamos",
    "seu",
    "seus",
    "somos",
    "sou",
    "sua",
    "suas",
    "são",
    "só",
    "também",
    "te",
    "tem",
    "temos",
    "tenha",
    "tenham",
    "tenhamos",
    "tenho",
    "terei",
    "teremos",
    "teria",
    "teriam",
    "terá",
    "terão",
    "teríamos",
    "teu",
    "teus",
    "teve",
    "tinha",
    "tinham",
    "tive",
    "tivemos",
    "tiver",
    "tivera",
    "tiveram",
    "tiverem",
    "tivermos",
    "tivesse",
    "tivessem",
    "tivéramos",
    "tivéssemos",
    "tu",
    "tua",
    "tuas",
    "tém",
    "tínhamos",
    "um",
    "uma",
    "você",
    "vocês",
    "vos",
    "à",
    "às",
    "éramos",
]);

make_stemmer!(Algorithm::Portuguese);
