Plugin `..` only found in rlib format, but must be available in dylib format.

Erroneous code example:

`rlib-plugin.rs`
```ignore (needs-linkage-with-other-tests)
#![crate_type = "rlib"]
#![feature(rustc_private)]

extern crate rustc_middle;
extern crate rustc_driver;

use rustc_driver::plugin::Registry;

#[no_mangle]
fn __rustc_plugin_registrar(_: &mut Registry) {}
```

`main.rs`
```ignore (needs-linkage-with-other-tests)
#![feature(plugin)]
#![plugin(rlib_plugin)] // error: plugin `rlib_plugin` only found in rlib
                        //        format, but must be available in dylib

fn main() {}
```

The compiler exposes a plugin interface to allow altering the compile process
(adding lints, etc). Plugins must be defined in their own crates (similar to
[proc-macro](../reference/procedural-macros.html) isolation) and then compiled
and linked to another crate. Plugin crates *must* be compiled to the
dynamically-linked dylib format, and not the statically-linked rlib format.
Learn more about different output types in
[this section](../reference/linkage.html) of the Rust reference.

This error is easily fixed by recompiling the plugin crate in the dylib format.
