#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "cavity.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo  omega (argv[1]);
  space Xh = cavity_space (omega, "P2");
  space Qh (omega, "P1qd");
  trial u (Xh);
  trial p (Qh);
  test v (Xh), q (Qh);
  form a  = integrate (2*ddot(D(u),D(v)));
  form mp = integrate (p*q);
  form b  = integrate (-div(u)*q);
  field uh = cavity_field (Xh, 1);
  field ph (Qh, 0.);
  solver_abtb stokes (a.uu(), b.uu(), mp.uu());
  stokes.solve (-(a.ub()*uh.b()), -(b.ub()*uh.b()),
                uh.set_u(),       ph.set_u());
  dout << catchmark("u")  << uh
       << catchmark("p")  << ph;
}
