/*+++++++++++++++++
  linklist.h - header file for linklist.c
  markus@mhoenicka.de 7-11-00
  $Id: linklist.h,v 1.7.2.1 2004/09/26 21:07:05 mhoenicka Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#define LILIFSTRING_SIZE 256

/*********************************************************************
 linked list for file descriptors
********************************************************************/
 
typedef struct olili {
  int fd;                        /* file descriptor */
  struct olili *ptr_next;  /* pointer to next element in the list */
} Olili;

int insert_olili(Olili *ptr_first, int value);

int delete_olili(Olili *ptr_first, int value);

int max_olili(Olili *ptr_first);

/*********************************************************************
 linked list for allocated memory
********************************************************************/

typedef struct lilimem {
  void **ptr_mem; /* pointer to the pointer to the allocated memory */
  struct lilimem *ptr_next; /* pointer to the next element in the list */
  char varname[32]; /* name of the pointer to the allocated memory */
} Lilimem;

int insert_lilimem(Lilimem *ptr_first, void** ptr_mem, char* varname);

int delete_lilimem(Lilimem *ptr_first, char* varname);

int delete_all_lilimem(Lilimem *ptr_first);

/*********************************************************************
 linked list for decoding html form data
********************************************************************/

typedef struct liliform {
  char name[32]; /* name of the item */
  char* value; /* ptr to allocated memory with the value of the item */
  struct liliform *ptr_next; /* pointer to the next element in the list */
} Liliform;

int insert_liliform(Liliform *ptr_first, char* name, char* value);
int append_liliform(Liliform *ptr_first, char* name, char* value);

Liliform* get_liliform(Liliform* ptr_first, char* name);
Liliform* get_nliliform(Liliform* ptr_first, char* name, size_t n);
Liliform* get_next_liliform(Liliform* ptr_first);

int delete_all_liliform(Liliform *ptr_first);

/*********************************************************************
 linked list for reading non-standard field mapping for BibTeX data
********************************************************************/

typedef struct lilibib {
  char* name; /* name of the item */
  char* value; /* ptr to allocated memory with the value of the item */
  struct lilibib *ptr_next; /* pointer to the next element in the list */
} Lilibib;

int insert_lilibib(Lilibib *ptr_first, char* name, char* value);

Lilibib* get_next_lilibib(Lilibib* ptr_first);

Lilibib* get_lilibib(Lilibib* ptr_first, char* name);

int delete_all_lilibib(Lilibib *ptr_first);

/*********************************************************************
 linked list for ID values
********************************************************************/

typedef struct lilid {
  unsigned long long value; /*  value of the item */
  char is_duplicate; /* set to 1 if id is a duplicate */
  char is_existent; /* set to 1 if id exists */
  struct lilid *ptr_next; /* pointer to the next element in the list */
} Lilid;

int insert_lilid(Lilid *ptr_first, unsigned long long value);

Lilid* get_next_lilid(Lilid* ptr_first);

unsigned long long count_lilid(Lilid* ptr_first);

int delete_all_lilid(Lilid *ptr_first);

/*********************************************************************
 linked list for tokenizing strings
********************************************************************/

typedef struct lilistring {
  char* token; /* ptr to allocated memory with the value of the item */
  struct lilistring *ptr_next; /* pointer to the next element in the list */
} Lilistring;

int insert_lilistring(Lilistring *ptr_first, char* token);

int append_lilistring(Lilistring *ptr_first, char* token);

Lilistring* get_next_lilistring(Lilistring* ptr_first);

int delete_all_lilistring(Lilistring *ptr_first);

int count_lilistring(Lilistring* ptr_first);

/*********************************************************************
 linked list for fixed-size strings
********************************************************************/

typedef struct lilifstring {
  char token[LILIFSTRING_SIZE]; /* ptr to allocated memory with the value of the item */
  struct lilifstring *ptr_next; /* pointer to the next element in the list */
} Lilifstring;

int append_lilifstring(Lilifstring *ptr_first, char* token);

Lilifstring* get_next_lilifstring(Lilifstring* ptr_first);

int delete_all_lilifstring(Lilifstring *ptr_first);

char* find_lilifstring(Lilifstring* ptr_first, char* token);



