// --- Generated by AidaCxxStub ---

// --- Custom Includes ---
#ifndef __AIDA_UTILITIES_HH__
#include "clientapi.hh"
#endif


#ifndef AIDA_CHECK
#define AIDA_CHECK(cond,errmsg) do { if (cond) break; throw std::runtime_error (std::string ("AIDA-ERROR: ") + errmsg); } while (0)
#endif

namespace { // Anon
using Rapicorn::Aida::uint64;

namespace __AIDA_Local__ {
using namespace Rapicorn::Aida;

// connection
static Rapicorn::Aida::ClientConnection *client_connection = NULL;
static Rapicorn::Init init_client_connection ([]() {
  client_connection = ObjectBroker::new_client_connection (":Rapicorn1307:AidaClientConnection:CxxStub:idl_file=ui/interfaces.idl:");
});

// helper

static AIDA_UNUSED FieldBuffer*
invoke (FieldBuffer *fb)                // async remote call, transfers memory
{
  return client_connection->call_remote (fb);
}

static AIDA_UNUSED bool
signal_disconnect (size_t signal_handler_id)
{
  return client_connection->signal_disconnect (signal_handler_id);
}

static AIDA_UNUSED size_t
signal_connect (uint64 hhi, uint64 hlo, const SmartHandle &sh, SignalEmitHandler seh, void *data)
{
  return client_connection->signal_connect (hhi, hlo, sh._orbid(), seh, data);
}

static inline uint64
smh2id (const SmartHandle &sh)
{
  return sh._orbid();
}

template<class SMH> SMH
smh2cast (const SmartHandle &handle)
{
  const uint64 orbid = __AIDA_Local__::smh2id (handle);
  SMH target;
  struct Broker : ObjectBroker { using ObjectBroker::tie_handle; };
  Broker::tie_handle (target, orbid);
  return target;
}

static inline void
add_header2_call (FieldBuffer &fb, const SmartHandle &sh, uint64 h, uint64 l)
{
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, ObjectBroker::connection_id_from_handle (sh),
                  client_connection->connection_id(), h, l);
}

static inline void
add_header1_call (FieldBuffer &fb, const SmartHandle &sh, uint64 h, uint64 l)
{
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, ObjectBroker::connection_id_from_handle (sh), h, l);
}

static inline FieldBuffer*
new_emit_result (const FieldBuffer *fb, uint64 h, uint64 l, uint32 n)
{
  return ObjectBroker::renew_into_result (const_cast<FieldBuffer*> (fb),
                                          Rapicorn::Aida::MSGID_EMIT_RESULT,
                                          ObjectBroker::receiver_connection_id (fb->first_id()),
                                          h, l, n);
}

} } // Anon::__AIDA_Local__


// --- Implementations ---

namespace Rapicorn {
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const BoolSeq &self)
{
  const size_t len = self.size();
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  for (size_t k = 0; k < len; k++) {
    fb <<= self[k];
  }
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, BoolSeq &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  self.resize (len);
  for (size_t k = 0; k < len; k++) {
    fbr >>= self[k];
  }
}
BoolSeq::reference
BoolSeq::append_back()
{
  resize (size() + 1);
  return back();
}
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const StringSeq &self)
{
  const size_t len = self.size();
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  for (size_t k = 0; k < len; k++) {
    fb <<= self[k];
  }
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, StringSeq &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  self.resize (len);
  for (size_t k = 0; k < len; k++) {
    fbr >>= self[k];
  }
}
StringSeq::reference
StringSeq::append_back()
{
  resize (size() + 1);
  return back();
}
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const AnySeq &self)
{
  const size_t len = self.size();
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  for (size_t k = 0; k < len; k++) {
    fb <<= self[k];
  }
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, AnySeq &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  self.resize (len);
  for (size_t k = 0; k < len; k++) {
    fbr >>= self[k];
  }
}
AnySeq::reference
AnySeq::append_back()
{
  resize (size() + 1);
  return back();
}
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const AnySeqSeq &self)
{
  const size_t len = self.size();
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  for (size_t k = 0; k < len; k++) {
    fb <<= self[k];
  }
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, AnySeqSeq &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  self.resize (len);
  for (size_t k = 0; k < len; k++) {
    fbr >>= self[k];
  }
}
AnySeqSeq::reference
AnySeqSeq::append_back()
{
  resize (size() + 1);
  return back();
}
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const PixelSeq &self)
{
  const size_t len = self.size();
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  for (size_t k = 0; k < len; k++) {
    fb <<= self[k];
  }
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, PixelSeq &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  self.resize (len);
  for (size_t k = 0; k < len; k++) {
    fbr >>= self[k];
  }
}
PixelSeq::reference
PixelSeq::append_back()
{
  resize (size() + 1);
  return back();
}
bool
Pixbuf::operator== (const Pixbuf &other) const
{
  if (this->row_length != other.row_length) return false;
  if (this->pixels != other.pixels) return false;
  if (this->variables != other.variables) return false;
  return true;
}
void
Pixbuf::operator<<= (Rapicorn::Aida::Any &any)
{
  struct Any : public Rapicorn::Aida::Any { using Rapicorn::Aida::Any::any_to_record; };
  Any::any_to_record (any, *this);
}
void
operator<<= (Rapicorn::Aida::Any &any, const Pixbuf &rec)
{
  struct Any : public Rapicorn::Aida::Any { using Rapicorn::Aida::Any::any_from_record; };
  Any::any_from_record (any, rec);
}
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const Pixbuf &self)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (3);
  fb <<= self.row_length;
  fb <<= self.pixels;
  fb <<= self.variables;
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, Pixbuf &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() < 3) return;
  fbr >>= self.row_length;
  fbr >>= self.pixels;
  fbr >>= self.variables;
}
bool
UpdateSpan::operator== (const UpdateSpan &other) const
{
  if (this->start != other.start) return false;
  if (this->length != other.length) return false;
  return true;
}
void
UpdateSpan::operator<<= (Rapicorn::Aida::Any &any)
{
  struct Any : public Rapicorn::Aida::Any { using Rapicorn::Aida::Any::any_to_record; };
  Any::any_to_record (any, *this);
}
void
operator<<= (Rapicorn::Aida::Any &any, const UpdateSpan &rec)
{
  struct Any : public Rapicorn::Aida::Any { using Rapicorn::Aida::Any::any_from_record; };
  Any::any_from_record (any, rec);
}
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const UpdateSpan &self)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (2);
  fb <<= self.start;
  fb <<= self.length;
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, UpdateSpan &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() < 2) return;
  fbr >>= self.start;
  fbr >>= self.length;
}
bool
UpdateRequest::operator== (const UpdateRequest &other) const
{
  if (this->kind != other.kind) return false;
  if (this->rowspan != other.rowspan) return false;
  if (this->colspan != other.colspan) return false;
  if (this->variables != other.variables) return false;
  if (this->value != other.value) return false;
  return true;
}
void
UpdateRequest::operator<<= (Rapicorn::Aida::Any &any)
{
  struct Any : public Rapicorn::Aida::Any { using Rapicorn::Aida::Any::any_to_record; };
  Any::any_to_record (any, *this);
}
void
operator<<= (Rapicorn::Aida::Any &any, const UpdateRequest &rec)
{
  struct Any : public Rapicorn::Aida::Any { using Rapicorn::Aida::Any::any_from_record; };
  Any::any_from_record (any, rec);
}
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const UpdateRequest &self)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (5);
  fb <<= self.kind;
  fb <<= self.rowspan;
  fb <<= self.colspan;
  fb <<= self.variables;
  fb <<= self.value;
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, UpdateRequest &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() < 5) return;
  fbr >>= self.kind;
  fbr >>= self.rowspan;
  fbr >>= self.colspan;
  fbr >>= self.variables;
  fbr >>= self.value;
}
static Rapicorn::Aida::FieldBuffer*
__aida_emit1__ListModelHandle__updated (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  auto fptr = (const std::function<void (const UpdateRequest &urequest)>*) data;
  if (AIDA_UNLIKELY (!sfb)) { delete fptr; return NULL; }
  Rapicorn::Aida::uint64 emit_result_id;
  Rapicorn::Aida::field_buffer_emit_signal (*sfb, *fptr, emit_result_id);
  return NULL;
}
size_t
ListModelHandle::__aida_connect__updated (size_t signal_handler_id, const std::function<void (const UpdateRequest &urequest)> &func)
{
  if (signal_handler_id)
    return __AIDA_Local__::signal_disconnect (signal_handler_id);
  void *fptr = new std::function<void (const UpdateRequest &urequest)> (func);
  return __AIDA_Local__::signal_connect (0xed8b8e157d8e8b09ULL, 0x40f08ab74596907eULL, *this, __aida_emit1__ListModelHandle__updated, fptr);
}
ListModelHandle::ListModelHandle ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, const ListModelHandle &handle)
{
  fb.add_object (__AIDA_Local__::smh2id (handle));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, ListModelHandle &handle)
{
  Rapicorn::Aida::ObjectBroker::pop_handle (fbr, handle);
}
const Rapicorn::Aida::TypeHash&
ListModelHandle::__aida_typeid__()
{
  static const Rapicorn::Aida::TypeHash type_hash = Rapicorn::Aida::TypeHash (0x87df0968192d4892ULL, 0xd8aa6bcd9795c903ULL);
  return type_hash;
}
ListModelHandle
ListModelHandle::__aida_cast__ (Rapicorn::Aida::SmartHandle &other, const Rapicorn::Aida::TypeHashList &types)
{
  size_t i; const Rapicorn::Aida::TypeHash &mine = __aida_typeid__();
  for (i = 0; i < types.size(); i++)
    if (mine == types[i])
      return __AIDA_Local__::smh2cast<ListModelHandle> (other);
  return ListModelHandle();
}
Rapicorn::Aida::BaseConnection*
ListModelHandle::__aida_connection__()
{
  return __AIDA_Local__::client_connection;
}
const Rapicorn::Aida::TypeHashList
ListModelHandle::__aida_typelist__()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
  __AIDA_Local__::add_header2_call (fb, *this, 0x7d38659266bcc806ULL, 0x7150e9f047ddfeedULL);
  fb <<= *this;
  Rapicorn::Aida::FieldBuffer *fr = __AIDA_Local__::invoke (&fb);
  AIDA_CHECK (fr != NULL, "missing result from 2-way call");
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  size_t len;
  frr >>= len;
  AIDA_CHECK (frr.remaining() == len * 2, "result truncated");
  Rapicorn::Aida::TypeHashList thl;
  Rapicorn::Aida::TypeHash thash;
  for (size_t i = 0; i < len; i++) {
    frr >>= thash;
    thl.push_back (thash);
  }
  delete fr;
  return thl;
}
int
ListModelHandle::count ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x9093828fc77e641aULL, 0x7e188ef4a3a95df1ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  int  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
Rapicorn::Aida::Any
ListModelHandle::row (int arg_index)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x0daa87bb937470ceULL, 0xac2cfd46e1de2fe3ULL);
  fb <<= *this;
  fb <<= arg_index;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  Rapicorn::Aida::Any  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
static Rapicorn::Aida::FieldBuffer*
__aida_emit1__ListModelRelayHandle__refill (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  auto fptr = (const std::function<void (const UpdateRequest &urequest)>*) data;
  if (AIDA_UNLIKELY (!sfb)) { delete fptr; return NULL; }
  Rapicorn::Aida::uint64 emit_result_id;
  Rapicorn::Aida::field_buffer_emit_signal (*sfb, *fptr, emit_result_id);
  return NULL;
}
size_t
ListModelRelayHandle::__aida_connect__refill (size_t signal_handler_id, const std::function<void (const UpdateRequest &urequest)> &func)
{
  if (signal_handler_id)
    return __AIDA_Local__::signal_disconnect (signal_handler_id);
  void *fptr = new std::function<void (const UpdateRequest &urequest)> (func);
  return __AIDA_Local__::signal_connect (0xfc80c8eeadcb6268ULL, 0x14b0db287fc04b3dULL, *this, __aida_emit1__ListModelRelayHandle__refill, fptr);
}
ListModelRelayHandle::ListModelRelayHandle ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, const ListModelRelayHandle &handle)
{
  fb.add_object (__AIDA_Local__::smh2id (handle));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, ListModelRelayHandle &handle)
{
  Rapicorn::Aida::ObjectBroker::pop_handle (fbr, handle);
}
const Rapicorn::Aida::TypeHash&
ListModelRelayHandle::__aida_typeid__()
{
  static const Rapicorn::Aida::TypeHash type_hash = Rapicorn::Aida::TypeHash (0x3e993ff1349c815cULL, 0x7280939def52d4e9ULL);
  return type_hash;
}
ListModelRelayHandle
ListModelRelayHandle::__aida_cast__ (Rapicorn::Aida::SmartHandle &other, const Rapicorn::Aida::TypeHashList &types)
{
  size_t i; const Rapicorn::Aida::TypeHash &mine = __aida_typeid__();
  for (i = 0; i < types.size(); i++)
    if (mine == types[i])
      return __AIDA_Local__::smh2cast<ListModelRelayHandle> (other);
  return ListModelRelayHandle();
}
Rapicorn::Aida::BaseConnection*
ListModelRelayHandle::__aida_connection__()
{
  return __AIDA_Local__::client_connection;
}
const Rapicorn::Aida::TypeHashList
ListModelRelayHandle::__aida_typelist__()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
  __AIDA_Local__::add_header2_call (fb, *this, 0x6f68d0e884a2ebdbULL, 0xdd54f615e10593caULL);
  fb <<= *this;
  Rapicorn::Aida::FieldBuffer *fr = __AIDA_Local__::invoke (&fb);
  AIDA_CHECK (fr != NULL, "missing result from 2-way call");
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  size_t len;
  frr >>= len;
  AIDA_CHECK (frr.remaining() == len * 2, "result truncated");
  Rapicorn::Aida::TypeHashList thl;
  Rapicorn::Aida::TypeHash thash;
  for (size_t i = 0; i < len; i++) {
    frr >>= thash;
    thl.push_back (thash);
  }
  delete fr;
  return thl;
}
ListModelHandle
ListModelRelayHandle::model ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x1e82ea1bf240ad5fULL, 0x2c8e4f655a3f3e8fULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  ListModelHandle  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
ListModelRelayHandle::fill (int arg_first,
                            const AnySeq &arg_asq)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 2), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x0bed2f670b7f4b6fULL, 0x46b9d94fd813c92dULL);
  fb <<= *this;
  fb <<= arg_first;
  fb <<= arg_asq;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
void
ListModelRelayHandle::update (const UpdateRequest &arg_urequest)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x9690b77b0d6f60e8ULL, 0x096dab753c1eac81ULL);
  fb <<= *this;
  fb <<= arg_urequest;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
bool
Requisition::operator== (const Requisition &other) const
{
  if (this->width != other.width) return false;
  if (this->height != other.height) return false;
  return true;
}
void
Requisition::operator<<= (Rapicorn::Aida::Any &any)
{
  struct Any : public Rapicorn::Aida::Any { using Rapicorn::Aida::Any::any_to_record; };
  Any::any_to_record (any, *this);
}
void
operator<<= (Rapicorn::Aida::Any &any, const Requisition &rec)
{
  struct Any : public Rapicorn::Aida::Any { using Rapicorn::Aida::Any::any_from_record; };
  Any::any_from_record (any, rec);
}
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const Requisition &self)
{
  Rapicorn::Aida::FieldBuffer &fb = dst.add_rec (2);
  fb <<= self.width;
  fb <<= self.height;
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, Requisition &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_rec());
  if (fbr.remaining() < 2) return;
  fbr >>= self.width;
  fbr >>= self.height;
}
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const WidgetSeq &self)
{
  const size_t len = self.size();
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  for (size_t k = 0; k < len; k++) {
    fb <<= self[k];
  }
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, WidgetSeq &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  self.reserve (len);
  for (size_t k = 0; k < len; k++) {
    fbr >>= self[k];
  }
}
WidgetSeq::reference
WidgetSeq::append_back()
{
  resize (size() + 1);
  return back();
}
WidgetHandle::WidgetHandle ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, const WidgetHandle &handle)
{
  fb.add_object (__AIDA_Local__::smh2id (handle));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, WidgetHandle &handle)
{
  Rapicorn::Aida::ObjectBroker::pop_handle (fbr, handle);
}
const Rapicorn::Aida::TypeHash&
WidgetHandle::__aida_typeid__()
{
  static const Rapicorn::Aida::TypeHash type_hash = Rapicorn::Aida::TypeHash (0x3da86581a5b52b19ULL, 0x84b2d8e05389bdd5ULL);
  return type_hash;
}
WidgetHandle
WidgetHandle::__aida_cast__ (Rapicorn::Aida::SmartHandle &other, const Rapicorn::Aida::TypeHashList &types)
{
  size_t i; const Rapicorn::Aida::TypeHash &mine = __aida_typeid__();
  for (i = 0; i < types.size(); i++)
    if (mine == types[i])
      return __AIDA_Local__::smh2cast<WidgetHandle> (other);
  return WidgetHandle();
}
Rapicorn::Aida::BaseConnection*
WidgetHandle::__aida_connection__()
{
  return __AIDA_Local__::client_connection;
}
const Rapicorn::Aida::TypeHashList
WidgetHandle::__aida_typelist__()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
  __AIDA_Local__::add_header2_call (fb, *this, 0x1eb6c5178436ad26ULL, 0x9f4a4699676886d5ULL);
  fb <<= *this;
  Rapicorn::Aida::FieldBuffer *fr = __AIDA_Local__::invoke (&fb);
  AIDA_CHECK (fr != NULL, "missing result from 2-way call");
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  size_t len;
  frr >>= len;
  AIDA_CHECK (frr.remaining() == len * 2, "result truncated");
  Rapicorn::Aida::TypeHashList thl;
  Rapicorn::Aida::TypeHash thash;
  for (size_t i = 0; i < len; i++) {
    frr >>= thash;
    thl.push_back (thash);
  }
  delete fr;
  return thl;
}
std::string
WidgetHandle::name () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x031285308fcdf2a6ULL, 0xe4751a850e1e28fdULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  std::string  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::name (const std::string &value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x5026ef8ea4009c59ULL, 0xb565349b095e6e11ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::width () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x84994bfcea433d65ULL, 0x11da4bfc5c624c8fULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::width (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x0cd03fe5fa594ec6ULL, 0x91842d18a1c6ebd6ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::height () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x35f842828c2bfa77ULL, 0x1884ebea3e98dbbfULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::height (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x44727037ddf45655ULL, 0x944fff4d9b1cc0a5ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WidgetHandle::hexpand () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xddc9455b83b5c9e3ULL, 0x673d77bbb37b6468ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::hexpand (bool value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x724a878f038650dcULL, 0x8e3a406bfebdc7d5ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WidgetHandle::vexpand () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xf0a4b0e20f0cd5fdULL, 0xdfabca8039302e55ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::vexpand (bool value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x333e8c0864c70ff0ULL, 0x83dd04bc7aac68beULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WidgetHandle::hspread () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x5ac252d6317e7d36ULL, 0x98a184e2844406e8ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::hspread (bool value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xe6dd3929668db66cULL, 0x9da336ba53f08a18ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WidgetHandle::vspread () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x391f095f19534988ULL, 0xf4867a2ebaa3c794ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::vspread (bool value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x508f008b21de58c9ULL, 0xcc23c5365cf017f6ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WidgetHandle::hshrink () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x251603c131c31f86ULL, 0x5dff639bd6c70e19ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::hshrink (bool value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xc357c2e04f0cc762ULL, 0x2bd324458ce3b86bULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WidgetHandle::vshrink () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x43c07cf21c154377ULL, 0x499474085275cd26ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::vshrink (bool value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x89ca7aa832131675ULL, 0x8084f9d24773b4cfULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WidgetHandle::visible () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x70842a509744bcb9ULL, 0xc07e68d369809582ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::visible (bool value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xae2e9f4866d97f9eULL, 0x4683fac44e7200deULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WidgetHandle::sensitive () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x480267748b1cbcccULL, 0xc09ac65197b64c3bULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::sensitive (bool value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x8464c27dd920075aULL, 0xe21827b12655c61dULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::hposition () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x26e5b794bb960060ULL, 0x8680536d636a3351ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::hposition (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xddfa6b7010466243ULL, 0xd82688a5e9656bd1ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::hspan () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x5eeb1641d7c3b52dULL, 0xb9dc0b7b3ea6e31aULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::hspan (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x91985befb9eea32dULL, 0x3ec215657b01a35cULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::vposition () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x74aeb757e09afcfdULL, 0x968359ce2c9c7849ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::vposition (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xccab42e4e4499f3aULL, 0x301bc5a7a254f720ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::vspan () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x2a12130db96b5ae9ULL, 0x00d0b705609fd4feULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::vspan (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xd64f52c7e4ffa97bULL, 0x95b7e3fb29643c1aULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
int
WidgetHandle::left_spacing () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x969c1084b85dd454ULL, 0xf16cdb02bbacbb3bULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  int  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::left_spacing (int value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x4f438c0e21c50f88ULL, 0x222e4001cce7a184ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
int
WidgetHandle::right_spacing () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x4c38330e86f21375ULL, 0xa3c2608930578e4dULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  int  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::right_spacing (int value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xd715d734aed172deULL, 0x5a4a1e8fccef99b5ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
int
WidgetHandle::bottom_spacing () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x1c7b00a54d4cab7eULL, 0xb2946b8d608eb312ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  int  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::bottom_spacing (int value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x53a63624185de070ULL, 0xd6a284ee64e16a6eULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
int
WidgetHandle::top_spacing () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xe7c94f940a362078ULL, 0xbfc0002e602aab18ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  int  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::top_spacing (int value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xc12ba3fcd5434db4ULL, 0x498fe76a23fe2f0cULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::hanchor () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xbaedd681aec0abc2ULL, 0x5cbd3da8d0dff05cULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::hanchor (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x1f1291c258eb0675ULL, 0x83123a4f1a6fb70bULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::vanchor () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x4421c5e41bc6ac93ULL, 0x1feaa29a57b54407ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::vanchor (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x19ba251d69d93619ULL, 0xb211d94cbd2b506dULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::halign () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x2b61614a4e727c24ULL, 0x49420277ff5bc98bULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::halign (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x59e6d2545ef9bd6eULL, 0xfc3cea9abfb4bb2dULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::hscale () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x84016e98460561a1ULL, 0xdfe2267757460248ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::hscale (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x06426644521ee976ULL, 0x91a45c0cb7fe67ccULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::valign () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x311f02f1f9878086ULL, 0x3c26a48be3bb42d5ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::valign (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xe2f20a1445d3a32bULL, 0xeb1ea30552ffe2b9ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
WidgetHandle::vscale () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x4673932466b5324fULL, 0x119e3992a3be264fULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::vscale (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x65ab326ea2d56bd4ULL, 0x3177534f494db9e5ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
ColorSchemeType
WidgetHandle::color_scheme () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x7670b7ba59b09d8fULL, 0xf67517302113137fULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  ColorSchemeType  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetHandle::color_scheme (ColorSchemeType value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x955c720e722e97ddULL, 0x605fd029288e16baULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WidgetHandle::match_selector (const std::string &arg_selector)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x50ee99f8844291f4ULL, 0x3f72b3646a1a7bc7ULL);
  fb <<= *this;
  fb <<= arg_selector;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
WidgetHandle
WidgetHandle::query_selector (const std::string &arg_selector)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xb6980840cde71811ULL, 0xb14e1aa50e08cfd8ULL);
  fb <<= *this;
  fb <<= arg_selector;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  WidgetHandle  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
WidgetSeq
WidgetHandle::query_selector_all (const std::string &arg_selector)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x2a5a8ff0a59cad2eULL, 0x26413f36b146fff0ULL);
  fb <<= *this;
  fb <<= arg_selector;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  WidgetSeq  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
WidgetHandle
WidgetHandle::query_selector_unique (const std::string &arg_selector)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x715164b16827bbd1ULL, 0xcebbbc9e7141d970ULL);
  fb <<= *this;
  fb <<= arg_selector;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  WidgetHandle  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
std::string
WidgetHandle::test_dump ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x75dec9a4cbbbb05dULL, 0xfb37a5dfc1f63ea7ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  std::string  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
ContainerHandle::ContainerHandle ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, const ContainerHandle &handle)
{
  fb.add_object (__AIDA_Local__::smh2id (handle));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, ContainerHandle &handle)
{
  Rapicorn::Aida::ObjectBroker::pop_handle (fbr, handle);
}
const Rapicorn::Aida::TypeHash&
ContainerHandle::__aida_typeid__()
{
  static const Rapicorn::Aida::TypeHash type_hash = Rapicorn::Aida::TypeHash (0x5bab3a4c9bcaeca4ULL, 0x0be9b6d2440be3c0ULL);
  return type_hash;
}
ContainerHandle
ContainerHandle::__aida_cast__ (Rapicorn::Aida::SmartHandle &other, const Rapicorn::Aida::TypeHashList &types)
{
  size_t i; const Rapicorn::Aida::TypeHash &mine = __aida_typeid__();
  for (i = 0; i < types.size(); i++)
    if (mine == types[i])
      return __AIDA_Local__::smh2cast<ContainerHandle> (other);
  return ContainerHandle();
}
const Rapicorn::Aida::TypeHashList
ContainerHandle::__aida_typelist__()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
  __AIDA_Local__::add_header2_call (fb, *this, 0x9c4a47a4b32f090eULL, 0x8aa78fc1673af212ULL);
  fb <<= *this;
  Rapicorn::Aida::FieldBuffer *fr = __AIDA_Local__::invoke (&fb);
  AIDA_CHECK (fr != NULL, "missing result from 2-way call");
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  size_t len;
  frr >>= len;
  AIDA_CHECK (frr.remaining() == len * 2, "result truncated");
  Rapicorn::Aida::TypeHashList thl;
  Rapicorn::Aida::TypeHash thash;
  for (size_t i = 0; i < len; i++) {
    frr >>= thash;
    thl.push_back (thash);
  }
  delete fr;
  return thl;
}
WidgetHandle
ContainerHandle::create_child (const std::string &arg_widget_identifier,
                               const StringSeq &arg_args)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 2), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xc81e0c8eda464c21ULL, 0xf8e1a41941ea388aULL);
  fb <<= *this;
  fb <<= arg_widget_identifier;
  fb <<= arg_args;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  WidgetHandle  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
ButtonAreaHandle::ButtonAreaHandle ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, const ButtonAreaHandle &handle)
{
  fb.add_object (__AIDA_Local__::smh2id (handle));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, ButtonAreaHandle &handle)
{
  Rapicorn::Aida::ObjectBroker::pop_handle (fbr, handle);
}
const Rapicorn::Aida::TypeHash&
ButtonAreaHandle::__aida_typeid__()
{
  static const Rapicorn::Aida::TypeHash type_hash = Rapicorn::Aida::TypeHash (0xd4eba9953fe88dd9ULL, 0x084b6a3a8f6103afULL);
  return type_hash;
}
ButtonAreaHandle
ButtonAreaHandle::__aida_cast__ (Rapicorn::Aida::SmartHandle &other, const Rapicorn::Aida::TypeHashList &types)
{
  size_t i; const Rapicorn::Aida::TypeHash &mine = __aida_typeid__();
  for (i = 0; i < types.size(); i++)
    if (mine == types[i])
      return __AIDA_Local__::smh2cast<ButtonAreaHandle> (other);
  return ButtonAreaHandle();
}
const Rapicorn::Aida::TypeHashList
ButtonAreaHandle::__aida_typelist__()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
  __AIDA_Local__::add_header2_call (fb, *this, 0x7d902f094f7403e7ULL, 0x815021369aaa2481ULL);
  fb <<= *this;
  Rapicorn::Aida::FieldBuffer *fr = __AIDA_Local__::invoke (&fb);
  AIDA_CHECK (fr != NULL, "missing result from 2-way call");
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  size_t len;
  frr >>= len;
  AIDA_CHECK (frr.remaining() == len * 2, "result truncated");
  Rapicorn::Aida::TypeHashList thl;
  Rapicorn::Aida::TypeHash thash;
  for (size_t i = 0; i < len; i++) {
    frr >>= thash;
    thl.push_back (thash);
  }
  delete fr;
  return thl;
}
std::string
ButtonAreaHandle::on_click () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xbe7282d89a4d4db2ULL, 0xb502688e28a880f6ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  std::string  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
ButtonAreaHandle::on_click (const std::string &value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x88e789a391ea37c1ULL, 0x0434df5f75f1e2bcULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
std::string
ButtonAreaHandle::on_click2 () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x27fae01da2300e44ULL, 0x3751b59e63d8e18fULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  std::string  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
ButtonAreaHandle::on_click2 (const std::string &value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x2e918c010d23b831ULL, 0xc38a590f18096fa4ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
std::string
ButtonAreaHandle::on_click3 () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x647626f32ffb2149ULL, 0xc0dbd63ec713a0eeULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  std::string  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
ButtonAreaHandle::on_click3 (const std::string &value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x9175e48a1888ca49ULL, 0xb545bdc3a3d046caULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
static Rapicorn::Aida::FieldBuffer*
__aida_emit1__DrawableHandle__redraw (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  auto fptr = (const std::function<void (int x, int y, int w, int h)>*) data;
  if (AIDA_UNLIKELY (!sfb)) { delete fptr; return NULL; }
  Rapicorn::Aida::uint64 emit_result_id;
  Rapicorn::Aida::field_buffer_emit_signal (*sfb, *fptr, emit_result_id);
  return NULL;
}
size_t
DrawableHandle::__aida_connect__redraw (size_t signal_handler_id, const std::function<void (int x, int y, int w, int h)> &func)
{
  if (signal_handler_id)
    return __AIDA_Local__::signal_disconnect (signal_handler_id);
  void *fptr = new std::function<void (int x, int y, int w, int h)> (func);
  return __AIDA_Local__::signal_connect (0xd532d8c1fad1e432ULL, 0xf03f2c52dfc54458ULL, *this, __aida_emit1__DrawableHandle__redraw, fptr);
}
DrawableHandle::DrawableHandle ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, const DrawableHandle &handle)
{
  fb.add_object (__AIDA_Local__::smh2id (handle));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, DrawableHandle &handle)
{
  Rapicorn::Aida::ObjectBroker::pop_handle (fbr, handle);
}
const Rapicorn::Aida::TypeHash&
DrawableHandle::__aida_typeid__()
{
  static const Rapicorn::Aida::TypeHash type_hash = Rapicorn::Aida::TypeHash (0x4c89f0cb4cc5fd40ULL, 0x6176a2cb29385095ULL);
  return type_hash;
}
DrawableHandle
DrawableHandle::__aida_cast__ (Rapicorn::Aida::SmartHandle &other, const Rapicorn::Aida::TypeHashList &types)
{
  size_t i; const Rapicorn::Aida::TypeHash &mine = __aida_typeid__();
  for (i = 0; i < types.size(); i++)
    if (mine == types[i])
      return __AIDA_Local__::smh2cast<DrawableHandle> (other);
  return DrawableHandle();
}
const Rapicorn::Aida::TypeHashList
DrawableHandle::__aida_typelist__()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
  __AIDA_Local__::add_header2_call (fb, *this, 0xee9c9cb8c4d1307cULL, 0xd09e7006446b4901ULL);
  fb <<= *this;
  Rapicorn::Aida::FieldBuffer *fr = __AIDA_Local__::invoke (&fb);
  AIDA_CHECK (fr != NULL, "missing result from 2-way call");
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  size_t len;
  frr >>= len;
  AIDA_CHECK (frr.remaining() == len * 2, "result truncated");
  Rapicorn::Aida::TypeHashList thl;
  Rapicorn::Aida::TypeHash thash;
  for (size_t i = 0; i < len; i++) {
    frr >>= thash;
    thl.push_back (thash);
  }
  delete fr;
  return thl;
}
void
DrawableHandle::draw_rect (int arg_x,
                           int arg_y,
                           const Pixbuf &arg_pixbuf)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 3), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x427a0b8bb25f6a0bULL, 0xa6474d1708083aefULL);
  fb <<= *this;
  fb <<= arg_x;
  fb <<= arg_y;
  fb <<= arg_pixbuf;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
WidgetListHandle::WidgetListHandle ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, const WidgetListHandle &handle)
{
  fb.add_object (__AIDA_Local__::smh2id (handle));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, WidgetListHandle &handle)
{
  Rapicorn::Aida::ObjectBroker::pop_handle (fbr, handle);
}
const Rapicorn::Aida::TypeHash&
WidgetListHandle::__aida_typeid__()
{
  static const Rapicorn::Aida::TypeHash type_hash = Rapicorn::Aida::TypeHash (0x4d8f55734db02590ULL, 0xb0027c1cf106e90eULL);
  return type_hash;
}
WidgetListHandle
WidgetListHandle::__aida_cast__ (Rapicorn::Aida::SmartHandle &other, const Rapicorn::Aida::TypeHashList &types)
{
  size_t i; const Rapicorn::Aida::TypeHash &mine = __aida_typeid__();
  for (i = 0; i < types.size(); i++)
    if (mine == types[i])
      return __AIDA_Local__::smh2cast<WidgetListHandle> (other);
  return WidgetListHandle();
}
const Rapicorn::Aida::TypeHashList
WidgetListHandle::__aida_typelist__()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
  __AIDA_Local__::add_header2_call (fb, *this, 0x3c0806880c00ee21ULL, 0xba294ea0987c7747ULL);
  fb <<= *this;
  Rapicorn::Aida::FieldBuffer *fr = __AIDA_Local__::invoke (&fb);
  AIDA_CHECK (fr != NULL, "missing result from 2-way call");
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  size_t len;
  frr >>= len;
  AIDA_CHECK (frr.remaining() == len * 2, "result truncated");
  Rapicorn::Aida::TypeHashList thl;
  Rapicorn::Aida::TypeHash thash;
  for (size_t i = 0; i < len; i++) {
    frr >>= thash;
    thl.push_back (thash);
  }
  delete fr;
  return thl;
}
std::string
WidgetListHandle::model () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x4999e64ab90f03a7ULL, 0xd525a0168740dd66ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  std::string  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetListHandle::model (const std::string &value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x39a6bb1dc5eff4f9ULL, 0x42c05f294d1b00f3ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
SelectionMode
WidgetListHandle::selection_mode () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x5572708a0378ba2eULL, 0xfd88c7c5701a1722ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  SelectionMode  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetListHandle::selection_mode (SelectionMode value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x2f02df4c7a4eff82ULL, 0x72f84ea8f7e123c9ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
void
WidgetListHandle::set_selection (const BoolSeq &arg_selection)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x932e82327a246153ULL, 0x53f25bb2a40e9493ULL);
  fb <<= *this;
  fb <<= arg_selection;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
BoolSeq
WidgetListHandle::get_selection ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x0eb72284726bafd2ULL, 0xc342e747310feaadULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  BoolSeq  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WidgetListHandle::select_range (int arg_first,
                                int arg_length)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 2), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x4a4be90ab0872e85ULL, 0xeeb47b4e4aad638eULL);
  fb <<= *this;
  fb <<= arg_first;
  fb <<= arg_length;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
void
WidgetListHandle::unselect_range (int arg_first,
                                  int arg_length)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 2), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x5e82a812571a8217ULL, 0x098fb142226cddbdULL);
  fb <<= *this;
  fb <<= arg_first;
  fb <<= arg_length;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
static Rapicorn::Aida::FieldBuffer*
__aida_emit2__WindowHandle__commands (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  auto fptr = (const std::function<bool (const std::string &cmdname, const StringSeq &args)>*) data;
  if (AIDA_UNLIKELY (!sfb)) { delete fptr; return NULL; }
  Rapicorn::Aida::uint64 emit_result_id;
  bool  rval = Rapicorn::Aida::field_buffer_emit_signal (*sfb, *fptr, emit_result_id);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_emit_result (sfb, 0x036b33fe77a44de3ULL, 0x1defbbcde7bdeb68ULL, 2);
  rb <<= emit_result_id;
  rb <<= rval;
  return &rb;
}
size_t
WindowHandle::__aida_connect__commands (size_t signal_handler_id, const std::function<bool (const std::string &cmdname, const StringSeq &args)> &func)
{
  if (signal_handler_id)
    return __AIDA_Local__::signal_disconnect (signal_handler_id);
  void *fptr = new std::function<bool (const std::string &cmdname, const StringSeq &args)> (func);
  return __AIDA_Local__::signal_connect (0x036b33fe77a44de3ULL, 0x1defbbcde7bdeb68ULL, *this, __aida_emit2__WindowHandle__commands, fptr);
}
static Rapicorn::Aida::FieldBuffer*
__aida_emit1__WindowHandle__displayed (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  auto fptr = (const std::function<void ()>*) data;
  if (AIDA_UNLIKELY (!sfb)) { delete fptr; return NULL; }
  Rapicorn::Aida::uint64 emit_result_id;
  Rapicorn::Aida::field_buffer_emit_signal (*sfb, *fptr, emit_result_id);
  return NULL;
}
size_t
WindowHandle::__aida_connect__displayed (size_t signal_handler_id, const std::function<void ()> &func)
{
  if (signal_handler_id)
    return __AIDA_Local__::signal_disconnect (signal_handler_id);
  void *fptr = new std::function<void ()> (func);
  return __AIDA_Local__::signal_connect (0x365ae114cf8798c3ULL, 0x94974b0699c1d4afULL, *this, __aida_emit1__WindowHandle__displayed, fptr);
}
WindowHandle::WindowHandle ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, const WindowHandle &handle)
{
  fb.add_object (__AIDA_Local__::smh2id (handle));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, WindowHandle &handle)
{
  Rapicorn::Aida::ObjectBroker::pop_handle (fbr, handle);
}
const Rapicorn::Aida::TypeHash&
WindowHandle::__aida_typeid__()
{
  static const Rapicorn::Aida::TypeHash type_hash = Rapicorn::Aida::TypeHash (0x1eb140f8125ad2ebULL, 0xbf9a6a7ebeee4b3eULL);
  return type_hash;
}
WindowHandle
WindowHandle::__aida_cast__ (Rapicorn::Aida::SmartHandle &other, const Rapicorn::Aida::TypeHashList &types)
{
  size_t i; const Rapicorn::Aida::TypeHash &mine = __aida_typeid__();
  for (i = 0; i < types.size(); i++)
    if (mine == types[i])
      return __AIDA_Local__::smh2cast<WindowHandle> (other);
  return WindowHandle();
}
const Rapicorn::Aida::TypeHashList
WindowHandle::__aida_typelist__()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
  __AIDA_Local__::add_header2_call (fb, *this, 0x6b4ee5cb5ac8b0a5ULL, 0x25beb0b83c4fab4bULL);
  fb <<= *this;
  Rapicorn::Aida::FieldBuffer *fr = __AIDA_Local__::invoke (&fb);
  AIDA_CHECK (fr != NULL, "missing result from 2-way call");
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  size_t len;
  frr >>= len;
  AIDA_CHECK (frr.remaining() == len * 2, "result truncated");
  Rapicorn::Aida::TypeHashList thl;
  Rapicorn::Aida::TypeHash thash;
  for (size_t i = 0; i < len; i++) {
    frr >>= thash;
    thl.push_back (thash);
  }
  delete fr;
  return thl;
}
std::string
WindowHandle::title () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x7385d837fddf4fc3ULL, 0x911665dbc59fd048ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  std::string  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WindowHandle::title (const std::string &value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x843eb5873003739bULL, 0x36826a9d2e9a0580ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WindowHandle::auto_focus () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x918fdef4f4ee722bULL, 0xb5bf9280f27e1b14ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WindowHandle::auto_focus (bool value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xc57f5c7ac8896aa7ULL, 0xf59a1654889d2eacULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
bool
WindowHandle::viewable ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xe0170f6a2d0c589aULL, 0xa3d2fa8184318ffcULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WindowHandle::show ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xe1063b18ff934735ULL, 0xe5ee95b1c597896dULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
bool
WindowHandle::closed ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xeb10e015ba34c84dULL, 0x4f4b8541207e754dULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
WindowHandle::close ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x2b8bf0726c952d0fULL, 0x1b49d505c740ba23ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
bool
WindowHandle::snapshot (const std::string &arg_pngname)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x7d9839fc1a8fc039ULL, 0x48afcf806e3f4ca8ULL);
  fb <<= *this;
  fb <<= arg_pngname;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
bool
WindowHandle::synthesize_click (WidgetHandle &arg_widget,
                                int arg_button,
                                double arg_xalign,
                                double arg_yalign)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 4), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x4f10f82b1f848a99ULL, 0x1a95300acb24ac2cULL);
  fb <<= *this;
  fb <<= arg_widget;
  fb <<= arg_button;
  fb <<= arg_xalign;
  fb <<= arg_yalign;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
bool
WindowHandle::synthesize_enter (double arg_xalign,
                                double arg_yalign)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 2), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xf3e41fc141e2f661ULL, 0x8fcbc461d2bfec4dULL);
  fb <<= *this;
  fb <<= arg_xalign;
  fb <<= arg_yalign;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
bool
WindowHandle::synthesize_leave ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xa4318a90eb7b22a7ULL, 0xce24499e920f9204ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
bool
WindowHandle::synthesize_delete ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x73a213ef280c28abULL, 0x190baa31ddaee3a4ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
inline void __attribute__ ((used))
operator<<= (Rapicorn::Aida::FieldBuffer &dst, const WindowList &self)
{
  const size_t len = self.size();
  Rapicorn::Aida::FieldBuffer &fb = dst.add_seq (len);
  for (size_t k = 0; k < len; k++) {
    fb <<= self[k];
  }
}
inline void __attribute__ ((used))
operator>>= (Rapicorn::Aida::FieldReader &src, WindowList &self)
{
  Rapicorn::Aida::FieldReader fbr (src.pop_seq());
  const size_t len = fbr.remaining();
  self.reserve (len);
  for (size_t k = 0; k < len; k++) {
    fbr >>= self[k];
  }
}
WindowList::reference
WindowList::append_back()
{
  resize (size() + 1);
  return back();
}
static Rapicorn::Aida::FieldBuffer*
__aida_emit1__ApplicationHandle__missing_primary (const Rapicorn::Aida::FieldBuffer *sfb, void *data)
{
  auto fptr = (const std::function<void ()>*) data;
  if (AIDA_UNLIKELY (!sfb)) { delete fptr; return NULL; }
  Rapicorn::Aida::uint64 emit_result_id;
  Rapicorn::Aida::field_buffer_emit_signal (*sfb, *fptr, emit_result_id);
  return NULL;
}
size_t
ApplicationHandle::__aida_connect__missing_primary (size_t signal_handler_id, const std::function<void ()> &func)
{
  if (signal_handler_id)
    return __AIDA_Local__::signal_disconnect (signal_handler_id);
  void *fptr = new std::function<void ()> (func);
  return __AIDA_Local__::signal_connect (0x090deb4506e6fb55ULL, 0x78791c7dd48e0029ULL, *this, __aida_emit1__ApplicationHandle__missing_primary, fptr);
}
ApplicationHandle::ApplicationHandle ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, const ApplicationHandle &handle)
{
  fb.add_object (__AIDA_Local__::smh2id (handle));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, ApplicationHandle &handle)
{
  Rapicorn::Aida::ObjectBroker::pop_handle (fbr, handle);
}
const Rapicorn::Aida::TypeHash&
ApplicationHandle::__aida_typeid__()
{
  static const Rapicorn::Aida::TypeHash type_hash = Rapicorn::Aida::TypeHash (0xe5f9548043408aa5ULL, 0x6908b766da2ce656ULL);
  return type_hash;
}
ApplicationHandle
ApplicationHandle::__aida_cast__ (Rapicorn::Aida::SmartHandle &other, const Rapicorn::Aida::TypeHashList &types)
{
  size_t i; const Rapicorn::Aida::TypeHash &mine = __aida_typeid__();
  for (i = 0; i < types.size(); i++)
    if (mine == types[i])
      return __AIDA_Local__::smh2cast<ApplicationHandle> (other);
  return ApplicationHandle();
}
Rapicorn::Aida::BaseConnection*
ApplicationHandle::__aida_connection__()
{
  return __AIDA_Local__::client_connection;
}
const Rapicorn::Aida::TypeHashList
ApplicationHandle::__aida_typelist__()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
  __AIDA_Local__::add_header2_call (fb, *this, 0x4caa06dd27701476ULL, 0x39a2f7b2a184e208ULL);
  fb <<= *this;
  Rapicorn::Aida::FieldBuffer *fr = __AIDA_Local__::invoke (&fb);
  AIDA_CHECK (fr != NULL, "missing result from 2-way call");
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  size_t len;
  frr >>= len;
  AIDA_CHECK (frr.remaining() == len * 2, "result truncated");
  Rapicorn::Aida::TypeHashList thl;
  Rapicorn::Aida::TypeHash thash;
  for (size_t i = 0; i < len; i++) {
    frr >>= thash;
    thl.push_back (thash);
  }
  delete fr;
  return thl;
}
std::string
ApplicationHandle::auto_path (const std::string &arg_file_name,
                              const std::string &arg_binary_path,
                              bool arg_search_vpath)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 3), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x883ef87a829e0944ULL, 0x195491c8d0bf4e7eULL);
  fb <<= *this;
  fb <<= arg_file_name;
  fb <<= arg_binary_path;
  fb <<= arg_search_vpath;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  std::string  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
StringSeq
ApplicationHandle::auto_load (const std::string &arg_defs_domain,
                              const std::string &arg_file_name,
                              const std::string &arg_binary_path,
                              const std::string &arg_i18n_domain)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 4), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x1831a495b8387eb5ULL, 0x96aaaaedfb2c16faULL);
  fb <<= *this;
  fb <<= arg_defs_domain;
  fb <<= arg_file_name;
  fb <<= arg_binary_path;
  fb <<= arg_i18n_domain;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  StringSeq  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
bool
ApplicationHandle::factory_window (const std::string &arg_factory_definition)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xc8ba1f022ffb00bfULL, 0x1e91863bdd87f4caULL);
  fb <<= *this;
  fb <<= arg_factory_definition;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
ApplicationHandle::load_string (const std::string &arg_defs_domain,
                                const std::string &arg_xml_string,
                                const std::string &arg_i18n_domain)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 3), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x53c7aaf3f9d757d1ULL, 0xf1baf1ac14b72027ULL);
  fb <<= *this;
  fb <<= arg_defs_domain;
  fb <<= arg_xml_string;
  fb <<= arg_i18n_domain;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
WindowHandle
ApplicationHandle::create_window (const std::string &arg_window_identifier,
                                  const StringSeq &arg_arguments)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 2), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xe46b57832b6c8e39ULL, 0xd41fd199a8c671c7ULL);
  fb <<= *this;
  fb <<= arg_window_identifier;
  fb <<= arg_arguments;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  WindowHandle  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
bool
ApplicationHandle::finishable ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xfc8cccc767334738ULL, 0xb40c63a6f7fecea2ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
ApplicationHandle::close_all ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xf1206e509f98f4b9ULL, 0x45cdee6fda852de5ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
WindowHandle
ApplicationHandle::query_window (const std::string &arg_selector)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xc529acfc083f761dULL, 0x5a7fff7c86242aa1ULL);
  fb <<= *this;
  fb <<= arg_selector;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  WindowHandle  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
WindowList
ApplicationHandle::query_windows (const std::string &arg_selector)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xb8d47414e9b43b0dULL, 0x14fb61db88caa2abULL);
  fb <<= *this;
  fb <<= arg_selector;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  WindowList  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
WindowList
ApplicationHandle::list_windows ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x5704e595ccb696c3ULL, 0x902917d3af754af9ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  WindowList  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
ListModelRelayHandle
ApplicationHandle::create_list_model_relay (const std::string &arg_name)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xa9e92d7520533508ULL, 0x561da3801e9cffb3ULL);
  fb <<= *this;
  fb <<= arg_name;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  ListModelRelayHandle  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
ApplicationHandle::test_counter_set (int arg_val)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x26752905d7f09528ULL, 0x54a6f5a27c92ce19ULL);
  fb <<= *this;
  fb <<= arg_val;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
void
ApplicationHandle::test_counter_add (int arg_val)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x3316624539ea4447ULL, 0x11e9c67949d113ffULL);
  fb <<= *this;
  fb <<= arg_val;
  fr = __AIDA_Local__::invoke (&fb);
  if (AIDA_UNLIKELY (fr != NULL)) delete fr;
}
int
ApplicationHandle::test_counter_get ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x767abbc55034366fULL, 0x0bc3b39445195e98ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  int  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
int
ApplicationHandle::test_counter_inc_fetch ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x3d42918d44218250ULL, 0xbfaa70498ef80c6eULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  int  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
Rapicorn::Aida::int64
ApplicationHandle::test_hook ()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x278a60c0598177c9ULL, 0x5a503b69fd381e47ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  Rapicorn::Aida::int64  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
IdlTestWidgetHandle::IdlTestWidgetHandle ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, const IdlTestWidgetHandle &handle)
{
  fb.add_object (__AIDA_Local__::smh2id (handle));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, IdlTestWidgetHandle &handle)
{
  Rapicorn::Aida::ObjectBroker::pop_handle (fbr, handle);
}
const Rapicorn::Aida::TypeHash&
IdlTestWidgetHandle::__aida_typeid__()
{
  static const Rapicorn::Aida::TypeHash type_hash = Rapicorn::Aida::TypeHash (0x817eedabcc71a18dULL, 0x6d0ebd54c6f76d87ULL);
  return type_hash;
}
IdlTestWidgetHandle
IdlTestWidgetHandle::__aida_cast__ (Rapicorn::Aida::SmartHandle &other, const Rapicorn::Aida::TypeHashList &types)
{
  size_t i; const Rapicorn::Aida::TypeHash &mine = __aida_typeid__();
  for (i = 0; i < types.size(); i++)
    if (mine == types[i])
      return __AIDA_Local__::smh2cast<IdlTestWidgetHandle> (other);
  return IdlTestWidgetHandle();
}
const Rapicorn::Aida::TypeHashList
IdlTestWidgetHandle::__aida_typelist__()
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
  __AIDA_Local__::add_header2_call (fb, *this, 0x417c418d764daf5cULL, 0x3add344ba015b4ecULL);
  fb <<= *this;
  Rapicorn::Aida::FieldBuffer *fr = __AIDA_Local__::invoke (&fb);
  AIDA_CHECK (fr != NULL, "missing result from 2-way call");
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  size_t len;
  frr >>= len;
  AIDA_CHECK (frr.remaining() == len * 2, "result truncated");
  Rapicorn::Aida::TypeHashList thl;
  Rapicorn::Aida::TypeHash thash;
  for (size_t i = 0; i < len; i++) {
    frr >>= thash;
    thl.push_back (thash);
  }
  delete fr;
  return thl;
}
bool
IdlTestWidgetHandle::bool_prop () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x99948d69ebc2a1c7ULL, 0x1992a2b3a67b8eefULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  bool  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
IdlTestWidgetHandle::bool_prop (bool value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x2d2d2b095c0cf7ffULL, 0x6362f30aafa731b4ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
int
IdlTestWidgetHandle::int_prop () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x40380baa71a4cee4ULL, 0xeea7f61a3a41412fULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  int  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
IdlTestWidgetHandle::int_prop (int value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x70567417a8035bd3ULL, 0xa531d42041c0bab8ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
double
IdlTestWidgetHandle::float_prop () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x69a313a068ce58d6ULL, 0x73e909580fbaa5e1ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  double  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
IdlTestWidgetHandle::float_prop (double value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x285d6b0165a2feafULL, 0x2cdc39a1797c38d7ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
std::string
IdlTestWidgetHandle::string_prop () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x339c39407627875eULL, 0x6d257fd8991d9804ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  std::string  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
IdlTestWidgetHandle::string_prop (const std::string &value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0xa7c21f819acfe836ULL, 0xcd5dd7e8d63620d0ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
TestEnum
IdlTestWidgetHandle::enum_prop () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0xfe0fd06847a75335ULL, 0xb5b012d4698a175dULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  TestEnum  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
IdlTestWidgetHandle::enum_prop (TestEnum value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x2621c4f924f8e7bcULL, 0xf49816311b6ba886ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
Requisition
IdlTestWidgetHandle::record_prop () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x1fe3a9975e8acac8ULL, 0x9cc5b5ca0a6faeacULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  Requisition  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
IdlTestWidgetHandle::record_prop (const Requisition &value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x9e0276bbb2bc5241ULL, 0x3609a090062cf622ULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
StringSeq
IdlTestWidgetHandle::sequence_prop () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x27b9e3914e473bb1ULL, 0xfa4c3b85c49b3e4cULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  StringSeq  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
IdlTestWidgetHandle::sequence_prop (const StringSeq &value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x2cb8c5f7d175d477ULL, 0xbd63e685f3372e4cULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
IdlTestWidgetHandle
IdlTestWidgetHandle::self_prop () const
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1), *fr = NULL;
  __AIDA_Local__::add_header2_call (fb, *this, 0x32a9f87045663ba1ULL, 0x04d55d5dcf8ad486ULL);
  fb <<= *this;
  fr = __AIDA_Local__::invoke (&fb);
  Rapicorn::Aida::FieldReader frr (*fr);
  frr.skip_header();
  IdlTestWidgetHandle  retval;
  frr >>= retval;
  delete fr;
  return retval;
}
void
IdlTestWidgetHandle::self_prop (IdlTestWidgetHandle value)
{
  Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1), *fr = NULL;
  __AIDA_Local__::add_header1_call (fb, *this, 0x386aca93cbab61deULL, 0xb13176c3748e715cULL);
  fb <<= *this;
  fb <<= value;
  fr = __AIDA_Local__::invoke (&fb);
  if (fr) delete fr;
}
} // Rapicorn

namespace { // Anon
static const char __aida_type_map__[] =
  "AidaTypeMap\0\0\0\0\0\320\35\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\320\3"
  "\0\0h\16\0\0\0\0\0\0\300\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0E\0\0\0h\16\0"
  "\0\320\3\0\0\324\3\0\0E\0\0\0,\17\0\0\320\3\0\0(\4\0\0E\0\0\0x\17\0"
  "\0\320\3\0\0h\4\0\0Y\0\0\0x\20\0\0\320\3\0\0\0\0\0\0Q\0\0\0`\20\0\0"
  "\320\3\0\0p\0\0\0T\0\0\0\234\20\0\0\320\3\0\0`\20\0\0Q\0\0\0\204\20"
  "\0\0\320\3\0\0\220\0\0\0C\0\0\0\244\20\0\0\320\3\0\0\320\3\0\0b\0\0"
  "\0\330\20\0\0\320\3\0\0\0\0\0\0Q\0\0\0\300\20\0\0\320\3\0\0\300\0\0"
  "\0C\0\0\0\344\20\0\0\320\3\0\0""4\5\0\0E\0\0\0\30\21\0\0\320\3\0\0"
  "<\5\0\0E\0\0\0\244\21\0\0\320\3\0\0\244\5\0\0E\0\0\0\20\22\0\0\320\3"
  "\0\0\370\5\0\0C\0\0\0\0\21\0\0\320\3\0\0\214\7\0\0E\0\0\0\320\23\0"
  "\0\320\3\0\0\224\7\0\0C\0\0\0""4\24\0\0\320\3\0\0\214\7\0\0E\0\0\0L"
  "\24\0\0\320\3\0\0\374\7\0\0E\0\0\0\250\24\0\0\320\3\0\0<\10\0\0E\0\0"
  "\0$\25\0\0\320\3\0\0\270\10\0\0C\0\0\0\330\25\0\0\320\3\0\0\214\7\0"
  "\0E\0\0\0\364\25\0\0\\\11\0\0d\11\0\0C\0\0\0\240\27\0\0\320\3\0\0\320"
  "\3\0\0C\0\0\0\270\27\0\0\320\3\0\0\320\3\0\0i\0\0\0\360\27\0\0\320"
  "\3\0\0\0\0\0\0T\0\0\0\0\30\0\0\320\3\0\0\14\30\0\0T\0\0\0$\30\0\0"
  "\320\3\0\0""4\30\0\0R\0\0\0\330\27\0\0\320\3\0\0\200\12\0\0i\0\0\0L"
  "\30\0\0\320\3\0\0\0\0\0\0Q\0\0\0\14\30\0\0\320\3\0\0\0\2\0\0d\0\0\0"
  "t\30\0\0\320\3\0\0\0\0\0\0d\0\0\0\200\30\0\0\320\3\0\0\0\0\0\0R\0\0"
  "\0X\30\0\0\320\3\0\0\220\12\0\0E\0\0\0\214\30\0\0\320\3\0\0\234\12\0"
  "\0E\0\0\0\4\31\0\0\320\3\0\0\360\12\0\0E\0\0\0\204\31\0\0\\\11\0\0"
  "0\13\0\0s\0\0\0\24\32\0\0\320\3\0\0\0\0\0\0Q\0\0\0""4\30\0\0\320\3\0"
  "\0\200\2\0\0E\0\0\0 \32\0\0\320\3\0\0\254\13\0\0E\0\0\0\200\32\0\0"
  "\320\3\0\0\354\13\0\0E\0\0\0\350\32\0\0\320\3\0\0,\14\0\0T\0\0\0p\33"
  "\0\0\320\3\0\0\350\32\0\0T\0\0\0|\33\0\0\320\3\0\0\210\33\0\0T\0\0"
  "\0\244\33\0\0\320\3\0\0\210\33\0\0Y\0\0\0\260\33\0\0\320\3\0\0\0\0\0"
  "\0R\0\0\0T\33\0\0\320\3\0\0\200\14\0\0i\0\0\0\274\33\0\0\320\3\0\0"
  "\0\0\0\0i\0\0\0\310\33\0\0\320\3\0\0\0\0\0\0R\0\0\0\210\33\0\0\320\3"
  "\0\0\230\14\0\0C\0\0\0\270\23\0\0\320\3\0\0\320\3\0\0C\0\0\0\324\33"
  "\0\0\320\3\0\0""4\5\0\0T\0\0\0\10\34\0\0\320\3\0\0\270\23\0\0Q\0\0"
  "\0\360\33\0\0\320\3\0\0p\3\0\0C\0\0\0\24\34\0\0\320\3\0\0""4\5\0\0T"
  "\0\0\0H\34\0\0\320\3\0\0\24\34\0\0Q\0\0\0,\34\0\0\320\3\0\0\240\3\0"
  "\0E\0\0\0T\34\0\0\320\3\0\0\244\14\0\0\0\0\0\0\24\0\0\0\0\0\0\0\0\0"
  "\0\0\214\16\0\0\250\16\0\0\250\16\0\0\1\0\0\0\0\0\0\0\260\16\0\0\250"
  "\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0\334\16\0\0\250\16\0\0\250\16\0\0"
  "\3\0\0\0\0\0\0\0\4\17\0\0\250\16\0\0\250\16\0\0\17\0\0\0\1\0\0\0\0"
  "\0\0\0D\17\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0T\17\0\0\250\16"
  "\0\0\250\16\0\0\3\0\0\0\0\0\0\0h\17\0\0\250\16\0\0\250\16\0\0""2\0\0"
  "\0\0\0\0\0\0\0\0\0\224\17\0\0\250\16\0\0\250\16\0\0\1\0\0\0\0\0\0\0"
  "\244\17\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0\270\17\0\0\250\16"
  "\0\0\250\16\0\0\3\0\0\0\0\0\0\0\310\17\0\0\250\16\0\0\250\16\0\0\4"
  "\0\0\0\0\0\0\0\340\17\0\0\250\16\0\0\250\16\0\0\5\0\0\0\0\0\0\0\364"
  "\17\0\0\250\16\0\0\250\16\0\0\6\0\0\0\0\0\0\0\14\20\0\0\250\16\0\0\250"
  "\16\0\0\7\0\0\0\0\0\0\0\34\20\0\0\250\16\0\0\250\16\0\0\10\0\0\0"
  "\0\0\0\0""4\20\0\0\250\16\0\0\250\16\0\0\11\0\0\0\0\0\0\0H\20\0\0\250"
  "\16\0\0\250\16\0\0\1\0\0\0\0\21\0\0\31\0\0\0\1\0\0\0\0\0\0\0""0\21"
  "\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0D\21\0\0\250\16\0\0\250\16"
  "\0\0\3\0\0\0\0\0\0\0\\\21\0\0\250\16\0\0\250\16\0\0\4\0\0\0\0\0\0"
  "\0t\21\0\0\250\16\0\0\250\16\0\0\5\0\0\0\0\0\0\0\214\21\0\0\250\16\0"
  "\0\250\16\0\0\24\0\0\0\0\0\0\0\0\0\0\0\304\21\0\0\250\16\0\0\250\16"
  "\0\0\1\0\0\0\0\0\0\0\330\21\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0\0"
  "\0\354\21\0\0\250\16\0\0\250\16\0\0\3\0\0\0\0\0\0\0\0\22\0\0\250\16"
  "\0\0\250\16\0\0d\0\0\0\0\0\0\0\0\0\0\0(\22\0\0\250\16\0\0\250\16\0"
  "\0\1\0\0\0\0\0\0\0""8\22\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0P"
  "\22\0\0\250\16\0\0\250\16\0\0\3\0\0\0\0\0\0\0h\22\0\0\250\16\0\0\250"
  "\16\0\0\4\0\0\0\0\0\0\0\204\22\0\0\250\16\0\0\250\16\0\0\5\0\0\0\0"
  "\0\0\0\240\22\0\0\250\16\0\0\250\16\0\0\6\0\0\0\0\0\0\0\260\22\0\0\250"
  "\16\0\0\250\16\0\0\7\0\0\0\0\0\0\0\310\22\0\0\250\16\0\0\250\16\0"
  "\0\10\0\0\0\0\0\0\0\340\22\0\0\250\16\0\0\250\16\0\0\11\0\0\0\0\0\0"
  "\0\360\22\0\0\250\16\0\0\250\16\0\0\12\0\0\0\0\0\0\0\10\23\0\0\250"
  "\16\0\0\250\16\0\0\13\0\0\0\0\0\0\0 \23\0\0\250\16\0\0\250\16\0\0\14"
  "\0\0\0\0\0\0\0""0\23\0\0\250\16\0\0\250\16\0\0\15\0\0\0\0\0\0\0@\23"
  "\0\0\250\16\0\0\250\16\0\0\16\0\0\0\0\0\0\0P\23\0\0\250\16\0\0\250"
  "\16\0\0\17\0\0\0\0\0\0\0`\23\0\0\250\16\0\0\250\16\0\0\20\0\0\0\0\0"
  "\0\0t\23\0\0\250\16\0\0\250\16\0\0\21\0\0\0\0\0\0\0\204\23\0\0\250\16"
  "\0\0\250\16\0\0\22\0\0\0\0\0\0\0\224\23\0\0\250\16\0\0\250\16\0\0"
  "\23\0\0\0\0\0\0\0\244\23\0\0\250\16\0\0\250\16\0\0\1\0\0\0\270\23\0"
  "\0\31\0\0\0\0\0\0\0\0\0\0\0\350\23\0\0\250\16\0\0\250\16\0\0\1\0\0\0"
  "\0\0\0\0\370\23\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0\10\24\0\0"
  "\250\16\0\0\250\16\0\0\3\0\0\0\0\0\0\0\24\24\0\0\250\16\0\0\250\16"
  "\0\0\4\0\0\0\0\0\0\0$\24\0\0\250\16\0\0\250\16\0\0\17\0\0\0\1\0\0\0"
  "\0\0\0\0h\24\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0|\24\0\0\250\16"
  "\0\0\250\16\0\0\3\0\0\0\0\0\0\0\224\24\0\0\250\16\0\0\250\16\0\0\36"
  "\0\0\0\1\0\0\0\0\0\0\0\304\24\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0"
  "\0\0\0\324\24\0\0\250\16\0\0\250\16\0\0\3\0\0\0\0\0\0\0\344\24\0\0\250"
  "\16\0\0\250\16\0\0\4\0\0\0\0\0\0\0\364\24\0\0\250\16\0\0\250\16\0"
  "\0\5\0\0\0\0\0\0\0\4\25\0\0\250\16\0\0\250\16\0\0\6\0\0\0\0\0\0\0\24"
  "\25\0\0\250\16\0\0\250\16\0\0(\0\0\0\0\0\0\0\0\0\0\0<\25\0\0\250\16"
  "\0\0\250\16\0\0\1\0\0\0\0\0\0\0L\25\0\0\250\16\0\0\250\16\0\0\2\0"
  "\0\0\0\0\0\0d\25\0\0\250\16\0\0\250\16\0\0\3\0\0\0\0\0\0\0t\25\0\0\250"
  "\16\0\0\250\16\0\0\4\0\0\0\0\0\0\0\204\25\0\0\250\16\0\0\250\16\0"
  "\0\5\0\0\0\0\0\0\0\230\25\0\0\250\16\0\0\250\16\0\0\6\0\0\0\0\0\0\0"
  "\260\25\0\0\250\16\0\0\250\16\0\0\7\0\0\0\0\0\0\0\300\25\0\0\250\16"
  "\0\0\250\16\0\0\1\0\0\0\20\26\0\0F\0\0\0\0\0\0\0\0\0\0\0(\26\0\0\250"
  "\16\0\0\250\16\0\0\1\0\0\0\0\0\0\0<\26\0\0\250\16\0\0\250\16\0\0\2"
  "\0\0\0\0\0\0\0T\26\0\0\250\16\0\0\250\16\0\0\3\0\0\0\0\0\0\0p\26\0"
  "\0\250\16\0\0\250\16\0\0\4\0\0\0\0\0\0\0\210\26\0\0\250\16\0\0\250\16"
  "\0\0\5\0\0\0\0\0\0\0\244\26\0\0\250\16\0\0\250\16\0\0\6\0\0\0\0\0"
  "\0\0\270\26\0\0\250\16\0\0\250\16\0\0\200\0\0\0\0\0\0\0\320\26\0\0\250"
  "\16\0\0\250\16\0\0\201\0\0\0\0\0\0\0\350\26\0\0\250\16\0\0\250\16"
  "\0\0\202\0\0\0\0\0\0\0\10\27\0\0\250\16\0\0\250\16\0\0\203\0\0\0\0"
  "\0\0\0(\27\0\0\250\16\0\0\250\16\0\0\204\0\0\0\0\0\0\0H\27\0\0\250\16"
  "\0\0\250\16\0\0\205\0\0\0\0\0\0\0h\27\0\0\250\16\0\0\250\16\0\0\206"
  "\0\0\0\0\0\0\0\204\27\0\0\250\16\0\0\250\16\0\0\3\0\0\0\300\1\0\0"
  "\320\1\0\0\340\1\0\0\2\0\0\0 \2\0\0""0\2\0\0\24\0\0\0\0\0\0\0\0\0\0"
  "\0\250\30\0\0\250\16\0\0\250\16\0\0\1\0\0\0\0\0\0\0\274\30\0\0\250\16"
  "\0\0\250\16\0\0\2\0\0\0\0\0\0\0\324\30\0\0\250\16\0\0\250\16\0\0\3"
  "\0\0\0\0\0\0\0\354\30\0\0\250\16\0\0\250\16\0\0\17\0\0\0\0\0\0\0\0"
  "\0\0\0$\31\0\0\250\16\0\0\250\16\0\0\1\0\0\0\0\0\0\0<\31\0\0\250\16"
  "\0\0\250\16\0\0\2\0\0\0\0\0\0\0`\31\0\0\250\16\0\0\250\16\0\0\36\0\0"
  "\0\0\0\0\0\0\0\0\0\234\31\0\0\250\16\0\0\250\16\0\0\1\0\0\0\0\0\0\0"
  "\260\31\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0\310\31\0\0\250\16"
  "\0\0\250\16\0\0\4\0\0\0\0\0\0\0\334\31\0\0\250\16\0\0\250\16\0\0\10"
  "\0\0\0\0\0\0\0\360\31\0\0\250\16\0\0\250\16\0\0\20\0\0\0\0\0\0\0\0"
  "\32\0\0\250\16\0\0\250\16\0\0\17\0\0\0\1\0\0\0\0\0\0\0""8\32\0\0\250"
  "\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0P\32\0\0\250\16\0\0\250\16\0\0\3"
  "\0\0\0\0\0\0\0h\32\0\0\250\16\0\0\250\16\0\0\17\0\0\0\1\0\0\0\0\0\0"
  "\0\230\32\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0\260\32\0\0\250\16"
  "\0\0\250\16\0\0\3\0\0\0\0\0\0\0\314\32\0\0\250\16\0\0\250\16\0\0\24"
  "\0\0\0\1\0\0\0\0\0\0\0\4\33\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0"
  "\0\0\24\33\0\0\250\16\0\0\250\16\0\0\3\0\0\0\0\0\0\0(\33\0\0\250\16"
  "\0\0\250\16\0\0\4\0\0\0\0\0\0\0@\33\0\0\250\16\0\0\250\16\0\0\5\0\0"
  "\0\320\2\0\0\340\2\0\0\360\2\0\0\340\1\0\0\0\3\0\0\2\0\0\0 \3\0\0""0"
  "\3\0\0F\0\0\0\0\0\0\0\0\0\0\0p\34\0\0\250\16\0\0\250\16\0\0\1\0\0\0"
  "\0\0\0\0\210\34\0\0\250\16\0\0\250\16\0\0\2\0\0\0\0\0\0\0\240\34\0"
  "\0\250\16\0\0\250\16\0\0\3\0\0\0\0\0\0\0\270\34\0\0\250\16\0\0\250\16"
  "\0\0\4\0\0\0\0\0\0\0\320\34\0\0\250\16\0\0\250\16\0\0\5\0\0\0\0\0"
  "\0\0\350\34\0\0\250\16\0\0\250\16\0\0\6\0\0\0\0\0\0\0\0\35\0\0\250\16"
  "\0\0\250\16\0\0\7\0\0\0\0\0\0\0\30\35\0\0\250\16\0\0\250\16\0\0\10"
  "\0\0\0\0\0\0\0""0\35\0\0\250\16\0\0\250\16\0\0\11\0\0\0\0\0\0\0P\35"
  "\0\0\250\16\0\0\250\16\0\0\12\0\0\0\0\0\0\0l\35\0\0\250\16\0\0\250"
  "\16\0\0\13\0\0\0\0\0\0\0\204\35\0\0\250\16\0\0\250\16\0\0\14\0\0\0\0"
  "\0\0\0\244\35\0\0\250\16\0\0\250\16\0\0\15\0\0\0\0\0\0\0\274\35\0\0"
  "\250\16\0\0\250\16\0\0(\0\0\0@\0\0\0P\0\0\0`\0\0\0\200\0\0\0\240\0"
  "\0\0\260\0\0\0\320\0\0\0\340\0\0\0\360\0\0\0\0\1\0\0\20\1\0\0 \1\0\0"
  "0\1\0\0@\1\0\0P\1\0\0`\1\0\0p\1\0\0\200\1\0\0\220\1\0\0\240\1\0\0\260"
  "\1\0\0\360\1\0\0\20\2\0\0@\2\0\0P\2\0\0`\2\0\0p\2\0\0\220\2\0\0\240"
  "\2\0\0\260\2\0\0\300\2\0\0\20\3\0\0@\3\0\0P\3\0\0P\3\0\0`\3\0\0\200"
  "\3\0\0\220\3\0\0\260\3\0\0\300\3\0\0\0\0\0\0\36\0\0\0Rapicorn::A"
  "djustmentSourceType\0 \26\0\0\0ADJUSTMENT_SOURCE_NONE\0 \0\0\0\0\0 "
  "  %\0\0\0ADJUSTMENT_SOURCE_ANCESTRY_HORIZONTAL\0  #\0\0\0ADJUSTMENT"
  "_SOURCE_ANCESTRY_VERTICAL\0 \0\0\0ADJUSTMENT_SOURCE_ANCESTRY_VALUE\0"
  "   \23\0\0\0Rapicorn::AlignType\0\12\0\0\0ALIGN_LEFT\0 \14\0\0\0AL"
  "IGN_CENTER\0   \13\0\0\0ALIGN_RIGHT\0\24\0\0\0Rapicorn::AnchorType\0"
  "   \13\0\0\0ANCHOR_NONE\0\15\0\0\0ANCHOR_CENTER\0  \13\0\0\0ANCHOR"
  "_EAST\0\21\0\0\0ANCHOR_NORTH_EAST\0  \14\0\0\0ANCHOR_NORTH\0   \21\0"
  "\0\0ANCHOR_NORTH_WEST\0  \13\0\0\0ANCHOR_WEST\0\21\0\0\0ANCHOR_SOU"
  "TH_WEST\0  \14\0\0\0ANCHOR_SOUTH\0   \21\0\0\0ANCHOR_SOUTH_EAST\0  "
  "\20\0\0\0Rapicorn::AnySeq\0   \4\0\0\0vany\0   \23\0\0\0Rapicorn::A"
  "nySeqSeq\0\3\0\0\0seq\0\25\0\0\0Rapicorn::Application\0  \21\0\0\0R"
  "apicorn::BoolSeq\0  \5\0\0\0bools\0  \24\0\0\0Rapicorn::ButtonArea\0"
  "   \23\0\0\0Rapicorn::Container\0\23\0\0\0Rapicorn::ClickType\0\16"
  "\0\0\0CLICK_ON_PRESS\0 \20\0\0\0CLICK_ON_RELEASE\0   \21\0\0\0CLICK"
  "_SLOW_REPEAT\0  \21\0\0\0CLICK_FAST_REPEAT\0  \20\0\0\0CLICK_KEY_RE"
  "PEAT\0   \31\0\0\0Rapicorn::ColorSchemeType\0  \15\0\0\0COLOR_INHER"
  "IT\0  \14\0\0\0COLOR_NORMAL\0   \16\0\0\0COLOR_SELECTED\0 \12\0\0\0"
  "COLOR_BASE\0 \23\0\0\0Rapicorn::ColorType\0\12\0\0\0COLOR_NONE\0 \20"
  "\0\0\0COLOR_FOREGROUND\0   \20\0\0\0COLOR_BACKGROUND\0   \25\0\0\0"
  "COLOR_BACKGROUND_EVEN\0  \24\0\0\0COLOR_BACKGROUND_ODD\0   \12\0\0\0"
  "COLOR_DARK\0 \21\0\0\0COLOR_DARK_SHADOW\0  \20\0\0\0COLOR_DARK_GLI"
  "NT\0   \13\0\0\0COLOR_LIGHT\0\22\0\0\0COLOR_LIGHT_SHADOW\0 \21\0\0\0"
  "COLOR_LIGHT_GLINT\0  \13\0\0\0COLOR_FOCUS\0\13\0\0\0COLOR_BLACK\0\13"
  "\0\0\0COLOR_WHITE\0\11\0\0\0COLOR_RED\0  \14\0\0\0COLOR_YELLOW\0 "
  "  \13\0\0\0COLOR_GREEN\0\12\0\0\0COLOR_CYAN\0 \12\0\0\0COLOR_BLUE\0"
  " \15\0\0\0COLOR_MAGENTA\0  \20\0\0\0Rapicorn::Widget\0   \21\0\0\0R"
  "apicorn::DirType\0  \10\0\0\0DIR_NONE\0   \11\0\0\0DIR_RIGHT\0  \6\0"
  "\0\0DIR_UP\0 \10\0\0\0DIR_LEFT\0   \10\0\0\0DIR_DOWN\0   \22\0\0\0"
  "Rapicorn::Drawable\0 \27\0\0\0Rapicorn::EllipsizeType\0\17\0\0\0ELL"
  "IPSIZE_START\0\20\0\0\0ELLIPSIZE_MIDDLE\0   \15\0\0\0ELLIPSIZE_END\0"
  "  \26\0\0\0Rapicorn::FocusDirType\0 \12\0\0\0FOCUS_NEXT\0 \12\0\0\0"
  "FOCUS_PREV\0 \13\0\0\0FOCUS_RIGHT\0\10\0\0\0FOCUS_UP\0   \12\0\0\0"
  "FOCUS_LEFT\0 \12\0\0\0FOCUS_DOWN\0 \23\0\0\0Rapicorn::FrameType\0\12"
  "\0\0\0FRAME_NONE\0 \20\0\0\0FRAME_BACKGROUND\0   \10\0\0\0FRAME_IN"
  "\0   \11\0\0\0FRAME_OUT\0  \17\0\0\0FRAME_ETCHED_IN\0\20\0\0\0FRAME"
  "_ETCHED_OUT\0   \13\0\0\0FRAME_FOCUS\0\21\0\0\0FRAME_ALERT_FOCUS\0 "
  " \27\0\0\0Rapicorn::IdlTestWidget\0\26\0\0\0Rapicorn::LightingType\0"
  " \21\0\0\0enum_combinable=1\0  \15\0\0\0LIGHTING_NONE\0  \23\0\0\0"
  "LIGHTING_UPPER_LEFT\0\24\0\0\0LIGHTING_UPPER_RIGHT\0   \23\0\0\0LIG"
  "HTING_LOWER_LEFT\0\24\0\0\0LIGHTING_LOWER_RIGHT\0   \17\0\0\0LIGHTI"
  "NG_CENTER\0\20\0\0\0LIGHTING_DIFFUSE\0   \22\0\0\0LIGHTING_DARK_FLA"
  "G\0 \30\0\0\0LIGHTING_DARK_UPPER_LEFT\0   \31\0\0\0LIGHTING_DARK_UP"
  "PER_RIGHT\0  \30\0\0\0LIGHTING_DARK_LOWER_LEFT\0   \31\0\0\0LIGHTIN"
  "G_DARK_LOWER_RIGHT\0  \24\0\0\0LIGHTING_DARK_CENTER\0   \25\0\0\0LI"
  "GHTING_DARK_DIFFUSE\0  \23\0\0\0Rapicorn::ListModel\0\30\0\0\0Rapic"
  "orn::ListModelRelay\0   \20\0\0\0Rapicorn::Pixbuf\0   \12\0\0\0row_"
  "length\0 \6\0\0\0pixels\0 \22\0\0\0Rapicorn::PixelSeq\0 \11\0\0\0va"
  "riables\0  \23\0\0\0Rapicorn::StringSeq\0\4\0\0\0argb\0   \25\0\0\0"
  "Rapicorn::Requisition\0  \5\0\0\0width\0  \6\0\0\0height\0 \27\0\0\0"
  "Rapicorn::SelectionMode\0\16\0\0\0SELECTION_NONE\0 \20\0\0\0SELECT"
  "ION_SINGLE\0   \20\0\0\0SELECTION_BROWSE\0   \22\0\0\0SELECTION_MUL"
  "TIPLE\0 \30\0\0\0Rapicorn::SizePolicyType\0   \22\0\0\0SIZE_POLICY_"
  "NORMAL\0 \35\0\0\0SIZE_POLICY_WIDTH_FROM_HEIGHT\0  \35\0\0\0SIZE_PO"
  "LICY_HEIGHT_FROM_WIDTH\0  \23\0\0\0Rapicorn::StateType\0\14\0\0\0ST"
  "ATE_NORMAL\0   \21\0\0\0STATE_INSENSITIVE\0  \16\0\0\0STATE_PRELIGH"
  "T\0 \17\0\0\0STATE_IMPRESSED\0\13\0\0\0STATE_FOCUS\0\15\0\0\0STATE_"
  "DEFAULT\0  \7\0\0\0strings\0\22\0\0\0Rapicorn::TestEnum\0 \20\0\0\0"
  "TEST_ENUM_VALUE1\0   \20\0\0\0TEST_ENUM_VALUE2\0   \20\0\0\0TEST_EN"
  "UM_VALUE3\0   \22\0\0\0Rapicorn::TextMode\0 \21\0\0\0TEXT_MODE_WRAP"
  "PED\0  \24\0\0\0TEXT_MODE_ELLIPSIZED\0   \25\0\0\0TEXT_MODE_SINGLE_"
  "LINE\0  \24\0\0\0Rapicorn::UpdateKind\0   \13\0\0\0UPDATE_READ\0\15"
  "\0\0\0UPDATE_CHANGE\0  \20\0\0\0UPDATE_INSERTION\0   \17\0\0\0UPDAT"
  "E_DELETION\0\27\0\0\0Rapicorn::UpdateRequest\0\4\0\0\0kind\0   \7\0"
  "\0\0rowspan\0\24\0\0\0Rapicorn::UpdateSpan\0   \7\0\0\0colspan\0\5\0"
  "\0\0value\0  \5\0\0\0start\0  \6\0\0\0length\0 \24\0\0\0Rapicorn::"
  "WidgetList\0   \23\0\0\0Rapicorn::WidgetSeq\0\7\0\0\0widgets\0\20\0"
  "\0\0Rapicorn::Window\0   \24\0\0\0Rapicorn::WindowList\0   \7\0\0\0"
  "windows\0\24\0\0\0Rapicorn::WindowType\0   \22\0\0\0WINDOW_TYPE_NOR"
  "MAL\0 \23\0\0\0WINDOW_TYPE_DESKTOP\0\20\0\0\0WINDOW_TYPE_DOCK\0   \23"
  "\0\0\0WINDOW_TYPE_TOOLBAR\0\20\0\0\0WINDOW_TYPE_MENU\0   \23\0\0\0"
  "WINDOW_TYPE_UTILITY\0\22\0\0\0WINDOW_TYPE_SPLASH\0 \22\0\0\0WINDOW"
  "_TYPE_DIALOG\0 \31\0\0\0WINDOW_TYPE_DROPDOWN_MENU\0  \26\0\0\0WINDO"
  "W_TYPE_POPUP_MENU\0 \23\0\0\0WINDOW_TYPE_TOOLTIP\0\30\0\0\0WINDOW_T"
  "YPE_NOTIFICATION\0   \21\0\0\0WINDOW_TYPE_COMBO\0  \17\0\0\0WINDOW_"
  "TYPE_DND\0\0\0\0\0";

static Rapicorn::Init __aida_autoinit_type_map__ ([]() {
  Rapicorn::Aida::TypeMap::enlist_map (__aida_type_map__);
});
} // Anon


