% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap-layout.R
\name{fixedPage}
\alias{fixedPage}
\alias{fixedRow}
\title{Create a page with a fixed layout}
\usage{
fixedPage(..., title = NULL, responsive = NULL, theme = NULL)

fixedRow(...)
}
\arguments{
\item{...}{Elements to include within the container}

\item{title}{The browser window title (defaults to the host URL of the page)}

\item{responsive}{This option is deprecated; it is no longer optional with
Bootstrap 3.}

\item{theme}{Alternative Bootstrap stylesheet (normally a css file within the
www directory). For example, to use the theme located at
\code{www/bootstrap.css} you would use \code{theme = "bootstrap.css"}.}
}
\value{
A UI defintion that can be passed to the \link{shinyUI} function.
}
\description{
Functions for creating fixed page layouts. A fixed page layout consists of
rows which in turn include columns. Rows exist for the purpose of making sure
their elements appear on the same line (if the browser has adequate width).
Columns exist for the purpose of defining how much horizontal space within a
12-unit wide grid it's elements should occupy. Fixed pages limit their width
to 940 pixels on a typical display, and 724px or 1170px on smaller and larger
displays respectively.
}
\details{
To create a fixed page use the \code{fixedPage} function and include
  instances of \code{fixedRow} and \code{\link{column}} within it. Note that
  unlike \code{\link{fluidPage}}, fixed pages cannot make use of higher-level
  layout functions like \code{sidebarLayout}, rather, all layout must be done
  with \code{fixedRow} and \code{column}.
}
\note{
See the \href{http://shiny.rstudio.com/articles/layout-guide.html}{
  Shiny Application Layout Guide} for additional details on laying out fixed
  pages.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fixedPage(
  title = "Hello, Shiny!",
  fixedRow(
    column(width = 4,
      "4"
    ),
    column(width = 3, offset = 2,
      "3 offset 2"
    )
  )
)

shinyApp(ui, server = function(input, output) { })
}

}
\seealso{
\code{\link{column}}
}
