#' Jane Austen's Complete Novels
#' 
#' This package contains the complete text of Jane Austen's 6 completed, 
#' published novels, formatted to be convenient for text analysis.
#' @docType package
#' @name janeaustenr
#' @aliases janeaustenr janeaustenr-package
NULL

#' The text of Jane Austen's novel "Sense and Sensibility"
#'
#' A dataset containing the text of Jane Austen's 1811 novel "Sense and 
#' Sensibility". The UTF-8 plain text was sourced from Project Gutenberg
#' and is divided into elements of up to about 70 characters each.
#' (Some elements are blank.)
#'
#' @source \url{http://www.gutenberg.org/ebooks/161}
#' @format A character vector with 12262 elements
"sensesensibility"

#' The text of Jane Austen's novel "Pride and Prejudice"
#'
#' A dataset containing the text of Jane Austen's 1813 novel "Pride and 
#' Prejudice". The UTF-8 plain text was sourced from Project Gutenberg
#' and is divided into elements of up to about 70 characters each.
#' (Some elements are blank.)
#'
#' @source \url{http://www.gutenberg.org/ebooks/1342}
#' @format A character vector with 12447 elements
"prideprejudice"

#' The text of Jane Austen's novel "Mansfield Park"
#'
#' A dataset containing the text of Jane Austen's 1814 novel "Mansfield
#' Park". The UTF-8 plain text was sourced from Project Gutenberg
#' and is divided into elements of up to about 70 characters each.
#' (Some elements are blank.)
#'
#' @source \url{http://www.gutenberg.org/ebooks/141}
#' @format A character vector with 14768 elements
"mansfieldpark"

#' The text of Jane Austen's novel "Emma"
#'
#' A dataset containing the text of Jane Austen's 1815 novel "Emma".
#' The UTF-8 plain text was sourced from Project Gutenberg
#' and is divided into elements of up to about 70 characters each. 
#' (Some elements are blank.)
#'
#' @source \url{http://www.gutenberg.org/ebooks/158}
#' @format A character vector with 15297 elements
"emma"

#' The text of Jane Austen's novel "Northanger Abbey"
#'
#' A dataset containing the text of Jane Austen's novel "Northanger Abbey", 
#' published posthumously in 1818.
#' The UTF-8 plain text was sourced from Project Gutenberg
#' and is divided into elements of up to about 70 characters each.
#' (Some elements are blank.)
#'
#' @source \url{http://www.gutenberg.org/ebooks/121}
#' @format A character vector with 7840 elements
"northangerabbey"

#' The text of Jane Austen's novel "Persuasion"
#'
#' A dataset containing the text of Jane Austen's novel "Persuasion", 
#' published posthumously in 1818.
#' The UTF-8 plain text was sourced from Project Gutenberg
#' and is divided into elements of up to about 70 characters each.
#' (Some elements are blank.)
#'
#' @source \url{http://www.gutenberg.org/ebooks/105}
#' @format A character vector with 8328 elements
"persuasion"
