% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncated-poisson-distributtion.R
\name{TruncPoisson}
\alias{TruncPoisson}
\alias{dtpois}
\alias{ptpois}
\alias{qtpois}
\alias{rtpois}
\title{Truncated Poisson distribution}
\usage{
dtpois(x, lambda, a = -Inf, b = Inf, log = FALSE)

ptpois(q, lambda, a = -Inf, b = Inf, lower.tail = TRUE,
  log.p = FALSE)

qtpois(p, lambda, a = -Inf, b = Inf, lower.tail = TRUE,
  log.p = FALSE)

rtpois(n, lambda, a = -Inf, b = Inf)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{vector of (non-negative) means.}

\item{a, b}{lower and upper truncation points (\code{a < x <= b}).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the truncated Poisson distribution.
}
\examples{

x <- rtpois(1e5, 14, 16)
xx <- seq(-1, 50)
plot(prop.table(table(x)))
lines(xx, dtpois(xx, 14, 16), col = "red")
hist(ptpois(x, 14, 16))

xx <- seq(0, 50, by = 0.01)
plot(ecdf(x))
lines(xx, ptpois(xx, 14, 16), col = "red", lwd = 2)

uu <- seq(0, 1, by = 0.001)
lines(qtpois(uu, 14, 16), uu, col = "blue", lty = 2)

# Zero-truncated Poisson

x <- rtpois(1e5, 5, 0)
xx <- seq(-1, 50)
plot(prop.table(table(x)))
lines(xx, dtpois(xx, 5, 0), col = "red")
hist(ptpois(x, 5, 0))

xx <- seq(0, 50, by = 0.01)
plot(ecdf(x))
lines(xx, ptpois(xx, 5, 0), col = "red", lwd = 2)
lines(qtpois(uu, 5, 0), uu, col = "blue", lty = 2)

}
\references{
Plackett, R.L. (1953). The truncated Poisson distribution.
Biometrics, 9(4), 485-488.

Singh, J. (1978). A characterization of positive Poisson distribution and
its statistical application.
SIAM Journal on Applied Mathematics, 34(3), 545-548.

Dalgaard, P. (May 1, 2005). [R] simulate zero-truncated Poisson distribution.
R-help mailing list.
\url{https://stat.ethz.ch/pipermail/r-help/2005-May/070680.html}
}
\concept{Discrete}
\concept{Univariate}
\keyword{distribution}
