% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async.R
\name{Async}
\alias{Async}
\title{Simple async client}
\value{
a list, with objects of class \code{\link[=HttpResponse]{HttpResponse()}}.
Responses are returned in the order they are passed in. We print the
first 10.
}
\description{
An async client to work with many URLs, but all with the same HTTP method
}
\details{
See \code{\link[=HttpClient]{HttpClient()}} for information on parameters.
}
\section{Failure behavior}{

HTTP requests mostly fail in ways that you are probably familiar with,
including when there's a 400 response (the URL not found), and when the
server made a mistake (a 500 series HTTP status code).

But requests can fail sometimes where there is no HTTP status code, and
no agreed upon way to handle it other than to just fail immediately.

When a request fails when using synchronous requests (see \link{HttpClient})
you get an error message that stops your code progression
immediately saying for example:
\itemize{
\item "Could not resolve host: https://foo.com"
\item "Failed to connect to foo.com"
\item "Resolving timed out after 10 milliseconds"
}

However, for async requests we don't want to fail immediately because
that would stop the subsequent requests from occurring. Thus, when
we find that a request fails for one of the reasons above we
give back a \link{HttpResponse} object just like any other response, and:
\itemize{
\item capture the error message and put it in the \code{content} slot of the
response object (thus calls to \code{content} and \code{parse()} work correctly)
\item give back a \code{0} HTTP status code. we handle this specially when testing
whether the request was successful or not with e.g., the \code{success()}
method
}
}

\section{R6 classes}{

This is an R6 class from the package \pkg{R6}. Find out more
about R6 at \url{https://r6.r-lib.org/}. After creating an instance of an R6
class (e.g., \code{x <- HttpClient$new(url = "https://hb.opencpu.org")}) you can
access values and methods on the object \code{x}.
}

\examples{
\dontrun{
cc <- Async$new(
  urls = c(
    'https://hb.opencpu.org/',
    'https://hb.opencpu.org/get?a=5',
    'https://hb.opencpu.org/get?foo=bar'
  )
)
cc
(res <- cc$get())
res[[1]]
res[[1]]$url
res[[1]]$success()
res[[1]]$status_http()
res[[1]]$response_headers
res[[1]]$method
res[[1]]$content
res[[1]]$parse("UTF-8")
lapply(res, function(z) z$parse("UTF-8"))

# curl options/headers with async
urls = c(
 'https://hb.opencpu.org/',
 'https://hb.opencpu.org/get?a=5',
 'https://hb.opencpu.org/get?foo=bar'
)
cc <- Async$new(urls = urls, 
  opts = list(verbose = TRUE),
  headers = list(foo = "bar")
)
cc
(res <- cc$get())

# using auth with async
dd <- Async$new(
  urls = rep('https://hb.opencpu.org/basic-auth/user/passwd', 3),
  auth = auth(user = "foo", pwd = "passwd"),
  opts = list(verbose = TRUE)
)
dd
res <- dd$get()
res
vapply(res, function(z) z$status_code, double(1))
vapply(res, function(z) z$success(), logical(1))
lapply(res, function(z) z$parse("UTF-8"))

# failure behavior
## e.g. when a URL doesn't exist, a timeout, etc.
urls <- c("http://stuffthings.gvb", "https://foo.com", 
  "https://hb.opencpu.org/get")
conn <- Async$new(urls = urls)
res <- conn$get()
res[[1]]$parse("UTF-8") # a failure
res[[2]]$parse("UTF-8") # a failure
res[[3]]$parse("UTF-8") # a success

# retry
urls = c("https://hb.opencpu.org/status/404", "https://hb.opencpu.org/status/429")
conn <- Async$new(urls = urls)
res <- conn$retry(verb="get")
}

## ------------------------------------------------
## Method `Async$get`
## ------------------------------------------------

\dontrun{
(cc <- Async$new(urls = c(
    'https://hb.opencpu.org/',
    'https://hb.opencpu.org/get?a=5',
    'https://hb.opencpu.org/get?foo=bar'
  )))
(res <- cc$get())
}

## ------------------------------------------------
## Method `Async$verb`
## ------------------------------------------------

\dontrun{
cc <- Async$new(
  urls = c(
    'https://hb.opencpu.org/',
    'https://hb.opencpu.org/get?a=5',
    'https://hb.opencpu.org/get?foo=bar'
  )
)
(res <- cc$verb('get'))
lapply(res, function(z) z$parse("UTF-8"))
}
}
\seealso{
Other async: 
\code{\link{AsyncQueue}},
\code{\link{AsyncVaried}},
\code{\link{HttpRequest}}
}
\concept{async}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{urls}}{(character) one or more URLs}

\item{\code{opts}}{any curl options}

\item{\code{proxies}}{named list of headers}

\item{\code{auth}}{an object of class \code{auth}}

\item{\code{headers}}{named list of headers}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Async-print}{\code{Async$print()}}
\item \href{#method-Async-new}{\code{Async$new()}}
\item \href{#method-Async-get}{\code{Async$get()}}
\item \href{#method-Async-post}{\code{Async$post()}}
\item \href{#method-Async-put}{\code{Async$put()}}
\item \href{#method-Async-patch}{\code{Async$patch()}}
\item \href{#method-Async-delete}{\code{Async$delete()}}
\item \href{#method-Async-head}{\code{Async$head()}}
\item \href{#method-Async-retry}{\code{Async$retry()}}
\item \href{#method-Async-verb}{\code{Async$verb()}}
\item \href{#method-Async-clone}{\code{Async$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-print"></a>}}
\if{latex}{\out{\hypertarget{method-Async-print}{}}}
\subsection{Method \code{print()}}{
print method for Async objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-new"></a>}}
\if{latex}{\out{\hypertarget{method-Async-new}{}}}
\subsection{Method \code{new()}}{
Create a new Async object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$new(urls, opts, proxies, auth, headers)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{urls}}{(character) one or more URLs}

\item{\code{opts}}{any curl options}

\item{\code{proxies}}{a \code{\link[=proxy]{proxy()}} object}

\item{\code{auth}}{an \code{\link[=auth]{auth()}} object}

\item{\code{headers}}{named list of headers}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Async} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-get"></a>}}
\if{latex}{\out{\hypertarget{method-Async-get}{}}}
\subsection{Method \code{get()}}{
execute the \code{GET} http verb for the \code{urls}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$get(path = NULL, query = list(), disk = NULL, stream = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character) URL path, appended to the base URL}

\item{\code{query}}{(list) query terms, as a named list}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
\code{NULL} (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
(cc <- Async$new(urls = c(
    'https://hb.opencpu.org/',
    'https://hb.opencpu.org/get?a=5',
    'https://hb.opencpu.org/get?foo=bar'
  )))
(res <- cc$get())
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-post"></a>}}
\if{latex}{\out{\hypertarget{method-Async-post}{}}}
\subsection{Method \code{post()}}{
execute the \code{POST} http verb for the \code{urls}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$post(
  path = NULL,
  query = list(),
  body = NULL,
  encode = "multipart",
  disk = NULL,
  stream = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character) URL path, appended to the base URL}

\item{\code{query}}{(list) query terms, as a named list}

\item{\code{body}}{body as an R list}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
\code{NULL} (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-put"></a>}}
\if{latex}{\out{\hypertarget{method-Async-put}{}}}
\subsection{Method \code{put()}}{
execute the \code{PUT} http verb for the \code{urls}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$put(
  path = NULL,
  query = list(),
  body = NULL,
  encode = "multipart",
  disk = NULL,
  stream = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character) URL path, appended to the base URL}

\item{\code{query}}{(list) query terms, as a named list}

\item{\code{body}}{body as an R list}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
\code{NULL} (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-patch"></a>}}
\if{latex}{\out{\hypertarget{method-Async-patch}{}}}
\subsection{Method \code{patch()}}{
execute the \code{PATCH} http verb for the \code{urls}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$patch(
  path = NULL,
  query = list(),
  body = NULL,
  encode = "multipart",
  disk = NULL,
  stream = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character) URL path, appended to the base URL}

\item{\code{query}}{(list) query terms, as a named list}

\item{\code{body}}{body as an R list}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
\code{NULL} (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Async-delete}{}}}
\subsection{Method \code{delete()}}{
execute the \code{DELETE} http verb for the \code{urls}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$delete(
  path = NULL,
  query = list(),
  body = NULL,
  encode = "multipart",
  disk = NULL,
  stream = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character) URL path, appended to the base URL}

\item{\code{query}}{(list) query terms, as a named list}

\item{\code{body}}{body as an R list}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
\code{NULL} (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-head"></a>}}
\if{latex}{\out{\hypertarget{method-Async-head}{}}}
\subsection{Method \code{head()}}{
execute the \code{HEAD} http verb for the \code{urls}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$head(path = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character) URL path, appended to the base URL}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-retry"></a>}}
\if{latex}{\out{\hypertarget{method-Async-retry}{}}}
\subsection{Method \code{retry()}}{
execute the \code{RETRY} http verb for the \code{urls}. see \code{\link[=HttpRequest]{HttpRequest$retry}} method for parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$retry(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-verb"></a>}}
\if{latex}{\out{\hypertarget{method-Async-verb}{}}}
\subsection{Method \code{verb()}}{
execute any supported HTTP verb
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$verb(verb, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verb}}{(character) a supported HTTP verb: get, post, put, patch, delete,
head.}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
cc <- Async$new(
  urls = c(
    'https://hb.opencpu.org/',
    'https://hb.opencpu.org/get?a=5',
    'https://hb.opencpu.org/get?foo=bar'
  )
)
(res <- cc$verb('get'))
lapply(res, function(z) z$parse("UTF-8"))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Async-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Async-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Async$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
