% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sri.R
\name{describe}
\alias{describe}
\title{Create a Description of a Shared Resource}
\usage{
describe(x)
}
\arguments{
\item{x}{the object to create the descriptor for.}
}
\value{
A user-defined description of a shared resource.
}
\description{
This generic function should be used for creating a 
description of a shared resource and is used in conjunction with 
\code{attach.resource()} to utilize shared resources from an R session.
}
\examples{
# Create a concrete function.
setMethod(
 "describe", 
 signature(x = "list"),
 function (x) {
   print(x$value)
 }
)

# Create an object to describe.
tst = list(loc = "in_ram_not_shared", value = "hello world")

# Describe it
describe(tst)
}
\seealso{
[bigmemory.sri::attach.resource()]
}
