% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExpression.R
\name{plotExpression}
\alias{plotExpression}
\title{Plot expression values for all cells}
\usage{
plotExpression(
  object,
  features,
  x = NULL,
  exprs_values = "logcounts",
  log2_values = FALSE,
  colour_by = color_by,
  shape_by = NULL,
  size_by = NULL,
  order_by = NULL,
  by_exprs_values = exprs_values,
  xlab = NULL,
  feature_colours = feature_colors,
  one_facet = TRUE,
  ncol = 2,
  scales = "fixed",
  other_fields = list(),
  swap_rownames = NULL,
  color_by = NULL,
  feature_colors = TRUE,
  point_fun = NULL,
  assay.type = exprs_values,
  scattermore = FALSE,
  bins = NULL,
  summary_fun = "sum",
  hex = FALSE,
  by.assay.type = by_exprs_values,
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object containing expression values and other metadata.}

\item{features}{A character vector or a list specifying the features to plot.
If a list is supplied, each entry of the list can be a string, an AsIs-wrapped vector or a data.frame - see \code{?\link{retrieveCellInfo}}.}

\item{x}{Specification of a column metadata field or a feature to show on the x-axis, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{exprs_values}{Alias to \code{assay.type}.}

\item{log2_values}{Logical scalar, specifying whether the expression values be transformed to the log2-scale for plotting (with an offset of 1 to avoid logging zeroes).}

\item{colour_by}{Specification of a column metadata field or a feature to colour by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{shape_by}{Specification of a column metadata field or a feature to shape by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{size_by}{Specification of a column metadata field or a feature to size by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{order_by}{Specification of a column metadata field or a feature to order points by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{by_exprs_values}{Alias to \code{by.assay.type}.}

\item{xlab}{String specifying the label for x-axis.
If \code{NULL} (default), \code{x} will be used as the x-axis label.}

\item{feature_colours}{Logical scalar indicating whether violins should be coloured by feature when \code{x} and \code{colour_by} are not specified and \code{one_facet=TRUE}.}

\item{one_facet}{Logical scalar indicating whether grouped violin plots for multiple features should be put onto one facet.
Only relevant when \code{x=NULL}.}

\item{ncol}{Integer scalar, specifying the number of columns to be used for the panels of a multi-facet plot.}

\item{scales}{String indicating whether should multi-facet scales be fixed (\code{"fixed"}), free (\code{"free"}), or free in one dimension (\code{"free_x"}, \code{"free_y"}).
Passed to the \code{scales} argument in the \code{\link[ggplot2]{facet_wrap}} when multiple facets are generated.}

\item{other_fields}{Additional cell-based fields to include in the data.frame, see \code{?"\link{scater-plot-args}"} for details.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labelling plot
elements.}

\item{color_by}{Alias to \code{colour_by}.}

\item{feature_colors}{Alias to \code{feature_colours}.}

\item{point_fun}{Function used to create a geom that shows individual cells. Should take \code{...} args and return a ggplot2 geom. For example, \code{point_fun=function(...) geom_quasirandom(...)}.}

\item{assay.type}{A string or integer scalar specifying which assay in \code{assays(object)} to obtain expression values from. Also the alias \code{assay.type} is accepted.}

\item{scattermore}{Logical, whether to use the \code{scattermore} package to
greatly speed up plotting a large number of cells. Use \code{point_size =
0} for the most performance gain.}

\item{bins}{Number of bins, can be different in x and y, to bin and summarize
the points and their values, to avoid overplotting. If \code{NULL}
(default), then the points are plotted without binning. Only used when both
x and y are numeric.}

\item{summary_fun}{Function to summarize the feature value of each point
(e.g. gene expression of each cell) when the points binned, defaults to
\code{sum}. Can be either the name of the function or the function itself.}

\item{hex}{Logical, whether to use \code{\link{geom_hex}}.}

\item{by.assay.type}{A string or integer scalar specifying which assay to obtain expression values from,
for use in point aesthetics - see the \code{assay.type} argument in \code{?\link{retrieveCellInfo}}. Also the alias \code{by.assay.type} is accepted.}

\item{...}{Additional arguments for visualization, see \code{?"\link{scater-plot-args}"} for details.}
}
\value{
A ggplot object.
}
\description{
Plot expression values for a set of features (e.g. genes or transcripts) in a SingleExperiment object, against a continuous or categorical covariate for all cells.
}
\details{
This function plots expression values for one or more features.
If \code{x} is not specified, a violin plot will be generated of expression values.
If \code{x} is categorical, a grouped violin plot will be generated, with one violin for each level of \code{x}.
If \code{x} is continuous, a scatter plot will be generated.

If multiple features are requested and \code{x} is not specified and \code{one_facet=TRUE}, a grouped violin plot will be generated with one violin per feature.
This will be coloured by feature if \code{colour_by=NULL} and \code{feature_colours=TRUE}, to yield a more aesthetically pleasing plot.
Otherwise, if \code{x} is specified or \code{one_facet=FALSE}, a multi-panel plot will be generated where each panel corresponds to a feature.
Each panel will be a scatter plot or (grouped) violin plot, depending on the nature of \code{x}.

Note that this assumes that the expression values are numeric.
If not, and \code{x} is continuous, horizontal violin plots will be generated.
If \code{x} is missing or categorical, rectangule plots will be generated where the area of a rectangle is proportional to the number of points for a combination of factors.
}
\note{
Arguments \code{shape_by} and \code{size_by} are ignored when
\code{scattermore = TRUE}. Using \code{scattermore} is only recommended for
very large datasets to speed up plotting. Small point size is also
recommended. For larger point size, the point shape may be distorted. Also,
when \code{scattermore = TRUE}, the \code{point_size} argument works
differently.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)

## default plot
plotExpression(example_sce, rownames(example_sce)[1:15])

## plot expression against an x-axis value
plotExpression(example_sce, c("Gene_0001", "Gene_0004"),
    x="Mutation_Status")
plotExpression(example_sce, c("Gene_0001", "Gene_0004"),
    x="Gene_0002")

## add visual options
plotExpression(example_sce, rownames(example_sce)[1:6],
    colour_by = "Mutation_Status")
plotExpression(example_sce, rownames(example_sce)[1:6],
    colour_by = "Mutation_Status", shape_by = "Treatment",
    size_by = "Gene_0010")

## use boxplot as well as violin plot
plotExpression(example_sce, rownames(example_sce)[1:6],
    show_boxplot = TRUE, show_violin = FALSE)

## plot expression against expression values for Gene_0004
plotExpression(example_sce, rownames(example_sce)[1:4],
    "Gene_0004", show_smooth = TRUE)

# Use scattermore
plotExpression(example_sce, "Gene_0001", x = "Gene_0100", scattermore = TRUE,
    point_size = 2)
# Bin to show point density
plotExpression(example_sce, "Gene_0001", x = "Gene_0100", bins = 10)
# Bin to summarize values (default is sum but can be changed with summary_fun)
plotExpression(example_sce, "Gene_0001", x = "Gene_0100", bins = 10,
    colour_by = "Gene_0002", summary_fun = "mean")

}
\author{
Davis McCarthy, with modifications by Aaron Lun
}
