% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{degMV}
\alias{degMV}
\title{Correlation of the standard desviation and the mean of the abundance of a
set of genes.}
\usage{
degMV(group, pvalues, counts, sign = 0.01)
}
\arguments{
\item{group}{Character vector with group name for each sample in the
same order than counts column names.}

\item{pvalues}{pvalues of DEG analysis.}

\item{counts}{Matrix with counts for each samples and each gene.}

\item{sign}{Defining the cutoff to label significant features.
row number should be the same length than pvalues vector.}
}
\value{
ggplot2 object
}
\description{
Correlation of the standard desviation and the mean of the abundance of a
set of genes.
}
\examples{
data(humanGender)
library(DESeq2)
idx <- c(1:10, 75:85)
dds <- DESeqDataSetFromMatrix(assays(humanGender)[[1]][1:1000, idx],
  colData(humanGender)[idx,], design=~group)
dds <- DESeq(dds)
res <- results(dds)
degMV(colData(dds)[["group"]],
      res[, 4],
      counts(dds, normalized = TRUE))
}
