% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{degQC}
\alias{degQC}
\title{Plot main figures showing p-values distribution and mean-variance correlation}
\usage{
degQC(counts, groups, object = NULL, pvalue = NULL)
}
\arguments{
\item{counts}{Matrix with counts for each samples and each gene.}

\item{groups}{Character vector with group name for each sample in the
same order than counts column names.}

\item{object}{\link{DEGSet} oobject.}

\item{pvalue}{pvalues of DEG analysis.}
}
\value{
ggplot2 object
}
\description{
This function joins the output of \code{\link[DEGreport]{degMean}},
\code{\link[DEGreport]{degVar}} and \code{\link[DEGreport]{degMV}} in a
single plot. See these functions for further information.
}
\examples{
data(humanGender)
library(DESeq2)
idx <- c(1:10, 75:85)
dds <- DESeqDataSetFromMatrix(assays(humanGender)[[1]][1:1000, idx],
  colData(humanGender)[idx,], design=~group)
dds <- DESeq(dds)
res <- results(dds)
degQC(counts(dds, normalized=TRUE), colData(dds)[["group"]],
  pvalue = res[["pvalue"]])
}
