/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fakecamerazoomcontrol.h"
#include "fakecameraservice.h"
#include "fakevideodeviceselectorcontrol.h"

#include <QDebug>

FakeCameraZoomControl::FakeCameraZoomControl(FakeCameraService *service, QObject *parent)
    : QCameraZoomControl(parent),
      m_service(service),
      m_zoom(1.0),
      m_maxZoom(6.0)
{
    m_service->fakeSensor().setZoomFactor(m_zoom);
}

qreal FakeCameraZoomControl::currentDigitalZoom() const
{
    return m_zoom;
}

qreal FakeCameraZoomControl::currentOpticalZoom() const
{
    return 1.0;
}

qreal FakeCameraZoomControl::maximumDigitalZoom() const
{
    return m_maxZoom;
}

qreal FakeCameraZoomControl::maximumOpticalZoom() const
{
    return 1.0;
}

qreal FakeCameraZoomControl::requestedDigitalZoom() const
{
    return m_zoom;
}

qreal FakeCameraZoomControl::requestedOpticalZoom() const
{
    return 1.0;
}

void FakeCameraZoomControl::zoomTo(qreal optical, qreal digital)
{
    Q_UNUSED(optical);
    if (!(digital < 1.0 || digital > maximumDigitalZoom())) {
        m_zoom = digital;
        m_service->fakeSensor().setZoomFactor(m_zoom);
        Q_EMIT currentDigitalZoomChanged(m_zoom);
    }
}

void FakeCameraZoomControl::resetZoom()
{
    if (m_service->deviceSelector()->selectedDevice() == 0) {
        m_zoom = 1.0;
        m_maxZoom = 6.0;
    } else {
        m_zoom = 1.0;
        m_maxZoom = 3.0;
    }
    m_service->fakeSensor().setZoomFactor(m_zoom);
    Q_EMIT currentDigitalZoomChanged(m_zoom);
    Q_EMIT maximumDigitalZoomChanged(m_maxZoom);
}

