/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FRIENDSSERVICE_H
#define FRIENDSSERVICE_H

#include <QObject>
#include <QStringList>

#include <friends.h>

class FriendsDispatcherQml : public QObject
{
    Q_OBJECT

public:
    explicit FriendsDispatcherQml(QObject *parent = 0);
    ~FriendsDispatcherQml();

public Q_SLOTS:
    QString urlShorten(const QString& url) const;
    QStringList featuresForProtocol(const QString& protocol) const;
    void uploadForAccount(const int& account_id, const QString& uri, const QString& description) const;
    void uploadForAccountAsync(const int& account_id, const QString& uri, const QString& description) const;
    void sendForAccount(const int& account_id, const QString& message) const;
    void sendForAccountAsync(const int& account_id, const QString& message) const;
    void send(const QString& message) const;
    void sendAsync(const QString& message) const;
    void sendReply(const int& account_id, const QString& message_id, const QString& message) const;
    void sendReplyAsync(const int& account_id, const QString& message_id, const QString& message) const;
    void retweet(const int& account_id, const QString& message_id) const;
    void retweetAsync(const int& account_id, const QString& message_id) const;
    void like(const int& account_id, const QString& message_id) const;
    void likeAsync(const int& account_id, const QString& message_id) const;
    void unlike(const int& account_id, const QString& message_id) const;
    void unlikeAsync(const int& account_id, const QString& message_id) const;
    void refresh() const;


Q_SIGNALS:
    void uploadComplete(QString resultUrl, bool success, QString errorMessage);
    void sendComplete(QString result, bool success, QString errorMessage);
    void retweetComplete(QString result, bool success, QString errorMessage);
    void likeComplete(QString result, bool success, QString errorMessage);
    void unlikeComplete(QString result, bool success, QString errorMessage);

private:
    static void uploadCompleteCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);
    static void sendCompleteCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);
    static void sendReplyCompleteCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);
    static void retweetCompleteCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);
    static void likeCompleteCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);
    static void unlikeCompleteCallback(GObject *source_object, GAsyncResult *res, gpointer user_data);
    FriendsDispatcher* m_dispatcher;
};

#endif // FRIENDSSERVICE_H
