#
# PySNMP MIB module ENTITY-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/ENTITY-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:11:42 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, Integer, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ConstraintsIntersection, ValueRangeConstraint, ValueSizeConstraint, SingleValueConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ConstraintsIntersection", "ValueRangeConstraint", "ValueSizeConstraint", "SingleValueConstraint")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Counter32, mib_2, Integer32, NotificationType, ObjectIdentity, Gauge32, MibScalar, MibTable, MibTableRow, MibTableColumn, Unsigned32, iso, MibIdentifier, Counter64, TimeTicks, IpAddress, ModuleIdentity, Bits, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter32", "mib-2", "Integer32", "NotificationType", "ObjectIdentity", "Gauge32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Unsigned32", "iso", "MibIdentifier", "Counter64", "TimeTicks", "IpAddress", "ModuleIdentity", "Bits")
( TDomain, DateAndTime, TAddress, AutonomousType, RowPointer, TimeStamp, DisplayString, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "TDomain", "DateAndTime", "TAddress", "AutonomousType", "RowPointer", "TimeStamp", "DisplayString", "TextualConvention", "TruthValue")
entityMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 47)).setRevisions(("2005-08-10 00:00", "1999-12-07 00:00", "1996-10-31 00:00",))
if mibBuilder.loadTexts: entityMIB.setLastUpdated('200508100000Z')
if mibBuilder.loadTexts: entityMIB.setOrganization('IETF ENTMIB Working Group')
if mibBuilder.loadTexts: entityMIB.setContactInfo('        WG E-mail: entmib@ietf.org\n                     Mailing list subscription info:\n                       http://www.ietf.org/mailman/listinfo/entmib\n\n                     Andy Bierman\n                     ietf@andybierman.com\n\n                     Keith McCloghrie\n                     Cisco Systems Inc.\n                     170 West Tasman Drive\n                     San Jose, CA 95134\n\n\n                     +1 408-526-5260\n                     kzm@cisco.com')
if mibBuilder.loadTexts: entityMIB.setDescription('The MIB module for representing multiple logical\n            entities supported by a single SNMP agent.\n\n            Copyright (C) The Internet Society (2005).  This\n            version of this MIB module is part of RFC 4133; see\n            the RFC itself for full legal notices.')
entityMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 1))
entityPhysical = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 1, 1))
entityLogical = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 1, 2))
entityMapping = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 1, 3))
entityGeneral = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 1, 4))
class PhysicalIndex(Integer32, TextualConvention):
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,2147483647)

class PhysicalIndexOrZero(Integer32, TextualConvention):
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)

class PhysicalClass(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("chassis", 3), ("backplane", 4), ("container", 5), ("powerSupply", 6), ("fan", 7), ("sensor", 8), ("module", 9), ("port", 10), ("stack", 11), ("cpu", 12),)

class SnmpEngineIdOrNone(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,32)

entPhysicalTable = MibTable((1, 3, 6, 1, 2, 1, 47, 1, 1, 1), )
if mibBuilder.loadTexts: entPhysicalTable.setDescription("This table contains one row per physical entity.  There is\n            always at least one row for an 'overall' physical entity.")
entPhysicalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1), ).setIndexNames((0, "ENTITY-MIB", "entPhysicalIndex"))
if mibBuilder.loadTexts: entPhysicalEntry.setDescription('Information about a particular physical entity.\n\n            Each entry provides objects (entPhysicalDescr,\n            entPhysicalVendorType, and entPhysicalClass) to help an NMS\n            identify and characterize the entry, and objects\n            (entPhysicalContainedIn and entPhysicalParentRelPos) to help\n            an NMS relate the particular entry to other entries in this\n            table.')
entPhysicalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 1), PhysicalIndex())
if mibBuilder.loadTexts: entPhysicalIndex.setDescription('The index for this entry.')
entPhysicalDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalDescr.setDescription("A textual description of physical entity.  This object\n            should contain a string that identifies the manufacturer's\n            name for the physical entity, and should be set to a\n            distinct value for each version or model of the physical\n            entity.")
entPhysicalVendorType = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalVendorType.setDescription("An indication of the vendor-specific hardware type of the\n            physical entity.  Note that this is different from the\n            definition of MIB-II's sysObjectID.\n\n            An agent should set this object to an enterprise-specific\n            registration identifier value indicating the specific\n            equipment type in detail.  The associated instance of\n            entPhysicalClass is used to indicate the general type of\n            hardware device.\n\n            If no vendor-specific registration identifier exists for\n            this physical entity, or the value is unknown by this agent,\n            then the value { 0 0 } is returned.")
entPhysicalContainedIn = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 4), PhysicalIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalContainedIn.setDescription("The value of entPhysicalIndex for the physical entity which\n            'contains' this physical entity.  A value of zero indicates\n            this physical entity is not contained in any other physical\n            entity.  Note that the set of 'containment' relationships\n            define a strict hierarchy; that is, recursion is not\n            allowed.\n\n            In the event that a physical entity is contained by more\n            than one physical entity (e.g., double-wide modules), this\n            object should identify the containing entity with the lowest\n            value of entPhysicalIndex.")
entPhysicalClass = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 5), PhysicalClass()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalClass.setDescription("An indication of the general hardware type of the physical\n            entity.\n\n            An agent should set this object to the standard enumeration\n            value that most accurately indicates the general class of\n            the physical entity, or the primary class if there is more\n            than one entity.\n\n            If no appropriate standard registration identifier exists\n            for this physical entity, then the value 'other(1)' is\n            returned.  If the value is unknown by this agent, then the\n            value 'unknown(2)' is returned.")
entPhysicalParentRelPos = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalParentRelPos.setDescription("An indication of the relative position of this 'child'\n            component among all its 'sibling' components.  Sibling\n            components are defined as entPhysicalEntries that share the\n            same instance values of each of the entPhysicalContainedIn\n            and entPhysicalClass objects.\n\n            An NMS can use this object to identify the relative ordering\n            for all sibling components of a particular parent\n            (identified by the entPhysicalContainedIn instance in each\n            sibling entry).\n\n            If possible, this value should match any external labeling\n            of the physical component.  For example, for a container\n            (e.g., card slot) labeled as 'slot #3',\n            entPhysicalParentRelPos should have the value '3'.  Note\n            that the entPhysicalEntry for the module plugged in slot 3\n            should have an entPhysicalParentRelPos value of '1'.\n\n            If the physical position of this component does not match\n            any external numbering or clearly visible ordering, then\n            user documentation or other external reference material\n            should be used to determine the parent-relative position.\n            If this is not possible, then the agent should assign a\n            consistent (but possibly arbitrary) ordering to a given set\n            of 'sibling' components, perhaps based on internal\n            representation of the components.\n\n\n            If the agent cannot determine the parent-relative position\n            for some reason, or if the associated value of\n            entPhysicalContainedIn is '0', then the value '-1' is\n            returned.  Otherwise, a non-negative integer is returned,\n            indicating the parent-relative position of this physical\n            entity.\n\n            Parent-relative ordering normally starts from '1' and\n            continues to 'N', where 'N' represents the highest\n            positioned child entity.  However, if the physical entities\n            (e.g., slots) are labeled from a starting position of zero,\n            then the first sibling should be associated with an\n            entPhysicalParentRelPos value of '0'.  Note that this\n            ordering may be sparse or dense, depending on agent\n            implementation.\n\n            The actual values returned are not globally meaningful, as\n            each 'parent' component may use different numbering\n            algorithms.  The ordering is only meaningful among siblings\n            of the same parent component.\n\n            The agent should retain parent-relative position values\n            across reboots, either through algorithmic assignment or use\n            of non-volatile storage.")
entPhysicalName = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 7), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalName.setDescription("The textual name of the physical entity.  The value of this\n            object should be the name of the component as assigned by\n            the local device and should be suitable for use in commands\n            entered at the device's `console'.  This might be a text\n            name (e.g., `console') or a simple component number (e.g.,\n            port or module number, such as `1'), depending on the\n            physical component naming syntax of the device.\n\n            If there is no local name, or if this object is otherwise\n            not applicable, then this object contains a zero-length\n            string.\n\n            Note that the value of entPhysicalName for two physical\n            entities will be the same in the event that the console\n            interface does not distinguish between them, e.g., slot-1\n            and the card in slot-1.")
entPhysicalHardwareRev = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 8), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalHardwareRev.setDescription('The vendor-specific hardware revision string for the\n            physical entity.  The preferred value is the hardware\n            revision identifier actually printed on the component itself\n            (if present).\n\n            Note that if revision information is stored internally in a\n            non-printable (e.g., binary) format, then the agent must\n            convert such information to a printable format, in an\n            implementation-specific manner.\n\n            If no specific hardware revision string is associated with\n            the physical component, or if this information is unknown to\n            the agent, then this object will contain a zero-length\n            string.')
entPhysicalFirmwareRev = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 9), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalFirmwareRev.setDescription('The vendor-specific firmware revision string for the\n            physical entity.\n\n            Note that if revision information is stored internally in a\n            non-printable (e.g., binary) format, then the agent must\n            convert such information to a printable format, in an\n            implementation-specific manner.\n\n            If no specific firmware programs are associated with the\n            physical component, or if this information is unknown to the\n            agent, then this object will contain a zero-length string.')
entPhysicalSoftwareRev = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 10), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalSoftwareRev.setDescription('The vendor-specific software revision string for the\n            physical entity.\n\n            Note that if revision information is stored internally in a\n\n\n            non-printable (e.g., binary) format, then the agent must\n            convert such information to a printable format, in an\n            implementation-specific manner.\n\n            If no specific software programs are associated with the\n            physical component, or if this information is unknown to the\n            agent, then this object will contain a zero-length string.')
entPhysicalSerialNum = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 11), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: entPhysicalSerialNum.setDescription("The vendor-specific serial number string for the physical\n            entity.  The preferred value is the serial number string\n            actually printed on the component itself (if present).\n\n            On the first instantiation of an physical entity, the value\n            of entPhysicalSerialNum associated with that entity is set\n            to the correct vendor-assigned serial number, if this\n            information is available to the agent.  If a serial number\n            is unknown or non-existent, the entPhysicalSerialNum will be\n            set to a zero-length string instead.\n\n            Note that implementations that can correctly identify the\n            serial numbers of all installed physical entities do not\n            need to provide write access to the entPhysicalSerialNum\n            object.  Agents which cannot provide non-volatile storage\n            for the entPhysicalSerialNum strings are not required to\n            implement write access for this object.\n\n            Not every physical component will have a serial number, or\n            even need one.  Physical entities for which the associated\n            value of the entPhysicalIsFRU object is equal to 'false(2)'\n            (e.g., the repeater ports within a repeater module), do not\n            need their own unique serial number.  An agent does not have\n            to provide write access for such entities, and may return a\n            zero-length string.\n\n            If write access is implemented for an instance of\n            entPhysicalSerialNum, and a value is written into the\n            instance, the agent must retain the supplied value in the\n            entPhysicalSerialNum instance (associated with the same\n            physical entity) for as long as that entity remains\n            instantiated.  This includes instantiations across all\n            re-initializations/reboots of the network management system,\n            including those resulting in a change of the physical\n\n\n            entity's entPhysicalIndex value.")
entPhysicalMfgName = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 12), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalMfgName.setDescription('The name of the manufacturer of this physical component.\n            The preferred value is the manufacturer name string actually\n            printed on the component itself (if present).\n\n            Note that comparisons between instances of the\n            entPhysicalModelName, entPhysicalFirmwareRev,\n            entPhysicalSoftwareRev, and the entPhysicalSerialNum\n            objects, are only meaningful amongst entPhysicalEntries with\n            the same value of entPhysicalMfgName.\n\n            If the manufacturer name string associated with the physical\n            component is unknown to the agent, then this object will\n            contain a zero-length string.')
entPhysicalModelName = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 13), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalModelName.setDescription('The vendor-specific model name identifier string associated\n            with this physical component.  The preferred value is the\n            customer-visible part number, which may be printed on the\n            component itself.\n\n            If the model name string associated with the physical\n            component is unknown to the agent, then this object will\n            contain a zero-length string.')
entPhysicalAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 14), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: entPhysicalAlias.setDescription("This object is an 'alias' name for the physical entity, as\n            specified by a network manager, and provides a non-volatile\n            'handle' for the physical entity.\n\n            On the first instantiation of a physical entity, the value\n\n\n            of entPhysicalAlias associated with that entity is set to\n            the zero-length string.  However, the agent may set the\n            value to a locally unique default value, instead of a\n            zero-length string.\n\n            If write access is implemented for an instance of\n            entPhysicalAlias, and a value is written into the instance,\n            the agent must retain the supplied value in the\n            entPhysicalAlias instance (associated with the same physical\n            entity) for as long as that entity remains instantiated.\n            This includes instantiations across all\n            re-initializations/reboots of the network management system,\n            including those resulting in a change of the physical\n            entity's entPhysicalIndex value.")
entPhysicalAssetID = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 15), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: entPhysicalAssetID.setDescription("This object is a user-assigned asset tracking identifier\n            (as specified by a network manager) for the physical entity,\n            and provides non-volatile storage of this information.\n\n            On the first instantiation of a physical entity, the value\n            of entPhysicalAssetID associated with that entity is set to\n            the zero-length string.\n\n            Not every physical component will have an asset tracking\n            identifier, or even need one.  Physical entities for which\n            the associated value of the entPhysicalIsFRU object is equal\n            to 'false(2)' (e.g., the repeater ports within a repeater\n            module), do not need their own unique asset tracking\n            identifier.  An agent does not have to provide write access\n            for such entities, and may instead return a zero-length\n            string.\n\n            If write access is implemented for an instance of\n            entPhysicalAssetID, and a value is written into the\n            instance, the agent must retain the supplied value in the\n            entPhysicalAssetID instance (associated with the same\n            physical entity) for as long as that entity remains\n            instantiated.  This includes instantiations across all\n            re-initializations/reboots of the network management system,\n            including those resulting in a change of the physical\n            entity's entPhysicalIndex value.\n\n\n            If no asset tracking information is associated with the\n            physical component, then this object will contain a\n            zero-length string.")
entPhysicalIsFRU = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 16), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalIsFRU.setDescription("This object indicates whether or not this physical entity\n            is considered a 'field replaceable unit' by the vendor.  If\n            this object contains the value 'true(1)' then this\n            entPhysicalEntry identifies a field replaceable unit.  For\n            all entPhysicalEntries that represent components\n            permanently contained within a field replaceable unit, the\n            value 'false(2)' should be returned for this object.")
entPhysicalMfgDate = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 17), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalMfgDate.setDescription("This object contains the date of manufacturing of the\n            managed entity.  If the manufacturing date is unknown or not\n            supported, the object is not instantiated.  The special\n            value '0000000000000000'H may also be returned in this\n            case.")
entPhysicalUris = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 18), OctetString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: entPhysicalUris.setDescription('This object contains additional identification information\n            about the physical entity.  The object contains URIs and,\n            therefore, the syntax of this object must conform to RFC\n            3986, section 2.\n\n            Multiple URIs may be present and are separated by white\n            space characters.  Leading and trailing white space\n            characters are ignored.\n\n            If no additional identification information is known\n            about the physical entity or supported, the object is not\n            instantiated.  A zero length octet string may also be\n\n\n            returned in this case.')
entLogicalTable = MibTable((1, 3, 6, 1, 2, 1, 47, 1, 2, 1), )
if mibBuilder.loadTexts: entLogicalTable.setDescription('This table contains one row per logical entity.  For agents\n            that implement more than one naming scope, at least one\n            entry must exist.  Agents which instantiate all MIB objects\n            within a single naming scope are not required to implement\n            this table.')
entLogicalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1), ).setIndexNames((0, "ENTITY-MIB", "entLogicalIndex"))
if mibBuilder.loadTexts: entLogicalEntry.setDescription('Information about a particular logical entity.  Entities\n            may be managed by this agent or other SNMP agents (possibly)\n            in the same chassis.')
entLogicalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: entLogicalIndex.setDescription('The value of this object uniquely identifies the logical\n            entity.  The value should be a small positive integer; index\n            values for different logical entities are not necessarily\n            contiguous.')
entLogicalDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalDescr.setDescription("A textual description of the logical entity.  This object\n            should contain a string that identifies the manufacturer's\n            name for the logical entity, and should be set to a distinct\n            value for each version of the logical entity.")
entLogicalType = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalType.setDescription("An indication of the type of logical entity.  This will\n            typically be the OBJECT IDENTIFIER name of the node in the\n            SMI's naming hierarchy which represents the major MIB\n            module, or the majority of the MIB modules, supported by the\n            logical entity.  For example:\n               a logical entity of a regular host/router -> mib-2\n               a logical entity of a 802.1d bridge -> dot1dBridge\n               a logical entity of a 802.3 repeater -> snmpDot3RptrMgmt\n            If an appropriate node in the SMI's naming hierarchy cannot\n            be identified, the value 'mib-2' should be used.")
entLogicalCommunity = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalCommunity.setDescription("An SNMPv1 or SNMPv2C community-string, which can be used to\n            access detailed management information for this logical\n            entity.  The agent should allow read access with this\n            community string (to an appropriate subset of all managed\n            objects) and may also return a community string based on the\n            privileges of the request used to read this object.  Note\n            that an agent may return a community string with read-only\n            privileges, even if this object is accessed with a\n            read-write community string.  However, the agent must take\n\n\n            care not to return a community string that allows more\n            privileges than the community string used to access this\n            object.\n\n            A compliant SNMP agent may wish to conserve naming scopes by\n            representing multiple logical entities in a single 'default'\n            naming scope.  This is possible when the logical entities,\n            represented by the same value of entLogicalCommunity, have\n            no object instances in common.  For example, 'bridge1' and\n            'repeater1' may be part of the main naming scope, but at\n            least one additional community string is needed to represent\n            'bridge2' and 'repeater2'.\n\n            Logical entities 'bridge1' and 'repeater1' would be\n            represented by sysOREntries associated with the 'default'\n            naming scope.\n\n            For agents not accessible via SNMPv1 or SNMPv2C, the value\n            of this object is the empty string.  This object may also\n            contain an empty string if a community string has not yet\n            been assigned by the agent, or if no community string with\n            suitable access rights can be returned for a particular SNMP\n            request.\n\n            Note that this object is deprecated.  Agents which implement\n            SNMPv3 access should use the entLogicalContextEngineID and\n            entLogicalContextName objects to identify the context\n            associated with each logical entity.  SNMPv3 agents may\n            return a zero-length string for this object, or may continue\n            to return a community string (e.g., tri-lingual agent\n            support).")
entLogicalTAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 5), TAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalTAddress.setDescription("The transport service address by which the logical entity\n            receives network management traffic, formatted according to\n            the corresponding value of entLogicalTDomain.\n\n            For snmpUDPDomain, a TAddress is 6 octets long: the initial\n            4 octets contain the IP-address in network-byte order and\n            the last 2 contain the UDP port in network-byte order.\n            Consult 'Transport Mappings for the Simple Network\n            Management Protocol' (STD 62, RFC 3417 [RFC3417]) for\n            further information on snmpUDPDomain.")
entLogicalTDomain = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 6), TDomain()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalTDomain.setDescription("Indicates the kind of transport service by which the\n            logical entity receives network management traffic.\n            Possible values for this object are presently found in the\n            Transport Mappings for Simple Network Management Protocol'\n            (STD 62, RFC 3417 [RFC3417]).")
entLogicalContextEngineID = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 7), SnmpEngineIdOrNone()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalContextEngineID.setDescription("The authoritative contextEngineID that can be used to send\n            an SNMP message concerning information held by this logical\n            entity, to the address specified by the associated\n            'entLogicalTAddress/entLogicalTDomain' pair.\n\n            This object, together with the associated\n            entLogicalContextName object, defines the context associated\n            with a particular logical entity, and allows access to SNMP\n            engines identified by a contextEngineId and contextName\n            pair.\n\n            If no value has been configured by the agent, a zero-length\n            string is returned, or the agent may choose not to\n            instantiate this object at all.")
entLogicalContextName = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 2, 1, 1, 8), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLogicalContextName.setDescription("The contextName that can be used to send an SNMP message\n            concerning information held by this logical entity, to the\n            address specified by the associated\n            'entLogicalTAddress/entLogicalTDomain' pair.\n\n            This object, together with the associated\n            entLogicalContextEngineID object, defines the context\n            associated with a particular logical entity, and allows\n\n\n            access to SNMP engines identified by a contextEngineId and\n            contextName pair.\n\n            If no value has been configured by the agent, a zero-length\n            string is returned, or the agent may choose not to\n            instantiate this object at all.")
entLPMappingTable = MibTable((1, 3, 6, 1, 2, 1, 47, 1, 3, 1), )
if mibBuilder.loadTexts: entLPMappingTable.setDescription('This table contains zero or more rows of logical entity to\n            physical equipment associations.  For each logical entity\n            known by this agent, there are zero or more mappings to the\n            physical resources, which are used to realize that logical\n            entity.\n\n            An agent should limit the number and nature of entries in\n            this table such that only meaningful and non-redundant\n            information is returned.  For example, in a system that\n            contains a single power supply, mappings between logical\n            entities and the power supply are not useful and should not\n            be included.\n\n            Also, only the most appropriate physical component, which is\n            closest to the root of a particular containment tree, should\n            be identified in an entLPMapping entry.\n\n            For example, suppose a bridge is realized on a particular\n            module, and all ports on that module are ports on this\n            bridge.  A mapping between the bridge and the module would\n            be useful, but additional mappings between the bridge and\n            each of the ports on that module would be redundant (because\n            the entPhysicalContainedIn hierarchy can provide the same\n            information).  On the other hand, if more than one bridge\n            were utilizing ports on this module, then mappings between\n            each bridge and the ports it used would be appropriate.\n\n            Also, in the case of a single backplane repeater, a mapping\n            for the backplane to the single repeater entity is not\n            necessary.')
entLPMappingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 47, 1, 3, 1, 1), ).setIndexNames((0, "ENTITY-MIB", "entLogicalIndex"), (0, "ENTITY-MIB", "entLPPhysicalIndex"))
if mibBuilder.loadTexts: entLPMappingEntry.setDescription('Information about a particular logical entity to physical\n            equipment association.  Note that the nature of the\n            association is not specifically identified in this entry.\n            It is expected that sufficient information exists in the\n            MIBs used to manage a particular logical entity to infer how\n            physical component information is utilized.')
entLPPhysicalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 3, 1, 1, 1), PhysicalIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLPPhysicalIndex.setDescription('The value of this object identifies the index value of a\n            particular entPhysicalEntry associated with the indicated\n            entLogicalEntity.')
entAliasMappingTable = MibTable((1, 3, 6, 1, 2, 1, 47, 1, 3, 2), )
if mibBuilder.loadTexts: entAliasMappingTable.setDescription("This table contains zero or more rows, representing\n            mappings of logical entity and physical component to\n            external MIB identifiers.  Each physical port in the system\n            may be associated with a mapping to an external identifier,\n            which itself is associated with a particular logical\n            entity's naming scope.  A 'wildcard' mechanism is provided\n            to indicate that an identifier is associated with more than\n            one logical entity.")
entAliasMappingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 47, 1, 3, 2, 1), ).setIndexNames((0, "ENTITY-MIB", "entPhysicalIndex"), (0, "ENTITY-MIB", "entAliasLogicalIndexOrZero"))
if mibBuilder.loadTexts: entAliasMappingEntry.setDescription("Information about a particular physical equipment, logical\n\n\n            entity to external identifier binding.  Each logical\n            entity/physical component pair may be associated with one\n            alias mapping.  The logical entity index may also be used as\n            a 'wildcard' (refer to the entAliasLogicalIndexOrZero object\n            DESCRIPTION clause for details.)\n\n            Note that only entPhysicalIndex values that represent\n            physical ports (i.e., associated entPhysicalClass value is\n            'port(10)') are permitted to exist in this table.")
entAliasLogicalIndexOrZero = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 3, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647)))
if mibBuilder.loadTexts: entAliasLogicalIndexOrZero.setDescription("The value of this object identifies the logical entity\n            that defines the naming scope for the associated instance\n            of the 'entAliasMappingIdentifier' object.\n\n            If this object has a non-zero value, then it identifies the\n            logical entity named by the same value of entLogicalIndex.\n\n            If this object has a value of zero, then the mapping between\n            the physical component and the alias identifier for this\n            entAliasMapping entry is associated with all unspecified\n            logical entities.  That is, a value of zero (the default\n            mapping) identifies any logical entity that does not have\n            an explicit entry in this table for a particular\n            entPhysicalIndex/entAliasMappingIdentifier pair.\n\n            For example, to indicate that a particular interface (e.g.,\n            physical component 33) is identified by the same value of\n            ifIndex for all logical entities, the following instance\n            might exist:\n\n                    entAliasMappingIdentifier.33.0 = ifIndex.5\n\n            In the event an entPhysicalEntry is associated differently\n            for some logical entities, additional entAliasMapping\n            entries may exist, e.g.:\n\n\n                    entAliasMappingIdentifier.33.0 = ifIndex.6\n                    entAliasMappingIdentifier.33.4 =  ifIndex.1\n                    entAliasMappingIdentifier.33.5 =  ifIndex.1\n                    entAliasMappingIdentifier.33.10 = ifIndex.12\n\n            Note that entries with non-zero entAliasLogicalIndexOrZero\n            index values have precedence over zero-indexed entries.  In\n            this example, all logical entities except 4, 5, and 10,\n            associate physical entity 33 with ifIndex.6.")
entAliasMappingIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 3, 2, 1, 2), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entAliasMappingIdentifier.setDescription("The value of this object identifies a particular conceptual\n            row associated with the indicated entPhysicalIndex and\n            entLogicalIndex pair.\n\n            Because only physical ports are modeled in this table, only\n            entries that represent interfaces or ports are allowed.  If\n            an ifEntry exists on behalf of a particular physical port,\n            then this object should identify the associated 'ifEntry'.\n            For repeater ports, the appropriate row in the\n            'rptrPortGroupTable' should be identified instead.\n\n            For example, suppose a physical port was represented by\n            entPhysicalEntry.3, entLogicalEntry.15 existed for a\n            repeater, and entLogicalEntry.22 existed for a bridge.  Then\n            there might be two related instances of\n            entAliasMappingIdentifier:\n               entAliasMappingIdentifier.3.15 == rptrPortGroupIndex.5.2\n               entAliasMappingIdentifier.3.22 == ifIndex.17\n            It is possible that other mappings (besides interfaces and\n            repeater ports) may be defined in the future, as required.\n\n            Bridge ports are identified by examining the Bridge MIB and\n            appropriate ifEntries associated with each 'dot1dBasePort',\n            and are thus not represented in this table.")
entPhysicalContainsTable = MibTable((1, 3, 6, 1, 2, 1, 47, 1, 3, 3), )
if mibBuilder.loadTexts: entPhysicalContainsTable.setDescription("A table that exposes the container/'containee'\n            relationships between physical entities.  This table\n            provides all the information found by constructing the\n            virtual containment tree for a given entPhysicalTable, but\n            in a more direct format.\n\n            In the event a physical entity is contained by more than one\n            other physical entity (e.g., double-wide modules), this\n            table should include these additional mappings, which cannot\n            be represented in the entPhysicalTable virtual containment\n            tree.")
entPhysicalContainsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 47, 1, 3, 3, 1), ).setIndexNames((0, "ENTITY-MIB", "entPhysicalIndex"), (0, "ENTITY-MIB", "entPhysicalChildIndex"))
if mibBuilder.loadTexts: entPhysicalContainsEntry.setDescription("A single container/'containee' relationship.")
entPhysicalChildIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 47, 1, 3, 3, 1, 1), PhysicalIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entPhysicalChildIndex.setDescription('The value of entPhysicalIndex for the contained physical\n            entity.')
entLastChangeTime = MibScalar((1, 3, 6, 1, 2, 1, 47, 1, 4, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: entLastChangeTime.setDescription('The value of sysUpTime at the time a conceptual row is\n            created, modified, or deleted in any of these tables:\n                    - entPhysicalTable\n                    - entLogicalTable\n                    - entLPMappingTable\n                    - entAliasMappingTable\n\n\n                    - entPhysicalContainsTable\n            ')
entityMIBTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 2))
entityMIBTrapPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 2, 0))
entConfigChange = NotificationType((1, 3, 6, 1, 2, 1, 47, 2, 0, 1)).setObjects(*())
if mibBuilder.loadTexts: entConfigChange.setDescription("An entConfigChange notification is generated when the value\n            of entLastChangeTime changes.  It can be utilized by an NMS\n            to trigger logical/physical entity table maintenance polls.\n\n            An agent should not generate more than one entConfigChange\n            'notification-event' in a given time interval (five seconds\n            is the suggested default).  A 'notification-event' is the\n            transmission of a single trap or inform PDU to a list of\n            notification destinations.\n\n            If additional configuration changes occur within the\n            throttling period, then notification-events for these\n            changes should be suppressed by the agent until the current\n            throttling period expires.  At the end of a throttling\n            period, one notification-event should be generated if any\n            configuration changes occurred since the start of the\n            throttling period.  In such a case, another throttling\n            period is started right away.\n\n            An NMS should periodically check the value of\n            entLastChangeTime to detect any missed entConfigChange\n            notification-events, e.g., due to throttling or transmission\n            loss.")
entityConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 3))
entityCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 3, 1))
entityGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 47, 3, 2))
entityCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 47, 3, 1, 1)).setObjects(*(("ENTITY-MIB", "entityPhysicalGroup"), ("ENTITY-MIB", "entityLogicalGroup"), ("ENTITY-MIB", "entityMappingGroup"), ("ENTITY-MIB", "entityGeneralGroup"), ("ENTITY-MIB", "entityNotificationsGroup"),))
if mibBuilder.loadTexts: entityCompliance.setDescription('The compliance statement for SNMP entities that implement\n            version 1 of the Entity MIB.')
entity2Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 47, 3, 1, 2)).setObjects(*(("ENTITY-MIB", "entityPhysicalGroup"), ("ENTITY-MIB", "entityPhysical2Group"), ("ENTITY-MIB", "entityGeneralGroup"), ("ENTITY-MIB", "entityNotificationsGroup"), ("ENTITY-MIB", "entityLogical2Group"), ("ENTITY-MIB", "entityMappingGroup"),))
if mibBuilder.loadTexts: entity2Compliance.setDescription('The compliance statement for SNMP entities that implement\n            version 2 of the Entity MIB.')
entity3Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 47, 3, 1, 3)).setObjects(*(("ENTITY-MIB", "entityPhysicalGroup"), ("ENTITY-MIB", "entityPhysical2Group"), ("ENTITY-MIB", "entityPhysical3Group"), ("ENTITY-MIB", "entityGeneralGroup"), ("ENTITY-MIB", "entityNotificationsGroup"), ("ENTITY-MIB", "entityLogical2Group"), ("ENTITY-MIB", "entityMappingGroup"),))
if mibBuilder.loadTexts: entity3Compliance.setDescription('The compliance statement for SNMP entities that implement\n            version 3 of the Entity MIB.')
entityPhysicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 1)).setObjects(*(("ENTITY-MIB", "entPhysicalDescr"), ("ENTITY-MIB", "entPhysicalVendorType"), ("ENTITY-MIB", "entPhysicalContainedIn"), ("ENTITY-MIB", "entPhysicalClass"), ("ENTITY-MIB", "entPhysicalParentRelPos"), ("ENTITY-MIB", "entPhysicalName"),))
if mibBuilder.loadTexts: entityPhysicalGroup.setDescription('The collection of objects used to represent physical\n            system components, for which a single agent provides\n            management information.')
entityLogicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 2)).setObjects(*(("ENTITY-MIB", "entLogicalDescr"), ("ENTITY-MIB", "entLogicalType"), ("ENTITY-MIB", "entLogicalCommunity"), ("ENTITY-MIB", "entLogicalTAddress"), ("ENTITY-MIB", "entLogicalTDomain"),))
if mibBuilder.loadTexts: entityLogicalGroup.setDescription('The collection of objects used to represent the list of\n            logical entities, for which a single agent provides\n            management information.')
entityMappingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 3)).setObjects(*(("ENTITY-MIB", "entLPPhysicalIndex"), ("ENTITY-MIB", "entAliasMappingIdentifier"), ("ENTITY-MIB", "entPhysicalChildIndex"),))
if mibBuilder.loadTexts: entityMappingGroup.setDescription('The collection of objects used to represent the\n            associations between multiple logical entities, physical\n            components, interfaces, and port identifiers, for which a\n            single agent provides management information.')
entityGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 4)).setObjects(*(("ENTITY-MIB", "entLastChangeTime"),))
if mibBuilder.loadTexts: entityGeneralGroup.setDescription('The collection of objects used to represent general entity\n            information, for which a single agent provides management\n            information.')
entityNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 5)).setObjects(*(("ENTITY-MIB", "entConfigChange"),))
if mibBuilder.loadTexts: entityNotificationsGroup.setDescription('The collection of notifications used to indicate Entity MIB\n            data consistency and general status information.')
entityPhysical2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 6)).setObjects(*(("ENTITY-MIB", "entPhysicalHardwareRev"), ("ENTITY-MIB", "entPhysicalFirmwareRev"), ("ENTITY-MIB", "entPhysicalSoftwareRev"), ("ENTITY-MIB", "entPhysicalSerialNum"), ("ENTITY-MIB", "entPhysicalMfgName"), ("ENTITY-MIB", "entPhysicalModelName"), ("ENTITY-MIB", "entPhysicalAlias"), ("ENTITY-MIB", "entPhysicalAssetID"), ("ENTITY-MIB", "entPhysicalIsFRU"),))
if mibBuilder.loadTexts: entityPhysical2Group.setDescription('The collection of objects used to represent physical\n            system components, for which a single agent provides\n            management information.  This group augments the objects\n            contained in the entityPhysicalGroup.')
entityLogical2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 7)).setObjects(*(("ENTITY-MIB", "entLogicalDescr"), ("ENTITY-MIB", "entLogicalType"), ("ENTITY-MIB", "entLogicalTAddress"), ("ENTITY-MIB", "entLogicalTDomain"), ("ENTITY-MIB", "entLogicalContextEngineID"), ("ENTITY-MIB", "entLogicalContextName"),))
if mibBuilder.loadTexts: entityLogical2Group.setDescription('The collection of objects used to represent the\n            list of logical entities, for which a single SNMP entity\n            provides management information.')
entityPhysical3Group = ObjectGroup((1, 3, 6, 1, 2, 1, 47, 3, 2, 8)).setObjects(*(("ENTITY-MIB", "entPhysicalMfgDate"), ("ENTITY-MIB", "entPhysicalUris"),))
if mibBuilder.loadTexts: entityPhysical3Group.setDescription('The collection of objects used to represent physical\n            system components, for which a single agent provides\n            management information.  This group augments the objects\n            contained in the entityPhysicalGroup.')
mibBuilder.exportSymbols("ENTITY-MIB", entAliasLogicalIndexOrZero=entAliasLogicalIndexOrZero, entityMIB=entityMIB, entPhysicalAlias=entPhysicalAlias, entLogicalType=entLogicalType, entPhysicalIsFRU=entPhysicalIsFRU, entPhysicalUris=entPhysicalUris, entPhysicalContainsEntry=entPhysicalContainsEntry, entPhysicalHardwareRev=entPhysicalHardwareRev, entConfigChange=entConfigChange, entityLogical=entityLogical, entPhysicalTable=entPhysicalTable, entLogicalTAddress=entLogicalTAddress, PhysicalClass=PhysicalClass, entAliasMappingTable=entAliasMappingTable, entPhysicalContainsTable=entPhysicalContainsTable, entLPPhysicalIndex=entLPPhysicalIndex, entAliasMappingIdentifier=entAliasMappingIdentifier, entLPMappingEntry=entLPMappingEntry, entLogicalContextName=entLogicalContextName, entLogicalContextEngineID=entLogicalContextEngineID, entityPhysical2Group=entityPhysical2Group, entPhysicalDescr=entPhysicalDescr, entPhysicalChildIndex=entPhysicalChildIndex, entLogicalIndex=entLogicalIndex, PhysicalIndex=PhysicalIndex, entPhysicalFirmwareRev=entPhysicalFirmwareRev, entity3Compliance=entity3Compliance, entPhysicalParentRelPos=entPhysicalParentRelPos, entPhysicalMfgDate=entPhysicalMfgDate, entityLogical2Group=entityLogical2Group, entPhysicalMfgName=entPhysicalMfgName, entLogicalDescr=entLogicalDescr, entPhysicalContainedIn=entPhysicalContainedIn, entLastChangeTime=entLastChangeTime, entityPhysical3Group=entityPhysical3Group, entAliasMappingEntry=entAliasMappingEntry, entityMIBTraps=entityMIBTraps, entLogicalEntry=entLogicalEntry, entity2Compliance=entity2Compliance, entPhysicalName=entPhysicalName, entPhysicalAssetID=entPhysicalAssetID, PYSNMP_MODULE_ID=entityMIB, entityMIBObjects=entityMIBObjects, entLogicalTDomain=entLogicalTDomain, entPhysicalEntry=entPhysicalEntry, entityCompliances=entityCompliances, entLogicalTable=entLogicalTable, entityConformance=entityConformance, entPhysicalModelName=entPhysicalModelName, entityGroups=entityGroups, entityPhysicalGroup=entityPhysicalGroup, entityGeneral=entityGeneral, entLPMappingTable=entLPMappingTable, entPhysicalSerialNum=entPhysicalSerialNum, entityMIBTrapPrefix=entityMIBTrapPrefix, entityCompliance=entityCompliance, entityPhysical=entityPhysical, entPhysicalIndex=entPhysicalIndex, entityNotificationsGroup=entityNotificationsGroup, entityMappingGroup=entityMappingGroup, entPhysicalSoftwareRev=entPhysicalSoftwareRev, entityMapping=entityMapping, PhysicalIndexOrZero=PhysicalIndexOrZero, entPhysicalClass=entPhysicalClass, entityGeneralGroup=entityGeneralGroup, SnmpEngineIdOrNone=SnmpEngineIdOrNone, entLogicalCommunity=entLogicalCommunity, entPhysicalVendorType=entPhysicalVendorType, entityLogicalGroup=entityLogicalGroup)
