;;; py-shell-arg-ert-tests.el --- py-shell ert tests

;; Copyright (C) 2015  Andreas Röhler
;; Author: Andreas Röhler <andreas.roehler@online.de>
;; Keywords: languages, convenience

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; This file is generated by function from python-mode-utils.el - see in
;; directory devel. Edits here might not be persistent.

;;; Code:

(ert-deftest py-ert-python-shell-test ()
  (let ((py-python-command-args  (list "-i -c\"abc=4\"")))
    (py-kill-buffer-unconditional "*Python*")
    (python)
    (should (buffer-live-p (get-buffer "*Python*")))
    (set-buffer (get-buffer "*Python*"))
    (should (string= "4" py-result))
    (should (< 1 comint-last-input-end))))

(ert-deftest py-ert-python2-shell-test ()
  (let ((py-python2-command-args  (list "-i -c\"abc=4\"")))
    (py-kill-buffer-unconditional "*Python2*")
    (python2)
    (should (buffer-live-p (get-buffer "*Python2*")))
    (set-buffer (get-buffer "*Python2*"))
    (should (string= "4" py-result))
    (should (< 1 comint-last-input-end))))

(ert-deftest py-ert-python3-shell-test ()
  (let ((py-python3-command-args  (list "-i -c\"abc=4\"")))
    (py-kill-buffer-unconditional "*Python3*")
    (python3)
    (should (buffer-live-p (get-buffer "*Python3*")))
    (set-buffer (get-buffer "*Python3*"))
    (should (string= "4" py-result))
    (should (< 1 comint-last-input-end))))

(ert-deftest py-ert-ipython-shell-test ()
  (let ((py-ipython-command-args  (list "-i -c\"abc=4\"")))
    (py-kill-buffer-unconditional "*IPython*")
    (ipython)
    (should (buffer-live-p (get-buffer "*IPython*")))
    (set-buffer (get-buffer "*IPython*"))
    (should (string= "4" py-result))
    (should (< 1 comint-last-input-end))))

(ert-deftest py-ert-ipython2.7-shell-test ()
  (let ((py-ipython2.7-command-args  (list "-i -c\"abc=4\"")))
    (py-kill-buffer-unconditional "*IPython2.7*")
    (ipython2.7)
    (should (buffer-live-p (get-buffer "*IPython2.7*")))
    (set-buffer (get-buffer "*IPython2.7*"))
    (should (string= "4" py-result))
    (should (< 1 comint-last-input-end))))

(ert-deftest py-ert-ipython3-shell-test ()
  (let ((py-ipython3-command-args  (list "-i -c\"abc=4\"")))
    (py-kill-buffer-unconditional "*IPython3*")
    (ipython3)
    (should (buffer-live-p (get-buffer "*IPython3*")))
    (set-buffer (get-buffer "*IPython3*"))
    (should (string= "4" py-result))
    (should (< 1 comint-last-input-end))))

(ert-deftest py-ert-jython-shell-test ()
  (let ((py-jython-command-args  (list "-i -c\"abc=4\"")))
    (py-kill-buffer-unconditional "*Jython*")
    (jython)
    (should (buffer-live-p (get-buffer "*Jython*")))
    (set-buffer (get-buffer "*Jython*"))
    (should (string= "4" py-result))
    (should (< 1 comint-last-input-end))))

(provide 'py-shell-arg-ert-tests)
;;; py-shell-arg-ert-tests.el ends here
 
