# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Optional, TypeVar

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class SqlVulnerabilityAssessmentBaselineRulesOperations(object):
    """SqlVulnerabilityAssessmentBaselineRulesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.security.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def create_or_update(
        self,
        rule_id,  # type: str
        workspace_id,  # type: str
        resource_id,  # type: str
        body=None,  # type: Optional["_models.RuleResultsInput"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.RuleResults"
        """Creates a Baseline for a rule in a database. Will overwrite any previously existing results.

        Creates a Baseline for a rule in a database. Will overwrite any previously existing results.

        :param rule_id: The rule Id.
        :type rule_id: str
        :param workspace_id: The workspace Id.
        :type workspace_id: str
        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :param body: The baseline results for this rule.
        :type body: ~azure.mgmt.security.models.RuleResultsInput
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RuleResults, or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RuleResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RuleResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-01-preview"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.create_or_update.metadata['url']  # type: ignore
        path_format_arguments = {
            'ruleId': self._serialize.url("rule_id", rule_id, 'str'),
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['workspaceId'] = self._serialize.query("workspace_id", workspace_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'RuleResultsInput')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('RuleResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_or_update.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}'}  # type: ignore

    def get(
        self,
        rule_id,  # type: str
        workspace_id,  # type: str
        resource_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.RuleResults"
        """Gets the results for a given rule in the Baseline.

        Gets the results for a given rule in the Baseline.

        :param rule_id: The rule Id.
        :type rule_id: str
        :param workspace_id: The workspace Id.
        :type workspace_id: str
        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RuleResults, or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RuleResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RuleResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-01-preview"
        accept = "application/json"

        # Construct URL
        url = self.get.metadata['url']  # type: ignore
        path_format_arguments = {
            'ruleId': self._serialize.url("rule_id", rule_id, 'str'),
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['workspaceId'] = self._serialize.query("workspace_id", workspace_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('RuleResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}'}  # type: ignore

    def delete(
        self,
        rule_id,  # type: str
        workspace_id,  # type: str
        resource_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Deletes a rule from the Baseline of a given database.

        Deletes a rule from the Baseline of a given database.

        :param rule_id: The rule Id.
        :type rule_id: str
        :param workspace_id: The workspace Id.
        :type workspace_id: str
        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-01-preview"
        accept = "application/json"

        # Construct URL
        url = self.delete.metadata['url']  # type: ignore
        path_format_arguments = {
            'ruleId': self._serialize.url("rule_id", rule_id, 'str'),
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['workspaceId'] = self._serialize.query("workspace_id", workspace_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}'}  # type: ignore

    def list(
        self,
        workspace_id,  # type: str
        resource_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.RulesResults"
        """Gets the results for all rules in the Baseline.

        Gets the results for all rules in the Baseline.

        :param workspace_id: The workspace Id.
        :type workspace_id: str
        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RulesResults, or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RulesResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RulesResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-01-preview"
        accept = "application/json"

        # Construct URL
        url = self.list.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['workspaceId'] = self._serialize.query("workspace_id", workspace_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('RulesResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    list.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules'}  # type: ignore

    def add(
        self,
        workspace_id,  # type: str
        resource_id,  # type: str
        body=None,  # type: Optional["_models.RulesResultsInput"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.RulesResults"
        """Add a list of baseline rules. Will overwrite any previously existing results (for all rules).

        Add a list of baseline rules. Will overwrite any previously existing results (for all rules).

        :param workspace_id: The workspace Id.
        :type workspace_id: str
        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :param body: The baseline rules.
        :type body: ~azure.mgmt.security.models.RulesResultsInput
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RulesResults, or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.RulesResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RulesResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-01-preview"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.add.metadata['url']  # type: ignore
        path_format_arguments = {
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['workspaceId'] = self._serialize.query("workspace_id", workspace_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'RulesResultsInput')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('RulesResults', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    add.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules'}  # type: ignore
