# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._image_builder_client_enums import *


class ApiError(msrest.serialization.Model):
    """Api error.

    :param details: The Api error details.
    :type details: list[~azure.mgmt.imagebuilder.models.ApiErrorBase]
    :param inner_error: The Api inner error.
    :type inner_error: ~azure.mgmt.imagebuilder.models.InnerError
    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'details': {'key': 'details', 'type': '[ApiErrorBase]'},
        'inner_error': {'key': 'innerError', 'type': 'InnerError'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        details: Optional[List["ApiErrorBase"]] = None,
        inner_error: Optional["InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ApiError, self).__init__(**kwargs)
        self.details = details
        self.inner_error = inner_error
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(msrest.serialization.Model):
    """Api error base.

    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ApiErrorBase, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ComponentsVrq145SchemasImagetemplateidentityPropertiesUserassignedidentitiesAdditionalproperties(msrest.serialization.Model):
    """ComponentsVrq145SchemasImagetemplateidentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentsVrq145SchemasImagetemplateidentityPropertiesUserassignedidentitiesAdditionalproperties, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ImageTemplate(Resource):
    """Image template is an ARM resource managed by Microsoft.VirtualMachineImages provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: Required. The identity of the image template, if configured.
    :type identity: ~azure.mgmt.imagebuilder.models.ImageTemplateIdentity
    :param source: Specifies the properties used to describe the source image.
    :type source: ~azure.mgmt.imagebuilder.models.ImageTemplateSource
    :param customize: Specifies the properties used to describe the customization steps of the
     image, like Image source etc.
    :type customize: list[~azure.mgmt.imagebuilder.models.ImageTemplateCustomizer]
    :param distribute: The distribution targets where the image output needs to go to.
    :type distribute: list[~azure.mgmt.imagebuilder.models.ImageTemplateDistributor]
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.imagebuilder.models.ProvisioningState
    :ivar provisioning_error: Provisioning error, if any.
    :vartype provisioning_error: ~azure.mgmt.imagebuilder.models.ProvisioningError
    :ivar last_run_status: State of 'run' that is currently executing or was last executed.
    :vartype last_run_status: ~azure.mgmt.imagebuilder.models.ImageTemplateLastRunStatus
    :param build_timeout_in_minutes: Maximum duration to wait while building the image template.
     Omit or specify 0 to use the default (4 hours).
    :type build_timeout_in_minutes: int
    :param vm_profile: Describes how virtual machine is set up to build images.
    :type vm_profile: ~azure.mgmt.imagebuilder.models.ImageTemplateVmProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'identity': {'required': True},
        'provisioning_state': {'readonly': True},
        'provisioning_error': {'readonly': True},
        'last_run_status': {'readonly': True},
        'build_timeout_in_minutes': {'maximum': 960, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ImageTemplateIdentity'},
        'source': {'key': 'properties.source', 'type': 'ImageTemplateSource'},
        'customize': {'key': 'properties.customize', 'type': '[ImageTemplateCustomizer]'},
        'distribute': {'key': 'properties.distribute', 'type': '[ImageTemplateDistributor]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'provisioning_error': {'key': 'properties.provisioningError', 'type': 'ProvisioningError'},
        'last_run_status': {'key': 'properties.lastRunStatus', 'type': 'ImageTemplateLastRunStatus'},
        'build_timeout_in_minutes': {'key': 'properties.buildTimeoutInMinutes', 'type': 'int'},
        'vm_profile': {'key': 'properties.vmProfile', 'type': 'ImageTemplateVmProfile'},
    }

    def __init__(
        self,
        *,
        location: str,
        identity: "ImageTemplateIdentity",
        tags: Optional[Dict[str, str]] = None,
        source: Optional["ImageTemplateSource"] = None,
        customize: Optional[List["ImageTemplateCustomizer"]] = None,
        distribute: Optional[List["ImageTemplateDistributor"]] = None,
        build_timeout_in_minutes: Optional[int] = 0,
        vm_profile: Optional["ImageTemplateVmProfile"] = None,
        **kwargs
    ):
        super(ImageTemplate, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.source = source
        self.customize = customize
        self.distribute = distribute
        self.provisioning_state = None
        self.provisioning_error = None
        self.last_run_status = None
        self.build_timeout_in_minutes = build_timeout_in_minutes
        self.vm_profile = vm_profile


class ImageTemplateCustomizer(msrest.serialization.Model):
    """Describes a unit of image customization.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ImageTemplateFileCustomizer, ImageTemplatePowerShellCustomizer, ImageTemplateShellCustomizer, ImageTemplateRestartCustomizer, ImageTemplateWindowsUpdateCustomizer.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of customization tool you want to use on the Image. For
     example, "Shell" can be shell customizer.Constant filled by server.
    :type type: str
    :param name: Friendly Name to provide context on what this customization step does.
    :type name: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'File': 'ImageTemplateFileCustomizer', 'PowerShell': 'ImageTemplatePowerShellCustomizer', 'Shell': 'ImageTemplateShellCustomizer', 'WindowsRestart': 'ImageTemplateRestartCustomizer', 'WindowsUpdate': 'ImageTemplateWindowsUpdateCustomizer'}
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ImageTemplateCustomizer, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.name = name


class ImageTemplateDistributor(msrest.serialization.Model):
    """Generic distribution object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ImageTemplateManagedImageDistributor, ImageTemplateSharedImageDistributor, ImageTemplateVhdDistributor.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of distribution.Constant filled by server.
    :type type: str
    :param run_output_name: Required. The name to be used for the associated RunOutput.
    :type run_output_name: str
    :param artifact_tags: Tags that will be applied to the artifact once it has been
     created/updated by the distributor.
    :type artifact_tags: dict[str, str]
    """

    _validation = {
        'type': {'required': True},
        'run_output_name': {'required': True, 'pattern': r'^[A-Za-z0-9-_.]{1,64}$'},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'run_output_name': {'key': 'runOutputName', 'type': 'str'},
        'artifact_tags': {'key': 'artifactTags', 'type': '{str}'},
    }

    _subtype_map = {
        'type': {'ManagedImage': 'ImageTemplateManagedImageDistributor', 'SharedImage': 'ImageTemplateSharedImageDistributor', 'VHD': 'ImageTemplateVhdDistributor'}
    }

    def __init__(
        self,
        *,
        run_output_name: str,
        artifact_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ImageTemplateDistributor, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.run_output_name = run_output_name
        self.artifact_tags = artifact_tags


class ImageTemplateFileCustomizer(ImageTemplateCustomizer):
    """Uploads files to VMs (Linux, Windows). Corresponds to Packer file provisioner.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of customization tool you want to use on the Image. For
     example, "Shell" can be shell customizer.Constant filled by server.
    :type type: str
    :param name: Friendly Name to provide context on what this customization step does.
    :type name: str
    :param source_uri: The URI of the file to be uploaded for customizing the VM. It can be a
     github link, SAS URI for Azure Storage, etc.
    :type source_uri: str
    :param sha256_checksum: SHA256 checksum of the file provided in the sourceUri field above.
    :type sha256_checksum: str
    :param destination: The absolute path to a file (with nested directory structures already
     created) where the file (from sourceUri) will be uploaded to in the VM.
    :type destination: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'source_uri': {'key': 'sourceUri', 'type': 'str'},
        'sha256_checksum': {'key': 'sha256Checksum', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        source_uri: Optional[str] = None,
        sha256_checksum: Optional[str] = "",
        destination: Optional[str] = None,
        **kwargs
    ):
        super(ImageTemplateFileCustomizer, self).__init__(name=name, **kwargs)
        self.type = 'File'  # type: str
        self.source_uri = source_uri
        self.sha256_checksum = sha256_checksum
        self.destination = destination


class ImageTemplateIdentity(msrest.serialization.Model):
    """Identity for the image template.

    :param type: The type of identity used for the image template. The type 'None' will remove any
     identities from the image template. Possible values include: "UserAssigned", "None".
    :type type: str or ~azure.mgmt.imagebuilder.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with the image
     template. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.imagebuilder.models.ComponentsVrq145SchemasImagetemplateidentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ComponentsVrq145SchemasImagetemplateidentityPropertiesUserassignedidentitiesAdditionalproperties}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "ComponentsVrq145SchemasImagetemplateidentityPropertiesUserassignedidentitiesAdditionalproperties"]] = None,
        **kwargs
    ):
        super(ImageTemplateIdentity, self).__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ImageTemplateLastRunStatus(msrest.serialization.Model):
    """Describes the latest status of running an image template.

    :param start_time: Start time of the last run (UTC).
    :type start_time: ~datetime.datetime
    :param end_time: End time of the last run (UTC).
    :type end_time: ~datetime.datetime
    :param run_state: State of the last run. Possible values include: "Running", "Canceling",
     "Succeeded", "PartiallySucceeded", "Failed", "Canceled".
    :type run_state: str or ~azure.mgmt.imagebuilder.models.RunState
    :param run_sub_state: Sub-state of the last run. Possible values include: "Queued", "Building",
     "Customizing", "Distributing".
    :type run_sub_state: str or ~azure.mgmt.imagebuilder.models.RunSubState
    :param message: Verbose information about the last run state.
    :type message: str
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'run_state': {'key': 'runState', 'type': 'str'},
        'run_sub_state': {'key': 'runSubState', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        run_state: Optional[Union[str, "RunState"]] = None,
        run_sub_state: Optional[Union[str, "RunSubState"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ImageTemplateLastRunStatus, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.run_state = run_state
        self.run_sub_state = run_sub_state
        self.message = message


class ImageTemplateListResult(msrest.serialization.Model):
    """The result of List image templates operation.

    :param value: An array of image templates.
    :type value: list[~azure.mgmt.imagebuilder.models.ImageTemplate]
    :param next_link: The continuation token.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ImageTemplate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ImageTemplate"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ImageTemplateListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImageTemplateManagedImageDistributor(ImageTemplateDistributor):
    """Distribute as a Managed Disk Image.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of distribution.Constant filled by server.
    :type type: str
    :param run_output_name: Required. The name to be used for the associated RunOutput.
    :type run_output_name: str
    :param artifact_tags: Tags that will be applied to the artifact once it has been
     created/updated by the distributor.
    :type artifact_tags: dict[str, str]
    :param image_id: Required. Resource Id of the Managed Disk Image.
    :type image_id: str
    :param location: Required. Azure location for the image, should match if image already exists.
    :type location: str
    """

    _validation = {
        'type': {'required': True},
        'run_output_name': {'required': True, 'pattern': r'^[A-Za-z0-9-_.]{1,64}$'},
        'image_id': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'run_output_name': {'key': 'runOutputName', 'type': 'str'},
        'artifact_tags': {'key': 'artifactTags', 'type': '{str}'},
        'image_id': {'key': 'imageId', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_output_name: str,
        image_id: str,
        location: str,
        artifact_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ImageTemplateManagedImageDistributor, self).__init__(run_output_name=run_output_name, artifact_tags=artifact_tags, **kwargs)
        self.type = 'ManagedImage'  # type: str
        self.image_id = image_id
        self.location = location


class ImageTemplateSource(msrest.serialization.Model):
    """Describes a virtual machine image source for building, customizing and distributing.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ImageTemplateManagedImageSource, ImageTemplatePlatformImageSource, ImageTemplateSharedImageVersionSource.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Specifies the type of source image you want to start with.Constant
     filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'ManagedImage': 'ImageTemplateManagedImageSource', 'PlatformImage': 'ImageTemplatePlatformImageSource', 'SharedImageVersion': 'ImageTemplateSharedImageVersionSource'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageTemplateSource, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class ImageTemplateManagedImageSource(ImageTemplateSource):
    """Describes an image source that is a managed image in customer subscription.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Specifies the type of source image you want to start with.Constant
     filled by server.
    :type type: str
    :param image_id: Required. ARM resource id of the managed image in customer subscription.
    :type image_id: str
    """

    _validation = {
        'type': {'required': True},
        'image_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'image_id': {'key': 'imageId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        image_id: str,
        **kwargs
    ):
        super(ImageTemplateManagedImageSource, self).__init__(**kwargs)
        self.type = 'ManagedImage'  # type: str
        self.image_id = image_id


class ImageTemplatePlatformImageSource(ImageTemplateSource):
    """Describes an image source from `Azure Gallery Images <https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages>`_.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Specifies the type of source image you want to start with.Constant
     filled by server.
    :type type: str
    :param publisher: Image Publisher in `Azure Gallery Images
     <https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages>`_.
    :type publisher: str
    :param offer: Image offer from the `Azure Gallery Images
     <https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages>`_.
    :type offer: str
    :param sku: Image sku from the `Azure Gallery Images
     <https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages>`_.
    :type sku: str
    :param version: Image version from the `Azure Gallery Images
     <https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages>`_. If 'latest' is
     specified here, the version is evaluated when the image build takes place, not when the
     template is submitted. Specifying 'latest' could cause ROUNDTRIP_INCONSISTENT_PROPERTY issue
     which will be fixed.
    :type version: str
    :param plan_info: Optional configuration of purchase plan for platform image.
    :type plan_info: ~azure.mgmt.imagebuilder.models.PlatformImagePurchasePlan
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'plan_info': {'key': 'planInfo', 'type': 'PlatformImagePurchasePlan'},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        plan_info: Optional["PlatformImagePurchasePlan"] = None,
        **kwargs
    ):
        super(ImageTemplatePlatformImageSource, self).__init__(**kwargs)
        self.type = 'PlatformImage'  # type: str
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
        self.plan_info = plan_info


class ImageTemplatePowerShellCustomizer(ImageTemplateCustomizer):
    """Runs the specified PowerShell on the VM (Windows). Corresponds to Packer powershell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of customization tool you want to use on the Image. For
     example, "Shell" can be shell customizer.Constant filled by server.
    :type type: str
    :param name: Friendly Name to provide context on what this customization step does.
    :type name: str
    :param script_uri: URI of the PowerShell script to be run for customizing. It can be a github
     link, SAS URI for Azure Storage, etc.
    :type script_uri: str
    :param sha256_checksum: SHA256 checksum of the power shell script provided in the scriptUri
     field above.
    :type sha256_checksum: str
    :param inline: Array of PowerShell commands to execute.
    :type inline: list[str]
    :param run_elevated: If specified, the PowerShell script will be run with elevated privileges.
    :type run_elevated: bool
    :param run_as_system: If specified, the PowerShell script will be run with elevated privileges
     using the Local System user. Can only be true when the runElevated field above is set to true.
    :type run_as_system: bool
    :param valid_exit_codes: Valid exit codes for the PowerShell script. [Default: 0].
    :type valid_exit_codes: list[int]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'script_uri': {'key': 'scriptUri', 'type': 'str'},
        'sha256_checksum': {'key': 'sha256Checksum', 'type': 'str'},
        'inline': {'key': 'inline', 'type': '[str]'},
        'run_elevated': {'key': 'runElevated', 'type': 'bool'},
        'run_as_system': {'key': 'runAsSystem', 'type': 'bool'},
        'valid_exit_codes': {'key': 'validExitCodes', 'type': '[int]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        script_uri: Optional[str] = None,
        sha256_checksum: Optional[str] = "",
        inline: Optional[List[str]] = None,
        run_elevated: Optional[bool] = False,
        run_as_system: Optional[bool] = False,
        valid_exit_codes: Optional[List[int]] = None,
        **kwargs
    ):
        super(ImageTemplatePowerShellCustomizer, self).__init__(name=name, **kwargs)
        self.type = 'PowerShell'  # type: str
        self.script_uri = script_uri
        self.sha256_checksum = sha256_checksum
        self.inline = inline
        self.run_elevated = run_elevated
        self.run_as_system = run_as_system
        self.valid_exit_codes = valid_exit_codes


class ImageTemplateRestartCustomizer(ImageTemplateCustomizer):
    """Reboots a VM and waits for it to come back online (Windows). Corresponds to Packer windows-restart provisioner.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of customization tool you want to use on the Image. For
     example, "Shell" can be shell customizer.Constant filled by server.
    :type type: str
    :param name: Friendly Name to provide context on what this customization step does.
    :type name: str
    :param restart_command: Command to execute the restart [Default: 'shutdown /r /f /t 0 /c
     "packer restart"'].
    :type restart_command: str
    :param restart_check_command: Command to check if restart succeeded [Default: ''].
    :type restart_check_command: str
    :param restart_timeout: Restart timeout specified as a string of magnitude and unit, e.g. '5m'
     (5 minutes) or '2h' (2 hours) [Default: '5m'].
    :type restart_timeout: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'restart_command': {'key': 'restartCommand', 'type': 'str'},
        'restart_check_command': {'key': 'restartCheckCommand', 'type': 'str'},
        'restart_timeout': {'key': 'restartTimeout', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        restart_command: Optional[str] = None,
        restart_check_command: Optional[str] = None,
        restart_timeout: Optional[str] = None,
        **kwargs
    ):
        super(ImageTemplateRestartCustomizer, self).__init__(name=name, **kwargs)
        self.type = 'WindowsRestart'  # type: str
        self.restart_command = restart_command
        self.restart_check_command = restart_check_command
        self.restart_timeout = restart_timeout


class ImageTemplateSharedImageDistributor(ImageTemplateDistributor):
    """Distribute via Shared Image Gallery.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of distribution.Constant filled by server.
    :type type: str
    :param run_output_name: Required. The name to be used for the associated RunOutput.
    :type run_output_name: str
    :param artifact_tags: Tags that will be applied to the artifact once it has been
     created/updated by the distributor.
    :type artifact_tags: dict[str, str]
    :param gallery_image_id: Required. Resource Id of the Shared Image Gallery image.
    :type gallery_image_id: str
    :param replication_regions: Required. A list of regions that the image will be replicated to.
    :type replication_regions: list[str]
    :param exclude_from_latest: Flag that indicates whether created image version should be
     excluded from latest. Omit to use the default (false).
    :type exclude_from_latest: bool
    :param storage_account_type: Storage account type to be used to store the shared image. Omit to
     use the default (Standard_LRS). Possible values include: "Standard_LRS", "Standard_ZRS".
    :type storage_account_type: str or
     ~azure.mgmt.imagebuilder.models.SharedImageStorageAccountType
    """

    _validation = {
        'type': {'required': True},
        'run_output_name': {'required': True, 'pattern': r'^[A-Za-z0-9-_.]{1,64}$'},
        'gallery_image_id': {'required': True},
        'replication_regions': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'run_output_name': {'key': 'runOutputName', 'type': 'str'},
        'artifact_tags': {'key': 'artifactTags', 'type': '{str}'},
        'gallery_image_id': {'key': 'galleryImageId', 'type': 'str'},
        'replication_regions': {'key': 'replicationRegions', 'type': '[str]'},
        'exclude_from_latest': {'key': 'excludeFromLatest', 'type': 'bool'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_output_name: str,
        gallery_image_id: str,
        replication_regions: List[str],
        artifact_tags: Optional[Dict[str, str]] = None,
        exclude_from_latest: Optional[bool] = False,
        storage_account_type: Optional[Union[str, "SharedImageStorageAccountType"]] = None,
        **kwargs
    ):
        super(ImageTemplateSharedImageDistributor, self).__init__(run_output_name=run_output_name, artifact_tags=artifact_tags, **kwargs)
        self.type = 'SharedImage'  # type: str
        self.gallery_image_id = gallery_image_id
        self.replication_regions = replication_regions
        self.exclude_from_latest = exclude_from_latest
        self.storage_account_type = storage_account_type


class ImageTemplateSharedImageVersionSource(ImageTemplateSource):
    """Describes an image source that is an image version in a shared image gallery.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Specifies the type of source image you want to start with.Constant
     filled by server.
    :type type: str
    :param image_version_id: Required. ARM resource id of the image version in the shared image
     gallery.
    :type image_version_id: str
    """

    _validation = {
        'type': {'required': True},
        'image_version_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'image_version_id': {'key': 'imageVersionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        image_version_id: str,
        **kwargs
    ):
        super(ImageTemplateSharedImageVersionSource, self).__init__(**kwargs)
        self.type = 'SharedImageVersion'  # type: str
        self.image_version_id = image_version_id


class ImageTemplateShellCustomizer(ImageTemplateCustomizer):
    """Runs a shell script during the customization phase (Linux). Corresponds to Packer shell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of customization tool you want to use on the Image. For
     example, "Shell" can be shell customizer.Constant filled by server.
    :type type: str
    :param name: Friendly Name to provide context on what this customization step does.
    :type name: str
    :param script_uri: URI of the shell script to be run for customizing. It can be a github link,
     SAS URI for Azure Storage, etc.
    :type script_uri: str
    :param sha256_checksum: SHA256 checksum of the shell script provided in the scriptUri field.
    :type sha256_checksum: str
    :param inline: Array of shell commands to execute.
    :type inline: list[str]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'script_uri': {'key': 'scriptUri', 'type': 'str'},
        'sha256_checksum': {'key': 'sha256Checksum', 'type': 'str'},
        'inline': {'key': 'inline', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        script_uri: Optional[str] = None,
        sha256_checksum: Optional[str] = "",
        inline: Optional[List[str]] = None,
        **kwargs
    ):
        super(ImageTemplateShellCustomizer, self).__init__(name=name, **kwargs)
        self.type = 'Shell'  # type: str
        self.script_uri = script_uri
        self.sha256_checksum = sha256_checksum
        self.inline = inline


class ImageTemplateUpdateParameters(msrest.serialization.Model):
    """Parameters for updating an image template.

    :param identity: The identity of the image template, if configured.
    :type identity: ~azure.mgmt.imagebuilder.models.ImageTemplateIdentity
    :param tags: A set of tags. The user-specified tags associated with the image template.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ImageTemplateIdentity'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        identity: Optional["ImageTemplateIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ImageTemplateUpdateParameters, self).__init__(**kwargs)
        self.identity = identity
        self.tags = tags


class ImageTemplateVhdDistributor(ImageTemplateDistributor):
    """Distribute via VHD in a storage account.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of distribution.Constant filled by server.
    :type type: str
    :param run_output_name: Required. The name to be used for the associated RunOutput.
    :type run_output_name: str
    :param artifact_tags: Tags that will be applied to the artifact once it has been
     created/updated by the distributor.
    :type artifact_tags: dict[str, str]
    """

    _validation = {
        'type': {'required': True},
        'run_output_name': {'required': True, 'pattern': r'^[A-Za-z0-9-_.]{1,64}$'},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'run_output_name': {'key': 'runOutputName', 'type': 'str'},
        'artifact_tags': {'key': 'artifactTags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        run_output_name: str,
        artifact_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ImageTemplateVhdDistributor, self).__init__(run_output_name=run_output_name, artifact_tags=artifact_tags, **kwargs)
        self.type = 'VHD'  # type: str


class ImageTemplateVmProfile(msrest.serialization.Model):
    """Describes the virtual machine used to build, customize and capture images.

    :param vm_size: Size of the virtual machine used to build, customize and capture images. Omit
     or specify empty string to use the default (Standard_D1_v2).
    :type vm_size: str
    :param os_disk_size_gb: Size of the OS disk in GB. Omit or specify 0 to use Azure's default OS
     disk size.
    :type os_disk_size_gb: int
    :param vnet_config: Optional configuration of the virtual network to use to deploy the build
     virtual machine in. Omit if no specific virtual network needs to be used.
    :type vnet_config: ~azure.mgmt.imagebuilder.models.VirtualNetworkConfig
    """

    _validation = {
        'os_disk_size_gb': {'minimum': 0},
    }

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_config': {'key': 'vnetConfig', 'type': 'VirtualNetworkConfig'},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[str] = "",
        os_disk_size_gb: Optional[int] = 0,
        vnet_config: Optional["VirtualNetworkConfig"] = None,
        **kwargs
    ):
        super(ImageTemplateVmProfile, self).__init__(**kwargs)
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_config = vnet_config


class ImageTemplateWindowsUpdateCustomizer(ImageTemplateCustomizer):
    """Installs Windows Updates. Corresponds to Packer Windows Update Provisioner (https://github.com/rgl/packer-provisioner-windows-update).

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of customization tool you want to use on the Image. For
     example, "Shell" can be shell customizer.Constant filled by server.
    :type type: str
    :param name: Friendly Name to provide context on what this customization step does.
    :type name: str
    :param search_criteria: Criteria to search updates. Omit or specify empty string to use the
     default (search all). Refer to above link for examples and detailed description of this field.
    :type search_criteria: str
    :param filters: Array of filters to select updates to apply. Omit or specify empty array to use
     the default (no filter). Refer to above link for examples and detailed description of this
     field.
    :type filters: list[str]
    :param update_limit: Maximum number of updates to apply at a time. Omit or specify 0 to use the
     default (1000).
    :type update_limit: int
    """

    _validation = {
        'type': {'required': True},
        'update_limit': {'minimum': 0},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'search_criteria': {'key': 'searchCriteria', 'type': 'str'},
        'filters': {'key': 'filters', 'type': '[str]'},
        'update_limit': {'key': 'updateLimit', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        search_criteria: Optional[str] = None,
        filters: Optional[List[str]] = None,
        update_limit: Optional[int] = None,
        **kwargs
    ):
        super(ImageTemplateWindowsUpdateCustomizer, self).__init__(name=name, **kwargs)
        self.type = 'WindowsUpdate'  # type: str
        self.search_criteria = search_criteria
        self.filters = filters
        self.update_limit = update_limit


class InnerError(msrest.serialization.Model):
    """Inner error details.

    :param exception_type: The exception type.
    :type exception_type: str
    :param error_detail: The internal error message or exception dump.
    :type error_detail: str
    """

    _attribute_map = {
        'exception_type': {'key': 'exceptionType', 'type': 'str'},
        'error_detail': {'key': 'errorDetail', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        exception_type: Optional[str] = None,
        error_detail: Optional[str] = None,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.exception_type = exception_type
        self.error_detail = error_detail


class Operation(msrest.serialization.Model):
    """A REST API operation.

    :param name: This is of the format {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that describes the operation.
    :type display: ~azure.mgmt.imagebuilder.models.OperationDisplay
    :param origin: The intended executor of the operation.
    :type origin: str
    :param properties: Any object.
    :type properties: any
    :param is_data_action: The flag that indicates whether the operation applies to data plane.
    :type is_data_action: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[Any] = None,
        is_data_action: Optional[bool] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties
        self.is_data_action = is_data_action


class OperationDisplay(msrest.serialization.Model):
    """The object that describes the operation.

    :param provider: Friendly name of the resource provider.
    :type provider: str
    :param operation: For example: read, write, delete, or listKeys/action.
    :type operation: str
    :param resource: The resource type on which the operation is performed.
    :type resource: str
    :param description: The friendly name of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        operation: Optional[str] = None,
        resource: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.operation = operation
        self.resource = resource
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next set of results.

    :param value: The list of operations supported by the resource provider.
    :type value: list[~azure.mgmt.imagebuilder.models.Operation]
    :param next_link: The URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PlatformImagePurchasePlan(msrest.serialization.Model):
    """Purchase plan configuration for platform image.

    All required parameters must be populated in order to send to Azure.

    :param plan_name: Required. Name of the purchase plan.
    :type plan_name: str
    :param plan_product: Required. Product of the purchase plan.
    :type plan_product: str
    :param plan_publisher: Required. Publisher of the purchase plan.
    :type plan_publisher: str
    """

    _validation = {
        'plan_name': {'required': True},
        'plan_product': {'required': True},
        'plan_publisher': {'required': True},
    }

    _attribute_map = {
        'plan_name': {'key': 'planName', 'type': 'str'},
        'plan_product': {'key': 'planProduct', 'type': 'str'},
        'plan_publisher': {'key': 'planPublisher', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        plan_name: str,
        plan_product: str,
        plan_publisher: str,
        **kwargs
    ):
        super(PlatformImagePurchasePlan, self).__init__(**kwargs)
        self.plan_name = plan_name
        self.plan_product = plan_product
        self.plan_publisher = plan_publisher


class ProvisioningError(msrest.serialization.Model):
    """Describes the error happened when create or update an image template.

    :param provisioning_error_code: Error code of the provisioning failure. Possible values
     include: "BadSourceType", "BadPIRSource", "BadManagedImageSource",
     "BadSharedImageVersionSource", "BadCustomizerType", "UnsupportedCustomizerType",
     "NoCustomizerScript", "BadDistributeType", "BadSharedImageDistribute", "ServerError", "Other".
    :type provisioning_error_code: str or ~azure.mgmt.imagebuilder.models.ProvisioningErrorCode
    :param message: Verbose error message about the provisioning failure.
    :type message: str
    """

    _attribute_map = {
        'provisioning_error_code': {'key': 'provisioningErrorCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provisioning_error_code: Optional[Union[str, "ProvisioningErrorCode"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ProvisioningError, self).__init__(**kwargs)
        self.provisioning_error_code = provisioning_error_code
        self.message = message


class SubResource(msrest.serialization.Model):
    """The Sub Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Required. Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = name
        self.type = None


class RunOutput(SubResource):
    """Represents an output that was created by running an image template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Required. Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param artifact_id: The resource id of the artifact.
    :type artifact_id: str
    :param artifact_uri: The location URI of the artifact.
    :type artifact_uri: str
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.imagebuilder.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'artifact_id': {'key': 'properties.artifactId', 'type': 'str'},
        'artifact_uri': {'key': 'properties.artifactUri', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        artifact_id: Optional[str] = None,
        artifact_uri: Optional[str] = None,
        **kwargs
    ):
        super(RunOutput, self).__init__(name=name, **kwargs)
        self.artifact_id = artifact_id
        self.artifact_uri = artifact_uri
        self.provisioning_state = None


class RunOutputCollection(msrest.serialization.Model):
    """The result of List run outputs operation.

    :param value: An array of run outputs.
    :type value: list[~azure.mgmt.imagebuilder.models.RunOutput]
    :param next_link: The continuation token.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RunOutput]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RunOutput"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RunOutputCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkConfig(msrest.serialization.Model):
    """Virtual Network configuration.

    :param subnet_id: Resource id of a pre-existing subnet.
    :type subnet_id: str
    """

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkConfig, self).__init__(**kwargs)
        self.subnet_id = subnet_id
