# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._conversation_analysis_client_enums import *


class AnalysisParameters(msrest.serialization.Model):
    """This is the parameter set of either the Orchestration project itself or one of the target services.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ConversationParameters, LUISParameters, QuestionAnsweringParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar target_kind: Required. The type of a target service.Constant filled by server. Possible
     values include: "luis", "conversation", "question_answering", "non_linked".
    :vartype target_kind: str or ~azure.ai.language.conversations.models.TargetKind
    :ivar api_version: The API version to use when call a specific target service.
    :vartype api_version: str
    """

    _validation = {
        'target_kind': {'required': True},
    }

    _attribute_map = {
        'target_kind': {'key': 'targetKind', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
    }

    _subtype_map = {
        'target_kind': {'conversation': 'ConversationParameters', 'luis': 'LUISParameters', 'question_answering': 'QuestionAnsweringParameters'}
    }

    def __init__(
        self,
        *,
        api_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword api_version: The API version to use when call a specific target service.
        :paramtype api_version: str
        """
        super(AnalysisParameters, self).__init__(**kwargs)
        self.target_kind = None  # type: Optional[str]
        self.api_version = api_version


class AnalyzeConversationResult(msrest.serialization.Model):
    """Represents a conversation analysis response.

    All required parameters must be populated in order to send to Azure.

    :ivar query: Required. The conversation utterance given by the caller.
    :vartype query: str
    :ivar detected_language: The system detected language for the query.
    :vartype detected_language: str
    :ivar prediction: Required. The prediction result of a conversation project.
    :vartype prediction: ~azure.ai.language.conversations.models.BasePrediction
    """

    _validation = {
        'query': {'required': True},
        'prediction': {'required': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'detected_language': {'key': 'detectedLanguage', 'type': 'str'},
        'prediction': {'key': 'prediction', 'type': 'BasePrediction'},
    }

    def __init__(
        self,
        *,
        query: str,
        prediction: "BasePrediction",
        detected_language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword query: Required. The conversation utterance given by the caller.
        :paramtype query: str
        :keyword detected_language: The system detected language for the query.
        :paramtype detected_language: str
        :keyword prediction: Required. The prediction result of a conversation project.
        :paramtype prediction: ~azure.ai.language.conversations.models.BasePrediction
        """
        super(AnalyzeConversationResult, self).__init__(**kwargs)
        self.query = query
        self.detected_language = detected_language
        self.prediction = prediction


class AnswerSpan(msrest.serialization.Model):
    """Answer span object of QnA.

    :ivar text: Predicted text of answer span.
    :vartype text: str
    :ivar confidence_score: Predicted score of answer span, value ranges from 0 to 1.
    :vartype confidence_score: float
    :ivar offset: The answer span offset from the start of answer.
    :vartype offset: int
    :ivar length: The length of the answer span.
    :vartype length: int
    """

    _validation = {
        'confidence_score': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        confidence_score: Optional[float] = None,
        offset: Optional[int] = None,
        length: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword text: Predicted text of answer span.
        :paramtype text: str
        :keyword confidence_score: Predicted score of answer span, value ranges from 0 to 1.
        :paramtype confidence_score: float
        :keyword offset: The answer span offset from the start of answer.
        :paramtype offset: int
        :keyword length: The length of the answer span.
        :paramtype length: int
        """
        super(AnswerSpan, self).__init__(**kwargs)
        self.text = text
        self.confidence_score = confidence_score
        self.offset = offset
        self.length = length


class BasePrediction(msrest.serialization.Model):
    """This is the base class of prediction.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ConversationPrediction, OrchestratorPrediction.

    All required parameters must be populated in order to send to Azure.

    :ivar project_kind: Required. The type of the project.Constant filled by server. Possible
     values include: "conversation", "workflow".
    :vartype project_kind: str or ~azure.ai.language.conversations.models.ProjectKind
    :ivar top_intent: The intent with the highest score.
    :vartype top_intent: str
    """

    _validation = {
        'project_kind': {'required': True},
    }

    _attribute_map = {
        'project_kind': {'key': 'projectKind', 'type': 'str'},
        'top_intent': {'key': 'topIntent', 'type': 'str'},
    }

    _subtype_map = {
        'project_kind': {'conversation': 'ConversationPrediction', 'workflow': 'OrchestratorPrediction'}
    }

    def __init__(
        self,
        *,
        top_intent: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword top_intent: The intent with the highest score.
        :paramtype top_intent: str
        """
        super(BasePrediction, self).__init__(**kwargs)
        self.project_kind = None  # type: Optional[str]
        self.top_intent = top_intent


class ConversationAnalysisOptions(msrest.serialization.Model):
    """The request body.

    All required parameters must be populated in order to send to Azure.

    :ivar query: Required. The conversation utterance to be analyzed.
    :vartype query: str
    :ivar direct_target: The name of the target project this request is sending to directly.
    :vartype direct_target: str
    :ivar language: The language to use in this request. This will be the language setting when
     communicating with all other target projects.
    :vartype language: str
    :ivar verbose: If true, the service will return more detailed information in the response.
    :vartype verbose: bool
    :ivar is_logging_enabled: If true, the query will be kept by the service for customers to
     further review, to improve the model quality.
    :vartype is_logging_enabled: bool
    :ivar parameters: A dictionary representing the input for each target project.
    :vartype parameters: dict[str, ~azure.ai.language.conversations.models.AnalysisParameters]
    """

    _validation = {
        'query': {'required': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'direct_target': {'key': 'directTarget', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
        'verbose': {'key': 'verbose', 'type': 'bool'},
        'is_logging_enabled': {'key': 'isLoggingEnabled', 'type': 'bool'},
        'parameters': {'key': 'parameters', 'type': '{AnalysisParameters}'},
    }

    def __init__(
        self,
        *,
        query: str,
        direct_target: Optional[str] = None,
        language: Optional[str] = None,
        verbose: Optional[bool] = None,
        is_logging_enabled: Optional[bool] = None,
        parameters: Optional[Dict[str, "AnalysisParameters"]] = None,
        **kwargs
    ):
        """
        :keyword query: Required. The conversation utterance to be analyzed.
        :paramtype query: str
        :keyword direct_target: The name of the target project this request is sending to directly.
        :paramtype direct_target: str
        :keyword language: The language to use in this request. This will be the language setting when
         communicating with all other target projects.
        :paramtype language: str
        :keyword verbose: If true, the service will return more detailed information in the response.
        :paramtype verbose: bool
        :keyword is_logging_enabled: If true, the query will be kept by the service for customers to
         further review, to improve the model quality.
        :paramtype is_logging_enabled: bool
        :keyword parameters: A dictionary representing the input for each target project.
        :paramtype parameters: dict[str, ~azure.ai.language.conversations.models.AnalysisParameters]
        """
        super(ConversationAnalysisOptions, self).__init__(**kwargs)
        self.query = query
        self.direct_target = direct_target
        self.language = language
        self.verbose = verbose
        self.is_logging_enabled = is_logging_enabled
        self.parameters = parameters


class ConversationCallingOptions(msrest.serialization.Model):
    """The option to set to call a Conversation project.

    :ivar language: The language of the query.
    :vartype language: str
    :ivar verbose: If true, the service will return more detailed information.
    :vartype verbose: bool
    :ivar is_logging_enabled: If true, the query will be saved for customers to further review in
     authoring, to improve the model quality.
    :vartype is_logging_enabled: bool
    """

    _attribute_map = {
        'language': {'key': 'language', 'type': 'str'},
        'verbose': {'key': 'verbose', 'type': 'bool'},
        'is_logging_enabled': {'key': 'isLoggingEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        language: Optional[str] = None,
        verbose: Optional[bool] = None,
        is_logging_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword language: The language of the query.
        :paramtype language: str
        :keyword verbose: If true, the service will return more detailed information.
        :paramtype verbose: bool
        :keyword is_logging_enabled: If true, the query will be saved for customers to further review
         in authoring, to improve the model quality.
        :paramtype is_logging_enabled: bool
        """
        super(ConversationCallingOptions, self).__init__(**kwargs)
        self.language = language
        self.verbose = verbose
        self.is_logging_enabled = is_logging_enabled


class ConversationEntity(msrest.serialization.Model):
    """The entity extraction result of a Conversation project.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Required. The entity category.
    :vartype category: str
    :ivar text: Required. The predicted entity text.
    :vartype text: str
    :ivar offset: Required. The starting index of this entity in the query.
    :vartype offset: int
    :ivar length: Required. The length of the text.
    :vartype length: int
    :ivar confidence_score: Required. The entity confidence score.
    :vartype confidence_score: float
    :ivar list_keys: List of keys.
    :vartype list_keys: list[str]
    """

    _validation = {
        'category': {'required': True},
        'text': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'list_keys': {'key': 'listKeys', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        category: str,
        text: str,
        offset: int,
        length: int,
        confidence_score: float,
        list_keys: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword category: Required. The entity category.
        :paramtype category: str
        :keyword text: Required. The predicted entity text.
        :paramtype text: str
        :keyword offset: Required. The starting index of this entity in the query.
        :paramtype offset: int
        :keyword length: Required. The length of the text.
        :paramtype length: int
        :keyword confidence_score: Required. The entity confidence score.
        :paramtype confidence_score: float
        :keyword list_keys: List of keys.
        :paramtype list_keys: list[str]
        """
        super(ConversationEntity, self).__init__(**kwargs)
        self.category = category
        self.text = text
        self.offset = offset
        self.length = length
        self.confidence_score = confidence_score
        self.list_keys = list_keys


class ConversationIntent(msrest.serialization.Model):
    """The intent classification result of a Conversation project.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Required. A predicted class.
    :vartype category: str
    :ivar confidence_score: Required. The confidence score of the class from 0.0 to 1.0.
    :vartype confidence_score: float
    """

    _validation = {
        'category': {'required': True},
        'confidence_score': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        category: str,
        confidence_score: float,
        **kwargs
    ):
        """
        :keyword category: Required. A predicted class.
        :paramtype category: str
        :keyword confidence_score: Required. The confidence score of the class from 0.0 to 1.0.
        :paramtype confidence_score: float
        """
        super(ConversationIntent, self).__init__(**kwargs)
        self.category = category
        self.confidence_score = confidence_score


class ConversationParameters(AnalysisParameters):
    """This is a set of request parameters for Customized Conversation projects.

    All required parameters must be populated in order to send to Azure.

    :ivar target_kind: Required. The type of a target service.Constant filled by server. Possible
     values include: "luis", "conversation", "question_answering", "non_linked".
    :vartype target_kind: str or ~azure.ai.language.conversations.models.TargetKind
    :ivar api_version: The API version to use when call a specific target service.
    :vartype api_version: str
    :ivar calling_options: The option to set to call a Conversation project.
    :vartype calling_options: ~azure.ai.language.conversations.models.ConversationCallingOptions
    """

    _validation = {
        'target_kind': {'required': True},
    }

    _attribute_map = {
        'target_kind': {'key': 'targetKind', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'calling_options': {'key': 'callingOptions', 'type': 'ConversationCallingOptions'},
    }

    def __init__(
        self,
        *,
        api_version: Optional[str] = None,
        calling_options: Optional["ConversationCallingOptions"] = None,
        **kwargs
    ):
        """
        :keyword api_version: The API version to use when call a specific target service.
        :paramtype api_version: str
        :keyword calling_options: The option to set to call a Conversation project.
        :paramtype calling_options: ~azure.ai.language.conversations.models.ConversationCallingOptions
        """
        super(ConversationParameters, self).__init__(api_version=api_version, **kwargs)
        self.target_kind = 'conversation'  # type: str
        self.calling_options = calling_options


class ConversationPrediction(BasePrediction):
    """Represents the prediction section of a Conversation project.

    All required parameters must be populated in order to send to Azure.

    :ivar project_kind: Required. The type of the project.Constant filled by server. Possible
     values include: "conversation", "workflow".
    :vartype project_kind: str or ~azure.ai.language.conversations.models.ProjectKind
    :ivar top_intent: The intent with the highest score.
    :vartype top_intent: str
    :ivar intents: Required. The intent classification results.
    :vartype intents: list[~azure.ai.language.conversations.models.ConversationIntent]
    :ivar entities: Required. The entity extraction results.
    :vartype entities: list[~azure.ai.language.conversations.models.ConversationEntity]
    """

    _validation = {
        'project_kind': {'required': True},
        'intents': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        'project_kind': {'key': 'projectKind', 'type': 'str'},
        'top_intent': {'key': 'topIntent', 'type': 'str'},
        'intents': {'key': 'intents', 'type': '[ConversationIntent]'},
        'entities': {'key': 'entities', 'type': '[ConversationEntity]'},
    }

    def __init__(
        self,
        *,
        intents: List["ConversationIntent"],
        entities: List["ConversationEntity"],
        top_intent: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword top_intent: The intent with the highest score.
        :paramtype top_intent: str
        :keyword intents: Required. The intent classification results.
        :paramtype intents: list[~azure.ai.language.conversations.models.ConversationIntent]
        :keyword entities: Required. The entity extraction results.
        :paramtype entities: list[~azure.ai.language.conversations.models.ConversationEntity]
        """
        super(ConversationPrediction, self).__init__(top_intent=top_intent, **kwargs)
        self.project_kind = 'conversation'  # type: str
        self.intents = intents
        self.entities = entities


class ConversationResult(msrest.serialization.Model):
    """The response returned by a Conversation project.

    All required parameters must be populated in order to send to Azure.

    :ivar query: Required. The same query given in request.
    :vartype query: str
    :ivar detected_language: The detected language from the query.
    :vartype detected_language: str
    :ivar prediction: Required. The predicted result for the query.
    :vartype prediction: ~azure.ai.language.conversations.models.ConversationPrediction
    """

    _validation = {
        'query': {'required': True},
        'prediction': {'required': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'detected_language': {'key': 'detectedLanguage', 'type': 'str'},
        'prediction': {'key': 'prediction', 'type': 'ConversationPrediction'},
    }

    def __init__(
        self,
        *,
        query: str,
        prediction: "ConversationPrediction",
        detected_language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword query: Required. The same query given in request.
        :paramtype query: str
        :keyword detected_language: The detected language from the query.
        :paramtype detected_language: str
        :keyword prediction: Required. The predicted result for the query.
        :paramtype prediction: ~azure.ai.language.conversations.models.ConversationPrediction
        """
        super(ConversationResult, self).__init__(**kwargs)
        self.query = query
        self.detected_language = detected_language
        self.prediction = prediction


class TargetIntentResult(msrest.serialization.Model):
    """This is the base class of an intent prediction.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ConversationTargetIntentResult, LUISTargetIntentResult, NoneLinkedTargetIntentResult, QuestionAnsweringTargetIntentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar target_kind: Required. This discriminator property specifies the type of the target
     project that returns the response.Constant filled by server. Possible values include: "luis",
     "conversation", "question_answering", "non_linked".
    :vartype target_kind: str or ~azure.ai.language.conversations.models.TargetKind
    :ivar api_version: The API version used to call a target service.
    :vartype api_version: str
    :ivar confidence_score: Required. The prediction score and it ranges from 0.0 to 1.0.
    :vartype confidence_score: float
    """

    _validation = {
        'target_kind': {'required': True},
        'confidence_score': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'target_kind': {'key': 'targetKind', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    _subtype_map = {
        'target_kind': {'conversation': 'ConversationTargetIntentResult', 'luis': 'LUISTargetIntentResult', 'non_linked': 'NoneLinkedTargetIntentResult', 'question_answering': 'QuestionAnsweringTargetIntentResult'}
    }

    def __init__(
        self,
        *,
        confidence_score: float,
        api_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword api_version: The API version used to call a target service.
        :paramtype api_version: str
        :keyword confidence_score: Required. The prediction score and it ranges from 0.0 to 1.0.
        :paramtype confidence_score: float
        """
        super(TargetIntentResult, self).__init__(**kwargs)
        self.target_kind = None  # type: Optional[str]
        self.api_version = api_version
        self.confidence_score = confidence_score


class ConversationTargetIntentResult(TargetIntentResult):
    """A wrap up of Conversation project response.

    All required parameters must be populated in order to send to Azure.

    :ivar target_kind: Required. This discriminator property specifies the type of the target
     project that returns the response.Constant filled by server. Possible values include: "luis",
     "conversation", "question_answering", "non_linked".
    :vartype target_kind: str or ~azure.ai.language.conversations.models.TargetKind
    :ivar api_version: The API version used to call a target service.
    :vartype api_version: str
    :ivar confidence_score: Required. The prediction score and it ranges from 0.0 to 1.0.
    :vartype confidence_score: float
    :ivar result: The actual response from a Conversation project.
    :vartype result: ~azure.ai.language.conversations.models.ConversationResult
    """

    _validation = {
        'target_kind': {'required': True},
        'confidence_score': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'target_kind': {'key': 'targetKind', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'result': {'key': 'result', 'type': 'ConversationResult'},
    }

    def __init__(
        self,
        *,
        confidence_score: float,
        api_version: Optional[str] = None,
        result: Optional["ConversationResult"] = None,
        **kwargs
    ):
        """
        :keyword api_version: The API version used to call a target service.
        :paramtype api_version: str
        :keyword confidence_score: Required. The prediction score and it ranges from 0.0 to 1.0.
        :paramtype confidence_score: float
        :keyword result: The actual response from a Conversation project.
        :paramtype result: ~azure.ai.language.conversations.models.ConversationResult
        """
        super(ConversationTargetIntentResult, self).__init__(api_version=api_version, confidence_score=confidence_score, **kwargs)
        self.target_kind = 'conversation'  # type: str
        self.result = result


class Error(msrest.serialization.Model):
    """The error object.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. One of a server-defined set of error codes. Possible values include:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
     "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
     "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable".
    :vartype code: str or ~azure.ai.language.conversations.models.ErrorCode
    :ivar message: Required. A human-readable representation of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.language.conversations.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.conversations.models.InnerErrorModel
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Error]'},
        'innererror': {'key': 'innererror', 'type': 'InnerErrorModel'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "ErrorCode"],
        message: str,
        target: Optional[str] = None,
        details: Optional[List["Error"]] = None,
        innererror: Optional["InnerErrorModel"] = None,
        **kwargs
    ):
        """
        :keyword code: Required. One of a server-defined set of error codes. Possible values include:
         "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
         "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
         "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
         "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable".
        :paramtype code: str or ~azure.ai.language.conversations.models.ErrorCode
        :keyword message: Required. A human-readable representation of the error.
        :paramtype message: str
        :keyword target: The target of the error.
        :paramtype target: str
        :keyword details: An array of details about specific errors that led to this reported error.
        :paramtype details: list[~azure.ai.language.conversations.models.Error]
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.ai.language.conversations.models.InnerErrorModel
        """
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.innererror = innererror


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.ai.language.conversations.models.Error
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        *,
        error: Optional["Error"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.ai.language.conversations.models.Error
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class InnerErrorModel(msrest.serialization.Model):
    """An object containing more specific information about the error. As per Microsoft One API guidelines - https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. One of a server-defined set of error codes. Possible values include:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure".
    :vartype code: str or ~azure.ai.language.conversations.models.InnerErrorCode
    :ivar message: Required. Error message.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.conversations.models.InnerErrorModel
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '{str}'},
        'target': {'key': 'target', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerErrorModel'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "InnerErrorCode"],
        message: str,
        details: Optional[Dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["InnerErrorModel"] = None,
        **kwargs
    ):
        """
        :keyword code: Required. One of a server-defined set of error codes. Possible values include:
         "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
         "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure".
        :paramtype code: str or ~azure.ai.language.conversations.models.InnerErrorCode
        :keyword message: Required. Error message.
        :paramtype message: str
        :keyword details: Error details.
        :paramtype details: dict[str, str]
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.ai.language.conversations.models.InnerErrorModel
        """
        super(InnerErrorModel, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.target = target
        self.innererror = innererror


class KnowledgeBaseAnswer(msrest.serialization.Model):
    """Represents knowledge base answer.

    :ivar questions: List of questions associated with the answer.
    :vartype questions: list[str]
    :ivar answer: Answer text.
    :vartype answer: str
    :ivar confidence_score: Answer confidence score, value ranges from 0 to 1.
    :vartype confidence_score: float
    :ivar id: ID of the QnA result.
    :vartype id: int
    :ivar source: Source of QnA result.
    :vartype source: str
    :ivar metadata: Metadata associated with the answer, useful to categorize or filter question
     answers.
    :vartype metadata: dict[str, str]
    :ivar dialog: Dialog associated with Answer.
    :vartype dialog: ~azure.ai.language.conversations.models.KnowledgeBaseAnswerDialog
    :ivar answer_span: Answer span object of QnA with respect to user's question.
    :vartype answer_span: ~azure.ai.language.conversations.models.AnswerSpan
    """

    _validation = {
        'confidence_score': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'questions': {'key': 'questions', 'type': '[str]'},
        'answer': {'key': 'answer', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'id': {'key': 'id', 'type': 'int'},
        'source': {'key': 'source', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'dialog': {'key': 'dialog', 'type': 'KnowledgeBaseAnswerDialog'},
        'answer_span': {'key': 'answerSpan', 'type': 'AnswerSpan'},
    }

    def __init__(
        self,
        *,
        questions: Optional[List[str]] = None,
        answer: Optional[str] = None,
        confidence_score: Optional[float] = None,
        id: Optional[int] = None,
        source: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        dialog: Optional["KnowledgeBaseAnswerDialog"] = None,
        answer_span: Optional["AnswerSpan"] = None,
        **kwargs
    ):
        """
        :keyword questions: List of questions associated with the answer.
        :paramtype questions: list[str]
        :keyword answer: Answer text.
        :paramtype answer: str
        :keyword confidence_score: Answer confidence score, value ranges from 0 to 1.
        :paramtype confidence_score: float
        :keyword id: ID of the QnA result.
        :paramtype id: int
        :keyword source: Source of QnA result.
        :paramtype source: str
        :keyword metadata: Metadata associated with the answer, useful to categorize or filter question
         answers.
        :paramtype metadata: dict[str, str]
        :keyword dialog: Dialog associated with Answer.
        :paramtype dialog: ~azure.ai.language.conversations.models.KnowledgeBaseAnswerDialog
        :keyword answer_span: Answer span object of QnA with respect to user's question.
        :paramtype answer_span: ~azure.ai.language.conversations.models.AnswerSpan
        """
        super(KnowledgeBaseAnswer, self).__init__(**kwargs)
        self.questions = questions
        self.answer = answer
        self.confidence_score = confidence_score
        self.id = id
        self.source = source
        self.metadata = metadata
        self.dialog = dialog
        self.answer_span = answer_span


class KnowledgeBaseAnswerDialog(msrest.serialization.Model):
    """Dialog associated with Answer.

    :ivar is_context_only: To mark if a prompt is relevant only with a previous question or not. If
     true, do not include this QnA as search result for queries without context; otherwise, if
     false, ignores context and includes this QnA in search result.
    :vartype is_context_only: bool
    :ivar prompts: List of prompts associated with the answer.
    :vartype prompts: list[~azure.ai.language.conversations.models.KnowledgeBaseAnswerPrompt]
    """

    _validation = {
        'prompts': {'max_items': 20, 'min_items': 0},
    }

    _attribute_map = {
        'is_context_only': {'key': 'isContextOnly', 'type': 'bool'},
        'prompts': {'key': 'prompts', 'type': '[KnowledgeBaseAnswerPrompt]'},
    }

    def __init__(
        self,
        *,
        is_context_only: Optional[bool] = None,
        prompts: Optional[List["KnowledgeBaseAnswerPrompt"]] = None,
        **kwargs
    ):
        """
        :keyword is_context_only: To mark if a prompt is relevant only with a previous question or not.
         If true, do not include this QnA as search result for queries without context; otherwise, if
         false, ignores context and includes this QnA in search result.
        :paramtype is_context_only: bool
        :keyword prompts: List of prompts associated with the answer.
        :paramtype prompts: list[~azure.ai.language.conversations.models.KnowledgeBaseAnswerPrompt]
        """
        super(KnowledgeBaseAnswerDialog, self).__init__(**kwargs)
        self.is_context_only = is_context_only
        self.prompts = prompts


class KnowledgeBaseAnswerPrompt(msrest.serialization.Model):
    """Prompt for an answer.

    :ivar display_order: Index of the prompt - used in ordering of the prompts.
    :vartype display_order: int
    :ivar qna_id: QnA ID corresponding to the prompt.
    :vartype qna_id: int
    :ivar display_text: Text displayed to represent a follow up question prompt.
    :vartype display_text: str
    """

    _validation = {
        'display_text': {'max_length': 200, 'min_length': 0},
    }

    _attribute_map = {
        'display_order': {'key': 'displayOrder', 'type': 'int'},
        'qna_id': {'key': 'qnaId', 'type': 'int'},
        'display_text': {'key': 'displayText', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_order: Optional[int] = None,
        qna_id: Optional[int] = None,
        display_text: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_order: Index of the prompt - used in ordering of the prompts.
        :paramtype display_order: int
        :keyword qna_id: QnA ID corresponding to the prompt.
        :paramtype qna_id: int
        :keyword display_text: Text displayed to represent a follow up question prompt.
        :paramtype display_text: str
        """
        super(KnowledgeBaseAnswerPrompt, self).__init__(**kwargs)
        self.display_order = display_order
        self.qna_id = qna_id
        self.display_text = display_text


class KnowledgeBaseAnswers(msrest.serialization.Model):
    """Represents List of Question Answers.

    :ivar answers: Represents Answer Result list.
    :vartype answers: list[~azure.ai.language.conversations.models.KnowledgeBaseAnswer]
    """

    _attribute_map = {
        'answers': {'key': 'answers', 'type': '[KnowledgeBaseAnswer]'},
    }

    def __init__(
        self,
        *,
        answers: Optional[List["KnowledgeBaseAnswer"]] = None,
        **kwargs
    ):
        """
        :keyword answers: Represents Answer Result list.
        :paramtype answers: list[~azure.ai.language.conversations.models.KnowledgeBaseAnswer]
        """
        super(KnowledgeBaseAnswers, self).__init__(**kwargs)
        self.answers = answers


class LUISCallingOptions(msrest.serialization.Model):
    """This customizes how the service calls LUIS Generally Available projects.

    :ivar verbose: Enable verbose response.
    :vartype verbose: bool
    :ivar log: Save log to add in training utterances later.
    :vartype log: bool
    :ivar show_all_intents: Set true to show all intents.
    :vartype show_all_intents: bool
    :ivar timezone_offset: The timezone offset for the location of the request.
    :vartype timezone_offset: float
    :ivar spell_check: Enable spell checking.
    :vartype spell_check: bool
    :ivar bing_spell_check_subscription_key: The subscription key to use when enabling Bing spell
     check.
    :vartype bing_spell_check_subscription_key: str
    """

    _attribute_map = {
        'verbose': {'key': 'verbose', 'type': 'bool'},
        'log': {'key': 'log', 'type': 'bool'},
        'show_all_intents': {'key': 'show-all-intents', 'type': 'bool'},
        'timezone_offset': {'key': 'timezoneOffset', 'type': 'float'},
        'spell_check': {'key': 'spellCheck', 'type': 'bool'},
        'bing_spell_check_subscription_key': {'key': 'bing-spell-check-subscription-key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        verbose: Optional[bool] = None,
        log: Optional[bool] = None,
        show_all_intents: Optional[bool] = None,
        timezone_offset: Optional[float] = None,
        spell_check: Optional[bool] = None,
        bing_spell_check_subscription_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword verbose: Enable verbose response.
        :paramtype verbose: bool
        :keyword log: Save log to add in training utterances later.
        :paramtype log: bool
        :keyword show_all_intents: Set true to show all intents.
        :paramtype show_all_intents: bool
        :keyword timezone_offset: The timezone offset for the location of the request.
        :paramtype timezone_offset: float
        :keyword spell_check: Enable spell checking.
        :paramtype spell_check: bool
        :keyword bing_spell_check_subscription_key: The subscription key to use when enabling Bing
         spell check.
        :paramtype bing_spell_check_subscription_key: str
        """
        super(LUISCallingOptions, self).__init__(**kwargs)
        self.verbose = verbose
        self.log = log
        self.show_all_intents = show_all_intents
        self.timezone_offset = timezone_offset
        self.spell_check = spell_check
        self.bing_spell_check_subscription_key = bing_spell_check_subscription_key


class LUISParameters(AnalysisParameters):
    """This is a set of request parameters for LUIS Generally Available projects.

    All required parameters must be populated in order to send to Azure.

    :ivar target_kind: Required. The type of a target service.Constant filled by server. Possible
     values include: "luis", "conversation", "question_answering", "non_linked".
    :vartype target_kind: str or ~azure.ai.language.conversations.models.TargetKind
    :ivar api_version: The API version to use when call a specific target service.
    :vartype api_version: str
    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar query: The utterance to predict.
    :vartype query: str
    :ivar calling_options: This customizes how the service calls LUIS Generally Available projects.
    :vartype calling_options: ~azure.ai.language.conversations.models.LUISCallingOptions
    """

    _validation = {
        'target_kind': {'required': True},
        'query': {'max_length': 500, 'min_length': 0},
    }

    _attribute_map = {
        'target_kind': {'key': 'targetKind', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'additional_properties': {'key': '', 'type': '{object}'},
        'query': {'key': 'query', 'type': 'str'},
        'calling_options': {'key': 'callingOptions', 'type': 'LUISCallingOptions'},
    }

    def __init__(
        self,
        *,
        api_version: Optional[str] = None,
        additional_properties: Optional[Dict[str, Any]] = None,
        query: Optional[str] = None,
        calling_options: Optional["LUISCallingOptions"] = None,
        **kwargs
    ):
        """
        :keyword api_version: The API version to use when call a specific target service.
        :paramtype api_version: str
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword query: The utterance to predict.
        :paramtype query: str
        :keyword calling_options: This customizes how the service calls LUIS Generally Available
         projects.
        :paramtype calling_options: ~azure.ai.language.conversations.models.LUISCallingOptions
        """
        super(LUISParameters, self).__init__(api_version=api_version, **kwargs)
        self.target_kind = 'luis'  # type: str
        self.additional_properties = additional_properties
        self.query = query
        self.calling_options = calling_options


class LUISTargetIntentResult(TargetIntentResult):
    """It is a wrap up of LUIS Generally Available response.

    All required parameters must be populated in order to send to Azure.

    :ivar target_kind: Required. This discriminator property specifies the type of the target
     project that returns the response.Constant filled by server. Possible values include: "luis",
     "conversation", "question_answering", "non_linked".
    :vartype target_kind: str or ~azure.ai.language.conversations.models.TargetKind
    :ivar api_version: The API version used to call a target service.
    :vartype api_version: str
    :ivar confidence_score: Required. The prediction score and it ranges from 0.0 to 1.0.
    :vartype confidence_score: float
    :ivar result: The actual response from a LUIS Generally Available application.
    :vartype result: any
    """

    _validation = {
        'target_kind': {'required': True},
        'confidence_score': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'target_kind': {'key': 'targetKind', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'result': {'key': 'result', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        confidence_score: float,
        api_version: Optional[str] = None,
        result: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword api_version: The API version used to call a target service.
        :paramtype api_version: str
        :keyword confidence_score: Required. The prediction score and it ranges from 0.0 to 1.0.
        :paramtype confidence_score: float
        :keyword result: The actual response from a LUIS Generally Available application.
        :paramtype result: any
        """
        super(LUISTargetIntentResult, self).__init__(api_version=api_version, confidence_score=confidence_score, **kwargs)
        self.target_kind = 'luis'  # type: str
        self.result = result


class NoneLinkedTargetIntentResult(TargetIntentResult):
    """A wrap up of non-linked intent response.

    All required parameters must be populated in order to send to Azure.

    :ivar target_kind: Required. This discriminator property specifies the type of the target
     project that returns the response.Constant filled by server. Possible values include: "luis",
     "conversation", "question_answering", "non_linked".
    :vartype target_kind: str or ~azure.ai.language.conversations.models.TargetKind
    :ivar api_version: The API version used to call a target service.
    :vartype api_version: str
    :ivar confidence_score: Required. The prediction score and it ranges from 0.0 to 1.0.
    :vartype confidence_score: float
    :ivar result: The actual response from a Conversation project.
    :vartype result: ~azure.ai.language.conversations.models.ConversationResult
    """

    _validation = {
        'target_kind': {'required': True},
        'confidence_score': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'target_kind': {'key': 'targetKind', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'result': {'key': 'result', 'type': 'ConversationResult'},
    }

    def __init__(
        self,
        *,
        confidence_score: float,
        api_version: Optional[str] = None,
        result: Optional["ConversationResult"] = None,
        **kwargs
    ):
        """
        :keyword api_version: The API version used to call a target service.
        :paramtype api_version: str
        :keyword confidence_score: Required. The prediction score and it ranges from 0.0 to 1.0.
        :paramtype confidence_score: float
        :keyword result: The actual response from a Conversation project.
        :paramtype result: ~azure.ai.language.conversations.models.ConversationResult
        """
        super(NoneLinkedTargetIntentResult, self).__init__(api_version=api_version, confidence_score=confidence_score, **kwargs)
        self.target_kind = 'non_linked'  # type: str
        self.result = result


class OrchestratorPrediction(BasePrediction):
    """This represents the prediction result of an Orchestrator project.

    All required parameters must be populated in order to send to Azure.

    :ivar project_kind: Required. The type of the project.Constant filled by server. Possible
     values include: "conversation", "workflow".
    :vartype project_kind: str or ~azure.ai.language.conversations.models.ProjectKind
    :ivar top_intent: The intent with the highest score.
    :vartype top_intent: str
    :ivar intents: Required. A dictionary that contains all intents. A key is an intent name and a
     value is its confidence score and target type. The top intent's value also contains the actual
     response from the target project.
    :vartype intents: dict[str, ~azure.ai.language.conversations.models.TargetIntentResult]
    """

    _validation = {
        'project_kind': {'required': True},
        'intents': {'required': True},
    }

    _attribute_map = {
        'project_kind': {'key': 'projectKind', 'type': 'str'},
        'top_intent': {'key': 'topIntent', 'type': 'str'},
        'intents': {'key': 'intents', 'type': '{TargetIntentResult}'},
    }

    def __init__(
        self,
        *,
        intents: Dict[str, "TargetIntentResult"],
        top_intent: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword top_intent: The intent with the highest score.
        :paramtype top_intent: str
        :keyword intents: Required. A dictionary that contains all intents. A key is an intent name and
         a value is its confidence score and target type. The top intent's value also contains the
         actual response from the target project.
        :paramtype intents: dict[str, ~azure.ai.language.conversations.models.TargetIntentResult]
        """
        super(OrchestratorPrediction, self).__init__(top_intent=top_intent, **kwargs)
        self.project_kind = 'workflow'  # type: str
        self.intents = intents


class QuestionAnsweringParameters(AnalysisParameters):
    """This is a set of request parameters for Question Answering knowledge bases.

    All required parameters must be populated in order to send to Azure.

    :ivar target_kind: Required. The type of a target service.Constant filled by server. Possible
     values include: "luis", "conversation", "question_answering", "non_linked".
    :vartype target_kind: str or ~azure.ai.language.conversations.models.TargetKind
    :ivar api_version: The API version to use when call a specific target service.
    :vartype api_version: str
    :ivar calling_options: The options sent to a Question Answering KB.
    :vartype calling_options: any
    """

    _validation = {
        'target_kind': {'required': True},
    }

    _attribute_map = {
        'target_kind': {'key': 'targetKind', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'calling_options': {'key': 'callingOptions', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        api_version: Optional[str] = None,
        calling_options: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword api_version: The API version to use when call a specific target service.
        :paramtype api_version: str
        :keyword calling_options: The options sent to a Question Answering KB.
        :paramtype calling_options: any
        """
        super(QuestionAnsweringParameters, self).__init__(api_version=api_version, **kwargs)
        self.target_kind = 'question_answering'  # type: str
        self.calling_options = calling_options


class QuestionAnsweringTargetIntentResult(TargetIntentResult):
    """It is a wrap up a Question Answering KB response.

    All required parameters must be populated in order to send to Azure.

    :ivar target_kind: Required. This discriminator property specifies the type of the target
     project that returns the response.Constant filled by server. Possible values include: "luis",
     "conversation", "question_answering", "non_linked".
    :vartype target_kind: str or ~azure.ai.language.conversations.models.TargetKind
    :ivar api_version: The API version used to call a target service.
    :vartype api_version: str
    :ivar confidence_score: Required. The prediction score and it ranges from 0.0 to 1.0.
    :vartype confidence_score: float
    :ivar result: The generated answer by a Question Answering KB.
    :vartype result: ~azure.ai.language.conversations.models.KnowledgeBaseAnswers
    """

    _validation = {
        'target_kind': {'required': True},
        'confidence_score': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'target_kind': {'key': 'targetKind', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'result': {'key': 'result', 'type': 'KnowledgeBaseAnswers'},
    }

    def __init__(
        self,
        *,
        confidence_score: float,
        api_version: Optional[str] = None,
        result: Optional["KnowledgeBaseAnswers"] = None,
        **kwargs
    ):
        """
        :keyword api_version: The API version used to call a target service.
        :paramtype api_version: str
        :keyword confidence_score: Required. The prediction score and it ranges from 0.0 to 1.0.
        :paramtype confidence_score: float
        :keyword result: The generated answer by a Question Answering KB.
        :paramtype result: ~azure.ai.language.conversations.models.KnowledgeBaseAnswers
        """
        super(QuestionAnsweringTargetIntentResult, self).__init__(api_version=api_version, confidence_score=confidence_score, **kwargs)
        self.target_kind = 'question_answering'  # type: str
        self.result = result
