/***************************************************************************
 *   Copyright (C) 2008 by Damien Lévin <dml_aon@hotmail.com>      	   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/


#include "searchmoid.h"

#include <plasma/svg.h>
#include <plasma/theme.h>
#include <QDebug> 



#include <QWidget>
#include <KConfigDialog>
#include <KLineEdit>
#include <KToolInvocation>
#include <plasma/widgets/textedit.h>


Searchmoid::Searchmoid(QObject *parent, const QVariantList &args) : 
Plasma::PopupApplet(parent, args)
    , widgetMain(0)

{
    setBackgroundHints(DefaultBackground);
    setPopupIcon("page-zoom");
    setAspectRatioMode(Plasma::IgnoreAspectRatio);
    initWebSites();
    initGui();
}

void Searchmoid::initGui()
{


     widgetMain = new QGraphicsWidget(this);
     m_layout = new QGraphicsLinearLayout(Qt::Horizontal);

     iconWebsite = new Plasma::IconWidget;
     iconWebsite->setIcon("page-zoom"); //Temporaly
     
     searchLine = new Plasma::LineEdit;
     searchLine->nativeWidget()->setClearButtonShown( true );
     searchLine->nativeWidget()->setClickMessage(i18n("Enter word to search here"));
     connect(searchLine, SIGNAL(returnPressed()), this, SLOT(launchRequest()));
 
     completion = new KCompletion();
     completion->setOrder(KCompletion::Sorted);

     m_layout->addItem(iconWebsite);
     m_layout->addItem(searchLine);

     widgetMain->setLayout(m_layout);
     widgetMain->setPreferredSize(300, 40);
}



 QGraphicsWidget *Searchmoid::graphicsWidget()
{
    return widgetMain;
}
 
Searchmoid::~Searchmoid()
{
}

void Searchmoid::launchRequest()
{
   configGroup = config();
   KToolInvocation::invokeBrowser(mapWebSites.value(currentWebSite)+searchLine->text()) ;
   configGroup.writeEntry("completionHistory", searchLine->text());
   updateHistory();
}


void Searchmoid::createConfigurationInterface(KConfigDialog *parent)
{

  widgetConfig = new QWidget;
  configGroup = config();
  uiConfig.setupUi(widgetConfig);
  uiConfig.currentWebSite->setCurrentIndex(uiConfig.currentWebSite->findText(configGroup.readEntry("currentWebSite")));

  connect(parent, SIGNAL(okClicked()), this, SLOT(configAccepted()));
  parent->setButtons(KDialog::Ok | KDialog::Cancel);
  parent->addPage(widgetConfig, i18n("Configuration"), icon());

}

void Searchmoid::updateHistory()
{
    configGroup = config();
    completionHistory = configGroup.readEntry("completionHistory", QStringList());
    completion->clear();
    completion->insertItems(completionHistory);
    searchLine->nativeWidget()->setCompletionObject(completion);
    searchLine->nativeWidget()->setCompletionMode(KGlobalSettings::CompletionAuto);
}


void Searchmoid::configAccepted(){
    
  configGroup = config();
  currentWebSite = uiConfig.currentWebSite->currentText();
  configGroup.writeEntry("currentWebSite",currentWebSite);    
 // iconWebsite->setSvg(mapWebSitesLogos.value(currentWebSite));
}


void Searchmoid::initWebSites(){

  mapWebSites.insert("Google","http://www.google.com/search?q=");
 // mapWebSitesLogos.insert("Google","widgets/wikipedia");

  mapWebSites.insert("Yahoo","http://search.yahoo.com/search?p=X");
//  mapWebSitesLogos.insert("Yahoo","widgets/wikipedia");

  mapWebSites.insert("Wikipedia","http://wikipedia.org/wiki/Special:Search?search=");
// mapWebSitesLogos.insert("Wikipedia","widgets/wikipedia");

  mapWebSites.insert("Debian Search","http://packages.debian.org/search?keywords=");
//  mapWebSitesLogos.insert("Debian Search","widgets/debian");

  mapWebSites.insert("Ubuntu Search","http://packages.ubuntu.com/search?keywords=");
//  mapWebSitesLogos.insert("Ubuntu Search","widgets/wikipedia");
}
 
#include "searchmoid.moc"