/********************************************************************************
 *   Copyright (C) 2008-2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#ifndef LOCATIONDIALOG_H
#define LOCATIONDIALOG_H

#include <KDialog>

class KComboBox;

static const int s_default_accuracy = 11; // default to city level

class LocationDialog : public KDialog
{
  Q_OBJECT
public:
  LocationDialog( QWidget *p_parent = 0 );
  virtual ~LocationDialog();

  int getAccuracy() const;
  virtual qreal getLatitude() const = 0;
  virtual qreal getLongitude() const = 0;
  void setAccuracy( int p_accuracy );
  virtual void setLatitude( qreal p_latitude ) = 0;
  virtual void setLongitude( qreal p_longitude ) = 0;

public slots:
  void accuracyChanged( int p_accuracy );

protected:
  int m_accuracy;
  KComboBox *m_accuracyCombo; 
};

#endif // LOCATIONDIALOG_H

