/*	Unresolved_Reference

PIRL CVS ID: Unresolved_Reference.java,v 1.6 2012/04/16 06:04:11 castalia Exp

Copyright (C) 2004-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package PIRL.Conductor;

/**	The <I>Exeception</I> that is thrown if a parameter source
	reference or database field reference can not be resolved
	and a Default_Value has not been provided.
<P>
	@author	Bradford Castalia - UA/PIRL
	@version	1.6
	@see	Reference_Resolver
*/
public class Unresolved_Reference
	extends Exception
{
/**	Class name and version identification.
*/
public static final String
	ID = "PIRL.Conductor.Unresolved_Reference (1.6 2012/04/16 06:04:11)";

private String
	Reference = null;

/**	Constructs an Unresolved_Reference exception with the
	specified detail message.
<P>
	The exception's Reference will be null.
<P>
	@param	message	The detail message; retrievable by the
		{@link Throwable#getMessage()} method.
*/
public Unresolved_Reference
	(
	String	message
	)
{super (message);}

/**	Constructs an Unresolved_Reference exception with
	the specified detail message and reference.
<P>
	@param	message	The detail message; retrievable by the
		{@link Throwable#getMessage()} method.
	@param	reference The reference String that could not be
		resolved; retrievable by the {@link #Reference()} method.
*/
public Unresolved_Reference
	(
	String	message,
	String	reference
	)
{
super (message);
Reference = reference;
}

/**	Gets the unresolved reference.
<p>
	@return	The unresolved reference String.
*/
public String Reference ()
{return Reference;}

}
