///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_ACTION_PROXY_H
#define __OVITO_ACTION_PROXY_H

#include <core/Core.h>
#include <core/gui/ApplicationManager.h>
#include "Action.h"

namespace Core {

/******************************************************************************
*
******************************************************************************/
class CORE_DLLEXPORT ActionProxy : public QWidgetAction
{
	Q_OBJECT

public:

	/// \brief Constructor that accepts an already existing action.
	ActionProxy(const Action::SmartPtr& action);

	/// \brief Returns a pointer to the real action object.
	const Action::SmartPtr& action() const { return _action; }

protected:

	/// This function is called whenever the action is added to a container widget that supports custom widgets.
	virtual QWidget* createWidget(QWidget* parent);

private:

	/// The actual action object encapsulated by this proxy.
	Action::SmartPtr _action;
};

};

#endif // __OVITO_ACTION_PROXY_H
