###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpmyadmin_37826.nasl 8287 2010-07-05 10:40:56Z mime $
#
# phpMyAdmin Insecure Temporary File and Directory Creation Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100450);
 script_bugtraq_id(37826);
 script_cve_id("CVE-2008-7251","CVE-2008-7252");
 script_version ("1.0-$Revision: 8287 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");

 script_name("phpMyAdmin Insecure Temporary File and Directory Creation Vulnerabilities");

desc = "Overview:
phpMyAdmin creates temporary directories and files in an insecure way.

An attacker with local access could potentially exploit this issue to
perform symbolic-link attacks, overwriting arbitrary files in the
context of the affected application.

Successful attacks may corrupt data or cause denial-of-service
conditions. Other unspecified attacks are also possible.

This issue affects phpMyAdmin 2.11.x (prior to 2.11.10.)

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37826
http://www.phpmyadmin.net/home_page/index.php
http://www.phpmyadmin.net/home_page/security/PMASA-2010-1.php
http://www.phpmyadmin.net/home_page/security/PMASA-2010-2.php

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if phpMyAdmin version is < 2.11.10");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("secpod_phpmyadmin_detect_900129.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/phpMyAdmin")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "2.11.10")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
