# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:115 (phpMyAdmin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64024);
 script_cve_id("CVE-2009-1150", "CVE-2009-1151");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Mandrake Security Advisory MDVSA-2009:115 (phpMyAdmin)";
 script_name(name);

 desc = "The remote host is missing an update to phpMyAdmin
announced via advisory MDVSA-2009:115.

Multiple vulnerabilities has been identified and corrected in
phpMyAdmin:

Multiple cross-site scripting (XSS) vulnerabilities in the export page
(display_export.lib.php) in phpMyAdmin 2.11.x before 2.11.9.5 and 3.x
before 3.1.3.1 allow remote attackers to inject arbitrary web script
or HTML via the pma_db_filename_template cookie (CVE-2009-1150).

Static code injection vulnerability in setup.php in phpMyAdmin 2.11.x
before 2.11.9.5 and 3.x before 3.1.3.1 allows remote attackers to
inject arbitrary PHP code into a configuration file via the save action
(CVE-2009-1151).

This update provides phpMyAdmin 2.11.9.5, which is not vulnerable to
these issues.

Affected: Corporate 4.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:115
http://www.phpmyadmin.net/home_page/security/PMASA-2009-2.php
http://www.phpmyadmin.net/home_page/security/PMASA-2009-3.php

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:115 (phpMyAdmin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"phpMyAdmin", rpm:"phpMyAdmin~2.11.9.5~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
