###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dm_filemanager_sec_bypass_vuln.nasl 2869 2009-07-01 18:47:17Z jul $
#
# DM FileManager 'login.php' Security Bypass Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800819);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2025", "CVE-2009-1741");
  script_bugtraq_id(35035);
  script_name("DM FileManager 'login.php' Security Bypass Vulnerability");
  desc = "

  Overview: The host is running DM FileManager and is prone to Security Bypass
  vulnerability.

  Vulnerability Insight:
  - Error exists when application fails to set the 'USER', 'GROUPID',
   'GROUP', and 'USERID' cookies to certain values in admin/login.php.
  - Error in 'login.php' which fails to sanitise user supplied input via
    the 'Username' and 'Password' fields.

  Impact:
  Successful exploitation will let the remote attacker execute arbitrary
  SQL commands when magic_quotes_gpc is disabled and bypass authentication
  and gain administrative access.

  Impact Level: Application

  Affected Software/OS:
  DutchMonkey, DM FileManager version 3.9.2 and prior

  Fix: Upgrade to DM FileManager version 3.9.10 or later,
  For updates refer, http://dutchmonkey.com

  References:
  http://milw0rm.com/exploits/8903
  http://milw0rm.com/exploits/8741
  http://secunia.com/advisories/35167
  http://www.vupen.com/english/advisories/2009/1532

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of DM FileManager");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_dm_filemanager_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

dmfPort = get_http_port(default:80);
if(!dmfPort){
  exit(0);
}

dmfVer = get_kb_item("www/" + dmfPort + "/DM-FileManager");
dmfVer = eregmatch(pattern:"^(.+) under (/.*)$", string:dmfVer);
if(dmfVer[1] != NULL)
{
  if(version_is_less_equal(version:dmfVer[1], test_version:"3.9.2")){
    security_warning(dmfPort);
  }
}
