# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1583-1 (gnome-peercast)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61035);
 script_cve_id("CVE-2007-6454", "CVE-2008-2040");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1583-1 (gnome-peercast)";
 script_name(name);

 desc = "The remote host is missing an update to gnome-peercast
announced via advisory DSA 1583-1.

Several remote vulnerabilities have been discovered in Gnome PeerCast,
the Gnome interface to PeerCast, a P2P audio and video streaming
server. The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2007-6454

Luigi Auriemma discovered that PeerCast is vulnerable to a heap
overflow in the HTTP server code, which allows remote attackers to
cause a denial of service and possibly execute arbitrary code via a
long SOURCE request.

CVE-2008-2040

Nico Golde discovered that PeerCast, a P2P audio and video streaming
server, is vulnerable to a buffer overflow in the HTTP Basic
Authentication code, allowing a remote attacker to crash PeerCast or
execure arbitrary code.

For the stable distribution (etch), these problems have been fixed in
version 0.5.4-1.1etch0.

For the unstable distribution (sid), the first issue has been fixed in
0.5.4-1.2. The second issue will be fixed soon.

We recommend that you upgrade your gnome-peercast package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201583-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1583-1 (gnome-peercast)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnome-peercast", ver:"0.5.4-1.1etch0", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
