#
# Sarju Bhagat <sarju@westpoint.ltd.uk>
#
# GPLv2


if(description)
{
 script_id(19304);
 script_bugtraq_id(1290);
 script_cve_id("CVE-2000-0470");
 script_version("$Revision: 7189 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Allegro Software RomPager 2.10 Denial of Service";


 script_name(name);
 desc = "

The remote host is running Allegro Software RomPager version 2.10, according
to its banner. This version is vulnerable to a denial of service when sending a
specifically crafted malformed request.

Solution : Upgrade to the latest version, or apply a patch.
Risk factor : High";


 script_description(desc);

 summary = "Checks for version of Allegro Software RomPager";

 script_summary(summary);

 script_category(ACT_GATHER_INFO);


 script_copyright("This script is Copyright (C) 2005 Westpoint Limited");
 family = "Denial of Service";
 script_family(family);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:80);

if(get_port_state(port))
{
 banner = get_http_banner(port:port);
 if(!banner || "Allegro" >!< banner )exit(0);

 serv = strstr(banner, "Server");
 if(ereg(pattern:"Allegro-Software-RomPager/2\.([0-9][^0-9]|10)", string:serv))
 {
   security_hole(port);
   exit(0);
 }
}
