# -*- shell-script -*-
#
# Copyright (c) 2004-2006 The Trustees of Indiana University and Indiana
#                         University Research and Technology
#                         Corporation.  All rights reserved.
# Copyright (c) 2004-2005 The University of Tennessee and The University
#                         of Tennessee Research Foundation.  All rights
#                         reserved.
# Copyright (c) 2004-2005 High Performance Computing Center Stuttgart,
#                         University of Stuttgart.  All rights reserved.
# Copyright (c) 2004-2005 The Regents of the University of California.
#                         All rights reserved.
# Copyright (c) 2010      Cisco Systems, Inc.  All rights reserved.
# Copyright (c) 2010-2019 Sandia National Laboratories.  All rights reserved.
# Copyright (c) 2014      Bull SAS.  All rights reserved.
# $COPYRIGHT$
#
# Additional copyrights may follow
#
# $HEADER$
#

# MCA_btl_portals4_CONFIG(action-if-can-compile,
#                        [action-if-cant-compile])
# ------------------------------------------------
AC_DEFUN([MCA_opal_btl_portals4_CONFIG],[
    AC_CONFIG_FILES([opal/mca/btl/portals4/Makefile])

    OPAL_CHECK_PORTALS4([btl_portals4],
                     [btl_portals4_happy="yes"],
                     [btl_portals4_happy="no"])

    AS_IF([test "$btl_portals4_happy" = "yes"],
          [btl_portals4_WRAPPER_EXTRA_LDFLAGS="$btl_portals4_LDFLAGS"
           btl_portals4_WRAPPER_EXTRA_LIBS="$btl_portals4_LIBS"
           $1],
          [$2])

    # need to propagate CPPFLAGS to all of OPAL
    AS_IF([test "$DIRECT_btl" = "portals4"],
          [CPPFLAGS="$CPPFLAGS $btl_portals4_CPPFLAGS"])

    AC_ARG_ENABLE([btl-portals4-flow-control],
       [AS_HELP_STRING([--enable-btl-portals4-flow-control],
           [enable flow control for Portals 4 BTL (default: disabled)])])
    AC_MSG_CHECKING([whether to enable flow control])
    if test "$enable_btl_portals4_flow_control" != "no"; then
        AC_MSG_RESULT([yes])
        btl_portals4_flow_control_enabled=1
    else
        AC_MSG_RESULT([no])
        btl_portals4_flow_control_enabled=0
    fi
    AC_DEFINE_UNQUOTED([OPAL_BTL_PORTALS4_FLOW_CONTROL],
        [$btl_portals4_flow_control_enabled],
        [Enable flow control for Portals4 BTL])
    AM_CONDITIONAL([OPAL_BTL_PORTALS4_FLOW_CONTROL],
        [test "$btl_portals4_flow_control_enabled" = "1"])

    # substitute in the things needed to build portals4
    AC_SUBST([btl_portals4_CPPFLAGS])
    AC_SUBST([btl_portals4_LDFLAGS])
    AC_SUBST([btl_portals4_LIBS])
])dnl
