/* 
 * Copyright (c) 2011, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javafx.scene.layout;

/**
Builder class for javafx.scene.layout.Region
@see javafx.scene.layout.Region
@deprecated This class is deprecated and will be removed in the next version
* @since JavaFX 2.0
*/
@javax.annotation.Generated("Generated by javafx.builder.processor.BuilderProcessor")
@Deprecated
public class RegionBuilder<B extends javafx.scene.layout.RegionBuilder<B>> extends javafx.scene.ParentBuilder<B> implements javafx.util.Builder<javafx.scene.layout.Region> {
    protected RegionBuilder() {
    }
    
    /** Creates a new instance of RegionBuilder. */
    @SuppressWarnings({"deprecation", "rawtypes", "unchecked"})
    public static javafx.scene.layout.RegionBuilder<?> create() {
        return new javafx.scene.layout.RegionBuilder();
    }
    
    private int __set;
    private void __set(int i) {
        __set |= 1 << i;
    }
    public void applyTo(javafx.scene.layout.Region x) {
        super.applyTo(x);
        int set = __set;
        while (set != 0) {
            int i = Integer.numberOfTrailingZeros(set);
            set &= ~(1 << i);
            switch (i) {
                case 0: x.setMaxHeight(this.maxHeight); break;
                case 1: x.setMaxWidth(this.maxWidth); break;
                case 2: x.setMinHeight(this.minHeight); break;
                case 3: x.setMinWidth(this.minWidth); break;
                case 4: x.setPadding(this.padding); break;
                case 5: x.setPrefHeight(this.prefHeight); break;
                case 6: x.setPrefWidth(this.prefWidth); break;
                case 7: x.setSnapToPixel(this.snapToPixel); break;
            }
        }
    }
    
    private double maxHeight;
    /**
    Set the value of the {@link javafx.scene.layout.Region#getMaxHeight() maxHeight} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B maxHeight(double x) {
        this.maxHeight = x;
        __set(0);
        return (B) this;
    }
    
    private double maxWidth;
    /**
    Set the value of the {@link javafx.scene.layout.Region#getMaxWidth() maxWidth} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B maxWidth(double x) {
        this.maxWidth = x;
        __set(1);
        return (B) this;
    }
    
    private double minHeight;
    /**
    Set the value of the {@link javafx.scene.layout.Region#getMinHeight() minHeight} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B minHeight(double x) {
        this.minHeight = x;
        __set(2);
        return (B) this;
    }
    
    private double minWidth;
    /**
    Set the value of the {@link javafx.scene.layout.Region#getMinWidth() minWidth} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B minWidth(double x) {
        this.minWidth = x;
        __set(3);
        return (B) this;
    }
    
    private javafx.geometry.Insets padding;
    /**
    Set the value of the {@link javafx.scene.layout.Region#getPadding() padding} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B padding(javafx.geometry.Insets x) {
        this.padding = x;
        __set(4);
        return (B) this;
    }
    
    private double prefHeight;
    /**
    Set the value of the {@link javafx.scene.layout.Region#getPrefHeight() prefHeight} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B prefHeight(double x) {
        this.prefHeight = x;
        __set(5);
        return (B) this;
    }
    
    private double prefWidth;
    /**
    Set the value of the {@link javafx.scene.layout.Region#getPrefWidth() prefWidth} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B prefWidth(double x) {
        this.prefWidth = x;
        __set(6);
        return (B) this;
    }
    
    private boolean snapToPixel;
    /**
    Set the value of the {@link javafx.scene.layout.Region#isSnapToPixel() snapToPixel} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B snapToPixel(boolean x) {
        this.snapToPixel = x;
        __set(7);
        return (B) this;
    }
    
    /**
    Make an instance of {@link javafx.scene.layout.Region} based on the properties set on this builder.
    */
    public javafx.scene.layout.Region build() {
        javafx.scene.layout.Region x = new javafx.scene.layout.Region();
        applyTo(x);
        return x;
    }
}
