/*
 *  Copyright (c) 2009,2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Source.h"

using namespace OpenRijn;

#include <GTLCore/Debug.h>

#include "LightParser_p.h"
#include <GTLFragment/Source_p.h>
#include <GTLFragment/Lexer_p.h>

struct Source::Private : public GTLFragment::Source::Private
{
  Private() : sourceType(InvalidSource) {}
  Private(const Private& _rhs) : GTLFragment::Source::Private(_rhs), sourceType(InvalidSource) {}
  
  Private* clone() { return new Private(*this); }
  void specificUpdate(const GTLCore::String& _source, GTLCore::String& name);

  SourceType sourceType;
};

void Source::Private::specificUpdate(const GTLCore::String& _source, GTLCore::String& name)
{
  std::istringstream iss(_source);
  GTLFragment::Lexer lexer( &iss, GTLFragment::Library::RIJN_SKETCH );
  LightParser parser(&lexer);
  parser.parse();
  name = parser.name();
  sourceType = parser.sourceType();
}

// ---- Library::Private ---- //

const Source::Private* Source::d_func() const
{
  return static_cast<Source::Private*>(d);
}

Source::Source() : GTLFragment::Source(new Private)
{
}

GTL_INHERITED_SHARED_DATA(Source, GTLFragment::Source)

Source::SourceType Source::sourceType() const
{
  return d_func()->sourceType;
}
