/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_ASSOCIATEDPOWERMANAGEMENTSERVICEACCESS_H_
#define OPENDRIM_ASSOCIATEDPOWERMANAGEMENTSERVICEACCESS_H_

#include "PowerManagement_Common.h"

#include "OpenDRIM_AssociatedPowerManagementService.h"
#include "assocOpenDRIM_AssociatedPowerManagementService.h"

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_load(const CMPIBroker* broker, string& errorMessage);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_unload(string& errorMessage);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AssociatedPowerManagementService>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AssociatedPowerManagementService& instance, const char** properties, string& errorMessage);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedPowerManagementService& newInstance, const OpenDRIM_AssociatedPowerManagementService& oldInstance, const char** properties, string& errorMessage);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedPowerManagementService& instance, string& errorMessage);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedPowerManagementService& instance, string& errorMessage);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_associatorUserOfServiceToServiceProvided(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& UserOfService_instance, const char** properties, vector<Instance>& ServiceProvided_associatedInstances, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_associatorServiceProvidedToUserOfService(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ServiceProvided_instance, const char** properties, vector<Instance>& UserOfService_associatedInstances, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_referenceUserOfServiceToServiceProvided(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& UserOfService_instance, const vector<Instance>& ServiceProvided_instances, vector<OpenDRIM_AssociatedPowerManagementService>& OpenDRIM_AssociatedPowerManagementService_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_referenceServiceProvidedToUserOfService(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ServiceProvided_instance, const vector<Instance>& UserOfService_instances, vector<OpenDRIM_AssociatedPowerManagementService>& OpenDRIM_AssociatedPowerManagementService_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_populate(OpenDRIM_AssociatedPowerManagementService& instance, string& errorMessage);

#endif /*OPENDRIM_ASSOCIATEDPOWERMANAGEMENTSERVICEACCESS_H_*/
