# Tutorials

Below we include a number of tutorials we believe are useful for understanding how OMPL works, grouped by level of difficulty. Users are encouraged to look at the [demos](group__demos.html) as well.


### Beginner

- [Geometric planning for a rigid body in 3D](geometricPlanningSE3.html)
- [Setting up state validity checking](stateValidation.html)
- [Working with states and state spaces](workingWithStates.html)
- [Using existing samplers and creating new ones](samplers.html)
- [Visualizing solution paths](pathVisualization.html)
- [Benchmarking planners](benchmark.html)
- [Optimal planning](optimalPlanningTutorial.html)


### Intermediate

- [Generic instructions for setting up a planning context](genericPlanning.html)
- [Implementing new state spaces](implementingStateSpaces.html)
- [Representing goals](goalRepresentation.html)
- [Using ODESolver for Planning with Controls](odeint.html)
- [Defining optimization objectives for optimal planning](optimizationObjectivesTutorial.html)


### Advanced

- [Adding a new planner](newPlanner.html)
- [Creating Python bindings for a new planner](pybindingsPlanner.html)
- [Setting up a projection](projections.html)
- [Using OMPL with the Morse simulator](morse.html)
