MODULE MPL_MYGATHERV_MOD

USE PARKIND1  ,ONLY : JPIM     ,JPRB

USE MPL_MPIF
USE MPL_DATA_MODULE
USE MPL_MESSAGE_MOD

IMPLICIT NONE
PRIVATE
PUBLIC MPL_MYGATHERV

LOGICAL :: LLABORT=.TRUE.

CONTAINS

! ------------------------------------------------------------------
SUBROUTINE MPL_MYGATHERV(PSEND,KSEND,PRECV,KRECV,KDISPL,KROOT,KCOMM)


#ifdef USE_8_BYTE_WORDS
  Use mpi4to8, Only : &
    MPI_GATHERV => MPI_GATHERV8
#endif


REAL(KIND=JPRB), INTENT(IN)  :: PSEND(:)
REAL(KIND=JPRB), INTENT(OUT) :: PRECV(:)
INTEGER(KIND=JPIM), INTENT(IN) :: KSEND, KRECV(:), KDISPL(:)
INTEGER(KIND=JPIM), INTENT(IN) :: KROOT, KCOMM
INTEGER(KIND=JPIM) :: ierr

CALL MPI_GATHERV(PSEND,KSEND,INT(MPI_REAL8), &
               & PRECV,KRECV,KDISPL,INT(MPI_REAL8),KROOT-1,KCOMM,ierr)

IF (ierr/=0) CALL MPL_MESSAGE(ierr,'MPL_MYGATHERV',LDABORT=LLABORT)

END SUBROUTINE MPL_MYGATHERV
! ------------------------------------------------------------------

END MODULE MPL_MYGATHERV_MOD
