package de.jost_net.OBanToo.Tools;

/**
 * Whrungskennzeichen gem. ISO 4217 die im internationalen Zahlungsverkehr zur
 * eindeutigen Identifizierung benutzt werden sollten. Quelle: <a
 * href='http://de.wikipedia.org/wiki/ISO_4217'>Wikipedia: ISO 4217</a>
 * 
 * @author Heiner Jostkleigrewe
 * 
 */
public class Waehrungskennzeichen
{
  /**
   * Dirham, Vereinigte Arabische Emirate
   */
  public static final String AED = "AED";

  /**
   * Afghani, Afghanistan
   */
  public static final String AFN = "AFN";

  /**
   * Lek, Albanien
   */
  public static final String ALL = "ALL";

  /**
   * Dram, Armenien
   */
  public static final String AMD = "AMD";

  /**
   * Gulden, Niederlndische Antillen
   */
  public static final String ANG = "ANG";

  /**
   * Kwanza, Angola
   */
  public static final String AOA = "AOA";

  /**
   * Peso, Argentinien
   */
  public static final String ARS = "ARS";

  /**
   * Dollar, Australien, Kiribati, Nauru, Tuvalu
   */
  public static final String AUD = "AUD";

  /**
   * Florin, Aruba
   */
  public static final String AWG = "AWG";

  /**
   * Manat, Aserbaidschan
   */
  public static final String AZN = "AZN";

  /**
   * Konvertible Mark, Bosnien und Herzegowina
   */
  public static final String BAM = "BAM";

  /**
   * Dollar, Barbados
   */
  public static final String BBD = "BBD";

  /**
   * Taka, Bangladesch
   */
  public static final String BDT = "BDT";

  /**
   * Lew, Bulgarien
   */
  public static final String BGN = "BGN";

  /**
   * Dinar, Bahrain
   */
  public static final String BHD = "BHD";

  /**
   * Franc, Burundi
   */
  public static final String BIF = "BIF";

  /**
   * Dollar, Bermuda
   */
  public static final String BMD = "BMD";

  /**
   * Dollar, Brunei
   */
  public static final String BND = "BND";

  /**
   * Boliviano, Bolivien
   */
  public static final String BOB = "BOB";

  /**
   * Real, Brasilien
   */
  public static final String BRL = "BRL";

  /**
   * Dollar, Bahamas
   */
  public static final String BSD = "BSD";

  /**
   * Ngultrum, Bhutan
   */
  public static final String BTN = "BTN";

  /**
   * Pula, Botsuana
   */
  public static final String BWP = "BWP";

  /**
   * Rubel, Weirussland
   */
  public static final String BYR = "BYR";

  /**
   * Dollar, Belize
   */
  public static final String BZD = "BZD";

  /**
   * Dollar, Kanada
   */
  public static final String CAD = "CAD";

  /**
   * Franc, Demokratische Republik Kongo
   */
  public static final String CDF = "CDF";

  /**
   * Franken, Schweiz, Liechtenstein
   */
  public static final String CHF = "CHF";

  /**
   * Peso, Chile
   */
  public static final String CLP = "CLP";

  /**
   * Renminbi Yuan, Volksrepublik China
   */
  public static final String CNY = "CNY";

  /**
   * Peso, Kolumbien
   */
  public static final String COP = "COP";

  /**
   * Coln, Costa Rica
   */
  public static final String CRC = "CRC";

  /**
   * Dinar,Serbien
   */
  public static final String CSD = "CSD";

  /**
   * Peso, Kuba
   */
  public static final String CUP = "CUP";

  /**
   * Escudo, Kap Verde
   */
  public static final String CVE = "CVE";

  /**
   * Pfund, Zypern (griechischer Teil)
   */
  public static final String CYP = "CYP";

  /**
   * Krone, Tschechien
   */
  public static final String CZK = "CZK";

  /**
   * Franc, Dschibuti
   */
  public static final String DJF = "DJF";

  /**
   * Krone, Dnemark
   */
  public static final String DKK = "DKK";

  /**
   * Peso, Dominikanische Republik
   */
  public static final String DOP = "DOP";

  /**
   * Dinar, Algerien
   */
  public static final String DZD = "DZD";

  /**
   * Krone, Estland
   */
  public static final String EEK = "EEK";

  /**
   * Pfund, gypten
   */
  public static final String EGP = "EGP";

  /**
   * Birr, thiopien
   */
  public static final String ETB = "ETB";

  /**
   * Nakfa, Eritrea
   */
  public static final String ERN = "ERN";

  /**
   * Euro, Europische Whrungsunion
   */
  public static final String EUR = "EUR";

  /**
   * Dollar, Fidschi
   */
  public static final String FJD = "FJD";

  /**
   * Pfund, Falklandinseln
   */
  public static final String FKP = "FKP";

  /**
   * Pfund, Grobritannien und Nordirland
   */
  public static final String GBP = "GBP";

  /**
   * Lari, Georgien
   */
  public static final String GEL = "GEL";

  /**
   * Cedi, Ghana
   */
  public static final String GHC = "GHC";

  /**
   * Pfund, Gibraltar
   */
  public static final String GIP = "GIP";

  /**
   * Dalasi, Gambia
   */
  public static final String GMD = "GMD";

  /**
   * Franc, Guinea
   */
  public static final String GNF = "GNF";

  /**
   * Quetzal, Guatemala
   */
  public static final String GTQ = "GTQ";

  /**
   * Dollar, Guyana
   */
  public static final String GYD = "GYD";

  /**
   * Dollar, Hongkong
   */
  public static final String HKD = "HKD";

  /**
   * Lempira, Honduras
   */
  public static final String HNL = "HNL";

  /**
   * Kuna, Kroatien
   */
  public static final String HRK = "HRK";

  /**
   * Gourde, Haiti
   */
  public static final String HTG = "HTG";

  /**
   * Forint, Ungarn
   */
  public static final String HUF = "HUF";

  /**
   * Rupiah, Indonesien
   */
  public static final String IDR = "IDR";

  /**
   * Schekel, Israel
   */
  public static final String ILS = "ILS";

  /**
   * Rupie, Indien
   */
  public static final String INR = "INR";

  /**
   * Dinar, Irak
   */
  public static final String IQD = "IQD";

  /**
   * Rial, Iran
   */
  public static final String IRR = "IRR";

  /**
   * Krone, Island
   */
  public static final String ISK = "ISK";

  /**
   * Dollar, Jamaika
   */
  public static final String JMD = "JMD";

  /**
   * Dinar, Jordanien
   */
  public static final String JOD = "JOD";

  /**
   * Yen, Japan
   */
  public static final String JPY = "JPY";

  /**
   * Schilling, Kenia
   */
  public static final String KES = "KES";

  /**
   * Som, Kirgisistan
   */
  public static final String KGS = "KGS";

  /**
   * Riel, Kambodscha
   */
  public static final String KHR = "KHR";

  /**
   * Franc, Komoren
   */
  public static final String KMF = "KMF";

  /**
   * Won, Nordkorea
   */
  public static final String KPW = "KPW";

  /**
   * Won, Sdkorea
   */
  public static final String KRW = "KRW";

  /**
   * Dinar, Kuwait
   */
  public static final String KWD = "KWD";

  /**
   * Dollar, Kaimaninseln
   */
  public static final String KYD = "KYD";

  /**
   * Tenge, Kasachstan
   */
  public static final String KZT = "KZT";

  /**
   * Kip, Laos
   */
  public static final String LAK = "LAK";

  /**
   * Kip, Laos
   */
  public static final String LBP = "LBP";

  /**
   * Rupie, Sri Lanka
   */
  public static final String LKR = "LKR";

  /**
   * Dollar, Liberia
   */
  public static final String LRD = "LRD";

  /**
   * Loti, Lesotho
   */
  public static final String LSL = "LSL";

  /**
   * Litas, Litauen
   */
  public static final String LTL = "LTL";

  /**
   * Lats, Lettland
   */
  public static final String LVL = "LVL";

  /**
   * Dinar, Libyen
   */
  public static final String LYD = "LYD";

  /**
   * Dirham, Marokko
   */
  public static final String MAD = "MAD";

  /**
   * Leu, Moldawien
   */
  public static final String MDL = "MDL";

  /**
   * Ariary, Madagaskar
   */
  public static final String MGA = "MGA";

  /**
   * Denar, Mazedonien
   */
  public static final String MKD = "MKD";

  /**
   * Kyat, Myanmar
   */
  public static final String MMK = "MMK";

  /**
   * Tgrg, Mongolei
   */
  public static final String MNT = "MNT";

  /**
   * Pataca, Macao
   */
  public static final String MOP = "MOP";

  /**
   * Ouguiya, Mauretanien
   */
  public static final String MRO = "MRO";

  /**
   * Lira, Malta
   */
  public static final String MTL = "MTL";

  /**
   * Rupie, Mauritius
   */
  public static final String MUR = "MUR";

  /**
   * Rufiyaa, Malediven
   */
  public static final String MVR = "MVR";

  /**
   * Kwacha, Malawi
   */
  public static final String MWK = "MWK";

  /**
   * Peso, Mexiko
   */
  public static final String MXN = "MXN";

  /**
   * Ringgit, Malaysia
   */
  public static final String MYR = "MYR"; //

  /**
   * Metical, Mosambik
   */
  public static final String MZM = "MZM";

  /**
   * Dollar, Namibia
   */
  public static final String NAD = "NAD";

  /**
   * Naira, Nigeria
   */
  public static final String NGN = "NGN";

  /**
   * Crdoba, Nicaragua
   */
  public static final String NIO = "NIO";

  /**
   * Krone, Norwegen
   */
  public static final String NOK = "NOK";

  /**
   * Rupie, Nepal
   */
  public static final String NPR = "NPR";

  /**
   * Dollar, Neuseeland
   */
  public static final String NZD = "NZD";

  /**
   * Rial, Oman
   */
  public static final String OMR = "OMR";

  /**
   * Balboa, Panama
   */
  public static final String PAB = "PAB";

  /**
   * Nuevo Sol, Peru
   */
  public static final String PEN = "PEN";

  /**
   * Kina, Papua-Neuguinea
   */
  public static final String PGK = "PGK";

  /**
   * Peso, Philippinen
   */
  public static final String PHP = "PHP";

  /**
   * Rupie, Pakistan
   */
  public static final String PKR = "PKR";

  /**
   * Z?oty, Polen
   */
  public static final String PLN = "PLN";

  /**
   * Guaran, Paraguay
   */
  public static final String PYG = "PYG";

  /**
   * Riyal, Katar
   */
  public static final String QAR = "QAR";

  /**
   * Leu, Rumnien
   */
  public static final String RON = "RON";

  /**
   * Rubel, Russland
   */
  public static final String RUB = "RUB";

  /**
   * Franc, Ruanda
   */
  public static final String RWF = "RWF";

  /**
   * Riyal, Saudi-Arabien
   */
  public static final String SAR = "SAR";

  /**
   * Dollar, Salomonen
   */
  public static final String SBD = "SBD";

  /**
   * Rupie, Seychellen
   */
  public static final String SCR = "SCR";

  /**
   * Dinar, Sudan
   */
  public static final String SDD = "SDD";

  /**
   * Krone, Schweden
   */
  public static final String SEK = "SEK";

  /**
   * Dollar, Singapur
   */
  public static final String SGD = "SGD";

  /**
   * Pfund, St. Helena
   */
  public static final String SHP = "SHP";

  /**
   * Tolar, Slowenien
   */
  public static final String SIT = "SIT";

  /**
   * Krone, Slowakei
   */
  public static final String SKK = "SKK";

  /**
   * Leone, Sierra Leone
   */
  public static final String SLL = "SLL";

  /**
   * Schilling, Somalia
   */
  public static final String SOS = "SOS";

  /**
   * Dollar, Suriname
   */
  public static final String SRD = "SRD";

  /**
   * Dobra, So Tom und Prncipe
   */
  public static final String STD = "STD";

  /**
   * Coln, El Salvador
   */
  public static final String SVC = "SVC";

  /**
   * Pfund, Syrien
   */
  public static final String SYP = "SYP";

  /**
   * Lilangeni, Swasiland
   */
  public static final String SZL = "SZL";

  /**
   * Baht, Thailand
   */
  public static final String THB = "THB";

  /**
   * Somoni, Tadschikistan
   */
  public static final String TJS = "TJS";

  /**
   * Manat, Turkmenistan
   */
  public static final String TMM = "TMM";

  /**
   * Dinar, Tunesien
   */
  public static final String TND = "TND";

  /**
   * Pa'anga, Tonga
   */
  public static final String TOP = "TOP";

  /**
   * Neue Lira, Trkei
   */
  public static final String TRY = "TRY";

  /**
   * Dollar, Trinidad und Tobago
   */
  public static final String TTD = "TTD";

  /**
   * Dollar, Taiwan
   */
  public static final String TWD = "TWD";

  /**
   * Schilling, Tansania
   */
  public static final String TZS = "TZS";

  /**
   * Hrywnja, Ukraine
   */
  public static final String UAH = "UAH";

  /**
   * Shilling, Uganda
   */
  public static final String UGX = "UGX";

  /**
   * Dollar, Vereinigte Staaten
   */
  public static final String USD = "USD";

  /**
   * Peson, Uruguay
   */
  public static final String UYU = "UYU";

  /**
   * So?m, Usbekistan
   */
  public static final String UZS = "UZS";

  /**
   * Bolvar, Venezuela
   */
  public static final String VEB = "VEB";

  /**
   * ??ng, Vietnam
   */
  public static final String VND = "VND";

  /**
   * Vatu, Vanuatu
   */
  public static final String VUV = "VUV";

  /**
   * Tala, Sene Samoa
   */
  public static final String WST = "WST";

  /**
   * Franc, Zentralafrikanische Wirtschafts- und Whrungsunion
   */
  public static final String XAF = "XAF";

  /**
   * Dollar, Ostkaribische Whrungsunion
   */
  public static final String XCD = "XCD";

  /**
   * Sonderziehungsrecht - Internationaler Whrungsfonds
   */
  public static final String XDR = "XDR";

  /**
   * Franc, Westafrikanische Wirtschafts- und Whrungsunion
   */
  public static final String XOF = "XOF";

  /**
   * Franc, Neukaledonien
   */
  public static final String XPF = "XPF";

  /**
   * Rial, Jemen
   */
  public static final String YER = "YER";

  /**
   * Rand, Sdafrika
   */
  public static final String ZAR = "ZAR";

  /**
   * Kwacha, Sambia
   */
  public static final String ZMK = "ZMK";

  /**
   * Dollar, Simbabwe
   */
  public static final String ZWD = "ZMD";

  private static String[] waehrungen = { AED, AFN, ALL, AMD, ANG, AOA, ARS, AUD, AWG,
      AZN, BAM, BBD, BDT, BGN, BHD, BIF, BMD, BND, BOB, BRL, BSD, BTN, BWP,
      BYR, BZD, CAD, CDF, CHF, CLP, CNY, COP, CRC, CSD, CUP, CVE, CYP, CZK,
      DJF, DKK, DOP, DZD, EEK, EGP, ETB, ERN, EUR, FJD, FKP, GBP, GEL, GHC,
      GIP, GMD, GNF, GTQ, GYD, HKD, HNL, HRK, HTG, HUF, IDR, ILS, INR, IQD,
      IRR, ISK, JMD, JOD, JPY, KES, KGS, KHR, KMF, KPW, KRW, KWD, KYD, KZT,
      LAK, LBP, LKR, LRD, LSL, LTL, LVL, LYD, MAD, MDL, MGA, MKD, MMK, MNT,
      MOP, MRO, MTL, MUR, MVR, MWK, MXN, MYR, MZM, NAD, NGN, NIO, NOK, NPR,
      NZD, OMR, PAB, PEN, PGK, PHP, PKR, PLN, PYG, QAR, RON, RUB, RWF, SAR,
      SBD, SCR, SDD, SEK, SGD, SHP, SIT, SKK, SLL, SOS, SRD, STD, SVC, SYP,
      SZL, THB, TJS, TMM, TND, TOP, TRY, TTD, TWD, TZS, UAH, UGX, USD, UYU,
      UZS, VEB, VND, VUV, WST, XAF, XCD, XDR, XOF, XPF, YER, ZAR, ZMK, ZWD };
  
  public static boolean isValid(String value)
  {
    for (int i = 0;i< waehrungen.length; i++)
    {
      if (waehrungen[i].equals(value))
      {
        return true;
      }
    }
    return false;
  }
}
