/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CACHINGPROVIDER_H
#define CACHINGPROVIDER_H

#include <QQuickImageProvider>
#include <QUrl>

class CachingProvider : public QQuickImageProvider
{
public:
    CachingProvider();
    QImage requestImage(const QString &id, QSize *size, const QSize& requestedSize);

private:
    QImage downloadImage(const QUrl& url);

    static const int REDIRECT_LIMIT = 5;
};

#endif
