<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/integrations/cloud-notifications/integrations/slack.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/integrations/cloud-notifications/metadata.yaml"
sidebar_label: "Slack"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Centralized Cloud Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# Slack


<img src="https://netdata.cloud/img/slack.png" width="150"/>


From the Netdata Cloud UI, you can manage your space's notification settings and enable the configuration to deliver notifications on Slack.


<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites

- A Netdata Cloud account
- Access to the Netdata Space as an **Admin**
- The Netdata Space needs to be on a paid plan
- You need to have a Slack app on your workspace to receive the Webhooks.

### Slack Server Configuration

Steps to configure your Slack to receive notifications from Netdata:

1. Create an app to receive webhook integrations. Check [Create an app](https://api.slack.com/apps?new_app=1) from Slack documentation for further details
2. Install the app on your workspace
3. Configure Webhook URLs for your workspace
  - On your app go to **Incoming Webhooks** and click on **activate incoming webhooks**
  - At the bottom of **Webhook URLs for Your Workspace** section you have **Add New Webhook to Workspace**
  - After pressing that specify the channel where you want your notifications to be delivered
  - Once completed copy the Webhook URL that you will need to add to your notification configuration on Netdata UI

For more details please check Slacks's article [Incoming webhooks for Slack](https://slack.com/help/articles/115005265063-Incoming-webhooks-for-Slack).

### Netdata Configuration Steps

1. Click on the **Space settings** cog (located above your profile icon)
2. Click on the **Notification** tab
3. Click on the **+ Add configuration** button (near the top-right corner of your screen)
4. On the **Slack** card click on **+ Add**
5. A modal will be presented to you to enter the required details to enable the configuration:
  * **Notification settings** are Netdata specific settings
    - Configuration name - you can optionally provide a name for your configuration you can easily refer to it
    - Rooms - by specifying a list of Rooms you are select to which nodes or areas of your infrastructure you want to be notified using this configuration
    - Notification - you specify which notifications you want to be notified using this configuration: All Alerts and unreachable, All Alerts, Critical only
  * **Integration configuration** are the specific notification integration required settings, which vary by notification method. For Slack:
    - Webhook URL - URL provided on Slack for the channel you want to receive your notifications.


